﻿//-----------------------------------------------------------------------
// <copyright file="StartConsole.cs" company="KONICA MINOLTA, INC.">
//     (c) Copyright KONICA MINOLTA, INC.   All rights reserved.
// </copyright>
//-----------------------------------------------------------------------
﻿
using System;
using System.Collections.Generic;
using System.Linq;

namespace SampleProgram
{
    class StartConsole
    {
        static void Main(string[] args)
        {

            // List up sample program src files
            List<string> srcFiles = new List<string>();

            srcFiles.Add("OneShotMeasurementSample.cs");
            srcFiles.Add("ReadSampleDataSample.cs");
            srcFiles.Add("BackLightSettingSample.cs");
            srcFiles.Add("MeasurementTimeSampleSetting.cs");
            srcFiles.Add("SinglePointCalibrationSample.cs");
            srcFiles.Add("RGBCalibrationSample.cs");

            // Display sample programs
            Console.WriteLine("Please select a sample program from below.");
            for (int i=0; i<srcFiles.Count(); i++ )
            {
                Console.WriteLine("  {0}: {1}", i, srcFiles[i]);
            }
            
            // Make an user input integer to select a sample
            int selectedNum = -1;
            Console.Write("> ");
            try
            {
                selectedNum = int.Parse(Console.ReadLine());
            }
            catch ( System.FormatException )
            {
                Console.WriteLine("Please input any integer");
                return;
            }

            // Start the programs which the user selected.
            
            switch(selectedNum)
            {
                case 0:
                    Console.WriteLine("{0} is selected", srcFiles[0]);
                    OneShotMeasurementSample.Execute();
                    break;

                case 1:
                    Console.WriteLine("{0} is selected", srcFiles[1]);
                    ReadSampleDataSample.Execute();
                    break;

                case 2:
                    Console.WriteLine("{0} is selected", srcFiles[2]);
                    BackLightSettingSample.Execute();
                    break;

                case 3:
                    Console.WriteLine("{0} is selected", srcFiles[3]);
                    MeasurementTimeSample.Execute();
                    break;

                case 4:
                    Console.WriteLine("{0} is selected", srcFiles[4]);
                    SinglePointCalibrationSample.Execute();
                    break;

                case 5:
                    Console.WriteLine("{0} is selected", srcFiles[5]);
                    RGBCalibrationSample.Execute();
                    break;

                default:
                    Console.WriteLine("Please input 0~{0}", srcFiles.Count());
                    break;

            }
            Console.WriteLine("FINISH");
            Console.WriteLine("Press any key to exit...");
            Console.ReadKey();
        }
    }
}
