﻿//-----------------------------------------------------------------------
// <copyright file="ReadSanpleDataSample.cs" company="KONICA MINOLTA, INC.">
//     (c) Copyright KONICA MINOLTA, INC.   All rights reserved.
// </copyright>
//-----------------------------------------------------------------------

using System;
using Konicaminolta;

namespace SampleProgram
{
    class ReadSampleDataSample
    {
        public static void Execute()
        {

            //  Setup
            LightColorMISDK sdk = LightColorMISDK.GetInstance();
            ReturnMessage ret;

            //  Connect
            ret = sdk.Connect();
            if (ret.errorCode != ErrorDefine.KmSuccess)
            {
                Console.WriteLine("Error in Connect(): {0}", ret.errorCode);
                return;
            }

            //  Get the number of sample data
            int totalSampleCount;
            ret = sdk.GetNumberOfSampleData(out totalSampleCount);
            if (ret.errorCode != ErrorDefine.KmSuccess)
            {
                Console.WriteLine("Error in Connect(): {0}", ret.errorCode);
                return;
            }

            if (totalSampleCount == 0)
            {
                Console.WriteLine("No sample data");
                return;
            }

            //  Get Sample measured value as ( X, Y, Z )
            XYZ xyzValue = new XYZ();
            for (int i = 1; i <= totalSampleCount; i++)
            {
                ret = sdk.ReadSampleData(i, xyzValue);
                if (ret.errorCode != ErrorDefine.KmSuccess)
                {
                    Console.WriteLine("Error in ReadSampleData(): {0}", ret.errorCode);
                    return;
                }
                else
                {
                    // Display measurement values
                    Console.WriteLine("Result : DataNumber{0}", i);
                    Console.WriteLine("X:{0}", xyzValue.X);
                    Console.WriteLine("Y:{0}", xyzValue.Y);
                    Console.WriteLine("Z:{0}", xyzValue.Z);
                }
            }

            //  Disconnect
            ret = sdk.DisConnect(0); 
        }
    }
}
