﻿//-----------------------------------------------------------------------
// <copyright file="RGBCalibrationSample.cs" company="KONICA MINOLTA, INC.">
//     (c) Copyright KONICA MINOLTA, INC.   All rights reserved.
// </copyright>
//-----------------------------------------------------------------------

using System;
using System.Collections.Generic;
using Konicaminolta;

namespace SampleProgram
{
    class RGBCalibrationSample
    {
        public static void Execute()
        {

            // Setup
            LightColorMISDK sdk = LightColorMISDK.GetInstance();
            ReturnMessage ret;
            
            //  Connect
            ret = sdk.Connect();
            if (ret.errorCode != ErrorDefine.KmSuccess)
            {
                Console.WriteLine("Error in Connect():{0}", ret.errorCode);
                return;
            }

            // Set calibration channel 0
            ret = sdk.SetCalibrationCh(0);
            if (ret.errorCode != ErrorDefine.KmSuccess)
            {
                Console.WriteLine("Error in SetCalibrationCh():{0}", ret.errorCode);
                return;
            }

            //  Start measurement (of a red light)
            Console.WriteLine("Press any key to measure a red light");
            Console.ReadKey();
            ret = sdk.Measure();
            if( ret.errorCode != ErrorDefine.KmSuccess)
            {
                Console.WriteLine("Error in Measure(): {0}", ret.errorCode);
                return;
            }

            //  Polling status of measurement
            MeasStatus state;
            do
            {
                ret = sdk.PollingMeasurement(out state);
                if (ret.errorCode != ErrorDefine.KmSuccess)
                {
                    Console.WriteLine("Error in PollingMeasurement(): {0}", ret.errorCode);
                    return;
                }
            } while (state == MeasStatus.Measuring);
 
            //  Get measured value as ( X, Y, Z )
            XYZ measRedValue = new XYZ();
            ret = sdk.ReadLatestData(measRedValue);
            if( ret.errorCode != ErrorDefine.KmSuccess)
            {
                Console.WriteLine("Error in ReadLatestData(): {0}", ret.errorCode);
                return;
            }

            //  Start measurement (of a green light)
            Console.WriteLine("Press any key to measure a green light");
            Console.ReadKey();
            ret = sdk.Measure();
            if( ret.errorCode != ErrorDefine.KmSuccess)
            {
                Console.WriteLine("Error in Measure(): {0}", ret.errorCode);
                return;
            }

            //  Polling status of measurement
            do {
                ret = sdk.PollingMeasurement(out state);
                if( ret.errorCode != ErrorDefine.KmSuccess)
                {
                    Console.WriteLine("Error in PollingMeasurement(): {0}", ret.errorCode);
                    return;
                }
            } while( state == MeasStatus.Measuring );
 
            //  Get measured value as ( X, Y, Z )
            XYZ measGreenValue = new XYZ();
            ret = sdk.ReadLatestData(measGreenValue);
            if( ret.errorCode != ErrorDefine.KmSuccess)
            {
                Console.WriteLine("Error in ReadLatestData(): {0}", ret.errorCode);
                return;
            }

            //  Start measurement (of a blue light)
            Console.WriteLine("Press any key to measure a blue light");
            Console.ReadKey();
            ret = sdk.Measure();
            if( ret.errorCode != ErrorDefine.KmSuccess)
            {
                Console.WriteLine("Error in Measure(): {0}", ret.errorCode);
                return;
            }
 
            //  Polling status of measurement
            do
            {
                ret = sdk.PollingMeasurement(out state);
                if (ret.errorCode != ErrorDefine.KmSuccess)
                {
                    Console.WriteLine("Error in PollingMeasurement(): {0}", ret.errorCode);
                    return;
                }
            } while (state == MeasStatus.Measuring);
 

            //  Get measured value as ( X, Y, Z )
            XYZ measBlueValue = new XYZ();
            ret = sdk.ReadLatestData(measBlueValue);
            if( ret.errorCode != ErrorDefine.KmSuccess)
            {
                Console.WriteLine("Error in ReadLatestData(): {0}", ret.errorCode);
                return;
            }

            List<XYZ> measValues = new List<XYZ>();
            measValues.Add(measRedValue);
            measValues.Add(measGreenValue);
            measValues.Add(measBlueValue);

            XYZ trueRedValue = new XYZ();
            trueRedValue.X = 800;
            trueRedValue.Y = 400;
            trueRedValue.Z = 300;
            XYZ trueGreenValue = new XYZ();
            trueGreenValue.X = 600;
            trueGreenValue.Y = 1000;
            trueGreenValue.Z = 400;
            XYZ trueBlueValue = new XYZ();
            trueBlueValue.X = 500;
            trueBlueValue.Y = 600;
            trueBlueValue.Z = 1000;
            List<XYZ> trueValues = new List<XYZ>();
            trueValues.Add(trueRedValue);
            trueValues.Add(trueGreenValue);
            trueValues.Add(trueBlueValue);

            // Set calibration coefs
            string id      = "some_id";    // you can set your favorite id
            CalibType type = CalibType.RGB;
            int calibrationCh = 1;
            ret = sdk.SetMatrixCalib(calibrationCh, measValues, trueValues, type, id);
            if (ret.errorCode != ErrorDefine.KmSuccess)
            {
                Console.WriteLine("Error in SetMatrixCalib():{0}", ret.errorCode);
                return;
            }

            // Get calibration coefs
            List<MeasurementData> outputMeasValues = new List<MeasurementData>();
            List<MeasurementData> outputTrueValues = new List<MeasurementData>();
            UserCalibData calibCoefs = new UserCalibData();

            ret = sdk.GetCalibData(calibrationCh, out outputMeasValues, out outputTrueValues, out calibCoefs);
            if (ret.errorCode != ErrorDefine.KmSuccess)
            {
                Console.WriteLine("Error in GetCalibData():{0}", ret.errorCode);
                return;
            }

            // Display
            Console.WriteLine("Before calibration (Red)");
            foreach(var _measRedValue in outputMeasValues[0].ColorSpaceValue){
                Console.WriteLine("{0} : {1}", _measRedValue.Key, _measRedValue.Value);
            }

            Console.WriteLine("After calibration (Red)");
            foreach(var _trueRedValue in outputTrueValues[0].ColorSpaceValue){
                Console.WriteLine("{0} : {1}", _trueRedValue.Key, _trueRedValue.Value);
            }

            Console.WriteLine("Before calibration (Green)");
            foreach(var _measGreenValue in outputMeasValues[1].ColorSpaceValue){
                Console.WriteLine("{0} : {1}", _measGreenValue.Key, _measGreenValue.Value);
            }

            Console.WriteLine("After calibration (Green)");
            foreach(var _trueGreenValue in outputTrueValues[1].ColorSpaceValue){
                Console.WriteLine("{0} : {1}", _trueGreenValue.Key, _trueGreenValue.Value);
            }

            Console.WriteLine("Before calibration (Blue)");
            foreach(var _measBlueValue in outputMeasValues[2].ColorSpaceValue){
                Console.WriteLine("{0} : {1}", _measBlueValue.Key, _measBlueValue.Value);
            }

            Console.WriteLine("After calibration (Blue)");
            foreach(var _trueBlueValue in outputTrueValues[2].ColorSpaceValue){
                Console.WriteLine("{0} : {1}", _trueBlueValue.Key, _trueBlueValue.Value);
            }

            //  Disconnect
            ret = sdk.DisConnect(0); 

        }
    }
}
