﻿//-----------------------------------------------------------------------
// <copyright file="OneShotMeasurementSample.cs" company="KONICA MINOLTA, INC.">
//     (c) Copyright KONICA MINOLTA, INC.   All rights reserved.
// </copyright>
//-----------------------------------------------------------------------

using System;
using Konicaminolta;

namespace SampleProgram
{
    class OneShotMeasurementSample
    {
        public static void Execute()
        {

            //  Setup
            LightColorMISDK sdk = LightColorMISDK.GetInstance();
            ReturnMessage ret;


            //  Connect
            ret = sdk.Connect();
            if( ret.errorCode != ErrorDefine.KmSuccess )
            {
                Console.WriteLine("Error in Connect(): {0}", ret.errorCode);
                return;
            }
            
            //  Start measurement
            ret = sdk.Measure();
            if( ret.errorCode != ErrorDefine.KmSuccess)
            {
                Console.WriteLine("Error in Measure(): {0}", ret.errorCode);
                return;
            }

            //  Polling status of measurement
            MeasStatus state;
            do
            {
                ret = sdk.PollingMeasurement(out state);
                if (ret.errorCode != ErrorDefine.KmSuccess)
                {
                    Console.WriteLine("Error in PollingMeasurement(): {0}", ret.errorCode);
                    return;
                }
            } while (state == MeasStatus.Measuring);
 
            //  Get measured value as ( X, Y, Z )
            XYZ xyzValue = new XYZ();
            ret = sdk.ReadLatestData(xyzValue);
            if( ret.errorCode != ErrorDefine.KmSuccess)
            {
                Console.WriteLine("Error in ReadLatestData(): {0}", ret.errorCode);
                return;
            }
            else
            {
                // Display measurement values 
                Console.WriteLine("Result");
                Console.WriteLine("X:{0}", xyzValue.X);
                Console.WriteLine("Y:{0}", xyzValue.Y);
                Console.WriteLine("Z:{0}", xyzValue.Z);
            }

            // Get measured Value as (Lv[cd/m2], x, y)
            Lvxy lvxyValue = new Lvxy(LuminanceUnit.cdm2);
            ret = sdk.ReadLatestData(lvxyValue);
            if (ret.errorCode != ErrorDefine.KmSuccess)
            {
                Console.WriteLine("Error in ReadLatestData(): {0}", ret.errorCode);
                return;
            }
            else
            {
                // Display measurement values 
                Console.WriteLine("Result");
                Console.WriteLine("Lv:{0}", lvxyValue.Lv);
                Console.WriteLine(" x:{0}", lvxyValue.x);
                Console.WriteLine(" y:{0}", lvxyValue.y);
            }

            //  Disconnect
            ret = sdk.DisConnect(0); 

        }
    }
}
