﻿//-----------------------------------------------------------------------
// <copyright file="MeasurementTimeSettingSample.cs" company="KONICA MINOLTA, INC.">
//     (c) Copyright KONICA MINOLTA, INC.   All rights reserved.
// </copyright>
//-----------------------------------------------------------------------

using System;
using Konicaminolta;

namespace SampleProgram
{
    class MeasurementTimeSample
    {
        public static void Execute()
        {

            //  Setup
            LightColorMISDK sdk = LightColorMISDK.GetInstance();
            ReturnMessage ret;


            //  Connect
            ret = sdk.Connect();
            if (ret.errorCode != ErrorDefine.KmSuccess)
            {
                Console.WriteLine("Error in Connect(): {0}", ret.errorCode);
                return;
            }

            //  Set the measurement time automatic
            MeasurementTime inputMeasurementTime = new MeasurementTime();
            inputMeasurementTime.MeasTimeMode = MeasTimeMode.Auto;
            ret = sdk.SetMeasurementTime(inputMeasurementTime);
            if (ret.errorCode != ErrorDefine.KmSuccess)
            {
                Console.WriteLine("Error in SetMeasurementTime(): {0}", ret.errorCode);
                return;
            }

            MeasurementTime outputMeasurementTime;
            ret = sdk.GetMeasurementTime(out outputMeasurementTime);
            if (ret.errorCode != ErrorDefine.KmSuccess)
            {
                Console.WriteLine("Error in GetMeasurementTime(): {0}", ret.errorCode);
                return;
            }            
            else
            {
                // Display measurement time values 
                Console.WriteLine("MeasTimeMode:{0}", inputMeasurementTime.MeasTimeMode);
            }

            //  Set a measurement time manually
            inputMeasurementTime.MeasTimeMode = MeasTimeMode.Manual;
            inputMeasurementTime.ManualMeasurementTime = 1.5;

            ret = sdk.SetMeasurementTime(inputMeasurementTime);
            if (ret.errorCode != ErrorDefine.KmSuccess)
            {
                Console.WriteLine("Error in SetMeasurementTime(): {0}", ret.errorCode);
                return;
            }
            else
            {
                // Display measurement time values 
                Console.WriteLine("");
                Console.WriteLine("MeasTimeMode:{0}", inputMeasurementTime.MeasTimeMode);
                Console.WriteLine("ManualMeasurementTime:{0}" , inputMeasurementTime.ManualMeasurementTime);
            }
            


            //  Disconnect
            ret = sdk.DisConnect(0); 
        }
    }
}
