﻿//-----------------------------------------------------------------------
// <copyright file="BackLightSettingSample.cs" company="KONICA MINOLTA, INC.">
//     (c) Copyright KONICA MINOLTA, INC.   All rights reserved.
// </copyright>
//-----------------------------------------------------------------------

using System;
using Konicaminolta; 
using System.Threading;

namespace SampleProgram
{
    class BackLightSettingSample
    {
        public static void Execute()
        {

            //  Setup
            LightColorMISDK sdk = LightColorMISDK.GetInstance();
            ReturnMessage ret;

            //  Connect
            ret = sdk.Connect();
            if (ret.errorCode != ErrorDefine.KmSuccess)
            {
                Console.WriteLine("Error in Connect(): {0}", ret.errorCode);
                return;
            }
            
            // Set the backlight on
            BackLightMode mode = BackLightMode.On;
            ret = sdk.SetBackLightOnOff(mode);
            if (ret.errorCode != ErrorDefine.KmSuccess)
            {
                Console.WriteLine("Error in SetBackLightOnOff(): {0}", ret.errorCode);
                return;
            }

            Thread.Sleep(2000);

            // Set the backlight off
            mode = BackLightMode.Off;
            ret = sdk.SetBackLightOnOff(mode);
            if (ret.errorCode != ErrorDefine.KmSuccess)
            {
                Console.WriteLine("Error in SetBackLightOnOff(): {0}", ret.errorCode);
                return;
            }

            // Disconnect
            ret = sdk.DisConnect();

        }
    }
}
