/** @brief      Sample code for getting the stored datas in the device
                
    @file       DeviceStoreData.cpp
    @author     KONICA MINOLTA, INC.

	Copyright(c) 2012-2016 KONICA MINOLTA, INC. All rights reserved.
*/

#include "../stdafx.h"
#include "../CLAPI.h"

void Execute();
bool RemoteOffClose(DEVICE_HANDLE handle);
bool Close(DEVICE_HANDLE handle);

int main(int argc, char* argv[])
{
	Execute();
	printf("Press any key.\n");
	getchar();
	return 0;
}

void Execute()
{
	ER_CODE ret;

	// Acquire the device handle
	DEVICE_HANDLE handle;

	printf("Call CLOpenDevice");
	ret = CLOpenDevice(&handle);
	if(ret != SUCCESS){
		printf("... Failed.\n");
		return;
	}
	printf("... Succeeded.\n");
	
	// Set remote mode on
	printf("Call CLSetRemoteMode(ON)");
	ret = CLSetRemoteMode(handle, CL_RMODE_ON);
	if(ret != SUCCESS){
		printf("... Failed .\n");
		Close(handle);
		return;
	}
	printf("... Succeeded.\n");


	// Getting the number of the stored data in the device
	int32_km num;
	printf("Call CLGetDeviceStoredDataNum()");
	ret = CLGetDeviceStoredDataNum(handle, &num);
	if(ret != SUCCESS){
		printf("... Failed.\n");
		RemoteOffClose(handle);
		return;
	}
	printf("... Succeeded.(num:%d)\n", num);


	// Getting the stored data in the device
	CL_LISTDATA alldata[CL_LIST_NO_END];
	printf("Call CLGetDeviceStoredData()");
	ret = CLGetDeviceStoredData(handle, alldata, CL_COLORSPACE_EVXY, CL_LIST_NO_END);
	if(ret != SUCCESS){
		printf("... Failed.\n");
		RemoteOffClose(handle);
		return;
	}
	printf("... Succeeded.\n");

	for(int32_km i = 0; i < num; i++){
		printf("[%4d/%2d/%2d %2d:%2d:%2d]\n",
			alldata[i].DateTime.Year, alldata[i].DateTime.Month, alldata[i].DateTime.Day,
			alldata[i].DateTime.Hour, alldata[i].DateTime.Minute, alldata[i].DateTime.Second
		);
		printf("data[%d].Ev:%f\n", i + 1, alldata[i].Data.Evxy.Ev);
		printf("data[%d].x:%f\n", i + 1, alldata[i].Data.Evxy.x);
		printf("data[%d].y:%f\n\n", i + 1, alldata[i].Data.Evxy.y);
	}

	// Post-processing
	RemoteOffClose(handle);
}

// Set remote mode off
bool RemoteOffClose(DEVICE_HANDLE handle){
	ER_CODE ret;

	printf("Call CLSetRemoteMode(OFF)");
	ret = CLSetRemoteMode(handle, CL_RMODE_OFF);
	if(ret != SUCCESS){
		printf("... Failed.\n");
		return false;
	}
	printf("... Succeeded.\n");

	if(Close(handle) == false){
		return false;
	}

	return true;
}

// Release the device handle
bool Close(DEVICE_HANDLE handle){
	ER_CODE ret;

	printf("Call CLCloseDevice");
	ret = CLCloseDevice(handle);
	if(ret != SUCCESS){
		printf("... Failed.\n");
		return false;
	}
	printf("... Succeeded.\n");
	return true;
}
