/** @brief      Sample code for the measurement and system settings in the device.
                
    @file       DeviceSetting.cpp 
    @author     KONICA MINOLTA, INC.

	Copyright(c) 2012-2016 KONICA MINOLTA, INC. All rights reserved.
*/

#include "../stdafx.h"
#include "../CLAPI.h"
#include "../globaldata.h"

void Execute();
bool RemoteOffClose(DEVICE_HANDLE handle);
bool Close(DEVICE_HANDLE handle);

int main(int argc, char* argv[])
{
	Execute();
	printf("Press any key.\n");
	getchar();
	return 0;
}

void Execute()
{
	ER_CODE ret;

	// Acquire the device handle
	DEVICE_HANDLE handle;

	printf("Call CLOpenDevice");
	ret = CLOpenDevice(&handle);
	if(ret != SUCCESS){
		printf("... Failed.\n");
		return;
	}
	printf("... Succeeded.\n");
	
	// Set remote mode on
	printf("Call CLSetRemoteMode(ON)");
	ret = CLSetRemoteMode(handle, CL_RMODE_ON);
	if(ret != SUCCESS){
		printf("... Failed .\n");
		Close(handle);
		return;
	}
	printf("... Succeeded.\n");

	// Set the measurement conditions in the stand alone measurement
	CL_MEASSETTING measset;
	measset.DispType = CL_DISP_DEFAULT;		
	measset.Obs = CL_OBS_DEFAULT;			
	measset.ColorSpace = CL_MODE_DEFAULT;		
	measset.IlluminantUnit = CL_ILLUNIT_DEFAULT;	
	measset.ExposureTime = CL_MEAS_TIME_DEFAULT;	
	measset.UserCalibCh = 0;	
	measset.TargetNo = 1;		
	measset.UserCustom[0] = CL_CUSTOM_DEFAULT1;
	measset.UserCustom[1] = CL_CUSTOM_DEFAULT2;
	measset.UserCustom[2] = CL_CUSTOM_DEFAULT3;
	measset.UserCustom[3] = CL_CUSTOM_DEFAULT4;
	measset.MeasMode					= CL_MEASMODE_SINGLE;
	measset.TimerConf.DelaySec			= 0;
	measset.UserWavelength.lambda[0]	= 400;
	measset.UserWavelength.lambda[1]	= 500;
	measset.UserWavelength.lambda[2]	= 600;
	measset.UserWavelength.lambda[3]	= 700;


	for(int32_km i = 0; i < CL_MEASSET_NUM; i++){
		printf("Call CLSetMeasSettings(CL_MEASSETTYPE:%d)", i);
		ret = CLSetMeasSetting(handle, (CL_MEASSETTYPE)i, &measset);
		if(ret != SUCCESS){
			printf("... Failed.\n");
			RemoteOffClose(handle);
			return;
		}
		printf("... Succeeded.\n");
	}


	// Set the system condition in the device
	CL_SYSTEMSETTING system;
	
	system.Datetime = g_datedata;	
	system.Display = DISPLAY_DEFAULT;	
	system.Beep = CL_BEEP_DEFAULT;		
	system.Lang = CL_LANG_DEFAULT;		
	system.DateFormat = CL_DATEFORMAT_DEFAULT;	
	system.UserCalLimit = CL_USERCAL_LIMIT_DEFAULT;
	system.AutoPowerOff = CL_AUTOPOWEROFF_DEFAULT;
	system.PCalNotify = CL_PCALNOTIFY_DEFAULT;	
	
	for(int32_km i = 0; i < CL_SYSTEM_NUM; i++){
		printf("Call CLSetSystemSetting(CL_SYSTEMTYPE:%d)", i);
		ret = CLSetSystemSetting(handle, (CL_SYSTEMTYPE)i, &system);
		if(ret != SUCCESS){
			printf("... Failed.\n");
			RemoteOffClose(handle);
			return;
		}
		printf("... Succeeded.\n");
	}

	// Get the measurement setting in the stand alone measurement
	CL_MEASSETTING cur_measset;
	for(int32_km i = 0; i < CL_MEASSET_NUM; i++){
		printf("Call CLGetMeasSettings(CL_MEASSETTYPE:%d)", i);
		ret = CLGetMeasSetting(handle, (CL_MEASSETTYPE)i, &cur_measset);
		if(ret != SUCCESS){
			printf("... Failed.\n");
			RemoteOffClose(handle);
			return;
		}
		printf("... Succeeded.\n");
	}

	// Get the system setting in the device
	CL_SYSTEMSETTING cur_getsystem;
	for(int32_km i = 0; i < CL_SYSTEM_NUM; i++){
		printf("Call CLGetSystemSetting(CL_SYSTEMTYPE:%d)", i);
		ret = CLGetSystemSetting(handle, (CL_SYSTEMTYPE)i, &cur_getsystem);
		if(ret != SUCCESS){
			printf("... Failed.\n");
			RemoteOffClose(handle);
			return;
		}
		printf("... Succeeded.\n");
	}

	// Post-processing
	RemoteOffClose(handle);
}

// Set remote mode off
bool RemoteOffClose(DEVICE_HANDLE handle){
	ER_CODE ret;

	printf("Call CLSetRemoteMode(OFF)");
	ret = CLSetRemoteMode(handle, CL_RMODE_OFF);
	if(ret != SUCCESS){
		printf("... Failed.\n");
		return false;
	}
	printf("... Succeeded.\n");

	if(Close(handle) == false){
		return false;
	}

	return true;
}

// Release the device handle
bool Close(DEVICE_HANDLE handle){
	ER_CODE ret;

	printf("Call CLCloseDevice");
	ret = CLCloseDevice(handle);
	if(ret != SUCCESS){
		printf("... Failed.\n");
		return false;
	}
	printf("... Succeeded.\n");
	return true;
}
