﻿' Sample Code for CA-SDK
' Copyright (c) 2016 KONICA MINOLTA, INC.

Public Class Form1
    '===================================
    ' SDK Object
    '===================================
    Private objCa200 As Ca200
    Private objCa As Ca
    Private objProbe As Probe
    Private objMemory As Memory
    Private objProbeInfo As IProbeInfo

    Private objCaControl As CaControl.CaControl

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        '===================================
        ' Create SDK/Application Object
        '===================================
        objCa200 = New Ca200

        '===================================
        ' Set Configuration
        '===================================
        objCa200.AutoConnect()

        '===================================
        ' Initialize SDK Object
        '===================================
        objCa = objCa200.SingleCa
        objProbe = objCa.SingleProbe
        objMemory = objCa.Memory
        objProbeInfo = objProbe

        objCaControl = CaControlWrapper1.cacontrolobj

        objCaControl.Ca = objCa
        objCaControl.Probe = objProbe
        objCaControl.Memory = objMemory

        objCaControl.UpdateCaInfo()
        objCaControl.UpdateMemoryInfo()
    End Sub

    Private Sub Form1_FormClosing(sender As Object, e As FormClosingEventArgs) Handles MyBase.FormClosing
        objCa.RemoteMode = 0
        objCa200 = Nothing
        objCa = Nothing
        objProbe = Nothing
        objMemory = Nothing
        objProbeInfo = Nothing

        objCaControl = Nothing
    End Sub
End Class
