﻿' Sample Code for CA-SDK
' Copyright (c) 2016 KONICA MINOLTA, INC.

Public Class Form1
    Public objCa200 As Ca200
    Public objCa As Ca
    Public objProbe As Probe
    Public objMemory As Memory
    Public objProbeInfo As IProbeInfo

    Public objxyControl As ColorSpaceControl.xyControl

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        '===================================
        ' Create SDK/Application Object
        '===================================
        objCa200 = New Ca200

        '===================================
        ' Set Configuration
        '===================================
        objCa200.AutoConnect()

        '===================================
        ' Initialize SDK Object
        '===================================
        objCa = objCa200.SingleCa
        objProbe = objCa.SingleProbe
        objMemory = objCa.Memory
        objProbeInfo = objProbe

        objxyControl = ColorSpaceControlWrapper1.xycontrolobj
        objxyControl.Probe = objProbe
        objxyControl.Ca = objCa
        objxyControl.ClearData()
    End Sub

    Private Sub Button_Measure_Click(sender As Object, e As EventArgs) Handles Button_Measure.Click
        objCa.Measure()
        objxyControl.SetXYGraphData()
    End Sub

    Private Sub Form1_FormClosing(sender As Object, e As FormClosingEventArgs) Handles MyBase.FormClosing
        objCa.RemoteMode = 0
        objCa200 = Nothing
        objCa = Nothing
        objProbe = Nothing
        objMemory = Nothing
        objProbeInfo = Nothing

        objxyControl = Nothing
    End Sub
End Class
