
// MeasurementDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Measurement.h"
#include "MeasurementDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CMeasurementDlg dialog




CMeasurementDlg::CMeasurementDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CMeasurementDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMeasurementDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CMeasurementDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON1, &CMeasurementDlg::OnBnClickedButton1)
END_MESSAGE_MAP()


// CMeasurementDlg message handlers

BOOL CMeasurementDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMeasurementDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMeasurementDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMeasurementDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


#ifdef _DEBUG
	#pragma comment(lib, "Debug/CA2DSDK.lib")
#else
	#pragma comment(lib, "Release/CA2DSDK.lib")
#endif
#include "CA2DErrorDefine.h"
#include "CA2Dcommon.h"
#include "CA2DSDKapi.h"

void CMeasurementDlg::OnBnClickedButton1()
{
	int ret(CA2D_OK);

	//Enable the SDK
	ret = CA2DSDK_Enable();
	if (ret < 0){
		return;
	}
	
	//Connect to the specified instrument
	ret = CA2DSDK_ConnectInstrument(0);
	if (ret < 0){
		CA2DSDK_Disable();
		return;
	}


	//Set the measurement conditions
	tagInstrumentCond cond;
	cond.lensType = LENS_NORMAL;				//Normal lens
	cond.lensPosition = 0;						//0.25m
	cond.exposureMode = EXPOSURE_AUTO;			//Auto exposure
	cond.measurementType  = SYNCMODE_OFF;		//Synchronized measurements : Don't care
	cond.syncValue = 60.0;						
	cond.exposureIndex = 11;					
	cond.additional = 1;						
	cond.left = 0;								
	cond.top = 0;
	cond.right = 979;
	cond.bottom = 979;
	cond.filterMeasure = FILTER_MEASURE_OFF;	//XYZ measurements
	cond.filterIndex = FILTER_INDEX_Y;			
	cond.smearIndex = SMEAR_NONE;				
	cond.userCal = USERCAL_OFF;					
	cond.rotate = ROTATION_NONE;				

	ret = CA2DSDK_SetInstrumentCondition(&cond);
	if (ret < 0){
		CA2DSDK_DisconnectInstrument();
		CA2DSDK_Disable();
		return;
	}


	//Start the measurement
	ret = CA2DSDK_DoMeasurement();
	if (ret < 0){
		CA2DSDK_DisconnectInstrument();
		CA2DSDK_Disable();
		return;
	}
	while(1){
		ret = CA2DSDK_PollingMeasurement();
		if (ret == CA2D_OK){
			//When measurement is complete
			break;
		}else if (ret >= CA2D_OK){
			//When measuring
		}else{
			//When an error has occurred
			CA2DSDK_DisconnectInstrument();
			CA2DSDK_Disable();
			return;
		}
		Sleep(100);
	}

	//The conditions to calculate data
	tagDataCond cond_d;
	cond_d.lower_enable = 0;
	cond_d.lower_item = 1;
	cond_d.lower_threshold = 3;
	cond_d.resolution = 0;

	//Data acquisition area
	tagGetDataParam paramArea;
	paramArea.left = 0;
	paramArea.top = 0;
	paramArea.right = 979;
	paramArea.bottom = 979;


	float_km* pData = new float[MAXDATAROW * MAXDATACOL];
	//Gets X/Y/Z image data
	for (int j = VALTYPE_X; j <= VALTYPE_Z; j++){
		//Set the conditions to calculate data
		cond_d.valueType = j;
		ret = CA2DSDK_SetDataCondition(&cond_d);
		if (ret < 0){
			break;
		}

		//Get the data for the specified area
		ret = CA2DSDK_GetAreaData(&paramArea, pData);
		if (ret < 0){
			break;
		}

		//The image is stored in pData, so process the data as necessary
	}
	delete [] pData;



	//Clear the evaluation areas
	ret = CA2DSDK_ClearEvaluationArea();
	if (ret < 0){
		CA2DSDK_DisconnectInstrument();
		CA2DSDK_Disable();
		return;
	}

	//Set the evaluation area layout conditions
	tagEvaluationCond cond_e;
	cond_e.type = 0;
	ret = CA2DSDK_SetEvaluationAreaCondition(&cond_e);
	if (ret < 0){
		CA2DSDK_DisconnectInstrument();
		CA2DSDK_Disable();
		return;
	}

	//Set the conditions to lay out the spots
	tagAlignedSpotCond cond_spot;
	cond_spot.row = 3;								//Vertical layout count
	cond_spot.col = 3;								//Horizontal layout count
	cond_spot.shape = SPOT_SHAPETYPE_CIRCLE;		//Circle
	cond_spot.height = 50;							//Circle diameter : 50pixel
	cond_spot.width = 50;						
	cond_spot.offset_input = SPOT_OFFSET_RELATIVE;	//Relative values
	cond_spot.offset_position = SPOT_OFFSET_CENTER;	//Set spot center as edge
	cond_spot.offset_left = 10;						// H/10
	cond_spot.offset_top = 10;						// V/10
	cond_spot.offset_right = 10;					// H/10
	cond_spot.offset_bottom = 10;					// V/10
	ret = CA2DSDK_SetAlignedSpotCondition(&cond_spot);
	if (ret < 0){
		CA2DSDK_DisconnectInstrument();
		CA2DSDK_Disable();
		return;
	}

	//Calculate the spot results
	ret = CA2DSDK_CalculateSpotValue();
	if (ret < 0){
		CA2DSDK_DisconnectInstrument();
		CA2DSDK_Disable();
		return;
	}

	//Get the spot results
	tagSpotValue spot_val;
	spot_val.color = 1;
	for (int i = 0; i < 9; i++){
		ret = CA2DSDK_GetSpotValue(0, i, &spot_val);
		if (ret < 0){
			break;
		}

		//The spot values are stored in spot_val, so process the data as necessary
	}



	//Disconnect from the connected instrument
	CA2DSDK_DisconnectInstrument();

	//End usage of the SDK
	CA2DSDK_Disable();
}
