//---------------------------------------------------------------------------------------
/*!
@file	CA2Dcommon.h
@author	KONICA MINOLTA, INC.
		Copyright(c) KONICA MINOLTA, INC.  All rights reserved. 2013
*/
//---------------------------------------------------------------------------------------
#ifndef CA2D_COMMON_H__
#define CA2D_COMMON_H__

#include "CA2DTypeDefine.h"


#define MAX_CONNECT_LIST		10

#define MAXDATAROW				980				//!< row size max.
#define MAXDATACOL				980				//!< col size min.

#define FINDER_MAXDATAROW		490				//!< row size for finder
#define FINDER_MAXDATACOL		490				//!< col size for finder

#define LENS_NORMAL	0	//!< Lens type : Normal lens
#define LENS_WIDE	1	//!< Lens type : Wide lens
#define LENS_TELE	2	//!< Lens type : Telephoto lens
#define LENS_MACRO1	3	//!< Lens type : Macro 1 (low magnification)
#define LENS_MACRO2	4	//!< Lens type : Macro 2 (high magnification)
#define LENS_NUM	5	//!< Lens count

//Lens position						Normal		Wide	Telephoto	Macro1	Macro2
#define LENS_POSITION_0		0	//	0.25m		0.20m	0.90m		0.50m	0.30m
#define LENS_POSITION_1		1	//	0.25m+1/2	0.24m	0.90m+1/2
#define LENS_POSITION_2		2	//	0.30m		0.30m	1.00m
#define LENS_POSITION_3		3	//	0.30m+1/2	0.50m	1.00m+1/3
#define LENS_POSITION_4		4	//	0.50m		1.00m	1.00m+2/3
#define LENS_POSITION_5		5	//	0.50m+1/2	inf.	1.50m
#define LENS_POSITION_6		6	//	1.00m				1.50m+1/3
#define LENS_POSITION_7		7	//	1.00m+1/2			1.50m+2/3	
#define LENS_POSITION_8		8	//	inf.				3.00m	
#define LENS_POSITION_9		9	//						3.00m+1/3
#define LENS_POSITION_10	10	//						3.00m+2/3
#define LENS_POSITION_11	11	//						inf.

//Exposure mode
#define EXPOSURE_MANUAL		0	//!< Manual exposure
#define EXPOSURE_AUTO		1	//!< Auto exposure
#define EXPOSURE_MULTI		2	//!< Multiple exposure

//Synchronized measurement frequency
#define SYNCMODE_OFF		0			//!< Synchronized measurements : Do't care
#define SYNCMODE_ON			1			//!< Synchronized measurements
#define SYNC_MIN			4.0000		//!< Max. frequency
#define SYNC_MAX			2000.0000	//!< Min. frequency

//Exposure time table
#define EXPOSURE_INDEX_MIN		0		//!< Min.
#define EXPOSURE_INDEX_MAX		20		//!< Max.

//Cumulative number 
#define ADDITIONAL_MIN		1			//!< Min.
#define ADDITIONAL_MAX		256			//!< Max.

//Exposure setting area
#define EXPOSURE_AREA_MIN	0			//!< Min. 
#define EXPOSURE_AREA_MAX	979			//!< Max.

//Measurement component
#define FILTER_MEASURE_OFF	0		//!< XYZ measurements
#define FILTER_MEASURE_ON	1		//!< Filter measuement
//Filter index number
#define	FILTER_INDEX_X	0
#define	FILTER_INDEX_Y	1
#define	FILTER_INDEX_Z	2

//Smear compensation
#define	SMEAR_NONE		0	//!< None
#define	SMEAR_SIMPLE	1	//!< Simple compensation
#define	SMEAR_DETAIL	2	//!< Approximate compensation

//Apply user calibration
#define USERCAL_OFF		0	//!< OFF
#define USERCAL_ON		1	//!< ON

//Image orientation
#define ROTATION_NONE		0		//!< Output unmodified
#define ROTATION_RIGHT		1		//!< Rotate clockwise 90
#define ROTATION_INVERSION	2		//!< Rotate clockwise 180
#define ROTATION_LEFT		3		//!< Rotate clockwise 270

//Calibration type
#define USER_CALTYPE_NONE	0	//!< No calibration
#define USER_CALTYPE_NORMAL	1	//!< One-color calibration
#define USER_CALTYPE_RGB	2	//!< RGB calibration
#define USER_CALTYPE_WRGB	3	//!< WWRGB calibration
#define USER_CALTYPE_GAMUT	4	//!< Color gamut calibration
#define USER_CALTYPE_EDIT	5	//

//Measurement data error
#define COUNT_MAX_ERR			-3.302823e+38F	//!< Over error pixel
#define COUNT_MIN_ERR			-2.402823e+38F	//!< Under error pixel
#define CAL_ERROR				-1.402823e+38F	//!< Calculation error pixel

//Color specification value to calculate
#define VALTYPE_X						0
#define VALTYPE_Y						1
#define VALTYPE_Z						2
#define VALTYPE_LV						3
#define VALTYPE_S_X						4
#define VALTYPE_S_Y						5
#define VALTYPE_UD						6
#define VALTYPE_VD						7
#define VALTYPE_TCP						8
#define VALTYPE_DUV						9
#define VALTYPE_TCP_JIS					10
#define VALTYPE_DUV_JIS					11
#define VALTYPE_DWL						12		//!< Dominant wavelength
#define VALTYPE_PURITY					13
#define VALTYPE_EV						14
#define VALTYPE_COUNT                   15 

//Resolution
#define RESOLUTION_HIGH			0		//!< 980*980
#define RESOLUTION_MIDDLE		1		//!< 490*490
#define RESOLUTION_LOW			2		//!< 196*196

//Layout method
#define EXTTYPE_MANU	0	//!< Manual layout
#define EXTTYPE_AUTO	1	//!< Automatic layout

//Spot shape
#define SPOT_SHAPETYPE_CIRCLE	0	//!< Circle
#define SPOT_SHAPETYPE_RECT		1	//!< Rectangle

//Offset input method
#define SPOT_OFFSET_ABSOLUTE	0	//!< Absolute values
#define SPOT_OFFSET_RELATIVE	1	//!< Relative values

//Offset position
#define SPOT_OFFSET_CORNER		0	//!< Set spot edge as edge
#define SPOT_OFFSET_CENTER		1	//!< Set spot center as edge

//Color values of spot results 
#define VALTYPE_X_Y_Z			0		//!< X, Y, Z
#define VALTYPE_LV_SX_SY		1		//!< Lv, x, y
#define VALTYPE_Y_UD_VD			2		//!< Y, u', v'
#define VALTYPE_Y_TCP_DUV		3		//!< Y, Tcp, duv
#define VALTYPE_Y_TCP_DUV_JIS	4		//!< Y, Tcp(JIS), duv(JIS)
#define VALTYPE_Y_DWL_PURITY	5		//!< Y, ld, Pe

#ifdef LABVIEW
#pragma pack(1)
#endif

//Measurement conditions structure
struct tagInstrumentCond{
	int16_km	lensType;			//!< Lens type
	int16_km	lensPosition;		//!< Lens position
	int16_km	exposureMode;		//!< Exposure mode
	int16_km	measurementType;	//!< Measurement type
	double_km	syncValue;			//!< Synchronized measurement frequency
	int16_km	exposureIndex;		//!< Exposure time table
	int16_km	additional;			//!< Cumulative number
	int16_km	left;				//!< Exposure setting area
	int16_km	top;				
	int16_km	right;
	int16_km	bottom;				
	int16_km	filterMeasure;		//!< Measurement component
	int16_km	filterIndex;		//!< Filter index number
	int16_km	smearIndex;			//!< Smear compensation
	int16_km	userCal;			//!< Apply user calibration
	int16_km	rotate;				//!< Image orientation
};

//User calibration data structure
struct tagUserCalData{
	int16_km	calType;	//!< Calibration type
	double_km	R[3][2];	//!< Red data
	double_km	G[3][2];	//!< Green data
	double_km	B[3][2];	//!< Blue data
	double_km	W[3][2];	//!< White data
};

//Data structure
struct tagData{
	float_km	X[MAXDATAROW * MAXDATACOL];
	float_km	Y[MAXDATAROW * MAXDATACOL];
	float_km	Z[MAXDATAROW * MAXDATACOL];
};

//Data acquisition conditions structure
struct tagGetDataParam{
	int16_km	left;
	int16_km	top;
	int16_km	right;
	int16_km	bottom;
};

//Data configuration structure
struct tagDataCond{
	int16_km	valueType;			//!< Color specification value to calculate
	int16_km	resolution;			//!< Resolution
	int16_km	lower_enable;		//!< Turn on/off under errors
	int16_km	lower_item;			//!< Item of under errors
	double_km	lower_threshold;	//!< The threshold value to process as an under error
};

//Periodic calibration information structure
struct tagPeriodicalCalInfo{
	int32_km	Year;
	int32_km	Month;
	int32_km	Day;
	int32_km	Interval;
};


//Evaluation area structure
struct tagEvaluationArea{
	int16_km	left;
	int16_km	top;
	int16_km	right;
	int16_km	bottom;
};

//Evaluation area layout conditions structure
struct tagEvaluationCond{
	int16_km	type;				//!< Layout method
	int16_km	left;				//!< Area to detect 
	int16_km	top;
	int16_km	right;
	int16_km	bottom;
	int16_km	row;				//!< Vertical layout count
	int16_km	col;				//!< Horizontal layout count
	double_km	thresholdValue;		//!< Threshold value for detection
};

//Spot layout structure
struct tagAlignedSpotCond{
	int16_km	row;				//!< Vertical layout count
	int16_km	col;				//!< Horizontal layout count
	int16_km	shape;				//!< Shape
	float_km	height;				//!< Rectangle height (or circle diameter)
	float_km	width;				//!< Rectangle width
	int16_km	offset_input;		//!< Offset input method
	int16_km	offset_position;	//!< Offset position
	float_km	offset_left;		//!< Offset margin
	float_km	offset_top;
	float_km	offset_right;
	float_km	offset_bottom;
};

//Spot result structure
struct tagSpotValue{
	int16_km	color;				//!< Color values to get
	float_km	result[3];			//!< Color values
};

//Date structure 
struct tagDate{
	int32_km	Year;
	int32_km	Month;
	int32_km	Day;
};

#endif //CA2D_COMMON_H__
