﻿Imports System.Runtime.InteropServices

'--------------------------------------------------------------------------------------
'@author	KONICA MINOLTA, INC.
'		    Copyright(c) KONICA MINOLTA, INC.  All rights reserved. 2013
'---------------------------------------------------------------------------------------
'   int8_km = byte
'   int32_km = Integer
'   int16_km = Short
'   double_km = double
'   float_km = Single
'
Public Class clCA2DSDK
    '------------------------------------------const error----------------------------------------------
    Public Const CA2D_CANCEL As Integer = 0                    '!< Processing was canceled
    Public Const CA2D_OK As Integer = 1                        '!< Processing completed normally

    Public Const CA2D_OK_MEASURING As Integer = 10             '!< Measuring
    Public Const CA2D_OK_RUNNING_DIAGNOSIS As Integer = 11     '!< Running self-diagnostic

    Public Const CA2D_ER As Integer = -1                       '!< A problem occurred in the SDK

    Public Const CA2D_ER_ENABLE As Integer = -1000             '!< Initialization is not complete (Initialization failed)
    Public Const CA2D_ER_CONNECT As Integer = -1001            '!< Connection is not complete (Connection failed)

    Public Const CA2D_ER_INSTRUMENT As Integer = -1050         '!< The instrument information is incorrect

    Public Const CA2D_ER_MEASURING As Integer = -1100          '!< Cannot be processed because the measurement is running
    Public Const CA2D_ER_RUNNING_FINDER As Integer = -1101     '!< Processing is not possible because the finder is running
    Public Const CA2D_ER_RUNNING_DIAGNOSIS As Integer = -1102  '!< Cannot be processed because the instrument diagnostic is running

    Public Const CA2D_ER_DATA_NONE As Integer = -1150          '<! No measurement data (not measured or measurement error)

    Public Const CA2D_ER_EXPOSURE As Integer = -1200           '!< Not an appropriate exposure time
    Public Const CA2D_ER_AUTOEXPO_OVER As Integer = -1201      '!< Failed to calculate the exposure time (overexposed)
    Public Const CA2D_ER_AUTOEXPO_UNDER As Integer = -1202     '!< Failed to calculate the exposure time (underexposed)

    Public Const CA2D_ER_TEMPERATURE As Integer = -1250        '!< Temperature error

    Public Const CA2D_ER_USERCAL_NONE As Integer = -1300       '!< User calibration data has not been set
    Public Const CA2D_ER_USER_CALC As Integer = -1301          '!< The user calibration data is invalid (calibration factor could not be calculated)

    Public Const CA2D_ER_PERIODICAL_CAL As Integer = -1350     '!< Periodic calibration is now required

    Public Const CA2D_ER_DIAGNOSIS As Integer = -1400          '!< Stopped due to an error that occurred during the diagnostic
    Public Const CA2D_ER_DIAGNOSIS_AREA As Integer = -1401     '!< There is a problem with the diagnostic results
    Public Const CA2D_ER_DIAGNOSIS_CAUTION As Integer = -1402  '!< The diagnostic results have reached the caution level
    Public Const CA2D_ER_DIAGNOSIS_WARNING As Integer = -1403  '!< The diagnostic results have reached the warning level

    Public Const CA2D_ER_FILE_NOTFOUND_LENSTYPE As Integer = -1500     '!< The lens type file does not exist
    Public Const CA2D_ER_FILE_NOTFOUND_CALIBRATION As Integer = -1501  '!< Calibration data file does not exist
    Public Const CA2D_ER_FILE_FORMAT As Integer = -1502                '!< Invalid file format
    Public Const CA2D_ER_FILE_ACCESS As Integer = -1503                '!< Could not access the file

    Public Const CA2D_ER_PARAM As Integer = -1600                  '!< Invalid argument specification
    Public Const CA2D_ER_PARAM_INDEX As Integer = -1610            '!< Invalid instrument specification (the specified instrument does not exist)

    Public Const CA2D_ER_PARAM_LENSTYPE As Integer = -1620         '!< Invalid lens type specification (lens cannot be used)
    Public Const CA2D_ER_PARAM_LENSPOS As Integer = -1621          '!< Invalid focus ring distance indicator specification
    Public Const CA2D_ER_PARAM_EXPOSURE_MODE As Integer = -1622    '!< Invalid exposure mode specification
    Public Const CA2D_ER_PARAM_EXPOSURE_INDEX As Integer = -1623   '!< Invalid exposure table index number specification
    Public Const CA2D_ER_PARAM_EXPOSURE_AREA As Integer = -1624    '!< Invalid exposure setting area setting
    Public Const CA2D_ER_PARAM_SYNC_MODE As Integer = -1625        '!< Invalid synchronized measurement mode specification
    Public Const CA2D_ER_PARAM_SYNC_VALUE As Integer = -1626       '!< Invalid synchronization frequency specification
    Public Const CA2D_ER_PARAM_ADDITIONAL As Integer = -1627       '!< Invalid cumulative number specification
    Public Const CA2D_ER_PARAM_FILTER As Integer = -1628           '!< Invalid filter measurement specification
    Public Const CA2D_ER_PARAM_FILTER_INDEX As Integer = -1629     '!< Invalid filter type specification
    Public Const CA2D_ER_PARAM_SMEAR As Integer = -1630            '!< Invalid smear compensation specification
    Public Const CA2D_ER_PARAM_USERCAL As Integer = -1631          '!< Invalid user calibration specification
    Public Const CA2D_ER_PARAM_ROTATION As Integer = -1632         '!< Invalid image orientation specification

    Public Const CA2D_ER_PARAM_FILE As Integer = -1640             '!< Invalid file path (folder path)
    Public Const CA2D_ER_PARAM_CALTYPE As Integer = -1650          '!< Invalid calibration type specification
    Public Const CA2D_ER_PARAM_GETAREA As Integer = -1660          '!< Invalid data acquisition area specification

    Public Const CA2D_ER_PARAM_VALTYPE As Integer = -1670          '!< Invalid color specification value specification
    Public Const CA2D_ER_PARAM_RESOLUTION As Integer = -1671       '!< Invalid resolution specification
    Public Const CA2D_ER_PARAM_LOWER_LEVEL As Integer = -1672      '!< Invalid threshold value specification to process as an under error

    Public Const CA2D_ER_PARAM_EVAL_TYPE As Integer = -1680        '!< Invalid layout type specification
    Public Const CA2D_ER_PARAM_EVAL_AREA As Integer = -1681        '!< Invalid area specification
    Public Const CA2D_ER_PARAM_EVAL_COUNT As Integer = -1682       '!< Invalid detection count specification
    Public Const CA2D_ER_PARAM_EVAL_LEVEL As Integer = -1683       '!< Invalid detection threshold value specification

    Public Const CA2D_ER_PARAM_SPOT_COUNT As Integer = -1690       '!< Invalid layout count specification
    Public Const CA2D_ER_PARAM_SPOT_SHAPE As Integer = -1691       '!< Invalid shape specification
    Public Const CA2D_ER_PARAM_SPOT_SIZE As Integer = -1692        '!< Invalid size specification
    Public Const CA2D_ER_PARAM_SPOT_OFFSET_INPUT As Integer = -1693    '!< Invalid offset input method specification
    Public Const CA2D_ER_PARAM_SPOT_OFFSET_POS As Integer = -1694      '!< Invalid offset layout position specification
    Public Const CA2D_ER_PARAM_SPOT_OFFSET_AREA As Integer = -1695     '!< Invalid offset margin specification

    Public Const CA2D_ER_PARAM_NUM As Integer = -1700              '!< Invalid evaluation area number specification
    Public Const CA2D_ER_PARAM_POINT As Integer = -1701            '!< Invalid spot area specification

    Public Const CA2D_ER_EVAL_CALC As Integer = -1710              '!< Could not correctly layout the evaluation areas
    Public Const CA2D_ER_SPOT_CALC As Integer = -1711              '!< Could not correctly lay out the spots

    Public Const CA2D_ER_MEASURE_CALC As Integer = -1800           '!< Measurement calculation failed


    Public Const CA2D_ER_COMMUNICATION As Integer = -5000          '!< Could not communicate with the instrument
    Public Const CA2D_ER_COM_FILTER As Integer = -5010             '!< Filter control is not operating correctly
    Public Const CA2D_ER_COM_STATUS As Integer = -5020             '!< Get status is not operating correctly
    Public Const CA2D_ER_COM_MEASURE As Integer = -5030            '!< Measurement control is not operating correctly
    Public Const CA2D_ER_COM_FINDER As Integer = -5040             '!< Finder measurement is not operating correctly
    Public Const CA2D_ER_COM_SHUTTERSPEED As Integer = -5050       '!< Shutter speed control is not operating correctly
    Public Const CA2D_ER_COM_GAIN As Integer = -5060               '!< Gain control is not operating correctly
    Public Const CA2D_ER_COM_ADDTIONAL As Integer = -5070          '!< Cumulative number control is not operating correctly
    Public Const CA2D_ER_COM_GETDATA As Integer = -5110            '!< Data acquisition control is not operating correctly
    Public Const CA2D_ER_COM_TEMPERATURE As Integer = -5120        '!< emperature control is not operating correctly
    Public Const CA2D_ER_COM_FAN As Integer = -5130                '!< Fan control is not operating correctly
    Public Const CA2D_ER_COM_MOTOR As Integer = -5140              '!< Motor control is not operating correctly
    Public Const CA2D_ER_COM_MEMORY As Integer = -5150             '!< Insufficient memory
    Public Const CA2D_ER_COM_DETECT As Integer = -5200             '!< The instrument was disconnected
    Public Const CA2D_ER_USBDLL As Integer = -5300                 '!< USB driver control is not operating correctly

    'praivate info.
    Public Const CA2D_ER_COM_BINNING As Integer = -5080
    Public Const CA2D_ER_COM_EXAMINATIONAREA As Integer = -5090
    Public Const CA2D_ER_COM_CCDMODE As Integer = -5100

    '------------------------------------------common---------------------------------------------------
    Public Const MAX_CONNECT_LIST As Integer = 10

    Public Const MAXDATAROW As Integer = 980               'row size max.
    Public Const MAXDATACOL As Integer = 980               '!< col size min.

    Public Const FINDER_MAXDATAROW As Integer = 490        '!< row size for finder
    Public Const FINDER_MAXDATACOL As Integer = 490        '!< col size for finder

    Public Const LENS_NORMAL As Integer = 0    '!< Lens type : Normal lens
    Public Const LENS_WIDE As Integer = 1      '!< Lens type : Wide lens
    Public Const LENS_TELE As Integer = 2      '!< Lens type : Telephoto lens
    Public Const LENS_MACRO1 As Integer = 3    '!< Lens type : Macro 1 (low magnification)
    Public Const LENS_MACRO2 As Integer = 4    '!< Lens type : Macro 2 (high magnification)
    Public Const LENS_NUM As Integer = 5       '!< Lens count

    'Lens position						            Normal		Wide	Telephoto	Macro1	Macro2
    Public Const LENS_POSITION_0 As Integer = 0    '0.25m		0.20m	0.90m		0.50m	0.30m
    Public Const LENS_POSITION_1 As Integer = 1    '0.25m+1/2	0.24m	0.90m+1/2
    Public Const LENS_POSITION_2 As Integer = 2    '0.30m		0.30m	1.00m
    Public Const LENS_POSITION_3 As Integer = 3    '0.30m+1/2	0.50m	1.00m+1/3
    Public Const LENS_POSITION_4 As Integer = 4    '0.50m		1.00m	1.00m+2/3
    Public Const LENS_POSITION_5 As Integer = 5    '0.50m+1/2	inf.	1.50m
    Public Const LENS_POSITION_6 As Integer = 6    '1.00m				1.50m+1/3
    Public Const LENS_POSITION_7 As Integer = 7    '1.00m+1/2			1.50m+2/3	
    Public Const LENS_POSITION_8 As Integer = 8    'inf.				3.00m	
    Public Const LENS_POSITION_9 As Integer = 9    '					3.00m+1/3
    Public Const LENS_POSITION_10 As Integer = 10  '					3.00m+2/3
    Public Const LENS_POSITION_11 As Integer = 11  '					inf.

    'Exposure mode
    Public Const EXPOSURE_MANUAL As Integer = 0    '!< Manual exposure
    Public Const EXPOSURE_AUTO As Integer = 1      '!< Auto exposure
    Public Const EXPOSURE_MULTI As Integer = 2     '!< Multiple exposure

    'Synchronized measurement frequency
    Public Const SYNCMODE_OFF As Integer = 0       '!< Synchronized measurements : Do't care
    Public Const SYNCMODE_ON As Integer = 1        '!< Synchronized measurements
    Public Const SYNC_MIN As Single = 4.0F          '!< Max. frequency
    Public Const SYNC_MAX As Single = 2000.0F       '!< Min. frequency

    'Exposure time table
    Public Const EXPOSURE_INDEX_MIN As Integer = 0     '!< Min.
    Public Const EXPOSURE_INDEX_MAX As Integer = 20    '!< Max.

    'Cumulative number 
    Public Const ADDITIONAL_MIN As Integer = 1         '!< Min.
    Public Const ADDITIONAL_MAX As Integer = 256       '!< Max.

    'Exposure setting area
    Public Const EXPOSURE_AREA_MIN As Integer = 0      '!< Min. 
    Public Const EXPOSURE_AREA_MAX As Integer = 979    '!< Max.

    'Measurement component
    Public Const FILTER_MEASURE_OFF As Integer = 0     '!< XYZ measurements
    Public Const FILTER_MEASURE_ON As Integer = 1      '!< Filter measuement

    'Filter index number
    Public Const FILTER_INDEX_X As Integer = 0
    Public Const FILTER_INDEX_Y As Integer = 1
    Public Const FILTER_INDEX_Z As Integer = 2

    'Smear compensation
    Public Const SMEAR_NONE As Integer = 0     '!< None
    Public Const SMEAR_SIMPLE As Integer = 1   '!< Simple compensation
    Public Const SMEAR_DETAIL As Integer = 2   '!< Approximate compensation

    'Apply user calibration
    Public Const USERCAL_OFF As Integer = 0    '!< OFF
    Public Const USERCAL_ON As Integer = 1     '!< ON

    'Image orientation
    Public Const ROTATION_NONE As Integer = 0      '!< Output unmodified
    Public Const ROTATION_RIGHT As Integer = 1     '!< Rotate clockwise 90
    Public Const ROTATION_INVERSION As Integer = 2 '!< Rotate clockwise 180
    Public Const ROTATION_LEFT As Integer = 3      '!< Rotate clockwise 270

    'Calibration type
    Public Const USER_CALTYPE_NONE As Integer = 0      '!< No calibration
    Public Const USER_CALTYPE_NORMAL As Integer = 1    '!< One-color calibration
    Public Const USER_CALTYPE_RGB As Integer = 2       '!< RGB calibration
    Public Const USER_CALTYPE_WRGB As Integer = 3      '!< WWRGB calibration
    Public Const USER_CALTYPE_GAMUT As Integer = 4     '!< Color gamut calibration
    Public Const USER_CALTYPE_EDIT As Integer = 5

    'Measurement data error
    Public Const COUNT_MAX_ERR As Single = -3.302823E+38F  '!< Over error pixel
    Public Const COUNT_MIN_ERR As Single = -2.402823E+38F  '!< Under error pixel
    Public Const CAL_ERROR As Single = -1.402823E+38F      '!< Calculation error pixel

    'Color specification value to calculate
    Public Const VALTYPE_X As Integer = 0
    Public Const VALTYPE_Y As Integer = 1
    Public Const VALTYPE_Z As Integer = 2
    Public Const VALTYPE_LV As Integer = 3
    Public Const VALTYPE_S_X As Integer = 4
    Public Const VALTYPE_S_Y As Integer = 5
    Public Const VALTYPE_UD As Integer = 6
    Public Const VALTYPE_VD As Integer = 7
    Public Const VALTYPE_TCP As Integer = 8
    Public Const VALTYPE_DUV As Integer = 9
    Public Const VALTYPE_TCP_JIS As Integer = 10
    Public Const VALTYPE_DUV_JIS As Integer = 11
    Public Const VALTYPE_DWL As Integer = 12      '!< Dominant wavelength
    Public Const VALTYPE_PURITY As Integer = 13
    Public Const VALTYPE_EV As Integer = 14
    Public Const VALTYPE_COUNT As Integer = 15

    'Resolution
    Public Const RESOLUTION_HIGH As Integer = 0     '!< 980*980
    Public Const RESOLUTION_MIDDLE As Integer = 1     '!< 490*490
    Public Const RESOLUTION_LOW As Integer = 2       '!< 196*196

    'Layout method
    Public Const EXTTYPE_MANU As Integer = 0   '!< Manual layout
    Public Const EXTTYPE_AUTO As Integer = 1   '!< Automatic layout

    'Spot shape
    Public Const SPOT_SHAPETYPE_CIRCLE As Integer = 0  '!< Circle
    Public Const SPOT_SHAPETYPE_RECT As Integer = 1   '!< Rectangle

    'Offset input method
    Public Const SPOT_OFFSET_ABSOLUTE As Integer = 0 '!< Absolute values
    Public Const SPOT_OFFSET_RELATIVE As Integer = 1 '!< Relative values

    'Offset position
    Public Const SPOT_OFFSET_CORNER As Integer = 0   '!< Set spot edge as edge
    Public Const SPOT_OFFSET_CENTER As Integer = 1   '!< Set spot center as edge

    'Color values of spot results 
    Public Const VALTYPE_X_Y_Z As Integer = 0       '!< X, Y, Z
    Public Const VALTYPE_LV_SX_SY As Integer = 1       '!< Lv, x, y
    Public Const VALTYPE_Y_UD_VD As Integer = 2       '!< Y, u’, v’
    Public Const VALTYPE_Y_TCP_DUV As Integer = 3       '!< Y, Tcp, ⊿uv
    Public Const VALTYPE_Y_TCP_DUV_JIS As Integer = 4      '!< Y, Tcp(JIS), ⊿uv(JIS)
    Public Const VALTYPE_Y_DWL_PURITY As Integer = 5       '!< Y, 主波長, 刺激純度


    'Measurement conditions structure
    Public Structure tagInstrumentCond
        Public lensType As Short             '!< Lens type
        Public lensPosition As Short         '!< Lens position
        Public exposureMode As Short         '!< Exposure mode
        Public measurementType As Short      '!< Measurement type
        Public syncValue As Double              '!< Synchronized measurement frequency
        Public exposureIndex As Short            '!< Exposure time table
        Public additional As Short               '!< Cumulative number
        Public left As Short                 '!< Exposure setting area
        Public top As Short
        Public right As Short
        Public bottom As Short
        Public filterMeasure As Short            '!< Measurement component
        Public filterIndex As Short          '!< Filter index number
        Public smearIndex As Short               '!< Smear compensation
        Public userCal As Short              '!< Apply user calibration
        Public rotate As Short                   '!< Image orientation
    End Structure

    'User calibration data structure
    Public Structure tagUserCalData
        Public calType As Short      '!< Calibration type
        <MarshalAs(UnmanagedType.ByValArray, SizeConst:=(6))> Public R() As Double    '!< Red data
        <MarshalAs(UnmanagedType.ByValArray, SizeConst:=(6))> Public G() As Double    '!< Green data
        <MarshalAs(UnmanagedType.ByValArray, SizeConst:=(6))> Public B() As Double    '!< Blue data
        <MarshalAs(UnmanagedType.ByValArray, SizeConst:=(6))> Public W() As Double    '!< White data
    End Structure

    'Data structure
    Public Structure tagData
        <MarshalAs(UnmanagedType.ByValArray, SizeConst:=(MAXDATAROW * MAXDATACOL - 1))> Public X() As Single
        <MarshalAs(UnmanagedType.ByValArray, SizeConst:=(MAXDATAROW * MAXDATACOL - 1))> Public Y() As Single
        <MarshalAs(UnmanagedType.ByValArray, SizeConst:=(MAXDATAROW * MAXDATACOL - 1))> Public Z() As Single
    End Structure

    'Data acquisition conditions structure
    Public Structure tagGetDataParam
        Public left As Short
        Public top As Short
        Public right As Short
        Public bottom As Short
    End Structure

    'Data configuration structure
    Public Structure tagDataCond
        Public valueType As Short                '!< Color specification value to calculate
        Public resolution As Short               '!< Resolution
        Public lower_enable As Short         '!< Turn on/off under errors
        Public lower_item As Short               '!< Item of under errors
        Public lower_threshold As Double        '!< The threshold value to process as an under error
    End Structure

    'Periodic calibration information structure
    Public Structure tagPeriodicalCalInfo
        Public Year As Integer
        Public Month As Integer
        Public Day As Integer
        Public Interval As Integer
    End Structure


    'Evaluation area structure
    Public Structure tagEvaluationArea
        Public left As Short
        Public top As Short
        Public right As Short
        Public bottom As Short
    End Structure

    'Evaluation area layout conditions structure
    Public Structure tagEvaluationCond
        Public type As Short                 '!< Layout method
        Public left As Short                 '!< Area to detect 
        Public top As Short
        Public right As Short
        Public bottom As Short
        Public row As Short                  '!< Vertical layout count
        Public col As Short                  '!< Horizontal layout count
        Public thresholdValue As Double     '!< Threshold value for detection
    End Structure

    'Spot layout structure
    Public Structure tagAlignedSpotCond
        Public row As Short                  '!< Vertical layout count
        Public col As Short                  '!< Horizontal layout count
        Public shape As Short                '!< Shape
        Public height As Single             '!< Rectangle height (or circle diameter)
        Public width As Single              '!< Rectangle width
        Public offset_input As Short         '!< Offset input method
        Public offset_position As Short      '!< Offset position
        Public offset_left As Single        '!< Offset margin
        Public offset_top As Single
        Public offset_right As Single
        Public offset_bottom As Single
    End Structure

    'Spot result structure
    Public Structure tagSpotValue
        Public color As Short                    '!< Color values to get
        <MarshalAs(UnmanagedType.ByValArray, SizeConst:=3)> Public result() As Single '!< Color values
    End Structure

    'Date structure
    Public Structure tagDate
        Public Year As Integer
        Public Month As Integer
        Public Day As Integer
    End Structure

    '------------------------------------------------CA2DSDK.dll API----------------------------------------------------
    'Enable the SDK
    Declare Function CA2DSDK_Enable Lib "CA2DSDK.dll" () As Integer
    'End usage of the SDK
    Declare Function CA2DSDK_Disable Lib "CA2DSDK.dll" () As Integer
    'Connect to the specified instrument
    Declare Function CA2DSDK_ConnectInstrument Lib "CA2DSDK.dll" (ByVal index As Integer) As Integer
    'Disconnect from the connected instrument
    Declare Function CA2DSDK_DisconnectInstrument Lib "CA2DSDK.dll" () As Integer
    'Check the connection state
    Declare Function CA2DSDK_IsConnectInstrument Lib "CA2DSDK.dll" () As Integer
    'Get the number of instruments connected to the PC
    Declare Function CA2DSDK_GetInstrumentCount Lib "CA2DSDK.dll" () As Integer
    'Get the serial number of the specified instrument
    Declare Function CA2DSDK_GetInstrumentSerialNumber Lib "CA2DSDK.dll" (ByVal index As Integer) As Integer
    'Set the measurement conditions
    Declare Function CA2DSDK_SetInstrumentCondition Lib "CA2DSDK.dll" (ByRef pInstCond As tagInstrumentCond) As Integer
    'Get the measurement conditions
    Declare Function CA2DSDK_GetInstrumentCondition Lib "CA2DSDK.dll" (ByRef pInstCond As tagInstrumentCond) As Integer
    'Set the user calibration data
    Declare Function CA2DSDK_SetUserCalibrationData Lib "CA2DSDK.dll" (ByRef pInstCond As tagUserCalData) As Integer
    'Get the user calibration data
    Declare Function CA2DSDK_GetUserCalibrationData Lib "CA2DSDK.dll" (ByRef pInstCond As tagUserCalData) As Integer
    'Start the measurement
    Declare Function CA2DSDK_DoMeasurement Lib "CA2DSDK.dll" () As Integer
    'Check the measurement
    Declare Function CA2DSDK_PollingMeasurement Lib "CA2DSDK.dll" () As Integer
    'Stop the completion of the measurement
    Declare Function CA2DSDK_StopMeasurement Lib "CA2DSDK.dll" () As Integer
    'Get the data
    Declare Function CA2DSDK_GetAreaData Lib "CA2DSDK.dll" (ByRef pDataParam As tagGetDataParam, ByRef pData As Single) As Integer
    'Set the conditions for calculating data
    Declare Function CA2DSDK_SetDataCondition Lib "CA2DSDK.dll" (ByRef pDataCond As tagDataCond) As Integer
    'Get the data settings
    Declare Function CA2DSDK_GetDataCondition Lib "CA2DSDK.dll" (ByRef pDataCond As tagDataCond) As Integer
    'Clear the evaluation areas
    Declare Function CA2DSDK_ClearEvaluationArea Lib "CA2DSDK.dll" () As Integer
    'Set the evaluation area layout conditions
    Declare Function CA2DSDK_SetEvaluationAreaCondition Lib "CA2DSDK.dll" (ByRef pCond As tagEvaluationCond) As Integer
    'Get the evaluation area layout conditions
    Declare Function CA2DSDK_GetEvaluationAreaCondition Lib "CA2DSDK.dll" (ByRef pCond As tagEvaluationCond) As Integer
    'Add an evaluation area
    Declare Function CA2DSDK_AddEvaluationArea Lib "CA2DSDK.dll" (ByRef pArea As tagEvaluationArea) As Integer
    'Get the number of evaluation areas
    Declare Function CA2DSDK_GetEvaluationAreaCount Lib "CA2DSDK.dll" (ByRef pCount As Integer) As Integer
    'Get the evaluation area
    Declare Function CA2DSDK_GetEvaluationArea Lib "CA2DSDK.dll" (ByVal num As Integer, ByRef pArea As tagEvaluationArea) As Integer
    'Set the spot aligned layout conditions
    Declare Function CA2DSDK_SetAlignedSpotCondition Lib "CA2DSDK.dll" (ByRef pCond As tagAlignedSpotCond) As Integer
    'Get the spot aligned layout conditions
    Declare Function CA2DSDK_GetAlignedSpotCondition Lib "CA2DSDK.dll" (ByRef pCond As tagAlignedSpotCond) As Integer
    'Calculate the spot results
    Declare Function CA2DSDK_CalculateSpotValue Lib "CA2DSDK.dll" () As Integer
    'Get the spot result
    Declare Function CA2DSDK_GetSpotValue Lib "CA2DSDK.dll" (ByVal num As Integer, ByVal point As Integer, ByRef pResult As tagSpotValue) As Integer
    'Start the instrument diagnostic
    Declare Function CA2DSDK_DiagnosisInstrument Lib "CA2DSDK.dll" () As Integer
    'Check the instrument diagnostic
    Declare Function CA2DSDK_PollingDiagnosis Lib "CA2DSDK.dll" () As Integer
    'Stop the completion of the instrument diagnostic
    Declare Function CA2DSDK_StopDiagnosis Lib "CA2DSDK.dll" () As Integer
    'Get the finder image
    Declare Function CA2DSDK_GetFinderImage Lib "CA2DSDK.dll" (ByRef pData As Short) As Integer
    'Check if periodic calibration is required
    Declare Function CA2DSDK_CheckPeriodicalCalibration Lib "CA2DSDK.dll" (ByRef pInfo As tagPeriodicalCalInfo) As Integer
    'Get the SDK version
    Declare Function CA2DSDK_GetSDKVersion Lib "CA2DSDK.dll" () As Integer

End Class

