﻿Imports Measurement.clCA2DSDK

Public Class Form1

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

    End Sub

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click

        Button1.Enabled = False

        Dim ret As Integer = 0

        'Enable the SDK
        ret = CA2DSDK_Enable()
        If (ret < CA2D_OK) Then
            Button1.Enabled = True
            Return
        End If

        'Connect to the specified instrument
        ret = CA2DSDK_ConnectInstrument(0)
        If (ret < CA2D_OK) Then
            CA2DSDK_Disable()
            Button1.Enabled = True
            Return
        End If

        'Set the measurement conditions
        Dim cond As tagInstrumentCond
        cond.lensType = LENS_NORMAL             'Normal lens
        cond.lensPosition = 0                   '0.25m
        cond.exposureMode = EXPOSURE_AUTO       'Auto exposure
        cond.measurementType = SYNCMODE_OFF     'Synchronized measurements : Don't care
        cond.syncValue = 60.0
        cond.exposureIndex = 11
        cond.additional = 1
        cond.left = 0
        cond.top = 0
        cond.right = 979
        cond.bottom = 979
        cond.filterMeasure = FILTER_MEASURE_OFF 'XYZ measurements
        cond.filterIndex = FILTER_INDEX_Y
        cond.smearIndex = SMEAR_NONE
        cond.userCal = USERCAL_OFF
        cond.rotate = ROTATION_NONE

        ret = CA2DSDK_SetInstrumentCondition(cond)
        If (ret < 0) Then
            CA2DSDK_DisconnectInstrument()
            CA2DSDK_Disable()
            Button1.Enabled = True
            Return
        End If

        'Start the measurement
        ret = CA2DSDK_DoMeasurement()
        If (ret < 0) Then
            CA2DSDK_DisconnectInstrument()
            CA2DSDK_Disable()
            Button1.Enabled = True
            Return
        End If
        While (1)
            ret = CA2DSDK_PollingMeasurement()
            If (ret = CA2D_OK) Then
                'When measurement is complete
                Exit While
            ElseIf (ret >= CA2D_OK) Then
                'When measuring
            Else
                'When an error has occurred
                CA2DSDK_DisconnectInstrument()
                CA2DSDK_Disable()
                Button1.Enabled = True
                Return
            End If
            'wait 1sec
            System.Threading.Thread.Sleep(1000)
        End While

        'The conditions to calculate data
        Dim cond_d As tagDataCond
        cond_d.lower_enable = 0
        cond_d.lower_item = 1
        cond_d.lower_threshold = 3
        cond_d.resolution = 0

        'Data acquisition area
        Dim paramArea As tagGetDataParam
        paramArea.left = 0
        paramArea.top = 0
        paramArea.right = 979
        paramArea.bottom = 979

        Dim pData = New Single(MAXDATAROW * MAXDATACOL - 1) {}
        'Gets X/Y/Z image data
        Dim j As Integer
        For j = VALTYPE_X To VALTYPE_Z
            'Set the conditions to calculate data
            cond_d.valueType = j
            ret = CA2DSDK_SetDataCondition(cond_d)
            If (ret < 0) Then
                Exit For
            End If

            'Get the data for the specified area
            ret = CA2DSDK_GetAreaData(paramArea, pData(0))
            If (ret < 0) Then
                Exit For
            End If

            'The image is stored in pData, so process the data as necessary
        Next
        'pData = Nothing
        ReDim pData(0)

        'Clear the evaluation areas
        ret = CA2DSDK_ClearEvaluationArea()
        If (ret < 0) Then
            CA2DSDK_DisconnectInstrument()
            CA2DSDK_Disable()
            Button1.Enabled = True
            Return
        End If

        'Set the evaluation area layout conditions
        Dim cond_e As tagEvaluationCond
        cond_e.type = 0
        ret = CA2DSDK_SetEvaluationAreaCondition(cond_e)
        If (ret < 0) Then
            CA2DSDK_DisconnectInstrument()
            CA2DSDK_Disable()
            Button1.Enabled = True
            Return
        End If

        'Set the conditions to lay out the spots
        Dim cond_spot As tagAlignedSpotCond
        cond_spot.row = 3                               'Vertical layout count
        cond_spot.col = 3                               'Horizontal layout count
        cond_spot.shape = SPOT_SHAPETYPE_CIRCLE         'Circle
        cond_spot.height = 50                           'Circle diameter : 50pixel
        cond_spot.width = 50
        cond_spot.offset_input = SPOT_OFFSET_RELATIVE   'Relative values
        cond_spot.offset_position = SPOT_OFFSET_CENTER  'Set spot center as edge
        cond_spot.offset_left = 10                      ' H/10
        cond_spot.offset_top = 10                       ' V/10
        cond_spot.offset_right = 10                     ' H/10
        cond_spot.offset_bottom = 10                    ' V/10
        ret = CA2DSDK_SetAlignedSpotCondition(cond_spot)
        If (ret < 0) Then
            CA2DSDK_DisconnectInstrument()
            CA2DSDK_Disable()
            Button1.Enabled = True
            Return
        End If

        'Calculate the spot results
        ret = CA2DSDK_CalculateSpotValue()
        If (ret < 0) Then
            CA2DSDK_DisconnectInstrument()
            CA2DSDK_Disable()
            Button1.Enabled = True
            Return
        End If


        'Get the spot results
        Dim spot_val As New tagSpotValue
        ReDim spot_val.result(2)
        spot_val.color = 1

        Dim i As Integer

        For i = 0 To 8
            ret = CA2DSDK_GetSpotValue(0, i, spot_val)
            If (ret < 0) Then
                Exit For
            End If

            'The spot values are stored in spot_val, so process the data as necessary
        Next

        'Disconnect from the connected instrument
        CA2DSDK_DisconnectInstrument()

        'End usage of the SDK
        CA2DSDK_Disable()

        Button1.Enabled = True

    End Sub

End Class