﻿' Sample Code for CA-SDK
' Copyright (c) 2016 KONICA MINOLTA, INC.

Public Class Form1
    Private objCa200 As Ca200
    Private WithEvents objCa As Ca
    Private objProbe As Probe
    Private isMsr As Boolean

    Private Sub Form1_FormClosing(sender As Object, e As FormClosingEventArgs) Handles Me.FormClosing
        objCa.RemoteMode = 0
        objCa200 = Nothing
        objCa = Nothing
        objProbe = Nothing
    End Sub

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles Me.Load
        On Error GoTo Error1

        objCa200 = New Ca200
        objCa200.AutoConnect()
        objCa = objCa200.SingleCa
        objProbe = objCa.SingleProbe

        ButtonCancel.Enabled = False
        ButtonMeasure.Enabled = True
        ButtonCalZero.Enabled = True
        Exit Sub

Error1:
        DisplayError()
        End

    End Sub

    Private Sub DisplayError()
        Dim msg As String
        msg = "Error from" + Err.Source + vbCrLf
        msg = msg + Err.Description + vbCrLf
        msg = msg + "HR:" + (Err.Number - vbObjectError).ToString
        MessageBox.Show(msg)
    End Sub

    Private Sub ButtonCancel_Click(sender As Object, e As EventArgs) Handles ButtonCancel.Click
        isMsr = False
        ButtonCancel.Enabled = False
        ButtonMeasure.Enabled = True
        ButtonCalZero.Enabled = True
    End Sub

    Private Sub ButtonMeasure_Click(sender As Object, e As EventArgs) Handles ButtonMeasure.Click
        Dim i As Integer

        On Error GoTo Error2

        isMsr = True
        ButtonCancel.Enabled = True
        ButtonMeasure.Enabled = False
        ButtonCalZero.Enabled = False
        For i = 1 To 20
            objCa.Measure()
            LabelLv.Text = objProbe.Lv.ToString("##0.00")
            Labelx.Text = objProbe.sx.ToString("0.0000")
            Labely.Text = objProbe.sy.ToString("0.0000")
            LabelT.Text = objProbe.T.ToString("####")
            Labelduv.Text = objProbe.duv.ToString("0.0000")
            Application.DoEvents()
            If isMsr = False Then
                Exit For
            End If
        Next

        ButtonCancel.Enabled = False
        ButtonMeasure.Enabled = True
        ButtonCalZero.Enabled = True
        Exit Sub

Error2:
        DisplayError()
        End

    End Sub

    Private Sub ButtonCalZero_Click(sender As Object, e As EventArgs) Handles ButtonCalZero.Click
        Dim calzero_success As Boolean = False

        While calzero_success = False
            ButtonMeasure.Enabled = False
            ButtonCalZero.Enabled = False
            Try
                objCa.CalZero()
                calzero_success = True
            Catch er As Exception
                DisplayError()
                If MessageBox.Show("Zero Cal Error" + vbCrLf + "Retry?", "CalZero", MessageBoxButtons.OKCancel) = DialogResult.Cancel Then
                    objCa.RemoteMode = 0
                    End
                End If
            End Try
        End While

        ButtonMeasure.Enabled = True
        ButtonCalZero.Enabled = True

    End Sub

    Private Sub objCa_ExeCalZero() Handles objCa.ExeCalZero
        If MessageBox.Show("CalZero?", "CalZero", MessageBoxButtons.OKCancel) = DialogResult.Cancel Then
            Exit Sub
        End If
        ButtonMeasure.Enabled = False
        ButtonCalZero.Enabled = False

        Try
            objCa.CalZero()
        Catch er As Exception
            DisplayError()
        End Try

        ButtonMeasure.Enabled = True
        ButtonCalZero.Enabled = True

    End Sub
End Class
