/*
 *  SVC interface library
 *
 *     created from include/nlif/nlif.h
 */

#include <basic.h>
#include <sys/svc.h>
#include <nlif/sys/svc/fnnlif.h>
#include <nlif/sys/svc/ifnlif.h>

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_1"
#endif /* #ifdef __CC_ARM */
EXPORT int genl_connect(
    struct nl_sock *sk)
{
    NLIF_GENL_CONNECT_PARA packet;

    packet.sk = sk;
    return (int)call_svc_tk(
        &packet,
        NLIF_GENL_CONNECT_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_2"
#endif /* #ifdef __CC_ARM */
EXPORT int genl_ctrl_alloc_cache(
    struct nl_sock *sock, 
    struct nl_cache **result)
{
    NLIF_GENL_CTRL_ALLOC_CACHE_PARA packet;

    packet.sock = sock;
    packet.result = result;
    return (int)call_svc_tk(
        &packet,
        NLIF_GENL_CTRL_ALLOC_CACHE_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_3"
#endif /* #ifdef __CC_ARM */
EXPORT struct genl_family * genl_ctrl_search_by_name(
    struct nl_cache *cache, 
    const char *name)
{
    NLIF_GENL_CTRL_SEARCH_BY_NAME_PARA packet;

    packet.cache = cache;
    packet.name = name;
    return (struct genl_family *)call_svc_tk(
        &packet,
        NLIF_GENL_CTRL_SEARCH_BY_NAME_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_4"
#endif /* #ifdef __CC_ARM */
EXPORT void genl_family_put(
    struct genl_family *family)
{
    NLIF_GENL_FAMILY_PUT_PARA packet;

    packet.family = family;
    (void)call_svc_tk(
        &packet,
        NLIF_GENL_FAMILY_PUT_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_5"
#endif /* #ifdef __CC_ARM */
EXPORT void nl_cache_free(
    struct nl_cache *cache)
{
    NLIF_NL_CACHE_FREE_PARA packet;

    packet.cache = cache;
    (void)call_svc_tk(
        &packet,
        NLIF_NL_CACHE_FREE_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_6"
#endif /* #ifdef __CC_ARM */
EXPORT struct nl_cb * nl_cb_alloc(
    enum nl_cb_kind kind)
{
    NLIF_NL_CB_ALLOC_PARA packet;

    packet.kind = kind;
    return (struct nl_cb *)call_svc_tk(
        &packet,
        NLIF_NL_CB_ALLOC_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_7"
#endif /* #ifdef __CC_ARM */
EXPORT int nl_cb_err(
    struct nl_cb *cb, 
    enum nl_cb_kind kind, 
    nl_recvmsg_err_cb_t func, 
    void *arg)
{
    NLIF_NL_CB_ERR_PARA packet;

    packet.cb = cb;
    packet.kind = kind;
    packet.func = func;
    packet.arg = arg;
    return (int)call_svc_tk(
        &packet,
        NLIF_NL_CB_ERR_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_8"
#endif /* #ifdef __CC_ARM */
EXPORT void nl_cb_put(
    struct nl_cb *cb)
{
    NLIF_NL_CB_PUT_PARA packet;

    packet.cb = cb;
    (void)call_svc_tk(
        &packet,
        NLIF_NL_CB_PUT_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_9"
#endif /* #ifdef __CC_ARM */
EXPORT int nl_cb_set(
    struct nl_cb *cb, 
    enum nl_cb_type type, 
    enum nl_cb_kind kind, 
    nl_recvmsg_msg_cb_t func, 
    void *arg)
{
    NLIF_NL_CB_SET_PARA packet;

    packet.cb = cb;
    packet.type = type;
    packet.kind = kind;
    packet.func = func;
    packet.arg = arg;
    return (int)call_svc_tk(
        &packet,
        NLIF_NL_CB_SET_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_10"
#endif /* #ifdef __CC_ARM */
EXPORT int nl_recvmsgs(
    struct nl_sock *sk, 
    struct nl_cb *cb)
{
    NLIF_NL_RECVMSGS_PARA packet;

    packet.sk = sk;
    packet.cb = cb;
    return (int)call_svc_tk(
        &packet,
        NLIF_NL_RECVMSGS_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_11"
#endif /* #ifdef __CC_ARM */
EXPORT int nl_send_auto_complete(
    struct nl_sock *sk, 
    struct nl_msg *msg)
{
    NLIF_NL_SEND_AUTO_COMPLETE_PARA packet;

    packet.sk = sk;
    packet.msg = msg;
    return (int)call_svc_tk(
        &packet,
        NLIF_NL_SEND_AUTO_COMPLETE_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_12"
#endif /* #ifdef __CC_ARM */
EXPORT struct nl_sock * nl_socket_alloc(void)
{
    return (struct nl_sock *)call_svc_tk(
        0,
        NLIF_NL_SOCKET_ALLOC_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_13"
#endif /* #ifdef __CC_ARM */
EXPORT void nl_socket_free(
    struct nl_sock *sk)
{
    NLIF_NL_SOCKET_FREE_PARA packet;

    packet.sk = sk;
    (void)call_svc_tk(
        &packet,
        NLIF_NL_SOCKET_FREE_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_14"
#endif /* #ifdef __CC_ARM */
EXPORT struct nl_msg * nlmsg_alloc(void)
{
    return (struct nl_msg *)call_svc_tk(
        0,
        NLIF_NLMSG_ALLOC_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_15"
#endif /* #ifdef __CC_ARM */
EXPORT void nlmsg_free(
    struct nl_msg *msg)
{
    NLIF_NLMSG_FREE_PARA packet;

    packet.msg = msg;
    (void)call_svc_tk(
        &packet,
        NLIF_NLMSG_FREE_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_16"
#endif /* #ifdef __CC_ARM */
EXPORT void * sxk_genlmsg_put(
    struct nl_msg *msg, 
    uint32_t pid, 
    uint32_t seq, 
    int family, 
    int hdrlen, 
    int flags, 
    uint8_t cmd, 
    uint8_t version)
{
    NLIF_SXK_GENLMSG_PUT_PARA packet;

    packet.msg = msg;
    packet.pid = pid;
    packet.seq = seq;
    packet.family = family;
    packet.hdrlen = hdrlen;
    packet.flags = flags;
    packet.cmd = cmd;
    packet.version = version;
    return (void *)call_svc_tk(
        &packet,
        NLIF_SXK_GENLMSG_PUT_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_17"
#endif /* #ifdef __CC_ARM */
EXPORT int sxk_nla_put(
    struct nl_msg *msg, 
    int attrtype, 
    int datalen, 
    const void *data)
{
    NLIF_SXK_NLA_PUT_PARA packet;

    packet.msg = msg;
    packet.attrtype = attrtype;
    packet.datalen = datalen;
    packet.data = data;
    return (int)call_svc_tk(
        &packet,
        NLIF_SXK_NLA_PUT_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_18"
#endif /* #ifdef __CC_ARM */
EXPORT void sxk_genl_ctrl_init(void)
{
    (void)call_svc_tk(
        0,
        NLIF_SXK_GENL_CTRL_INIT_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_19"
#endif /* #ifdef __CC_ARM */
EXPORT void nlmsg_set_default_size(
    size_t max)
{
    NLIF_NLMSG_SET_DEFAULT_SIZE_PARA packet;

    packet.max = max;
    (void)call_svc_tk(
        &packet,
        NLIF_NLMSG_SET_DEFAULT_SIZE_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_20"
#endif /* #ifdef __CC_ARM */
EXPORT struct nlattr * genlmsg_attrdata(
    const struct genlmsghdr *gnlh, 
    int hdrlen)
{
    NLIF_GENLMSG_ATTRDATA_PARA packet;

    packet.gnlh = gnlh;
    packet.hdrlen = hdrlen;
    return (struct nlattr *)call_svc_tk(
        &packet,
        NLIF_GENLMSG_ATTRDATA_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_21"
#endif /* #ifdef __CC_ARM */
EXPORT int genlmsg_attrlen(
    const struct genlmsghdr *gnlh, 
    int hdrlen)
{
    NLIF_GENLMSG_ATTRLEN_PARA packet;

    packet.gnlh = gnlh;
    packet.hdrlen = hdrlen;
    return (int)call_svc_tk(
        &packet,
        NLIF_GENLMSG_ATTRLEN_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_22"
#endif /* #ifdef __CC_ARM */
EXPORT int nl_socket_add_membership(
    struct nl_sock *sk, 
    int group)
{
    NLIF_NL_SOCKET_ADD_MEMBERSHIP_PARA packet;

    packet.sk = sk;
    packet.group = group;
    return (int)call_svc_tk(
        &packet,
        NLIF_NL_SOCKET_ADD_MEMBERSHIP_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_23"
#endif /* #ifdef __CC_ARM */
EXPORT struct nlattr * nla_next(
    const struct nlattr *nla, 
    int *remaining)
{
    NLIF_NLA_NEXT_PARA packet;

    packet.nla = nla;
    packet.remaining = remaining;
    return (struct nlattr *)call_svc_tk(
        &packet,
        NLIF_NLA_NEXT_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_24"
#endif /* #ifdef __CC_ARM */
EXPORT int nla_ok(
    const struct nlattr *nla, 
    int remaining)
{
    NLIF_NLA_OK_PARA packet;

    packet.nla = nla;
    packet.remaining = remaining;
    return (int)call_svc_tk(
        &packet,
        NLIF_NLA_OK_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_25"
#endif /* #ifdef __CC_ARM */
EXPORT int sxk_nla_parse(
    struct nlattr *tb[], 
    int maxtype, 
    struct nlattr *head, 
    int len, 
    struct nla_policy *policy)
{
    NLIF_SXK_NLA_PARSE_PARA packet;

    packet.tb = tb;
    packet.maxtype = maxtype;
    packet.head = head;
    packet.len = len;
    packet.policy = policy;
    return (int)call_svc_tk(
        &packet,
        NLIF_SXK_NLA_PARSE_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_26"
#endif /* #ifdef __CC_ARM */
EXPORT int genl_ctrl_resolve(
    struct nl_sock *sk, 
    const char *name)
{
    NLIF_GENL_CTRL_RESOLVE_PARA packet;

    packet.sk = sk;
    packet.name = name;
    return (int)call_svc_tk(
        &packet,
        NLIF_GENL_CTRL_RESOLVE_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_27"
#endif /* #ifdef __CC_ARM */
EXPORT void nl_socket_disable_seq_check(
    struct nl_sock *sk)
{
    NLIF_NL_SOCKET_DISABLE_SEQ_CHECK_PARA packet;

    packet.sk = sk;
    (void)call_svc_tk(
        &packet,
        NLIF_NL_SOCKET_DISABLE_SEQ_CHECK_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_28"
#endif /* #ifdef __CC_ARM */
EXPORT int nl_socket_set_nonblocking(
    struct nl_sock *sk)
{
    NLIF_NL_SOCKET_SET_NONBLOCKING_PARA packet;

    packet.sk = sk;
    return (int)call_svc_tk(
        &packet,
        NLIF_NL_SOCKET_SET_NONBLOCKING_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_29"
#endif /* #ifdef __CC_ARM */
EXPORT struct nl_cb * nl_cb_clone(
    struct nl_cb *orig)
{
    NLIF_NL_CB_CLONE_PARA packet;

    packet.orig = orig;
    return (struct nl_cb *)call_svc_tk(
        &packet,
        NLIF_NL_CB_CLONE_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "NLIF_SEC_30"
#endif /* #ifdef __CC_ARM */
EXPORT struct nl_sock * nl_socket_alloc_cb(
    struct nl_cb *cb)
{
    NLIF_NL_SOCKET_ALLOC_CB_PARA packet;

    packet.cb = cb;
    return (struct nl_sock *)call_svc_tk(
        &packet,
        NLIF_NL_SOCKET_ALLOC_CB_FN,
        GET_CALLER_ADDRESS());
}

