#include <sys/ssid.h>
#include "nlif/sys/svc/fnnlif.h"
#include "nlif/sys/svc/ifnlif.h"

int errno;

static ER NlSyscallEntry( VP para, W fn )
{
	switch (fn) {
	case NLIF_GENL_CONNECT_FN:
		return genl_connect(((NLIF_GENL_CONNECT_PARA*)para)->sk);
	case NLIF_GENL_CTRL_ALLOC_CACHE_FN:
		return genl_ctrl_alloc_cache(((NLIF_GENL_CTRL_ALLOC_CACHE_PARA*)para)->sock, ((NLIF_GENL_CTRL_ALLOC_CACHE_PARA*)para)->result);
	case NLIF_GENL_CTRL_SEARCH_BY_NAME_FN:
		return (ER)genl_ctrl_search_by_name(((NLIF_GENL_CTRL_SEARCH_BY_NAME_PARA*)para)->cache, ((NLIF_GENL_CTRL_SEARCH_BY_NAME_PARA*)para)->name);
	case NLIF_GENL_FAMILY_PUT_FN:
		genl_family_put(((NLIF_GENL_FAMILY_PUT_PARA*)para)->family);
		return E_OK;
	case NLIF_NL_CACHE_FREE_FN:
		nl_cache_free(((NLIF_NL_CACHE_FREE_PARA*)para)->cache);
		return E_OK;
	case NLIF_NL_CB_ALLOC_FN:
		return (ER)nl_cb_alloc(((NLIF_NL_CB_ALLOC_PARA*)para)->kind);
	case NLIF_NL_CB_ERR_FN:
		return nl_cb_err(((NLIF_NL_CB_ERR_PARA*)para)->cb, ((NLIF_NL_CB_ERR_PARA*)para)->kind, ((NLIF_NL_CB_ERR_PARA*)para)->func, ((NLIF_NL_CB_ERR_PARA*)para)->arg);
	case NLIF_NL_CB_PUT_FN:
		nl_cb_put(((NLIF_NL_CB_PUT_PARA*)para)->cb);
		return E_OK;
	case NLIF_NL_CB_SET_FN:
		return nl_cb_set(((NLIF_NL_CB_SET_PARA*)para)->cb, ((NLIF_NL_CB_SET_PARA*)para)->type, ((NLIF_NL_CB_SET_PARA*)para)->kind, ((NLIF_NL_CB_SET_PARA*)para)->func, ((NLIF_NL_CB_SET_PARA*)para)->arg);
	case NLIF_NL_RECVMSGS_FN:
		return nl_recvmsgs(((NLIF_NL_RECVMSGS_PARA*)para)->sk, ((NLIF_NL_RECVMSGS_PARA*)para)->cb);
	case NLIF_NL_SEND_AUTO_COMPLETE_FN:
		return nl_send_auto_complete(((NLIF_NL_SEND_AUTO_COMPLETE_PARA*)para)->sk, ((NLIF_NL_SEND_AUTO_COMPLETE_PARA*)para)->msg);
	case NLIF_NL_SOCKET_ALLOC_FN:
		return (ER)nl_socket_alloc();
	case NLIF_NL_SOCKET_FREE_FN:
		nl_socket_free(((NLIF_NL_SOCKET_FREE_PARA*)para)->sk);
		return E_OK;
	case NLIF_NLMSG_ALLOC_FN:
		return (ER)nlmsg_alloc();
	case NLIF_NLMSG_FREE_FN:
		nlmsg_free(((NLIF_NLMSG_FREE_PARA*)para)->msg);
		return E_OK;
	case NLIF_SXK_GENLMSG_PUT_FN:
		return (ER)sxk_genlmsg_put(((NLIF_SXK_GENLMSG_PUT_PARA*)para)->msg, ((NLIF_SXK_GENLMSG_PUT_PARA*)para)->pid, ((NLIF_SXK_GENLMSG_PUT_PARA*)para)->seq, ((NLIF_SXK_GENLMSG_PUT_PARA*)para)->family,
			((NLIF_SXK_GENLMSG_PUT_PARA*)para)->hdrlen, ((NLIF_SXK_GENLMSG_PUT_PARA*)para)->flags, ((NLIF_SXK_GENLMSG_PUT_PARA*)para)->cmd, ((NLIF_SXK_GENLMSG_PUT_PARA*)para)->version);
	case NLIF_SXK_NLA_PUT_FN:
		return sxk_nla_put(((NLIF_SXK_NLA_PUT_PARA*)para)->msg, ((NLIF_SXK_NLA_PUT_PARA*)para)->attrtype, ((NLIF_SXK_NLA_PUT_PARA*)para)->datalen, ((NLIF_SXK_NLA_PUT_PARA*)para)->data);
	case NLIF_SXK_GENL_CTRL_INIT_FN:
		sxk_genl_ctrl_init();
		return E_OK;
	case NLIF_NLMSG_SET_DEFAULT_SIZE_FN:
		nlmsg_set_default_size(((NLIF_NLMSG_SET_DEFAULT_SIZE_PARA*)para)->max);
		return E_OK;
	case NLIF_GENLMSG_ATTRDATA_FN:
		return (ER)genlmsg_attrdata(((NLIF_GENLMSG_ATTRDATA_PARA*)para)->gnlh, ((NLIF_GENLMSG_ATTRDATA_PARA*)para)->hdrlen);
	case NLIF_GENLMSG_ATTRLEN_FN:
		return genlmsg_attrlen(((NLIF_GENLMSG_ATTRLEN_PARA*)para)->gnlh, ((NLIF_GENLMSG_ATTRLEN_PARA*)para)->hdrlen);
	case NLIF_NL_SOCKET_ADD_MEMBERSHIP_FN:
		return nl_socket_add_membership(((NLIF_NL_SOCKET_ADD_MEMBERSHIP_PARA*)para)->sk, ((NLIF_NL_SOCKET_ADD_MEMBERSHIP_PARA*)para)->group);
	case NLIF_NLA_NEXT_FN:
		return (ER)nla_next(((NLIF_NLA_NEXT_PARA*)para)->nla, ((NLIF_NLA_NEXT_PARA*)para)->remaining);
	case NLIF_NLA_OK_FN:
		return nla_ok(((NLIF_NLA_OK_PARA*)para)->nla, ((NLIF_NLA_OK_PARA*)para)->remaining);
	case NLIF_SXK_NLA_PARSE_FN:
		return sxk_nla_parse(((NLIF_SXK_NLA_PARSE_PARA*)para)->tb, ((NLIF_SXK_NLA_PARSE_PARA*)para)->maxtype, ((NLIF_SXK_NLA_PARSE_PARA*)para)->head, ((NLIF_SXK_NLA_PARSE_PARA*)para)->len,
			((NLIF_SXK_NLA_PARSE_PARA*)para)->policy);
	case NLIF_GENL_CTRL_RESOLVE_FN:
		return genl_ctrl_resolve(((NLIF_GENL_CTRL_RESOLVE_PARA*)para)->sk, ((NLIF_GENL_CTRL_RESOLVE_PARA*)para)->name);
	case NLIF_NL_SOCKET_DISABLE_SEQ_CHECK_FN:
		nl_socket_disable_seq_check(((NLIF_NL_SOCKET_DISABLE_SEQ_CHECK_PARA*)para)->sk);
		return E_OK;
	case NLIF_NL_SOCKET_SET_NONBLOCKING_FN:
		return nl_socket_set_nonblocking(((NLIF_NL_SOCKET_SET_NONBLOCKING_PARA*)para)->sk);
	case NLIF_NL_CB_CLONE_FN:
		return (ER)nl_cb_clone(((NLIF_NL_CB_CLONE_PARA*)para)->orig);
	case NLIF_NL_SOCKET_ALLOC_CB_FN:
		return (ER)nl_socket_alloc_cb(((NLIF_NL_SOCKET_ALLOC_CB_PARA*)para)->cb);
	}

	return E_RSFN;
}

ER main( INT ac, UB *av[] )
{
	if (ac >= 0) {
		T_DSSY  dssy;

		dssy.ssyatr    = TA_RNGK;
		dssy.ssypri    = NLIF_PRI;
		dssy.svchdr    = (FP)NlSyscallEntry;
		dssy.breakfn   = NULL;
		dssy.startupfn = NULL;
		dssy.cleanupfn = NULL;
		dssy.eventfn   = NULL;
		dssy.resblksz  = 0;
		dssy.svctbl    = NULL;
		dssy.nsvc      = 0;

		return tk_def_ssy(NLIF_SVC, &dssy);
	}
	else {
		return tk_def_ssy(NLIF_SVC, NULL);
	}
}
