/*
 *  SVC interface library
 *
 *     created from include/compatif/compatif.h
 */

#include <basic.h>
#include <sys/svc.h>
#include <compatif/sys/svc/fncompatif.h>
#include <compatif/sys/svc/ifcompatif.h>

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_1"
#endif /* #ifdef __CC_ARM */
EXPORT int sxk_cfg80211_init(void)
{
    return (int)call_svc_tk(
        0,
        CMPTIF_SXK_CFG80211_INIT_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_2"
#endif /* #ifdef __CC_ARM */
EXPORT void sxk_cfg80211_exit(void)
{
    (void)call_svc_tk(
        0,
        CMPTIF_SXK_CFG80211_EXIT_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_3"
#endif /* #ifdef __CC_ARM */
EXPORT int sxk_compat_init(void)
{
    return (int)call_svc_tk(
        0,
        CMPTIF_SXK_COMPAT_INIT_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_4"
#endif /* #ifdef __CC_ARM */
EXPORT void sxk_compat_exit(void)
{
    (void)call_svc_tk(
        0,
        CMPTIF_SXK_COMPAT_EXIT_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_5"
#endif /* #ifdef __CC_ARM */
EXPORT void cfg80211_scan_done(
    struct cfg80211_scan_request *request, 
    bool aborted)
{
    CMPTIF_CFG80211_SCAN_DONE_PARA packet;

    packet.request = request;
    packet.aborted = aborted;
    (void)call_svc_tk(
        &packet,
        CMPTIF_CFG80211_SCAN_DONE_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_6"
#endif /* #ifdef __CC_ARM */
EXPORT void cfg80211_connect_result(
    struct net_device *dev, 
    const u8 *bssid, 
    const u8 *req_ie, 
    size_t req_ie_len, 
    const u8 *resp_ie, 
    size_t resp_ie_len, 
    u16 status, 
    gfp_t gfp)
{
    CMPTIF_CFG80211_CONNECT_RESULT_PARA packet;

    packet.dev = dev;
    packet.bssid = bssid;
    packet.req_ie = req_ie;
    packet.req_ie_len = req_ie_len;
    packet.resp_ie = resp_ie;
    packet.resp_ie_len = resp_ie_len;
    packet.status = status;
    packet.gfp = gfp;
    (void)call_svc_tk(
        &packet,
        CMPTIF_CFG80211_CONNECT_RESULT_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_7"
#endif /* #ifdef __CC_ARM */
EXPORT void cfg80211_disconnected(
    struct net_device *dev, 
    u16 reason, 
    u8 *ie, 
    size_t ie_len, 
    gfp_t gfp)
{
    CMPTIF_CFG80211_DISCONNECTED_PARA packet;

    packet.dev = dev;
    packet.reason = reason;
    packet.ie = ie;
    packet.ie_len = ie_len;
    packet.gfp = gfp;
    (void)call_svc_tk(
        &packet,
        CMPTIF_CFG80211_DISCONNECTED_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_8"
#endif /* #ifdef __CC_ARM */
EXPORT struct cfg80211_bss * cfg80211_get_bss(
    struct wiphy *wphy, 
    struct ieee80211_channel *channel, 
    const u8 *bssid, 
    const u8 *ssid, 
    size_t ssid_len, 
    u16 capa_mask, 
    u16 capa_val)
{
    CMPTIF_CFG80211_GET_BSS_PARA packet;

    packet.wphy = wphy;
    packet.channel = channel;
    packet.bssid = bssid;
    packet.ssid = ssid;
    packet.ssid_len = ssid_len;
    packet.capa_mask = capa_mask;
    packet.capa_val = capa_val;
    return (struct cfg80211_bss *)call_svc_tk(
        &packet,
        CMPTIF_CFG80211_GET_BSS_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_9"
#endif /* #ifdef __CC_ARM */
EXPORT void cfg80211_ibss_joined(
    struct net_device *dev, 
    const u8 *bssid, 
    gfp_t gfp)
{
    CMPTIF_CFG80211_IBSS_JOINED_PARA packet;

    packet.dev = dev;
    packet.bssid = bssid;
    packet.gfp = gfp;
    (void)call_svc_tk(
        &packet,
        CMPTIF_CFG80211_IBSS_JOINED_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_10"
#endif /* #ifdef __CC_ARM */
EXPORT struct cfg80211_bss * cfg80211_inform_bss(
    struct wiphy *wphy, 
    struct ieee80211_channel *channel, 
    const u8 *bssid, 
    u64 timestamp, 
    u16 capability, 
    u16 beacon_interval, 
    const u8 *ie, 
    size_t ielen, 
    s32 signal, 
    gfp_t gfp)
{
    CMPTIF_CFG80211_INFORM_BSS_PARA packet;

    packet.wphy = wphy;
    packet.channel = channel;
    packet.bssid = bssid;
    packet.timestamp = timestamp;
    packet.capability = capability;
    packet.beacon_interval = beacon_interval;
    packet.ie = ie;
    packet.ielen = ielen;
    packet.signal = signal;
    packet.gfp = gfp;
    return (struct cfg80211_bss *)call_svc_tk(
        &packet,
        CMPTIF_CFG80211_INFORM_BSS_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_11"
#endif /* #ifdef __CC_ARM */
EXPORT void cfg80211_michael_mic_failure(
    struct net_device *dev, 
    const u8 *addr, 
    enum nl80211_key_type key_type, 
    int key_id, 
    const u8 *tsc, 
    gfp_t gfp)
{
    CMPTIF_CFG80211_MICHAEL_MIC_FAILURE_PARA packet;

    packet.dev = dev;
    packet.addr = addr;
    packet.key_type = key_type;
    packet.key_id = key_id;
    packet.tsc = tsc;
    packet.gfp = gfp;
    (void)call_svc_tk(
        &packet,
        CMPTIF_CFG80211_MICHAEL_MIC_FAILURE_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_12"
#endif /* #ifdef __CC_ARM */
EXPORT void cfg80211_put_bss(
    struct cfg80211_bss *pub)
{
    CMPTIF_CFG80211_PUT_BSS_PARA packet;

    packet.pub = pub;
    (void)call_svc_tk(
        &packet,
        CMPTIF_CFG80211_PUT_BSS_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_13"
#endif /* #ifdef __CC_ARM */
EXPORT void cfg80211_roamed_bss(
    struct net_device *dev, 
    struct cfg80211_bss *bss, 
    const u8 *req_ie, 
    size_t req_ie_len, 
    const u8 *resp_ie, 
    size_t resp_ie_len, 
    gfp_t gfp)
{
    CMPTIF_CFG80211_ROAMED_BSS_PARA packet;

    packet.dev = dev;
    packet.bss = bss;
    packet.req_ie = req_ie;
    packet.req_ie_len = req_ie_len;
    packet.resp_ie = resp_ie;
    packet.resp_ie_len = resp_ie_len;
    packet.gfp = gfp;
    (void)call_svc_tk(
        &packet,
        CMPTIF_CFG80211_ROAMED_BSS_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_14"
#endif /* #ifdef __CC_ARM */
EXPORT void cfg80211_sched_scan_results(
    struct wiphy *wphy)
{
    CMPTIF_CFG80211_SCHED_SCAN_RESULTS_PARA packet;

    packet.wphy = wphy;
    (void)call_svc_tk(
        &packet,
        CMPTIF_CFG80211_SCHED_SCAN_RESULTS_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_15"
#endif /* #ifdef __CC_ARM */
EXPORT void cfg80211_del_sta(
    struct net_device *dev, 
    const u8 *mac_addr, 
    gfp_t gfp)
{
    CMPTIF_CFG80211_DEL_STA_PARA packet;

    packet.dev = dev;
    packet.mac_addr = mac_addr;
    packet.gfp = gfp;
    (void)call_svc_tk(
        &packet,
        CMPTIF_CFG80211_DEL_STA_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_16"
#endif /* #ifdef __CC_ARM */
EXPORT struct cfg80211_bss * cfg80211_inform_bss_frame(
    struct wiphy *wphy, 
    struct ieee80211_channel *channel, 
    struct ieee80211_mgmt *mgmt, 
    size_t len, 
    s32 signal, 
    gfp_t gfp)
{
    CMPTIF_CFG80211_INFORM_BSS_FRAME_PARA packet;

    packet.wphy = wphy;
    packet.channel = channel;
    packet.mgmt = mgmt;
    packet.len = len;
    packet.signal = signal;
    packet.gfp = gfp;
    return (struct cfg80211_bss *)call_svc_tk(
        &packet,
        CMPTIF_CFG80211_INFORM_BSS_FRAME_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_17"
#endif /* #ifdef __CC_ARM */
EXPORT void cfg80211_new_sta(
    struct net_device *dev, 
    const u8 *mac_addr, 
    struct station_info *sinfo, 
    gfp_t gfp)
{
    CMPTIF_CFG80211_NEW_STA_PARA packet;

    packet.dev = dev;
    packet.mac_addr = mac_addr;
    packet.sinfo = sinfo;
    packet.gfp = gfp;
    (void)call_svc_tk(
        &packet,
        CMPTIF_CFG80211_NEW_STA_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_18"
#endif /* #ifdef __CC_ARM */
EXPORT const u8 * cfg80211_find_ie(
    u8 eid, 
    const u8 *ies, 
    int len)
{
    CMPTIF_CFG80211_FIND_IE_PARA packet;

    packet.eid = eid;
    packet.ies = ies;
    packet.len = len;
    return (const u8 *)call_svc_tk(
        &packet,
        CMPTIF_CFG80211_FIND_IE_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_19"
#endif /* #ifdef __CC_ARM */
EXPORT void cfg80211_mgmt_tx_status(
    struct net_device *dev, 
    u64 cookie, 
    const u8 *buf, 
    size_t len, 
    bool ack, 
    gfp_t gfp)
{
    CMPTIF_CFG80211_MGMT_TX_STATUS_PARA packet;

    packet.dev = dev;
    packet.cookie = cookie;
    packet.buf = buf;
    packet.len = len;
    packet.ack = ack;
    packet.gfp = gfp;
    (void)call_svc_tk(
        &packet,
        CMPTIF_CFG80211_MGMT_TX_STATUS_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_20"
#endif /* #ifdef __CC_ARM */
EXPORT void cfg80211_pmksa_candidate_notify(
    struct net_device *dev, 
    int index, 
    const u8 *bssid, 
    bool preauth, 
    gfp_t gfp)
{
    CMPTIF_CFG80211_PMKSA_CANDIDATE_NOTIFY_PARA packet;

    packet.dev = dev;
    packet.index = index;
    packet.bssid = bssid;
    packet.preauth = preauth;
    packet.gfp = gfp;
    (void)call_svc_tk(
        &packet,
        CMPTIF_CFG80211_PMKSA_CANDIDATE_NOTIFY_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_21"
#endif /* #ifdef __CC_ARM */
EXPORT void cfg80211_ready_on_channel(
    struct net_device *dev, 
    u64 cookie, 
    struct ieee80211_channel *chan, 
    enum nl80211_channel_type channel_type, 
    unsigned int duration, 
    gfp_t gfp)
{
    CMPTIF_CFG80211_READY_ON_CHANNEL_PARA packet;

    packet.dev = dev;
    packet.cookie = cookie;
    packet.chan = chan;
    packet.channel_type = channel_type;
    packet.duration = duration;
    packet.gfp = gfp;
    (void)call_svc_tk(
        &packet,
        CMPTIF_CFG80211_READY_ON_CHANNEL_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_22"
#endif /* #ifdef __CC_ARM */
EXPORT void cfg80211_remain_on_channel_expired(
    struct net_device *dev, 
    u64 cookie, 
    struct ieee80211_channel *chan, 
    enum nl80211_channel_type channel_type, 
    gfp_t gfp)
{
    CMPTIF_CFG80211_REMAIN_ON_CHANNEL_EXPIRED_PARA packet;

    packet.dev = dev;
    packet.cookie = cookie;
    packet.chan = chan;
    packet.channel_type = channel_type;
    packet.gfp = gfp;
    (void)call_svc_tk(
        &packet,
        CMPTIF_CFG80211_REMAIN_ON_CHANNEL_EXPIRED_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_23"
#endif /* #ifdef __CC_ARM */
EXPORT bool cfg80211_rx_mgmt(
    struct net_device *dev, 
    int freq, 
    const u8 *buf, 
    size_t len, 
    gfp_t gfp)
{
    CMPTIF_CFG80211_RX_MGMT_PARA packet;

    packet.dev = dev;
    packet.freq = freq;
    packet.buf = buf;
    packet.len = len;
    packet.gfp = gfp;
    return (bool)call_svc_tk(
        &packet,
        CMPTIF_CFG80211_RX_MGMT_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_24"
#endif /* #ifdef __CC_ARM */
EXPORT struct sk_buff * cfg80211_testmode_alloc_event_skb(
    struct wiphy *wphy, 
    int approxlen, 
    gfp_t gfp)
{
    CMPTIF_CFG80211_TESTMODE_ALLOC_EVENT_SKB_PARA packet;

    packet.wphy = wphy;
    packet.approxlen = approxlen;
    packet.gfp = gfp;
    return (struct sk_buff *)call_svc_tk(
        &packet,
        CMPTIF_CFG80211_TESTMODE_ALLOC_EVENT_SKB_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_25"
#endif /* #ifdef __CC_ARM */
EXPORT void cfg80211_testmode_event(
    struct sk_buff *skb, 
    gfp_t gfp)
{
    CMPTIF_CFG80211_TESTMODE_EVENT_PARA packet;

    packet.skb = skb;
    packet.gfp = gfp;
    (void)call_svc_tk(
        &packet,
        CMPTIF_CFG80211_TESTMODE_EVENT_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_26"
#endif /* #ifdef __CC_ARM */
EXPORT int ieee80211_frequency_to_channel(
    int freq)
{
    CMPTIF_IEEE80211_FREQUENCY_TO_CHANNEL_PARA packet;

    packet.freq = freq;
    return (int)call_svc_tk(
        &packet,
        CMPTIF_IEEE80211_FREQUENCY_TO_CHANNEL_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_27"
#endif /* #ifdef __CC_ARM */
EXPORT int ieee80211_channel_to_frequency(
    int chan, 
    enum ieee80211_band band)
{
    CMPTIF_IEEE80211_CHANNEL_TO_FREQUENCY_PARA packet;

    packet.chan = chan;
    packet.band = band;
    return (int)call_svc_tk(
        &packet,
        CMPTIF_IEEE80211_CHANNEL_TO_FREQUENCY_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_28"
#endif /* #ifdef __CC_ARM */
EXPORT struct ieee80211_channel * __ieee80211_get_channel(
    struct wiphy *wphy, 
    int freq)
{
    CMPTIF___IEEE80211_GET_CHANNEL_PARA packet;

    packet.wphy = wphy;
    packet.freq = freq;
    return (struct ieee80211_channel *)call_svc_tk(
        &packet,
        CMPTIF___IEEE80211_GET_CHANNEL_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_29"
#endif /* #ifdef __CC_ARM */
EXPORT int regulatory_hint(
    struct wiphy *wphy, 
    const char *alpha2)
{
    CMPTIF_REGULATORY_HINT_PARA packet;

    packet.wphy = wphy;
    packet.alpha2 = alpha2;
    return (int)call_svc_tk(
        &packet,
        CMPTIF_REGULATORY_HINT_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_30"
#endif /* #ifdef __CC_ARM */
EXPORT struct wiphy * wiphy_new(
    const struct cfg80211_ops *ops, 
    int sizeof_priv)
{
    CMPTIF_WIPHY_NEW_PARA packet;

    packet.ops = ops;
    packet.sizeof_priv = sizeof_priv;
    return (struct wiphy *)call_svc_tk(
        &packet,
        CMPTIF_WIPHY_NEW_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_31"
#endif /* #ifdef __CC_ARM */
EXPORT void wiphy_free(
    struct wiphy *wphy)
{
    CMPTIF_WIPHY_FREE_PARA packet;

    packet.wphy = wphy;
    (void)call_svc_tk(
        &packet,
        CMPTIF_WIPHY_FREE_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_32"
#endif /* #ifdef __CC_ARM */
EXPORT int wiphy_register(
    struct wiphy *wphy)
{
    CMPTIF_WIPHY_REGISTER_PARA packet;

    packet.wphy = wphy;
    return (int)call_svc_tk(
        &packet,
        CMPTIF_WIPHY_REGISTER_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_33"
#endif /* #ifdef __CC_ARM */
EXPORT void wiphy_unregister(
    struct wiphy *wphy)
{
    CMPTIF_WIPHY_UNREGISTER_PARA packet;

    packet.wphy = wphy;
    (void)call_svc_tk(
        &packet,
        CMPTIF_WIPHY_UNREGISTER_FN,
        GET_CALLER_ADDRESS());
}

#ifdef __CC_ARM
#pragma arm section code = "CMPTIF_SEC_34"
#endif /* #ifdef __CC_ARM */
EXPORT int _kstrtoul(
    const char *s, 
    unsigned int base, 
    unsigned long *res)
{
    CMPTIF__KSTRTOUL_PARA packet;

    packet.s = s;
    packet.base = base;
    packet.res = res;
    return (int)call_svc_tk(
        &packet,
        CMPTIF__KSTRTOUL_FN,
        GET_CALLER_ADDRESS());
}

