#include <sys/ssid.h>
#include "compatif/sys/svc/fncompatif.h"
#include "compatif/sys/svc/ifcompatif.h"

#define SXK_SUPPORT_COMPAT_OUTPUT 1

int sxk_printk(const char *form, ...)
{
#if SXK_SUPPORT_COMPAT_OUTPUT
	va_list arg;
	int len;

	va_start(arg, form);
	len = sxk_vprintk(form, arg);
	va_end(arg);

	return len;
#else
	if (form) return strlen(form);
	else return 0;
#endif
}

unsigned char _sxk_ctype[] = {
	_C,_C,_C,_C,_C,_C,_C,_C,                             /* 0-7 */
	_C,_C|_S,_C|_S,_C|_S,_C|_S,_C|_S,_C,_C,              /* 8-15 */
	_C,_C,_C,_C,_C,_C,_C,_C,                             /* 16-23 */
	_C,_C,_C,_C,_C,_C,_C,_C,                             /* 24-31 */
	_S|_SP,_P,_P,_P,_P,_P,_P,_P,                         /* 32-39 */
	_P,_P,_P,_P,_P,_P,_P,_P,                             /* 40-47 */
	_D,_D,_D,_D,_D,_D,_D,_D,                             /* 48-55 */
	_D,_D,_P,_P,_P,_P,_P,_P,                             /* 56-63 */
	_P,_U|_X,_U|_X,_U|_X,_U|_X,_U|_X,_U|_X,_U,           /* 64-71 */
	_U,_U,_U,_U,_U,_U,_U,_U,                             /* 72-79 */
	_U,_U,_U,_U,_U,_U,_U,_U,                             /* 80-87 */
	_U,_U,_U,_P,_P,_P,_P,_P,                             /* 88-95 */
	_P,_L|_X,_L|_X,_L|_X,_L|_X,_L|_X,_L|_X,_L,           /* 96-103 */
	_L,_L,_L,_L,_L,_L,_L,_L,                             /* 104-111 */
	_L,_L,_L,_L,_L,_L,_L,_L,                             /* 112-119 */
	_L,_L,_L,_P,_P,_P,_P,_C,                             /* 120-127 */
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,                     /* 128-143 */
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,                     /* 144-159 */
	_S|_SP,_P,_P,_P,_P,_P,_P,_P,_P,_P,_P,_P,_P,_P,_P,_P, /* 160-175 */
	_P,_P,_P,_P,_P,_P,_P,_P,_P,_P,_P,_P,_P,_P,_P,_P,     /* 176-191 */
	_U,_U,_U,_U,_U,_U,_U,_U,_U,_U,_U,_U,_U,_U,_U,_U,     /* 192-207 */
	_U,_U,_U,_U,_U,_U,_U,_P,_U,_U,_U,_U,_U,_U,_U,_L,     /* 208-223 */
	_L,_L,_L,_L,_L,_L,_L,_L,_L,_L,_L,_L,_L,_L,_L,_L,     /* 224-239 */
	_L,_L,_L,_L,_L,_L,_L,_P,_L,_L,_L,_L,_L,_L,_L,_L};    /* 240-255 */

static ER CompatSyscallEntry( VP para, W fn )
{
	switch (fn) {
	case CMPTIF_SXK_CFG80211_INIT_FN:
		return sxk_cfg80211_init();
	case CMPTIF_SXK_CFG80211_EXIT_FN:
		sxk_cfg80211_exit();
		return E_OK;
	case CMPTIF_SXK_COMPAT_INIT_FN:
		return sxk_compat_init();
	case CMPTIF_SXK_COMPAT_EXIT_FN:
		sxk_compat_exit();
		return E_OK;
	case CMPTIF_CFG80211_SCAN_DONE_FN:
		cfg80211_scan_done(((CMPTIF_CFG80211_SCAN_DONE_PARA*)para)->request, ((CMPTIF_CFG80211_SCAN_DONE_PARA*)para)->aborted);
		return E_OK;
	case CMPTIF_CFG80211_CONNECT_RESULT_FN:
		cfg80211_connect_result(((CMPTIF_CFG80211_CONNECT_RESULT_PARA*)para)->dev, ((CMPTIF_CFG80211_CONNECT_RESULT_PARA*)para)->bssid,
			((CMPTIF_CFG80211_CONNECT_RESULT_PARA*)para)->req_ie, ((CMPTIF_CFG80211_CONNECT_RESULT_PARA*)para)->req_ie_len,
			((CMPTIF_CFG80211_CONNECT_RESULT_PARA*)para)->resp_ie, ((CMPTIF_CFG80211_CONNECT_RESULT_PARA*)para)->resp_ie_len,
			((CMPTIF_CFG80211_CONNECT_RESULT_PARA*)para)->status, ((CMPTIF_CFG80211_CONNECT_RESULT_PARA*)para)->gfp);
		return E_OK;
	case CMPTIF_CFG80211_DISCONNECTED_FN:
		cfg80211_disconnected(((CMPTIF_CFG80211_DISCONNECTED_PARA*)para)->dev, ((CMPTIF_CFG80211_DISCONNECTED_PARA*)para)->reason,
			((CMPTIF_CFG80211_DISCONNECTED_PARA*)para)->ie, ((CMPTIF_CFG80211_DISCONNECTED_PARA*)para)->ie_len, ((CMPTIF_CFG80211_DISCONNECTED_PARA*)para)->gfp);
		return E_OK;
	case CMPTIF_CFG80211_GET_BSS_FN:
		return (ER)cfg80211_get_bss(((CMPTIF_CFG80211_GET_BSS_PARA*)para)->wphy,
			((CMPTIF_CFG80211_GET_BSS_PARA*)para)->channel,
			((CMPTIF_CFG80211_GET_BSS_PARA*)para)->bssid,
			((CMPTIF_CFG80211_GET_BSS_PARA*)para)->ssid, ((CMPTIF_CFG80211_GET_BSS_PARA*)para)->ssid_len,
			((CMPTIF_CFG80211_GET_BSS_PARA*)para)->capa_mask, ((CMPTIF_CFG80211_GET_BSS_PARA*)para)->capa_val);
	case CMPTIF_CFG80211_IBSS_JOINED_FN:
		cfg80211_ibss_joined(((CMPTIF_CFG80211_IBSS_JOINED_PARA*)para)->dev, ((CMPTIF_CFG80211_IBSS_JOINED_PARA*)para)->bssid, ((CMPTIF_CFG80211_IBSS_JOINED_PARA*)para)->gfp);
		return E_OK;
	case CMPTIF_CFG80211_INFORM_BSS_FN:
		return (ER)cfg80211_inform_bss(((CMPTIF_CFG80211_INFORM_BSS_PARA*)para)->wphy,
			((CMPTIF_CFG80211_INFORM_BSS_PARA*)para)->channel,
			((CMPTIF_CFG80211_INFORM_BSS_PARA*)para)->bssid,
			((CMPTIF_CFG80211_INFORM_BSS_PARA*)para)->timestamp, ((CMPTIF_CFG80211_INFORM_BSS_PARA*)para)->capability, ((CMPTIF_CFG80211_INFORM_BSS_PARA*)para)->beacon_interval,
			((CMPTIF_CFG80211_INFORM_BSS_PARA*)para)->ie, ((CMPTIF_CFG80211_INFORM_BSS_PARA*)para)->ielen,
			((CMPTIF_CFG80211_INFORM_BSS_PARA*)para)->signal, ((CMPTIF_CFG80211_INFORM_BSS_PARA*)para)->gfp);
	case CMPTIF_CFG80211_MICHAEL_MIC_FAILURE_FN:
		cfg80211_michael_mic_failure(((CMPTIF_CFG80211_MICHAEL_MIC_FAILURE_PARA*)para)->dev, ((CMPTIF_CFG80211_MICHAEL_MIC_FAILURE_PARA*)para)->addr,
			((CMPTIF_CFG80211_MICHAEL_MIC_FAILURE_PARA*)para)->key_type, ((CMPTIF_CFG80211_MICHAEL_MIC_FAILURE_PARA*)para)->key_id,
			((CMPTIF_CFG80211_MICHAEL_MIC_FAILURE_PARA*)para)->tsc, ((CMPTIF_CFG80211_MICHAEL_MIC_FAILURE_PARA*)para)->gfp);
		return E_OK;
	case CMPTIF_CFG80211_PUT_BSS_FN:
		cfg80211_put_bss(((CMPTIF_CFG80211_PUT_BSS_PARA*)para)->pub);
		return E_OK;
	case CMPTIF_CFG80211_ROAMED_BSS_FN:
		cfg80211_roamed_bss(((CMPTIF_CFG80211_ROAMED_BSS_PARA*)para)->dev, ((CMPTIF_CFG80211_ROAMED_BSS_PARA*)para)->bss,
			((CMPTIF_CFG80211_ROAMED_BSS_PARA*)para)->req_ie, ((CMPTIF_CFG80211_ROAMED_BSS_PARA*)para)->req_ie_len,
			((CMPTIF_CFG80211_ROAMED_BSS_PARA*)para)->resp_ie, ((CMPTIF_CFG80211_ROAMED_BSS_PARA*)para)->resp_ie_len, ((CMPTIF_CFG80211_ROAMED_BSS_PARA*)para)->gfp);
		return E_OK;
	case CMPTIF_CFG80211_SCHED_SCAN_RESULTS_FN:
		cfg80211_sched_scan_results(((CMPTIF_CFG80211_SCHED_SCAN_RESULTS_PARA*)para)->wphy);
		return E_OK;
	case CMPTIF_CFG80211_DEL_STA_FN:
		cfg80211_del_sta(((CMPTIF_CFG80211_DEL_STA_PARA*)para)->dev, ((CMPTIF_CFG80211_DEL_STA_PARA*)para)->mac_addr, ((CMPTIF_CFG80211_DEL_STA_PARA*)para)->gfp);
		return E_OK;
	case CMPTIF_CFG80211_INFORM_BSS_FRAME_FN:
		return (ER)cfg80211_inform_bss_frame(((CMPTIF_CFG80211_INFORM_BSS_FRAME_PARA*)para)->wphy,
			((CMPTIF_CFG80211_INFORM_BSS_FRAME_PARA*)para)->channel,
			((CMPTIF_CFG80211_INFORM_BSS_FRAME_PARA*)para)->mgmt, ((CMPTIF_CFG80211_INFORM_BSS_FRAME_PARA*)para)->len,
			((CMPTIF_CFG80211_INFORM_BSS_FRAME_PARA*)para)->signal, ((CMPTIF_CFG80211_INFORM_BSS_FRAME_PARA*)para)->gfp);
	case CMPTIF_CFG80211_NEW_STA_FN:
		cfg80211_new_sta(((CMPTIF_CFG80211_NEW_STA_PARA*)para)->dev, ((CMPTIF_CFG80211_NEW_STA_PARA*)para)->mac_addr,
			((CMPTIF_CFG80211_NEW_STA_PARA*)para)->sinfo, ((CMPTIF_CFG80211_NEW_STA_PARA*)para)->gfp);
		return E_OK;
	case CMPTIF_CFG80211_FIND_IE_FN:
		return (ER)cfg80211_find_ie(((CMPTIF_CFG80211_FIND_IE_PARA*)para)->eid, ((CMPTIF_CFG80211_FIND_IE_PARA*)para)->ies, ((CMPTIF_CFG80211_FIND_IE_PARA*)para)->len);
	case CMPTIF_CFG80211_MGMT_TX_STATUS_FN:
		cfg80211_mgmt_tx_status(((CMPTIF_CFG80211_MGMT_TX_STATUS_PARA*)para)->dev, ((CMPTIF_CFG80211_MGMT_TX_STATUS_PARA*)para)->cookie,
			((CMPTIF_CFG80211_MGMT_TX_STATUS_PARA*)para)->buf, ((CMPTIF_CFG80211_MGMT_TX_STATUS_PARA*)para)->len, ((CMPTIF_CFG80211_MGMT_TX_STATUS_PARA*)para)->ack, ((CMPTIF_CFG80211_MGMT_TX_STATUS_PARA*)para)->gfp);
		return E_OK;
	case CMPTIF_CFG80211_PMKSA_CANDIDATE_NOTIFY_FN:
		cfg80211_pmksa_candidate_notify(((CMPTIF_CFG80211_PMKSA_CANDIDATE_NOTIFY_PARA*)para)->dev, ((CMPTIF_CFG80211_PMKSA_CANDIDATE_NOTIFY_PARA*)para)->index,
			((CMPTIF_CFG80211_PMKSA_CANDIDATE_NOTIFY_PARA*)para)->bssid, ((CMPTIF_CFG80211_PMKSA_CANDIDATE_NOTIFY_PARA*)para)->preauth, ((CMPTIF_CFG80211_PMKSA_CANDIDATE_NOTIFY_PARA*)para)->gfp);
		return E_OK;
	case CMPTIF_CFG80211_READY_ON_CHANNEL_FN:
		cfg80211_ready_on_channel(((CMPTIF_CFG80211_READY_ON_CHANNEL_PARA*)para)->dev, ((CMPTIF_CFG80211_READY_ON_CHANNEL_PARA*)para)->cookie,
			((CMPTIF_CFG80211_READY_ON_CHANNEL_PARA*)para)->chan,
			((CMPTIF_CFG80211_READY_ON_CHANNEL_PARA*)para)->channel_type,
			((CMPTIF_CFG80211_READY_ON_CHANNEL_PARA*)para)->duration, ((CMPTIF_CFG80211_READY_ON_CHANNEL_PARA*)para)->gfp);
		return E_OK;
	case CMPTIF_CFG80211_REMAIN_ON_CHANNEL_EXPIRED_FN:
		cfg80211_remain_on_channel_expired(((CMPTIF_CFG80211_REMAIN_ON_CHANNEL_EXPIRED_PARA*)para)->dev,
			((CMPTIF_CFG80211_REMAIN_ON_CHANNEL_EXPIRED_PARA*)para)->cookie,
			((CMPTIF_CFG80211_REMAIN_ON_CHANNEL_EXPIRED_PARA*)para)->chan,
			((CMPTIF_CFG80211_REMAIN_ON_CHANNEL_EXPIRED_PARA*)para)->channel_type,
			((CMPTIF_CFG80211_REMAIN_ON_CHANNEL_EXPIRED_PARA*)para)->gfp);
		return E_OK;
	case CMPTIF_CFG80211_RX_MGMT_FN:
		return cfg80211_rx_mgmt(((CMPTIF_CFG80211_RX_MGMT_PARA*)para)->dev, ((CMPTIF_CFG80211_RX_MGMT_PARA*)para)->freq, ((CMPTIF_CFG80211_RX_MGMT_PARA*)para)->buf,
			((CMPTIF_CFG80211_RX_MGMT_PARA*)para)->len, ((CMPTIF_CFG80211_RX_MGMT_PARA*)para)->gfp);
	case CMPTIF_CFG80211_TESTMODE_ALLOC_EVENT_SKB_FN:
		return (ER)cfg80211_testmode_alloc_event_skb(((CMPTIF_CFG80211_TESTMODE_ALLOC_EVENT_SKB_PARA*)para)->wphy,
			((CMPTIF_CFG80211_TESTMODE_ALLOC_EVENT_SKB_PARA*)para)->approxlen, ((CMPTIF_CFG80211_TESTMODE_ALLOC_EVENT_SKB_PARA*)para)->gfp);
	case CMPTIF_CFG80211_TESTMODE_EVENT_FN:
		cfg80211_testmode_event(((CMPTIF_CFG80211_TESTMODE_EVENT_PARA*)para)->skb, ((CMPTIF_CFG80211_TESTMODE_EVENT_PARA*)para)->gfp);
		return E_OK;
	case CMPTIF_IEEE80211_FREQUENCY_TO_CHANNEL_FN:
		return ieee80211_frequency_to_channel(((CMPTIF_IEEE80211_FREQUENCY_TO_CHANNEL_PARA*)para)->freq);
	case CMPTIF_IEEE80211_CHANNEL_TO_FREQUENCY_FN:
		return ieee80211_channel_to_frequency(((CMPTIF_IEEE80211_CHANNEL_TO_FREQUENCY_PARA*)para)->chan, ((CMPTIF_IEEE80211_CHANNEL_TO_FREQUENCY_PARA*)para)->band);
	case CMPTIF___IEEE80211_GET_CHANNEL_FN:
		return (ER)__ieee80211_get_channel(((CMPTIF___IEEE80211_GET_CHANNEL_PARA*)para)->wphy,
			((CMPTIF___IEEE80211_GET_CHANNEL_PARA*)para)->freq);
	case CMPTIF_REGULATORY_HINT_FN:
		return regulatory_hint(((CMPTIF_REGULATORY_HINT_PARA*)para)->wphy, ((CMPTIF_REGULATORY_HINT_PARA*)para)->alpha2);
	case CMPTIF_WIPHY_NEW_FN:
		return (ER)wiphy_new(((CMPTIF_WIPHY_NEW_PARA*)para)->ops, ((CMPTIF_WIPHY_NEW_PARA*)para)->sizeof_priv);
	case CMPTIF_WIPHY_FREE_FN:
		wiphy_free(((CMPTIF_WIPHY_FREE_PARA*)para)->wphy);
		return E_OK;
	case CMPTIF_WIPHY_REGISTER_FN:
		return wiphy_register(((CMPTIF_WIPHY_REGISTER_PARA*)para)->wphy);
	case CMPTIF_WIPHY_UNREGISTER_FN:
		wiphy_unregister(((CMPTIF_WIPHY_UNREGISTER_PARA*)para)->wphy);
		return E_OK;
	case CMPTIF__KSTRTOUL_FN:
		return _kstrtoul(((CMPTIF__KSTRTOUL_PARA*)para)->s, ((CMPTIF__KSTRTOUL_PARA*)para)->base, ((CMPTIF__KSTRTOUL_PARA*)para)->res);
	}

	return E_RSFN;
}

ER main( INT ac, UB *av[] )
{
	if (ac >= 0) {
		T_DSSY  dssy;

		dssy.ssyatr    = TA_RNGK;
		dssy.ssypri    = CMPTIF_PRI;
		dssy.svchdr    = (FP)CompatSyscallEntry;
		dssy.breakfn   = NULL;
		dssy.startupfn = NULL;
		dssy.cleanupfn = NULL;
		dssy.eventfn   = NULL;
		dssy.resblksz  = 0;
		dssy.svctbl    = NULL;
		dssy.nsvc      = 0;

		return tk_def_ssy(CMPTIF_SVC, &dssy);
	}
	else {
		return tk_def_ssy(CMPTIF_SVC, NULL);
	}
}
