.tr ~
.PH "''''"
.B
.ce
\s+2prtpost \*(EM a PostScript Text Formatter\s-2
.R
.PH "''- \\\\nP -''"
.SP
\s-2PostScript is a registered trademark of Adobe Systems, Inc.\s+2
.SP
\f2prtpost\f1 is a utility to format raw ASCII text files for printing
on a PostScript printer.
It is intended for users who want to
print program listings without having to select an emulation (e.g. Diablo,
LaserJet).
.P
By default, lines of text are displayed in 10
point
Courier type at 7.2 lines per inch in portrait mode. A page header in 10
point Courier-Bold displays the time and date of printing on the left,
the file name centered in the middle, and the page number on the right.
The header baseline is 1/2" from the top of the page, and has left and right
margins of 1/2". The main body of text has a top margin 1" wide, a left
margin 3/4" wide, and a bottom margin 1/2" wide.
The right margin is determined by the right limit of the
printer's imageable area. The fonts, point sizes, margins, orientation,
line spacing, and several other parameters can all be altered by the user
by means of command line options.
.P
\f2prtpost\f1 takes a single optional argument, the source file name.
If no file name is given, \f2prtpost\f1 will read from the standard input.
\f2prtpost\f1 always writes to the standard output. These properties allow
it to function as a filter under Unix and MS-DOS. The source code is written
in C, and has compiled with no changes on the IBM PC and the Sun 3.
.P
\f2prtpost\f1 reads command line options in standard Unix style: options
come between the command name and the file argument, and each option is
a one or two letter code preceded by a "-". If an option takes an argument,
it may immediately follow the option code or be separated from it by a space.
For example,
.nf
.po +1i

\fHprtpost  -L -P120 -F Helvetica stuff.txt\f1

.po -1i
.fi
means "print file \f3stuff.txt\f1 in landscape mode and in 12 point
Helvetica type." The option codes are cryptic and there is a distressingly
large number of them, but they offer the user a high degree of control over
the printed output. Most users will only want to use a few of the options,
and script or batch files can be written for frequently used option
combinations. Since \f2prtpost\f1 writes to standard output, redirection
must be used to get a printout. For example, one might use
.nf
.po +1i

\fHprtpost textfile | lpr\f1~~~~for \f1\s-2UNIX\s+2 or

\fHprtpost textfile > PRN:\f1~~~~for DOS.

.po -1i
.fi
.P
Margins and point sizes are specified in decipoints, where one decipoint
is 1/720th of an inch. For point sizes, this amounts to multiplying by 10.
For example, "-F120" was used to select 12 point type above. Margins are
measured in the default PostScript coordinate system: the origin is at
the lower left corner of the page, x increases to the right, and y increases
upwards. For example, the upper right corner of an 8-1/2" \(mu 11" page
would have an x-coordinate of 6120 and a y-coordinate of 7920.
.P
Following is a list of all the options:
.VL 16
.LI -\f3C\f2compression\f1
compression factor for body font. This is a number from 1 to 500 representing
the percentage by which the font's normal character width is compressed or
expanded. Examples: -C50 will produce a half-wide font, and -C200 will
produce a double-wide font. The default pitch of 10 pt. Courier is 12 cpi.
-C72 will cause it to print at 16.66 cpi.
.LI -\f3c\f2compression\f1
compression factor for header font.
.LI -\f3I\f2lpi\f1
lines per inch \(mu 100. Line spacing defaults to the point size; for example,
lines in a 12 pt. font are spaced 12/72 = 1/6" apart, giving 6 lpi.
4 lpi would be enetered as -I400, 8.5 lpi as -I850.
.LI -\f3L\f1
landscape orientation. The default is portrait.
.LI -\f3N\f1
turn off header. The default is to print a header for every page.
.LI -\f3n\f1
prefix each line with a 5-digit line number. Default is no line numbers.
.LI -\f32\f1
set text in two columns. The default is one column.
.LI -\f3X\f1
don't separate columns with a rule line. In two column mode, a vertical
line normally separates the columns.
.LI -\f34\f1
print four half-size pages per sheet, i.e. 4-up.
.LI -\f3Z\f1
don't separate 4-up pages with rule lines. Normally, two lines are drawn
in a cross to separate the miniature pages.
.LI -\f3#\f2copies\f1
select number of copies.
.LI -\f3F\f2font\f1
select body font. PostScript font, resident or downloaded, to be used
for the main body of text.
.LI -\f3f\f2font\f1
header font.
.LI -\f3B\f2filename\f1
beginning-of-page file. The user may create a PostScript file which will
be executed before each page is formatted. Because of PostScript's
"opaque paint" imaging model, marks laid down by this file may be
overwritten by the page. A possible use might be to print "CONFIDENTIAL"
or "DRAFT" in grey letters across each page.
.LI -\f3E\f2filename\f1
end-of-page file. The user may create a PostScript file which will
be executed after each page is formatted. Because of PostScript's
"opaque paint" imaging model, marks laid down by this file may
overwrite the page text. Possible uses might be to draw borders around
each page, print a company logo, or print a custom page header.
.LI -\f3T\f2ncols\f1
tab stop. Set tab stops at every \f2ncols\f1 columns. The default is 8.
.LI -\f3G\f2size\f1
page size. \f2size\f1 is a code from 0 to 5, as follows:
.TS
box;
c | c | c.
code	paper size	dimensions
=
0	letter	8-1/2" \(mu 11"
_
1	legal	8-1/2" \(mu 14"
_
2	ledger	11" \(mu 17"
_
3	A3	297 mm \(mu 420 mm
_
4	A4	210 mm \(mu 297 mm
_
5	A5	182 mm \(mu 257 mm
.TE
The default margins are based on the page size.
.LI -\f3P\f2size\f1
body point size (decipoints). Size of font used for main body of text.
.LI -\f3p\f2size\f1
header point size (decipoints). Size of font used for header.
.LI -\f3tb\f2ydist\f1
body top margin (decipoints). The main text will begin printing at this
distance from the bottom of the page. For example, to leave a top margin of 2"
on legal size paper, set tb to (14 - 2)\(mu720 = 8640. Default is page length
less 1" (720 decipoints).
.LI -\f3lb\f2xdist\f1
body left margin. The main text will begin printing at this distance from
the left edge of the page. The default is 3/4" (540 decipoints).
.LI -\f3bb\f2ydist\f1
body bottom margin. The last line on each page will be printed at this
distance from the bottom of the page. The default is 1/2" (360 decipoints).
.LI -\f3th\f2ydist\f1
header top margin. The page header will print at this distance from the
bottom of the page. The default is page length less 1/2" (360 decipoints).
.LI -\f3lh\f2xdist\f1
header left margin. The header time and date will be printed at this distance
from the left edge of the paper. The default is 1/2" (360 decipoints).
.LI -\f3rh\f2xdist\f1
header right margin. The header page number will be printed right-justified
at this distance from the left edge of the paper. The default is the paper
width less 1/2" (360 decipoints).
.LE
.P
When the -2 option is selected in conjuction with landscape mode, the effect
is similar to printing pages 2-up. There is still only one logical page,
however, so only one header is printed. Files invoked by the -B and -E
options will likewise only be executed once.
The default font for this combination is 7 pt. Courier.
.P
When the -4 option is selected, all attributes of each page, including the
header, margins, fonts, and any marks made by beginning-of-page and
end-of-page files, will be scaled to half size. Four exact, miniature
replicas of a full size page will be printed on each page. The -4, -2, and
-L options may all be used together, resulting in an effective "8-up"
appearance. The default type will be 3.5 pt. Courier, which is still
large enough to be legible.
.P
The -B and -E options are intended for users with some knowledge of
PostScript. Three PostScript strings can be accessed by the files used
with these options:
.TS
;
l | l.
Name	Contents
_
DT	Time and Date
PG	Page Number
FL	File Name
.TE
These strings can be used to design custom page headers, in conjuction with
the -N option to turn off the default header. The format of the DT string
is illustrated by the following example:
.SP
Fri Sep 23 11:18:14 1988
.SP
All of the fields are constant width, so the PostScript \f3getinterval\f1
operator can be used to break up the string and rearrange the fields, if
desired. The coordinate system inherited by the beginning- and end-of-page
files is not quite the default coordinate system: the origin is still in the
lower left corner, but the units are scaled to decipoints (1/720") in both
directions. If the -4 option is used, the whole page will have been scaled and
repositioned. Users should treat this case the same as the one-page-per-sheet
case, remembering that the beginning- and end-of-page files will be executed
four times per sheet, once for each reduced page. It is important to bracket
the custom PostScript with \f3gsave\f1 and \f3grestore\f1, otherwise the
main page will inherit any changes made to the graphics state and unexpected
output may result.
.SP
Here is a sample beginning-of-page file which prints "CONFIDENTIAL"
diagonally across a letter size page in gray letters about 1/2" high:
.SP
.nf
\fHgsave
52.3 rotate
/Helvetica findfont 540 scalefont setfont
.8 setgray
3047 -202 moveto (CONFIDENTIAL) show
grestore\f1
.fi
