#include <stdio.h>
#include "externs.h"
#define TRUE 1
#define FALSE 0
/*******************************************************
* Function to parse command line options. Adapted from *
* getargs in dqms1.c, from QUICroff package.           *
*******************************************************/
getargs(argc, argv)
int argc;
char **argv;
{
	int temp;
	long number;
	char char2;

	while (argc > 1 && argv[1][0] == '-') {
		switch(argv[1][1])
		{
/* compression factor for body font */
		case 'C':
			squeeze = getint(&argc, &argv, 2);
			break;

/* compression factor for header font */
		case 'c':
			hsqueeze = getint(&argc, &argv, 2);
			break;

/* lines per inch X 100 */
		case 'I':
			lspace = getint(&argc, &argv, 2);
			break;

/* number of copies */
		case '#':
			copies = getint(&argc, &argv, 2);
			break;

/* landscape orientation */
		case 'L':
			landscape = TRUE;
			break;

/* turn off header */
		case 'N':
			header = FALSE;
			break;

/* number lines */
		case 'n':
			numline = TRUE;
			break;

/* print in two columns */
		case '2':
			twocol = TRUE;
			break;

/* don't separate columns with a rule line */
		case 'X':
			rule = FALSE;
			break;

/* print 4-up, i.e. four half-size pages per sheet */
		case '4':
			fourup = TRUE;
			break;

/* dont't separate 4-up pages with rule lines */
		case 'Z':
			frule = FALSE;
			break;

/* body font */
		case 'F':
			getname(&argc, &argv, 2, font, sizeof(font));
			break;

/* header font */
		case 'f':
			getname(&argc, &argv, 2, hfont, sizeof(hfont));
			break;

/* beginning-of-page file */
		case 'B':
			getname(&argc, &argv, 2, bopfile, sizeof(bopfile));
			break;

/* end-of-page file */
		case 'E':
			getname(&argc, &argv, 2, eopfile, sizeof(eopfile));
			break;

/* tab stop */
		case 'T':
			tab = getint(&argc, &argv, 2);
			break;

/* page size */
		case 'G':
			page_size = getint(&argc, &argv, 2);
			break;

/* body point size X 10 */
		case 'P':
			ps = getint(&argc, &argv, 2);
			break;

/* header point size X 10 */
		case 'p':
			hps = getint(&argc, &argv, 2);
			break;

/* top margins */
		case 't':
			char2 = argv[1][2];
			if(char2 != 'b' && char2 != 'h')
			{
				fprintf(stderr, "Unknown option %s\n",
				 &argv[1][1]);
				exit(1);
			}
			temp = getint(&argc, &argv, 3);
			if(char2 == 'b')
				tm = temp;
			else
				htm = temp;
			break;

/* left margins */
		case 'l':
			char2 = argv[1][2];
			if(char2 != 'b' && char2 != 'h')
			{
				fprintf(stderr, "Unknown option %s\n",
				 &argv[1][1]);
				exit(1);
			}
			temp = getint(&argc, &argv, 3);
			if(char2 == 'b')
				lm = temp;
			else
				hlm = temp;
			break;

/* body bottom margin */
		case 'b':
			if(argv[1][2] != 'b')
			{
				fprintf(stderr, "Unknown option %s\n",
				 &argv[1][1]);
				exit(1);
			}
			bm = getint(&argc, &argv, 3);
			break;

/* header right margin */
		case 'r':
			if(argv[1][2] != 'h')
			{
				fprintf(stderr, "Unknown option %s\n",
				 &argv[1][1]);
				exit(1);
			}
			hrm = getint(&argc, &argv, 3);
			break;

		default:
			fprintf(stderr, "Unknown option %s\n", &argv[1][1]);
			exit(1);
			break;
		}
		argc--;
		argv++;
	}
	if (argc > 1)
		strcpy(fname, argv[1]);
}

int getint(argcnt, argvec, numoffset)
int *argcnt;
char ***argvec;
int numoffset;
{
	int temp;

	if(argvec[0][1][numoffset] != '\0')
		return(atoi(&argvec[0][1][numoffset]));
	if (*argcnt < 3)
	{
		fprintf(stderr, "Missing argument for %s option\n",
			&argvec[0][1][1]);
		exit(1);
	}
	temp =atoi(argvec[0][2]);
        (*argcnt)--;
        (*argvec)++;
        return temp;
}

getname(argcnt, argvec, nameoffset, name, namelength)
int *argcnt;
char ***argvec;
int nameoffset;
char *name;
int namelength;
{
	if(argvec[0][1][nameoffset] != '\0')
	{
		strncpy(name, &argvec[0][1][nameoffset], namelength);
		return;
	}
	if (*argcnt < 3)
	{
		fprintf(stderr, "Missing argument for %s option\n",
			&argvec[0][1][1]);
		exit(1);
	}
	strncpy(name, argvec[0][2], namelength);
        (*argcnt)--;
        (*argvec)++;
}
