/* Copyright (c) 2003 KONICA MINOLTA BUSINESS TECHNOLOGIES, INC. All rights reserved. */
/*
 * Utility routines.
 */

#include <stdio.h>
#include "qef.h"

short debug = 0,
      nostat = 0,
      bjobfile_present = FALSE,
      blogfile_present = FALSE,
      jobfile_present = 0,
      logfile_present = 0,
      verbose = 0,
      original = 0,
      uflag = 0,
      port_number = 35;

proc_args(argc, argv, copts)
int argc;
char *argv[];
struct command_opt *copts;
{
	short hname_present = 0;
	short statfile_present = 0;
	struct file_list *last, *fptr, *fname_alloc();

    copts->granularity = 5;
    copts->time = 0;
	copts->alternative = 0;
    copts->port_number = 35;
	if (argc < 1)
		pr_usage();
	while (--argc && (*(++argv))) {
		switch ((*argv)[1]) {
			case 'h':
			case 'H':
				if (*(argv + 1) == (char *)NULL)
					pr_usage();
				strcpy(copts->hostname, *(++argv));
				hname_present = 1;
				argc--;
				break;

			case 'f':
			case 'F':
				if (*(argv + 1) == (char *)NULL)
					pr_usage();
				last = (struct file_list *)NULL;
				while (*(++argv)) {
					if (**argv == '-') {
						argv--;
						break;
					}
					if ((fptr = fname_alloc(sizeof(struct file_list))) == (struct file_list *)NULL) {
						fprintf(stderr, "failed to allocate file_List\n");
						exit(1);
					}
					/* Disable input from stdin */
					copts->input_stdin = 0;

					if (last == (struct file_list *)NULL) {
						copts->flist = fptr;
					}
					else {
						last->next = fptr;
					}

					last = fptr;

					fptr->next = (struct file_list *)NULL;
					strcpy(fptr->filename, *argv);

					argc--;
				}
				break;

			case 's':
			case 'S':
				if (*(argv + 1) == (char *)NULL)
					pr_usage();
				statfile_present = 1;
				strcpy(copts->statfile, *(++argv));
				argc--;
				break;
            case 'b':
                if (*(argv + 1) == (char *)NULL)
                    pr_usage();
                bjobfile_present = TRUE;
                strcpy(copts->bjobfile, *(++argv));
                argc--;
                break;
            case 'B':
                if (*(argv + 1) == (char *)NULL)
                     pr_usage();
                blogfile_present = TRUE;
                strcpy(copts->blogfile, *(++argv));
                argc--;
                break;
            case 'j':
            case 'J':
                if (*(argv + 1) == (char *)NULL)
                    pr_usage();
                jobfile_present = 1;
                strcpy(copts->jobfile, *(++argv));
                argc--;
                break;
            case 'l':
            case 'L':
                if (*(argv + 1) == (char *)NULL)
                     pr_usage();
                logfile_present = 1;
                strcpy(copts->logfile, *(++argv));
                argc--;
                break;
			case 'a':
			case 'A':
				copts->alternative = 1;
				copts->time = 1;
				break;
            case 'r':
            case 'R':
                copts->time = 1;
                break;
            case 'g':
            case 'G':
                if (*(argv + 1) == (char *)NULL)
                    pr_usage();
                copts->granularity = atoi(*(++argv));
                argc--;
                if (copts->granularity > 60)
                    copts->granularity = 60;
			    else if (copts->granularity < 0)
			        copts->granularity = 0;
                break;
            case 'v':
            case 'V':
                verbose = 1;
                break;
		    case 'w':
            case 'W':
                pr_ver();
                break;		
            case 'd':
            case 'D':
                debug = 1;
                break;
            case 'n':
            case 'N':
                nostat = 1;
                break;
            case 'o':
            case 'O':
                original = 1;
                break;
	    case 'u':
            case 'U':
                uflag = 1;
                break;
            case 'p':
            case 'P':
                if (*(argv + 1) == (char *)NULL) {
                    pr_usage();
				}
                copts->port_number = atoi(*(++argv));
                argc--;
                if (copts->port_number > 9999) {
                    pr_usage();
                }
                else {
				    if (copts->port_number < 1) {
                        pr_usage();
                    }
                }
                break;
			default:
				pr_usage();
				break;
		}
	}
	if (hname_present == 0)
		pr_usage();
	
	if (statfile_present == 0)
		pr_usage();
}

struct file_list *fname_alloc(asize)
int asize;
{
	return ((struct file_list *)malloc(asize));
}



pr_usage()
{
	printf("qef: Program to send file to the printer\
		\n\t -{aA}	<alternative status mode>\
        \n\t -{b}	<backchannel_job_filename>\
        \n\t -{B}	<backchannel_log_filename>\
		\n\t -{fF}  <filename1> [[filename2] ...[filenamen ]\
        \n\t -{gG}	<time between status request>\
		\n\t -{hH}	<hostname>\
        \n\t -{jJ}	<job_status_filename>\
        \n\t -{lL}	<log_status_filename>\
        \n\t -{pP}	<port_number (1 - 9999)>\
        \n\t -{rR}	<time stamp real time>\
		\n\t -{sS}	<status_filename>\
		\n\t -{vV}	<verbose mode>\
        \n\t -{uU}	<Unison compatibility>\n");
	exit(1);
}
pr_ver()
{
	printf("Unix Host Software -- qef: Version 2.18\n");
	exit(0);
}
/*
        jcopy -- copy memory regions of arbitary length

        Copy LENGTH bytes from memory region pointed to by IN to memory
        region pointed to by OUT.

*/

void
jcopy (src, dest, len)
  register char *src, *dest;
  int len;
{
    while (len--)
      *dest++ = *src++;
}

/*
        jzero -- zero the contents of a specified memory region


        Zero COUNT bytes of memory pointed to by TO.

*/


void
jzero (to, count)
  char *to;
  int count;
{
  while (count-- > 0)
    {
      *to++ = 0;
    }
}

