/* Copyright (c) 2003 KONICA MINOLTA BUSINESS TECHNOLOGIES, INC. All rights reserved. */
#define PRINTER_ADDR "125.0.0.3"

#define PRINTER_PORT 35
#define PRINTER_TCP_PORT  PRINTER_PORT 
#define PRINTER_UDP_PORT  PRINTER_PORT 

#define MAX_STRING_SIZE 512
#define MAX_REPLY_SIZE 1024
#define BUFSIZE       16384

#define TCP_PROVIDER "/dev/tcp"
#define UDP_PROVIDER "/dev/udp"

#define POLL_TIMEOUT (99 * 10) /* in msecs */
#define UDP_TIMEOUT 99 /* in 1/100th of a second */
#define SLEEPTIME   10
#define NUMRETRY    100

#define STATFILE "./statfile"
#define STATUSINTERVAL  4  /* msecs */

/* Status file codes */

#define STABASE  512
#define STAJSTART (STABASE + 0)
#define STAFSTART (STABASE + 4)
#define STANCOMP  (STABASE + 8)
#define STARETRY  (STABASE + 12)
#define STAACOMP  (STABASE + 16)
#define STASTERM  (STABASE + 20)
#define STAJCOMP  (STABASE + 24)

#define MODNAME_LEN 1050

struct ACCOUNTING {
           unsigned int  JobId;
           unsigned int  Status;
           unsigned int  ByteSize;
           unsigned int  Recvd;
           unsigned int  Page;
           unsigned int  Sheet;
           unsigned int  Emulation;
           unsigned int  Terminate;
           char    Title[MODNAME_LEN];
           char    For[MODNAME_LEN];
        };
struct ACCOUNT {
           char    Status[MODNAME_LEN];
           char    Recvd[MODNAME_LEN]; 
           char    Time[MODNAME_LEN];
        };

struct printer_pkt{
	unsigned short pr_length;
	unsigned char  pr_status;
	unsigned char  pr_spare;
	unsigned long  pr_age;
	unsigned long  pr_supportmask;
	unsigned long  pr_acceptmask;
	unsigned short pr_stroffset;
	unsigned short pr_strlength;
};

struct file_list {
	char filename[MAX_STRING_SIZE];
	struct file_list *next;
};

struct time_info {
	char day[4];
	char month[4];
	char daynum[3];
	char hrminsec[9];
	char year[5];
};

struct command_opt {
	short input_stdin;
	char hostname[MAX_STRING_SIZE];
	char statfile[MAX_STRING_SIZE];
	struct file_list *flist; /* List of filenames to be printed */
	int cpid[2]; /* it's not really a command argument. But it's a good
		   * (though not neat) way of stashing way the child process's
		   * pid thus obviating the need to pass it as an argument from
		   * zillion different places.
		   */
    char bjobfile[MAX_STRING_SIZE];
    char blogfile[MAX_STRING_SIZE];
    char jobfile[MAX_STRING_SIZE];
    char logfile[MAX_STRING_SIZE];
    int  time;
    int  granularity;
	int  alternative;
    int  port_number;
};


/*
 * Printer status.
 */
#define PRINTER_READY 1


/* #ifdef DEBUG */
#define DBGPRT(a) if (debug) printf a;
/* #else 
#define DBGPRT(a) 
#endif  */

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif




