﻿/*/////////////////////////////////////////////////////////////////////////////////////////////////
	User Guide PP
		Select Print JavaScript
 Modified : 2016-12-21
/////////////////////////////////////////////////////////////////////////////////////////////////*/

/* global _get, menu, textData, contents, cmn */



var sprintFunc = {
	
	"_data": {}
	
	/*
	 * ツリー読み込み
	 */
	,"loadTree": function(id){
		var tree = menu[id];
		var fileArr = [];
		
		var setHtml = function(t){
			var temp = $('<div><ul/></div>');
			$.each(t, function(i,v){
				if(v.children){
					temp.children('ul').append('<li><span class="ctCheck"></span><span>' + v.title + '</span></li>');
					var child_LI = temp.find('> ul > li:last-child');
					child_LI.append(setHtml(v.children));
				}else{
					var file = v.file.replace(/\.html?/, '');
					temp.children('ul').append('<li><label><input type="checkbox" value="'
							+ file + '"><span>' + v.title + '</span></label></li>');
					fileArr.push(file);
				}
			});
			return temp.html();
		};
		
		var setContents = function(files){
			var html = [];
			$.each(files, function(i, file){
				html.push('<div id="' + file + '" style="display: none;" class="pageBreak">'
						+ '<div class="page">' + contents[file + '.html'].contents + '</div></div>');
			});
			return html.join('');
		};
		
		$('h1 .bookName').text('-' + tree.title + '-');
		$('#spTree').html(setHtml(tree.children));
		$("#spTree :checkbox").prop('checked', false);
		$("#spTree li > span").removeClass('check');
		
		$("#container").html(setContents(fileArr));
		cmn.removeThead($("#container"));
		cmn.addViewClass('pageNavi');
		
		$('#print, #unSele').prop('disabled',true);
		
		sprintFunc._data.pageCount = fileArr.length;
	}
	
	/*
	 * プリントボタンイベント
	 */
	,"printBtnEvent": function(){
		$('#print').on("click", function(){
			print();
		});
	}
	
	/*
	 * チェックボックスイベント
	 */
	,"checkboxEvent": function(){
		
		parentCheck = function(ctCheck){
			var this_LI = ctCheck.closest("li");
			this_LI.parents('li').each(function(i,el){
				var target = $(el).children(".ctCheck");
				var checkboxLen = $(el).find(':checkbox').length;
				var checkLen = $(el).find(':checkbox:checked').length;
				if(checkboxLen == checkLen){
					target.addClass('check').removeClass('childcheck');
				}else if(checkLen){
					target.addClass('childcheck').removeClass('check');
				}else{
					target.removeClass('check').removeClass('childcheck');
				}
			});
		};

		var contentsShowHide = function(){
			$('#container > div').addClass('pageBreak').hide();
			var isFirst = true;
			$("#selectForm :checked").each(function(i,e){
				$('#' + $(e).val()).show();
				if(isFirst){
					$('#' + $(e).val()).removeClass('pageBreak');
					isFirst = false;
				}
			});
		};
		
		var btnState = function(){
			var checkLen = $('#selectForm :checked').length;
			if(checkLen == 0){
				$('#print, #unSele').prop('disabled', true);
				$('#selAll').prop('disabled', false);
			}else if(checkLen == sprintFunc._data.pageCount){
				$('#print, #unSele').prop('disabled', false);
				$('#selAll').prop('disabled', true);
			}else{
				$('#print, #unSele, #selAll').prop('disabled', false);
			}
		};
		
		$('#selAll').on("click", function(){
			$("#selectForm :checkbox").prop('checked', true);
			$("#selectForm li > span.ctCheck").addClass('check').removeClass('childcheck');
			$('#container > div').show().addClass('pageBreak');
			$('#container > div:first').removeClass('pageBreak');
			btnState();
		});
		
		$('#unSele').on("click", function(){
			$("#selectForm :checkbox").prop('checked', false);
			$("#selectForm li").find('span').removeClass('check').removeClass('childcheck');
			$('#container > div').hide();
			btnState();
		});
		
		$('#selectForm').on("click", ':checkbox', function(e){
			parentCheck($(e.currentTarget));
			contentsShowHide();
			btnState();
		});
		
		$('#selectForm').on("click", '.ctCheck, .ctCheck + span', function(e){
			var this_LI = $(e.currentTarget).closest("li");
			var ctCheck = this_LI.children('.ctCheck');
			var doUnCheck = ctCheck.is('.check');
			if(doUnCheck){
				this_LI.find(':checkbox').prop('checked', false);
				this_LI.find('.check, .childcheck').removeClass('check childcheck');
			}else{
				this_LI.find(':checkbox').prop('checked', true);
				this_LI.find('.ctCheck').addClass('check').removeClass('childcheck');
			}
			parentCheck(ctCheck);
			contentsShowHide();
			btnState();
		});
	
	
	}
};



/**************************************************
 * jQuery ready
 */
$(function(){
	
	//ツリー読み込み
	setTimeout(function(){
		sprintFunc.loadTree(_get["b"]);
	},100);
	
	//プリントボタンイベント
	sprintFunc.printBtnEvent();
	
	//チェックボックスイベント
	sprintFunc.checkboxEvent();
	
	
	//
//	if(_ua._isSafari){
//		$(window).on('resize', function(){
//			if(_ua._isSafari){
//				setTimeout(function(){
//					console.log($(window).height());
//					$('#selectTree').css('flex', '1 0 calc('+$(window).height()+'px - (80px + 55px))');
//				},2000);
//			}
//		});
//	}
	
});
//end jQuery ready
