/*/////////////////////////////////////////////////////////////////////////////////////////////////
	User's Guide PP
		common JavaScript
 Modified : 2016-12-27
/////////////////////////////////////////////////////////////////////////////////////////////////*/


/* global decodeURIComponent */


/**************************************************
 * URLからの情報取得
 * 　戻り：　_uri
 */
var _uri = (function(){
	var uri = {
		"location": window.location.href
		,"fullPath": ((window.location.origin||'') + window.location.pathname).replace(/\\/g, "/")
	};
	uri.path = uri.fullPath.split('/').slice(0,-1).join('/');
	uri.file = uri.fullPath.split('/').slice(-1).join('')||"index.html";
	uri.hash = window.location.hash;
	uri.manualPath = uri.path.replace(/\/?contents\/?$/i, '');
	uri.fileName = uri.file.replace(/\.html?$/, '');
	uri.id = uri.file.split("_",1).join('');
	
	return uri;
}());




/**************************************************
 * ユーザーエージェントから情報取得
 * 　戻り：　_ua
 */
var _ua = (function(){
	var na = navigator, ua = na.userAgent;
	var __ua = {
		"_protocol": document.location.protocol
		,"_isWin": /win/i.test(na.platform)
		,"_isMac": /mac/i.test(na.platform)
		,"_isWebKit": /WebKit/i.test(ua)
		,"_isChrome": /chrome/i.test(ua)
		,"_isOpera": window.opera && window.opera.buildNumber
		,"_isEdge": /Edge\//i.test(ua)
		,"_isKMBuiltIn": /KMBuiltInBrowser/i.test(ua)
		,"_browser": false
	};
	__ua._isIE = !__ua._isWebKit && !__ua._isOpera && ( /MSIE/i.test(ua) || /Trident/i.test(ua) );
	__ua._isGecko = !__ua._isWebKit && /Gecko/.test(ua);
	__ua._isFirefox = __ua._isGecko && /Firefox/.test(ua);
	__ua._isSafari = __ua._isWebKit && !__ua._isChrome && __ua._isMac;
	
	if(__ua._isEdge){
		__ua._browser = 'edge';
	}else if(__ua._isIE){
		__ua._browser = 'ie';
	}else if(__ua._isSafari){
		__ua._browser = 'safari';
	}else if(__ua._isFirefox){
		__ua._browser = 'firefox';
	}else if(__ua._isChrome){
		__ua._browser = 'chrome';
	}
	
	if(__ua._isIE){
		var bver = ua.replace(/^.+(MSIE |rv:)([0-9]+).+$/i, '$2');
		__ua._IEVer = Number(bver);
		__ua._IEVer11 = bver == 11;
		__ua._IEolder10 = bver <= 10;
		__ua._IEolder9 = bver <= 9;
		__ua._IEolder8 = bver <= 8;
	}
	if(__ua._isSafari){
		__ua._SafariFullVer = ua.replace(/^.+Version\/([0-9.]+).*$/i, '$1');
		__ua._SafariVer = __ua._SafariFullVer.split('.')[0];
	}
	
	
	var html = document.getElementsByTagName('html')[0];
	var nowClass = [html.getAttribute("class") || ''];
	nowClass.push(__ua._browser);
	//IEに遅延表示
	if(__ua._isIE) nowClass.push('pageDelayShow');
	//Safariのバージョン付加
	if(__ua._isSafari) nowClass.push('safari-' + __ua._SafariVer);
	
	html.setAttribute("class", nowClass.join(' '));
	
	return __ua;
}());


/* *************************************************
 * プロトコルを判定し、[ HTML | PHP ]を変換し戻す
 */
var searchAction = function(formAction){
	var searchAction = (/https?:/.test(_ua._protocol))? formAction.replace(/\.htm.?$/,".php") : formAction ;
	return searchAction;
};


/* *************************************************
 * URLからGET情報取得
 */
var _get = (function(){
	var getdata = window.location.search.replace(/^\?/,'').split('&');
	var get = [];
	for(var i=0,len=getdata.length; i<len; i++){
		var temp = decodeURIComponent(getdata[i]).split('=');
		var ak = temp[0];
		temp.shift();
		get[ak] = temp.join('=');
	}
	return get;
}());


//古いIE対応
var olderIE =  (function(){
	if(_ua._IEolder9){
		var sharedPath = ("index" == _uri.fileName) ? 'contents/shared':'shared';
		document.write('<link href="' + sharedPath + '/css/older_ie.css" rel="stylesheet" type="text/css" media="screen,print">');
	}
}());

/**************************************************
 * 共有関数
 */
var cmn = {
	
	//初期
	"init": function(){
		
		//遅延表示
		setTimeout(function(){
			$('html').removeClass('pageDelayShow');
		}, 0);
	}
	
	//theadをtbodyへ移す
	,"removeThead": function(t){
		if(!t) t = $('#container');
		t.find('thead').each(function(i,e){
			var thead = $(e);
			var target = thead.siblings('tbody');
			if(!target) target = thead.parent();
			thead.children().prependTo(target);
			thead.remove();
		});
	}
	
	//
	,"addViewClass": function(v){
		if('pageNavi' == v){
			if($('.page > h1 + div').is('.pageNavi')){
				$('.page').addClass('inPageNavi');
			}
		}
	}
	
	//横スクロールが出た場合にnaviTreeにクラス追加
	,"ntbMargin": function(){
		if($(window).width() < $('#documentBody').width()){
			$('#naviTree, #localMenu.searchFilter').addClass('bottmMargin');
		}else{
			$('#naviTree, #localMenu.searchFilter').removeClass('bottmMargin');
		}
	}
	
	//グローバルメニューのメニュー開閉
	,"globalMenuOpen": function(){
		var pullpros = true;
		$(document).on('click', '#globalMenu .menu>span>a, #globalMenu .openCloseBtn, body.openGMenu *', function(e){
			var ta = $(e.target);
			
			//プルダウンメニュー内の「閉じる」ボタン、メニュー項目以外をクリックしたら処理停止
			if(ta.parents("div").is('.pulldownMenu') && !ta.is('.openCloseBtn, .pulldownMenu a')){
				return false;
			}
			
			if(pullpros){
				//メニュー項目以外をクリック
				if(!ta.is('.pulldownMenu a')){
					pullpros = false;
					var target = $('#globalMenu .menu').closest('li');
					//閉じる
					if($('body').is('.openGMenu')){
						target.find('>span>a').removeClass('active');
						target.find('.pulldownMenu').slideUp("fast");
						$('.overlay.gmenu').removeClass('in');
						setTimeout(function(){
							$('.overlay.gmenu').remove();
							$('body').toggleClass('openGMenu');
							pullpros = true;
						},300);
					}
					//開く
					else{
						target.find('>span>a').addClass('active');
						target.find('.pulldownMenu').slideDown("fast");
						$('body').toggleClass('openGMenu');
						$('body, #header').append('<div class="overlay gmenu"/>');
						setTimeout(function(){
							$('.overlay.gmenu').addClass('in');
							pullpros = true;
						},0);
					}

					if(!ta.closest('ul').is('.main')) return false;

				}
				e.stopPropagation();
			}
		});
	}
	
	//検索フォーム
	,"searchForm": function(){
		
		$('#search form').on("submit", function(){
			var keyword = $.trim($('#searchKey').val());
			if(!keyword){
				return false;
			}else{
				var fil = [];
				if($('#filter_title').is(':checked')){
					fil.push('t=1');
				}
				var filters = [];
				$('#searchCt input:checked').each(function(){
					filters.push($(this).val());
				});
				if(filters.length){
					fil.push('f=' + filters.join(','));
				}
				if($('#charUpLo').is(':checked')){
					fil.push('ul=1');
				}
				if($('#zenHan').is(':checked')){
					fil.push('zh=1');
				}
				fil = (fil.length) ? "&" + fil.join('&'):'';
				window.location = searchAction($('#search form').attr('action')) + "?k=" + encodeURIComponent(keyword) + fil;
				return false;
			}
		});
	}
	
};





/**************************************************
 * jQuery ready
 */
$(function(){
	
	//初期
	cmn.init();
	
	//アンカーのdisabled処理
	$(document).on('click', 'a[disabled], a.disabled', function(e){
		return false;
	});
	
	//検索フォーム
	cmn.searchForm();
	
	//グローバルメニューのメニュー開閉
	cmn.globalMenuOpen();
	
	//横スクロールが出た場合にナビツリーの下に余白を持たせてナビツリーのスクロールバーかぶりを防ぐ
	cmn.ntbMargin();
	$(window).on('resize', function(){
		cmn.ntbMargin();
	});
	
	//「ページトップへ」ボタン
	$('#returnToTop').on("click", "a", function(e){
		$('html, body').animate({ scrollTop: 0 }, 300, 'swing');
	});
	
	
	
	
	
});
//end jQuery ready
