/*/////////////////////////////////////////////////////////////////////////////////////////////////
	User Guide
		search_result JavaScript
 Modified : 2016-02-12
/////////////////////////////////////////////////////////////////////////////////////////////////*/

/* global textData, data, get, keyword_data, srCountType, settings */

$(function(){
	
	// 1ページあたりの結果数
	var max = 10;
	// ヒットキーワードの前何文字表示
	var snippetStart = 30;
	// 説明の表示文字数
	var snippetLength = 80;//380;
	// 検索タイプ
	var searchType = 'and';//(and|or)
	//トリムしたときの接頭接尾語
	var conm = '<span class="conm">&#8230;</span>';
	//ユーザーフォントパターン
	var ufPattern = /@@@(\d@)+@@/;
	//大文字小文字の区別
	var charUpLo = false;
	//全角半角の区別
	var zenHan = false;
	
	var splitStrBase = '㌀|㍇|㍬|㍭|㍮|㍯|㍰';
	
	$('#title h1').text(textData.searchResult);
	$('#search2 label[for="searchKey2"]').text(textData.SearchTxt);
	$('#searchSubmit2').val(textData.SearchTxt);
	$('#crombsNavi span.frist a').text(textData.home);
	$('#crombsNavi span:last-child').text(textData.searchResult);
	$('#NarrowDownBlock h4.txt-searchTarget').text(textData.refine);
	$('#searchTi label').text(textData.titleOnly);
	$('#alluncheck').text(textData.cancelAll);
	$('#narrowSubmit').text(textData.confirmed);
	
	
	var start = new Date().getTime();
	
	if(settings.searchOption){
		var optionItem = ['<span><input type="checkbox" id="charUpLo2" class="charUpLo" value="1"><label for="charUpLo2">' + textData.searchOptionCharUpLo + '</label></span>'];
		if("ja" == lang){
			optionItem.push('<span><input type="checkbox" id="zenHan2" class="zenHan" value="1"><label for="zenHan2">' + textData.searchOptionZenHan + '</label></span>');
		}
		$('#NarrowDownBlock').prepend('<h4 class="txt-searchOption">' + textData.searchOption + '</h4>'
			+ '<div id="searchOp">'
			+ optionItem.join('')
			+ '</div>'
		);
	}
	
	var ctSort = ['id08','id20','id01','id02','id03','id04','id05','id06','id07','id10','id11','id24','id25','id19','id13','id14','id15','id16','id17','id18','id12','id23'];
	var ct = [];
	for(var i=0,len=data.length; i<len; i++){
		for(var j=0,len2=ctSort.length; j<len2; j++){
			var testid = new RegExp('^'+ctSort[j],'i');
			if(testid.test(data[i].File)){
				var testct = data[i].Path.replace(/>?[ ]*([^>]+) ?>[ ]*([^>]+).*$/,'$2');
				ct[j]=[ctSort[j], testct];
				break;
			}
		}
	}
	
	for(var i=0,len=ct.length; i<len; i++){
		if(ct[i]){
			$('#searchCt').append('<span><input type="checkbox" id="scid'+i+'" value="'+ct[i][0]+'"/><label for="scid'+i+'">'+ct[i][1]+'</label></span>');
		}
	}
	
	$('#NarrowDown input:checkbox').change(function(){
		if(!$(this).is(':checked')){
			$(this).parent('span').removeClass('checked');
		}else{
			$(this).parent('span').addClass('checked');
		}
	});
	
	$(document).on('change', '.charUpLo', function(e){
		if($(e.currentTarget).is(':checked')){
			$(".charUpLo").attr('checked','checked').parent('span').addClass('checked');
		}else{
			$(".charUpLo").removeAttr('checked').parent('span').removeClass('checked');
		}
	});
	$(document).on('change', '.zenHan', function(e){
		if($(e.currentTarget).is(':checked')){
			$(".zenHan").attr('checked','checked').parent('span').addClass('checked');
		}else{
			$(".zenHan").removeAttr('checked').parent('span').removeClass('checked');
		}
	});
	
	$('#alluncheck').hover(
		function(){ $(this).addClass('hover'); },
		function(){ $(this).removeClass('hover'); }
	).click(function(){
		$('#NarrowDown input').removeAttr('checked');
		$('#NarrowDown span').removeClass('checked');
		return false;
	});
	
	
	$('#searchSubmit2').after('<span id="searchBtn2"></span>');
	$('#searchBtn2, #narrowSubmit').hover(
		function(){ $(this).addClass('hover'); },
		function(){ $(this).removeClass('hover'); }
	).click(function(){
		$('#search2 form').submit();
	});
	$('#search2 form').submit(function(){
		var str = $('#searchKey2').val();
		if(str == textData.searchDefTxt || str == ""){
			return false;
		}else{
			var fil = [];
			if($('#t').is(':checked')){
				fil.push('t=1');
			}
			var sid = [];
			$('#searchCt input:checked').each(function(){
				sid.push($(this).val());
			});
			if(sid.length){
				fil.push('scid=' + sid.join(','));
			}
			if($('#charUpLo2').is(':checked')){
				fil.push('ul=1');
			}
			if($('#zenHan2').is(':checked')){
				fil.push('zh=1');
			}
			fil = (fil.length) ? "&" + fil.join('&'):'';
			window.location =  searchAction($('#search2 form').attr('action')) +"?k="+encodeURIComponent(str) + fil;
			return false;
		}
	});
	$('#navi span:not(.selected)').live('click', function(){
		loadFilData["p"] = $(this).attr('page');
		var fil = [];
		for(var key in loadFilData){
			fil.push(key + '=' + loadFilData[key]);
		}
		window.location =  searchAction($('#search2 form').attr('action')) + "?" + fil.join('&');
	});
	
	//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	var datalist = [];
	var datalistTit = [];
	//var findreg = [];
	var bolderlist = [];
	//var boldreg;
	var releatekey = [];
	var searchTime;
	var st = gid("sCount");
	var re = gid("results");
	var nv = gid("navi");
	var loadFilData = {};
	//
	var andSearch = searchType==='and';
	
	//----------------------------------------------------------
	
	
	if(!!get['t'] && /(1|true)/i.test(get['t'].toString())){
		$('#t').attr('checked','checked').parent('span').addClass('checked');
	}else{
		get['t'] = '';
	}
	if(!!get['scid']){
		for(var i=0,len=ct.length; i<len; i++){
			if(ct[i]){
				if(get['scid'].match(ct[i][0])){
					$('#scid'+i).attr('checked','checked').parent('span').addClass('checked');
				}
			}
		}
	}else{
		get['scid'] = '';
	}
	if(!!get['ul'] && /(1|true)/i.test(get['ul'].toString())){
		charUpLo =  true;
		$('.charUpLo').attr('checked','checked').parent('span').addClass('checked');
	}
	if(!!get['zh'] && /(1|true)/i.test(get['zh'].toString())){
		zenHan = true;
		$('.zenHan').attr('checked','checked').parent('span').addClass('checked');
	}
	var page = get['p'] || 1 ;
	
	
	
	//フィルタにより検索データ作成
	for(var i=0,len=data.length; i<len; i++){
		var temp = data[i].File.replace(/(-|_).+$/,'');
		var reid = new RegExp(temp);
		if(!!get['t']){
			if(!!get['scid']){//----タイトルのみでカテゴリ指定
				if(reid.test(get['scid']+"")){
					datalist[datalist.length] = ufrm(data[i].Title);
				}else{
					datalist[datalist.length] = '';
				}
			}else{//----------------タイトルのみ
				datalist[datalist.length] = ufrm(data[i].Title);
			}
		}else if(!!get['scid']){//--本文含めカテゴリ指定
			if(reid.test(get['scid']+"")){
				datalist[datalist.length] = ufrm(data[i].Body + "　" + data[i].Title);
			}else{
				datalist[datalist.length] = '';
			}
		}else{//--------------------全内容
			datalist[datalist.length] = ufrm(data[i].Body + "　" + data[i].Title);
		}
		datalistTit[datalistTit.length] = ufrm(data[i].Title);
	}
	
	
	//ユーザーフォント削除
	function ufrm(d){
		return d.replace(/(@@@)((\d@)+)(@@)/g, '');
	}
	
	
	//検索して表示する。
	function do_find(v){//**************************************
		if(this.lastquery == v){return;}
		this.lastquery = v;
		var re = find(v);
		pagenavi(re);
		view(re,page);
	}
	
	
	//ID取得
	function gid(id){//**************************************
		return document.getElementById(id);
	}
	
	
	/* ***********************************
	 * カタカナ表現生成 ガ=> (ガ|ｶﾞ)、
	 */
	function katakanaRegExp(str){
		var han = "ｶﾞ ｷﾞ ｸﾞ ｹﾞ ｺﾞ ｻﾞ ｼﾞ ｽﾞ ｾﾞ ｿﾞ ﾀﾞ ﾁﾞ ﾂﾞ ﾃﾞ ﾄﾞ ﾊﾞ ﾊﾟ ﾋﾞ ﾋﾟ ﾌﾞ ﾌﾟ ﾍﾞ ﾍﾟ ﾎﾞ ﾎﾟ ｳﾞ ｧ ｱ ｨ ｲ ｩ ｳ ｪ ｴ ｫ ｵ ｶ ｷ ｸ ｹ ｺ ｻ ｼ ｽ ｾ ｿ ﾀ ﾁ ｯ ﾂ ﾃ ﾄ ﾅ ﾆ ﾇ ﾈ ﾉ ﾊ ﾋ ﾌ ﾍ ﾎ ﾏ ﾐ ﾑ ﾒ ﾓ ｬ ﾔ ｭ ﾕ ｮ ﾖ ﾗ ﾘ ﾙ ﾚ ﾛ ﾜ ｦ ﾝ ｡ ｢ ｣ ､ ･ ｰ ﾞ ﾟ".split(' ');
		var zen = "ガギグゲゴザジズゼゾダヂヅデドバパビピブプベペボポヴァアィイゥウェエォオカキクケコサシスセソタチッツテトナニヌネノハヒフヘホマミムメモャヤュユョヨラリルレロワヲン。「」、・ー゛゜".split('');
		if(han.length == zen.length){
			for(var i in han){
				var re = new RegExp('(' + han[i] + '|' + zen[i] + ')', "g");
				str = str.replace(re, re.source);
			}
		}
		return str;
	}
	
	
	/* ***********************************
	 * 全角半角正規表現生成　＆　エスケープ　a => (a|ａ)、ＡＢ => (Ａ|A)(Ｂ|B)、［ => (［|\[)
	 */
	function zenHanRegExp(str){
		if( /[\!-\~！-～￥]/.test(str) ){
			str = str.split('');
			for(var i in str){
				str[i] = str[i].replace(/[\!-\~！-～￥]/, function(s){
					if(/[！-～]/.test(s)){
						return '(' + s + '|' + escapeRegex(String.fromCharCode(s.charCodeAt(0) - 0xFEE0)) + ')';
					}else if(/[￥]/.test(s)){
						return '(' + s + '|' + escapeRegex(String.fromCharCode(0x005C)) + ')';
					}else if(/[\\]/.test(s)){
						return '(' + escapeRegex(s) + '|' + String.fromCharCode(0xFFE5) + ')';
					}else{
						return '(' + escapeRegex(s) + '|' + String.fromCharCode(s.charCodeAt(0) + 0xFEE0) + ')';
					}
				});
			}
			str = str.join('');
		}else{
			str = escapeRegex(str);
		}
		str = katakanaRegExp(str);
		return str;
	}
	
	
	//正規表現エスケープ処理
	var escapeRegex = function(s){//**************************************
		return s.replace(/[\[\]{}()*+?\\^$|#;\.]/g, "\\$&");
	};
	
	
	//検索キー作成
	function createfindreg(v){//**************************************
		var findregs = [];
		
		var keys = v.replace(/[\s　]+/g," ").split(" ");
		for(var i in keys){
			if(keys[i] == "") keys.splice(i,1);
		}
		
		var reFlag = (!charUpLo) ? "i":'';
		var releateRe = [];
		for(var i in keys){
			try{
				releateRe[i] = zenHanRegExp(keys[i]);
				if(zenHan){
					keys[i] = escapeRegex(keys[i]);
				}else{
					keys[i] = releateRe[i];
				}
				findregs.push([ new RegExp("(" + keys[i] + ")", reFlag) ]);
			}catch(e){}
		}
		
		//関連キーワード作成
		releateQuery(releateRe);
		
		return findregs;
	}
	
	//ソート
	function regSort(a, b){//**************************************
		return (a.source.length < b.source.length) ? 1 : -1;
	}
	
	//findregからor検索Reg作成
	function createboldreg(findreg){//**************************************
		strreg = "";
		for(i=0,len=findreg.length; i<len; i++){
			tmpreg = findreg[i].source;
			tmpreg = tmpreg.substring(1,tmpreg.length-1);
			strreg = strreg + tmpreg + "|";
		}
		strreg = "(" + strreg.substring(0,strreg.length-1) + ")";
		
		boldreg = new RegExp(strreg, 'i');
		return boldreg;
	}


	/* ***********************************
	 * 配列の重複削除
	 */
	function uniqueArray(array){
		var storage = {};
		var uniqueArray = [];
		var i,value;
		for ( i=0; i<array.length; i++){
			value = array[i];
			if (!(value in storage)){
				storage[value] = true;
				uniqueArray.push(value);
			}
		}
		return uniqueArray;
	}
	
	
	//関連キーワード作成
	function releateQuery(keys){//**************************************
		var keysArr = keys, res = ['^','$'];
		for(var i in keysArr){
			if(keysArr[i] == "") keysArr.splice(i,1);
		}
		
		for(var i in keysArr){
			for(var j in keyword_data){
				var re = new RegExp(res[0] + keysArr[i] + res[1], 'i');
				if(re.test(j)){
					releatekey = releatekey.concat(keyword_data[j]);
				}
			}
		}
		releatekey = uniqueArray(releatekey);
	}
	
	//検索処理
	function find(v){//**************************************
		//検索結果はkeyをこの配列から削除する。
		query = v;
		if(!v) return [];
		
		//検索キー作成 /(aaa)/i,/(bbb)/i
		var findregs = createfindreg(query);
		
		var result = [];
		//重複さけるための配列
		idList= [];
		
		for(var h=0,len1=findregs.length; h<len1; h++){
			var findreg = findregs[h];
			boldreg = createboldreg(findreg);
			
			if(andSearch && h>0){
				var result2=[];
				for(var i=0,len2=result.length; i<len2; i++){
					for(j=0,len3=findreg.length; j<len3; j++){
						tHit = result[i][0] || findreg[j].test(datalistTit[result[i][1]]);
						res = findreg[j].test(datalist[result[i][1]]);
						if(!res){break;}
					}
					if(res){
						if(jQuery.inArray(boldreg,bolderlist)==-1) bolderlist[bolderlist.length]=boldreg;
						result2.push([tHit,result[i][1]]);
					}
				}
			}else{
				for(var i=0,len2=datalist.length; i<len2; i++){
					res = false;
					tHit = false;
					s = datalist[i];
					if(jQuery.inArray(i,idList)==-1){
						for(var j=0,len3=findreg.length; j<len3; j++){
							tHit = tHit || findreg[j].test(datalistTit[i]);
							res = findreg[j].test(s);
							if(!res){break;}
						}
						if(res){
							idList[idList.length]=i;
							if(jQuery.inArray(boldreg,bolderlist)==-1) bolderlist[bolderlist.length]=boldreg;
							result.push([tHit,i]);
						}
					}
				}
			}
			result = (result2) ? result2 : result ;
		}
		
		var r1=[],r2=[];
		for(var i=0,len=result.length; i<len; i++){
			if(result[i][0]){//tHit true
				r1[r1.length]=result[i][1];
			}else{
				r2[r2.length]=result[i][1];
			}
		}
		var result = r1.concat(r2);
		
		return result;
	}
	
	//説明トリミング
	function snippet(body, boldreg){//**************************************
		var ufRe = new RegExp(ufPattern.source, "g");
		var splitStr, sniPoint = 0, userFont = [];
		
		if(ufPattern.test(body)){
			var temp = body.match(new RegExp('('+ splitStrBase + ')', "g"));
			if(temp){
				temp = new RegExp('(' + temp.join('|') + ')', "g");
				splitStr = splitStrBase.replace(/\|/, '').replace(temp, '').split('|');
			}else{
				splitStr = splitStrBase.split('|');
			}
			body = body.replace(ufRe, function(s){
				userFont.push(s);
				return splitStr[0];
			});
		}
		
		var reFlag = (!charUpLo) ? "i":'';
		for(i=0,len=boldreg.length; i<len; i++){
			var re = new RegExp(boldreg[i].source, reFlag);
			isMatch = body.match(re);
			if(isMatch) break;
		}
		if(isMatch){
			newPoint = isMatch.index;
			sniPoint = Math.max(sniPoint, newPoint);
		}
		var trimPoint = [
			sniPoint - snippetStart,
			sniPoint + snippetStart + snippetLength
		];
		var trimStr = [
			body.substring(0, trimPoint[0]),
			body.substring(trimPoint[0], trimPoint[1]),
			body.substring(trimPoint[1])
		];
		var rb = trimStr[1];
		if(userFont.length){
			var re = new RegExp(splitStr[0], "g");
			var ufNum = [];
			for(var i in trimStr){
				ufNum.push((trimStr[i].match(re)||[]).length);
			}
			for(var i=ufNum[0],len=ufNum[0]+ufNum[1]; i<len; i++){
				rb = rb.replace(splitStr[0], userFont[i]);
			}
		}
		if(trimPoint[0] > 0) rb = conm + rb;
		if(body.length > trimPoint[1]) rb = rb + conm;
		return rb;
		
		
	}
	
	//ページナビ作成
	function pagenavi(result){//**************************************
		var len = result.length;
		var ct = Math.ceil(len/max);
		var buf = [];
		for(var i=1; i<=ct; i++){
			buf[buf.length]='<span page="'+i+'">'+i+'</span>';
		}
		nv.innerHTML = buf.join("");
		sw(page);
	}
	
	//ページナビの現表示ページにクラス追加
	function sw(t){//**************************************
		var span = nv.getElementsByTagName("span");
		for(var i=0,len=span.length; i<len; i++){
			span[i].className = (i==t-1)?"selected":"";
		}
	}
	
	//検索結果を表示
	function view(result,page){//**************************************
		offset = page || 1;
		if(!result){
			result = this.last;
		}else{
			this.last = result;
		}
		var r = result;
		var buf = [];
		var count = 0;
		
		
		var fi = (offset-1)*max;
		for(var i=fi,len1=r.length; i<len1; i++){
			count++;
			if(count > max){break}
			var num = r[i];
			var da = data[num];
			var v = '';
			v = snippet(da.Body, bolderlist);
			v = boldkeyword(v, bolderlist);
			v = v.replace(/(@@@)((\d@)+)(@@)/gm, '#####<span class="kmsymbol"><img src="./img/userfonts/$2.png" alt="" /></span>#####').split('#####');
			for(vs=0,len2=v.length; vs<len2; vs++){
				if(v[vs].match(/^<span class="kmsymbol"><img [^>]+?><\/span>$/)){
					v[vs] = v[vs].replace(/@/gm, '');
				}
			}
			v=v.join('');
			var p= da.Path.split('> ');
			p.shift();p.shift();
			var pt=[];
			for(var j in p){
				if(j==0){
					pt.push('<span class="ctm">' + p[j] + ' </span>');
				}else{
					pt.push('<span>' + p[j] + ' </span>');
				}
			}
			var fil = [];
			if(charUpLo) fil.push('ul=1');
			if(zenHan) fil.push('zh=1');
			fil = (fil.length) ? "&" + fil.join('&'):'';
			hrefURI = da.File.replace(/\.html/, '$&' + "?k=" + encodeURIComponent(getKey) + fil);
			buf.push(
				'<div class="item">'
				,'<h3><a href="', hrefURI ,'">', boldkeyword(da.Title, bolderlist) || textData.searchUnknoun ,'</a></h3>'
				,'<div>', v ,'</div>'
				,'<div class="path">', pt.join("") ,'</div></div>'
			);
		}
		
		if(releatekey.length){
			var rurl = location.href;
			$('#relatedWords').remove();
			$('#sCount').after('<div id="relatedWords"><h4>'+ textData.searchRelatedHeader +'</h4></div>');
			for(var i=0,len=releatekey.length; i<len; i++){
				relatedUrl = location.href.replace(/(k\=)([^&]+)(\&|$)/, '$1' + releatekey[i] + '$3').replace(/(\&p=)([0-9]+)(\&|$)/,'');
				$('#relatedWords').append('<span class="relatedKey"><a href="' + relatedUrl + '">' + releatekey[i] + '</a></span>');
			}
		}
		
		
		var cost = Math.min(fi+1, result.length);
		var coen = Math.min(fi+max, result.length);
		
		var end = new Date().getTime();
		searchTime = (end-start) / 1000;
		
		var srCount = '';
		if(srCountType==1){
			srCount = textData.searchCounts1 +'<span id="counts">' + result.length + '</span> '+ textData.searchCounts1_2 +' [ '+ cost +'-'+ coen +' / '+ result.length + textData.searchCounts2+' ]  (' + searchTime + ' '+textData.searchCounts3+')';
		}else{
			srCount = '<span id="counts">' + result.length + '</span> '+ textData.searchCounts1 +' [ '+ cost +'-'+ coen +' / '+ result.length + textData.searchCounts2+' ]  (' + searchTime + ' '+textData.searchCounts3+')';
		}
		st.innerHTML = (result.length==1)? srCount.replace('items', 'item') : srCount ;
		re.innerHTML = buf.join("");
		$('html,body').scrollTop(0);
	}
	
	//キーワードの強調処理
	function boldkeyword(body, boldregs){//**************************************
		var result = body, conms = ['',''], splitStr, inUF = false;
		var ufRe = new RegExp(ufPattern.source, "g");
		
		if(new RegExp('^' + conm).test(result)){
			conms[0] = conm;
		}
		if(new RegExp(conm + '$').test(result)){
			conms[1] = conm;
		}
		result = result.replace(new RegExp(conm,"g"), '');
		
		var temp = body.match(new RegExp('('+ splitStrBase + ')', "g"));
		if(temp){
			temp = new RegExp('(' + temp.join('|') + ')', "g");
			splitStr = splitStrBase.replace(/\|/, '').replace(temp, '').split('|');
		}else{
			splitStr = splitStrBase.split('|');
		}
		
		if(ufRe.test(result)){
			inUF = true;
			result = result.split('@@@');
		}else{
			result=[result];
		}
		
		strreg = "";
		for(i=0,len=boldregs.length; i<len; i++){
			tmpreg = boldregs[i].source;
			tmpreg = tmpreg.substring(1,tmpreg.length-1);
			strreg = strreg + tmpreg + "|";
		}
		strreg = "(" + strreg.substring(0,strreg.length-1) + ")";
		strreg = strreg.replace(/</g, splitStr[0]).replace(/>/g, splitStr[1]);
		
		var reLtGt = [new RegExp(splitStr[0], 'g'), new RegExp(splitStr[1], 'g')];
		
		var reFlag = (!charUpLo) ? "igm":'gm';
		boldreg = new RegExp(strreg, reFlag);
		for(var i=0,len=result.length; i<len; i++){
			if(!/^(\d|\d(@\d)+)$/.test(result[i])){
				result[i] = result[i].replace(/</g, splitStr[0]).replace(/>/g, splitStr[1]);
				result[i] = result[i].replace(boldreg, '<span class="hitkey">$1</span>');
				result[i] = result[i].replace(reLtGt[0], '&lt;').replace(reLtGt[1], '&gt;');
			}
		}
		result = (inUF)? result.join('@@@') : result[0] ;
		result = conms[0] + result + conms[1];
		return result;
	}
	
	
	
	//////////////////////////////
	var getKey = (get['k']) ? get['k'].replace(/[\s　]+/g," ") : '';
	if(getKey){
		$("#searchKey2").val(getKey).addClass("keyIn");
		$("#searchKey").val(getKey).addClass("keyIn");
		do_find(getKey);//検索命令！
		
		for(var i in get){
			if(get[i]){
				if(i == 'k'){
					loadFilData[i] = encodeURIComponent(get[i]);
				}else{
					loadFilData[i] = get[i];
				}
			}
		}
	}
	///////////////////////////////

});

