/**********************************************
検索結果画面に関連したscript
**********************************************/

var checklistId;
var checklistTogglerId;

var delayOnResize = (function () {
    var timer = 0;
    return function (callback, ms) {
        clearTimeout(timer);
        timer = setTimeout(callback, ms);
    }
})();

resizeOnWindowWidth = function () {
    var w = window.innerWidth ? window.innerWidth : $(window).width();

    if (w < 769) {
        //モバイル表示
        $('#search-sidebar').hide(function () {
            $('#search-mobile-menu').css("display", "inline-block");
            $('#search-result-content').removeClass('active');
            $('#tocBody').removeClass('active');
        });

        $('#search-mobile-menu').show();

        if ($('div.search-menu-m-choices').css('display') == 'none') {
            // タイトルで絞るを非表示状態
            $('main#searchResult').css('overflow-y', 'initial');
            $('div.results').css('display', 'block');
            $('div.navi').css('display', 'block');
            $('div.back-to-menu').css('display', 'none');
            if ($('div#search-mobile-title').hasClass('open')) {
                // 絞り込み検索条件部を開く
                $('div.search-menu-m-body').css('display', 'block');
            } else {
                // 絞り込み検索条件部を閉じる
                $('div.search-menu-m-body').css('display', 'none');
            }
            $('div#search-mobile-menu').css('display', 'inline-block');
            $('div.search-menu-m-choices').css('display', 'none');
            $('div#title-body-wrapper').css('display', 'block');
            $('div.addConfirm').css('display', 'none');
        } else {
            // タイトルで絞るを表示状態
            $('main#searchResult').css('overflow-y', 'hidden');
            $('div.results').css('display', 'none');
            $('div.navi').css('display', 'none');
            $('div.back-to-menu').css('display', 'block');
            $('div.search-menu-m-body').css('display', 'block');
            $('div#search-mobile-menu').css('display', 'inline-block');
            $('div.search-menu-m-choices').css('display', 'block');
            $('div#title-body-wrapper').css('display', 'none');
            $('div.addConfirm').css('display', 'block');
        }
    } else if (w >= 769) {
        //PC表示
        $('#search-mobile-menu').hide(function () {
            $('#search-mobile-menu').css("display", "none");
            $('#search-result-content').addClass('active');
            $('#tocBody').addClass('active');
        });

        $('#search-sidebar').show();

        // モバイルサイズ→PCサイズへリサイズ時、
        // 検索結果を表示化
        $('main#searchResult').css('overflow-y', 'initial');
        $('div.results').css('display', 'block');
        $('div.navi').css('display', 'block');
        // モバイルサイズの絞り込み条件画面の専用要素の設定解除
        $('div.back-to-menu').css('display', 'none');
        $('div.addConfirm').css('display', 'none');
    }
}

//画面更新時に検索オプション部をPC用、Mobile用に切替
$(window).on('load', resizeOnWindowWidth());

//リサイズ時に検索オプション部をPC用、Mobile用に切替
$(window).on('resize', function () {
    delayOnResize(function () {
        resizeOnWindowWidth();
    }, 100);
});

/**********************************************
モバイルで検索に関連したscript
**********************************************/

//「絞り込み検索」箇所クリック時の処理
$("#contents-box").on("click", "#search-mobile-title", function (e) {
    $("#search-mobile-body").slideToggle();

    if ($(".search-menu-m-title").hasClass('open')) {
        $(".search-menu-m-title").removeClass('open').addClass('close');
    } else if ($(".search-menu-m-title").hasClass('close')) {
        $(".search-menu-m-title").removeClass('close').addClass('open');
    }

    e.preventDefault();
});

//「タイトルで絞る」箇所をクリックした場合の処理
$("#contents-box").on("click", "#search-menu-mobile-contents > li > span[class='mobiletoggle']", function (e) {
    if ($(this).parent('li').hasClass("search-title-filter-m")) {
        $('#confirm-title').removeClass("search-value-selected");

        $('#searchCt2 label').each(function () {
            if ($(this).hasClass('search-value-selected')) {
                $(this).children('input').prop('checked', true);
                $(this).addClass('search-chk-color');
            } else {
                $(this).children('input').prop('checked', false);
                $(this).removeClass('search-chk-color');
            }
        });
    }

    // 検索結果を非表示化
    $('main#searchResult').css('overflow-y', 'hidden');
    $('div.results').css('display', 'none');
    $('div.navi').css('display', 'none');
    // 絞り込み条件画面の専用要素の設定
    $('div.back-to-menu').css('display', 'block');
    $('div.full-width').css('flex', '1');
    $('div.full-width').css('overflow-y', 'scroll');
    $('div.addConfirm').css('display', 'block');

    if ($(this).children('a').hasClass('has-children-m-option')) {
        checklistTogglerId = "#" + $(this).children('a.has-children-m-option').attr("id");
        checklistId = getChecklistIdByTogglerId($(this).children('a.has-children-m-option').attr("id"));
    } else {
        checklistTogglerId = "#" + $(this).children('a.has-children-m').attr("id");
        checklistId = getChecklistIdByTogglerId($(this).children('a.has-children-m').attr("id"));
    }

    $('#title-body-wrapper').animate({ width: 'toggle' }, 100);

    $(checklistId).animate({ width: 'toggle' }, 100);
});

//子項目遷移後に親選択に戻る際の処理
$("#contents-box").on("click", "#search-return-btn", function (e) {
    $('#title-body-wrapper').animate({ width: 'toggle' }, 100);
    $(checklistId).animate({ width: 'toggle' }, 100);

    // 検索結果を表示化
    $('main#searchResult').css('overflow-y', 'initial');
    $('div.results').css('display', 'block');
    $('div.navi').css('display', 'block');
    // 絞り込み条件画面の専用要素の設定解除
    $('div.back-to-menu').css('display', 'none');
    $('div.full-width').css('flex', '0');
    $('div.full-width').css('overflow-y', 'initial');
    $('div.addConfirm').css('display', 'none');
});

//ID値を取得
function getChecklistIdByTogglerId(togglerID) {
    return "#" + togglerID.substr(0, togglerID.search("-toggler"));
}

//「条件を追加」ボタンクリック時の処理
$("#contents-box").on("click", ".confirm-choice-btn", function () {

    //チェックがついているチェックボックスにsearch-value-selectedクラスを付与
    //PC側を初期化
    $("#searchCt .initial").removeClass("initial");
    $("#searchCt .search-check-selected").removeClass("search-check-selected");
    $("#searchCt .search-chk-color").removeClass("search-chk-color");
    $("#title-modal-menu").removeClass("search-value-selected");

    $('#searchCt2 input').each(function () {
        if ($(this).prop('checked')) {
            $(this).addClass("initial");
            $(this).parent().addClass("search-value-selected");

            //PC側に反映
            var valueAttrVal = $(this).attr("value");
            //inputにinitialクラスを付与
            $('#searchCt input[value="' + valueAttrVal + '"]').addClass("initial");
            //inputの親のlabel要素にsearch-value-selectedとsearch-chk-colorクラスを付与
            $('#searchCt input[value="' + valueAttrVal + '"]').parent().addClass("search-check-selected");
            $('#searchCt input[value="' + valueAttrVal + '"]').parent().addClass("search-chk-color");
        } else {
            $(this).removeClass("initial");
            $(this).parent().removeClass("search-value-selected");
        }
    });

    // 検索結果を表示化
    $('main#searchResult').css('overflow-y', 'initial');
    $('div.results').css('display', 'block');
    $('div.navi').css('display', 'block');
    // 絞り込み条件画面の専用要素の設定解除
    $('div.back-to-menu').css('display', 'none');
    $('div.full-width').css('flex', '0');
    $('div.full-width').css('overflow-y', 'initial');
    $('div.addConfirm').css('display', 'none');

    if ($(checklistId).find("input[type=checkbox]:checked").length > 0) {
        $(checklistTogglerId).addClass("search-value-selected");
        $(checklistId).hide('slide', { direction: 'right' }, 300);
        $('#title-body-wrapper').show('slide', { direction: 'left' }, 300);
    } else {
        $(checklistTogglerId).removeClass("search-value-selected");
        $(checklistId).hide('slide', { direction: 'right' }, 300);
        $('#title-body-wrapper').show('slide', { direction: 'left' }, 300);
    }

    //「条件を追加」ボタン押下後、いずれかの項目にチェックが付いている場合は、すべてクリア、
    //検索ボタンの色を変更。
    //タイトルで絞る内の項目のみで合った場合はすべてクリアのみ色を変更。
    var chk_count_title = $('#searchCt2 :checked').length;
    var textbox_text = $('#searchKey2').val();

    if (textbox_text == "" && chk_count_title == 0) {
        $("#all-clear-button2").removeClass("search-value-selected");
        $(".search-button").removeClass("search-value-selected");

        //PC連動
        $('#all-clear-button').removeClass("search-value-selected");
        $('#searchSubmit').removeClass("search-value-selected");
        $('#title-modal-menu').removeClass("search-value-selected");
    }
    else if (textbox_text == "" && chk_count_title) {
        $("#all-clear-button2").addClass("search-value-selected");
        $(".search-button").removeClass("search-value-selected");

        //PC連動
        $('#all-clear-button').addClass("search-value-selected");
        $('#searchSubmit').removeClass("search-value-selected");
        $('#title-modal-menu').addClass("search-value-selected");
    } else {
        $("#all-clear-button2").addClass("search-value-selected");
        $(".search-button").addClass("search-value-selected");

        //PC連動
        $('#all-clear-button').addClass("search-value-selected");
        $('#searchSubmit').addClass("search-value-selected");
        if (chk_count_title) {
            $('#title-modal-menu').addClass("search-value-selected");
        } else {
            $('#title-modal-menu').removeClass("search-value-selected");
        }
    }

    //「条件を追加」ボタン押下後、「絞り込み検索」の位置へスクロールする
    scrollTo(0, $('#search-mobile-title').offset().top - $('.list-area').height() - 10);
});

//チェックボックス項目クリック時の処理
$("#contents-box").delegate(".search-menu-m-choices-inner li.choice", "click", function () {
    if ($(this).children("input[type='checkbox']").is(':checked')) {
        $(this).children("input[type='checkbox']").prop('checked', false);
    } else {
        $(this).children("input[type='checkbox']").prop('checked', true);
    }

    if ($(this).parent().find("input[type='checkbox']:checked").length > 0) {
        $(this).parent().siblings("a").addClass("search-value-selected");
    } else {
        $(this).parent().siblings("a").removeClass("search-value-selected");
    }
});

//チェックボックス自体をクリックした時の処理
$("#contents-box").delegate(".search-menu-m-choices-inner li.choice > input[type='checkbox']", "click", function (e) {
    toggleHighlightOnChecked("#" + $(this).parent().parent().prev("a").attr("id"));
    e.stopPropagation();
});

/**********************************************
検索処理関連
**********************************************/
$(function () {
    //初期設定
    func._init();

    if (conf.sData.k) {
        //検索実行
        func._search();

        //関連キーワード配列作成（あいまい）
        func._createReleateArr();

        //検索結果を表示
        func._view();
    }
});

//検索結果の保存用オブジェクト
var results = {};

//設定
var setting = {
    "itemByPage": 10,   //1ページあたりの結果数
    "clampFrontPoint": 30,  //ヒットキーワードの前何文字表示
    "clampDescLength": 150, //1項目の説明全体の表示文字数（PC表示用）
    "clampDescLengthForMobile": 100,    //1項目の説明全体の表示文字数（モバイル表示用）
    "searchType": 'and',    //検索タイプ
    "count_elm": "#searchResult > .sCount", //カウント表示要素
    "results_elm": "#searchResult > .results",  //結果表示要素
    "navi_elm": "#searchResult > .navi",    //ページネーション表示要素
    "ufPattern": /%#symbol-([^#]+?)#%/, //ユーザーフォントパターン
    "highlightTag": "mark", //検索キーワードをハイライトするためのタグ
    "highlightClass": "",   //ハイライトタグにつけるクラス
    "score": {
        "title": 10000, //タイトルにヒット
        "title_indexPoint": -1, //タイトルの何文字目かで減点する。1文字あたりの減点
        "text": 1000,   //説明にヒット
        "text_indexPoint": -1,  //説明の何文字目かで減点する。１文字あたりの減点
        "dePointMax": -1000,    //減点の最大値
        "add_point": 1000,  //カテゴリー加算点数
        "add_pointCT": ["FAQ", "QA", "TS"]  //加算カテゴリー（ブック識別子）
    }
};

//設定（システム用）
var conf = {
    "keywordData": keyword_data,    //関連ワードの変数
    "index": search_index,  //インデックスの変数
    "runStart": new Date().getTime(),   //検索動作開始を記録
    "thisFullPath": (window.location.origin + window.location.pathname).replace(/\\/g, "/"),    //URIパス
    "isWebStorage": false,  //WebStorageが使用可能かを判定
    "debug": {
        "runtime": false,   //経過時間表示（true:表示、false:非表示）
        "scoreDisplay": false   //スコアの表示（true:表示、false:非表示）
    },
    "isUD": typeof setting_ud !== 'undefined' ? true : false    // HTMLのタイプ（true:UD版、false：通常版）
};

//WebStorageが使用可能かを判定
try {
    conf.isWebStorage = ('sessionStorage' in window) && (window.sessionStorage !== undefined) && (window.sessionStorage !== null);
} catch (e) {
    conf.isWebStorage = false;
}

var getData = func._getGetData();