/**********************************************
各ブックのcontents内のscript
**********************************************/
var mainContentsFunc = {
    /**
     * メイン画面のイベントを設定
     */
    "setMaincontentsEvent": function () {
        //メイン領域の印刷アイコンクリックでメイン領域の印刷用ダイアログを起動する
        $('#mainarea_print').click(function () {
            window.print();
        });
    },
    /*
     * 検索結果からページへ遷移したときキーをハイライト
     */
    "searchKeyHighlight": function () {
        if (_get['k'] && $('body')) {
            var getKeywordArr = function (inputWord) {
                var splitStrBase = '㌀|㌞|㍇|㍧|㍨|㍩|㍪|㍫|㍬|㍭|㍮|㍯|㍰';
                var sep = splitStrBase.split('|');
                var temp = inputWord.match(new RegExp('(' + splitStrBase + ')', "g"));
                if (temp) {
                    temp = new RegExp('(' + temp.join('|') + ')', "g");
                    sep = splitStrBase.replace(/\|/, '').replace(temp, '').split('|');
                }
                var phraseArr = [];
                var temp = inputWord;

                temp = temp.replace(/"([^"]+)"/g, function (a, $1) {
                    phraseArr.push($1);
                    return sep[0];
                });

                var arr = temp.split(/[\s　]+/);

                $.each(arr, function (i, val) {
                    if (val == void (0)) arr.splice(i, 1);
                    if (val == sep[0]) {
                        arr[i] = phraseArr.shift();
                    }
                });

                return arr;
            };

            var keyword = getKeywordArr(_get['k']);
            for (var i in keyword) {
                if (keyword[i]) {
                    if (_uri.fileName != "search") {
                        $('main').keyHighlight(keyword[i]);
                    }
                }
            }
        }
    },

    /**
     * 全video要素へ字幕情報を追加する
     * 引数filename：メインページ内の動画を対象とする場合は不要。
     * リンクモーダル内の動画を対象とする場合、リンクモーダルへ表示対象するHTMLファイル名を指定する。
     */
    "prepareVideoTrack": function (filename) {
        if (typeof filename == 'undefined') filename = '';
        var selector;
        if (filename == '') {
            // ページ内の各video要素
            selector = 'video';
        } else {
            // data-tabContents属性値が引数filenameであるdiv（これから開くリンクモーダル）内の各video要素
            // ひとつのvideo要素に複数回字幕設定をしない様に、 開くタブ内だけを対象とする
            selector = 'div[data-tabContents="' + filename + '"]' + ' video';
        }

        // <html>のlang属性値をもとに、字幕言語を指定する
        var langAttr = $('html').attr('lang');
        var trackLang = '';
        if (langAttr == 'JA') {
            trackLang = 'ja-JP';
        } else if (langAttr == 'EN') {
            trackLang = 'en-GB';
        } else if (langAttr == 'CN') {
            trackLang = 'zh-CN';
        } else if (langAttr == 'TW') {
            trackLang = 'zh-TW';
        } else if (langAttr == 'KO') {
            trackLang = 'ko-KR';
        } else if (langAttr == 'FR') {
            trackLang = 'fr-FR';
        } else if (langAttr == 'IT') {
            trackLang = 'it-IT';
        } else if (langAttr == 'DE') {
            trackLang = 'de-DE';
        } else if (langAttr == 'ES') {
            trackLang = 'es-ES';
        }

        $(selector).each(function (index, videoElement) {
            // Video要素へTextTrackを追加
            var textTrack = videoElement.addTextTrack('subtitles', 'title', $(trackLang));
            textTrack.mode = 'showing';

            // trackContents.jsから字幕を取得する
            var videoNo = $(videoElement).attr('data-video_no');
            var trackContent = trackContents[videoNo];
            // 字幕情報を取得できた場合、各video要素へ字幕情報を設定する
            if (trackContent) {
                var trackKey = Object.keys(trackContent);
                try {
                    // Chrome, Firefox, Safari
                    for (i = 0; i < trackKey.length; i++) {
                        var track = trackContent[trackKey[i]];
                        var vttCue = new VTTCue(changeTimeFormat(track.starttime), changeTimeFormat(track.endtime), track.text);
                        textTrack.addCue(vttCue);
                    }
                } catch (e) {
                    // IE, Edge
                    for (i = 0; i < trackKey.length; i++) {
                        var track = trackContent[trackKey[i]];
                        var textTrackCue = new TextTrackCue(changeTimeFormat(track.starttime), changeTimeFormat(track.endtime), track.text);
                        textTrack.addCue(textTrackCue);
                    }
                }
            }
        });

        // XMLのTrack要素のBegin・End属性値の時刻指定形式（mm: ss）を
        // VTTCueやTextTrackCueの時刻指定形式（double）へ変更する
        function changeTimeFormat(trackTime) {
            var trackTimes = trackTime.split(":");
            var textTrackTime = trackTimes[0] * 60 + trackTimes[1];
            return textTrackTime;
        }
    },

    /**
     * Vimeoのデフォルト字幕言語を設定する
     * 引数filename：メインページ内の動画を対象とする場合は不要。
     * リンクモーダル内の動画を対象とする場合、リンクモーダルへ表示対象するHTMLファイル名を指定する。
     */
    "setVimeoTextTrackLanguage": function (filename) {
        // 動画形式がvimeo以外の場合は何もしない
        if ($('body').data("videotype") != 'vimeo') return;

        if (typeof filename == 'undefined') filename = '';
        // <html>のlang属性値をもとに、Vimeoの字幕言語を指定する
        var vimeoLangs = new Map();
        vimeoLangs.set('JA', 'ja');
        vimeoLangs.set('EN', 'en');
        vimeoLangs.set('CN', 'zh-Hans');
        vimeoLangs.set('TW', 'zh-Hant');
        vimeoLangs.set('KO', 'ko');
        vimeoLangs.set('FR', 'fr');
        vimeoLangs.set('IT', 'it');
        vimeoLangs.set('DE', 'de');
        vimeoLangs.set('ES', 'es');
        var vimeoLang = vimeoLangs.get($('html').attr('lang'));

        var selector;
        if (filename == '') {
            // ページ内の各iframe要素
            selector = 'div.iframe_div>iframe';
        } else {
            // data-tabContents属性値が引数filenameであるdiv（これから開くリンクモーダル）内の各iframe要素
            // メインページの字幕言語を変更してしまわない様に、 開くタブ内だけを対象とする
            selector = 'div[data-tabContents="' + filename + '"]' + ' div.iframe_div>iframe';
        }
        // ページ内の各iframe要素に対して字幕言語の指定をする
        $(selector).each(function (index, iframeElement) {
            var player = new Vimeo.Player(iframeElement);
            player.enableTextTrack(vimeoLang).catch(function () {
                // 指定した言語の字幕が無かったなど、字幕言語指定に失敗した場合、字幕なしをデフォルトとする（ユーザによる手動切替可）
                player.disableTextTrack().catch(function () { });
            });
        });
    },

    /**
     * ヘッダー・目次関連の表示・非表示設定
     */
    "setHeaderEvent": function () {
        var scrollStopEvent = $.Event("scrollstop");
        var delay = 400;
        var timer;

        function scrollStopEventTrigger() {
            if (timer) {
                clearTimeout(timer);
            }

            timer = setTimeout(function () { $(window).trigger(scrollStopEvent) }, delay);
        }

        $(window).on("scroll touchmove", function () {
            var w = window.innerWidth ? window.innerWidth : $(window).width();
            if (w < 769) {
                if ($(".refine-search-area").css("display") === "none") {
                    var currentPoint = $(window).scrollTop();

                    if (currentPoint !== 0) {
                        $("#search").stop();

                        $("#search").css("display", "none").delay(100).fadeIn('fast');

                        scrollStopEventTrigger();
                    }
                }
            }
        });
    },

    /**
    *	アンケートフォームを生成
    */
    "addQuestionaryForm": function () {
        var template = '<div class="questionnaire-area"><div class="questionnaire-form">'
            + '<p>' + textData.questionnaire_text + '</p>'
            + '<form><div><label><input id="answer3" type="radio" name="questionnaire-answer" value="3" /><p>'
            + textData.questionnaire_answer1 + '</p></label></div>'
            + '<div><label><input id="answer2" type="radio" name="questionnaire-answer" value="2" /><p>'
            + textData.questionnaire_answer2 + '</p></label></div>'
            + '<div><label><input id="answer1" type="radio" name="questionnaire-answer" value="1" /><p>'
            + textData.questionnaire_answer3 + '</p></label></div>'
            + '<div><textarea name="questionnaire-comment" rows="3" placeholder="' + textData.questionnaire_comment + '"></textarea></div>'
            + '<div><button type="button" disabled>' + textData.questionnaire_submit + '</button></div>'
            + '</form></div>'
            + '<div class="questionnaire-result" hidden>'
            + '<p>' + textData.questionnaire_result + '</p>'
            + '<p id="focusSearchKey"><a>' + textData.questionnaire_search + '</a></p>'
            + '</div></div>';

        if (_uri.file !== "index.html" && _uri.file !== "search.html") {
            $('main').append(template);
        }
    },
    /**
    *	アンケートイベント設定
    **/
    "addQuestionaryEvent": function () {

        //フォーム内変更時のイベント
        $('.questionnaire-form form').on('change', function () {
            var value = $("input[name='questionnaire-answer']:checked").val();
            if (value) {
                $('.questionnaire-form button').prop('disabled', false);
            }
        });

        //送信ボタンクリック時のイベント
        $('.questionnaire-form button').on('click', function () {
            $('.questionnaire-form').hide();
            $('.questionnaire-result').show();

            //Androidの場合、検索誘導ボタンクリック時に挙動がおかしくなる為、
            //scroll位置を1px上に戻している。(#404対応）
            var ua = navigator.userAgent;

            if (ua.indexOf("Android") > 0) {
                var scrollPos = $(window).scrollTop();
                scrollPos--;
                $(window).scrollTop(scrollPos);
            }

            //アンケートフォーム選択ラジオボタン文字列取得
            var selectRadioText = $("input[name='questionnaire-answer']:checked").parent('label').text();
            if (!selectRadioText) {
                selectRadioText = "(not set)";
            }

            //パンくずリスト取得
            var url = window.location;
            var path = url.href.split('/');
            var file_name = path.pop();
            var addPageObj = cmn.contents[file_name];
            var breadArray = addPageObj.topic_path;
            var breadcrumbText = breadArray.join(' > ');

            breadcrumbText = breadcrumbText.replace(/&quot;/g, "\"");
            breadcrumbText = breadcrumbText.replace(/&#39;/g, "'");
            breadcrumbText = breadcrumbText.replace(/&amp;/g, "&");
            breadcrumbText = breadcrumbText.replace(/&lt;/g, "<");
            breadcrumbText = breadcrumbText.replace(/&gt;/g, ">");

            //Symbolを実体文字に変換
            breadcrumbText = convertSymbolFont(breadcrumbText);

            //#466 &文字は送信不可のためURLエンコード
            breadcrumbText = breadcrumbText.replace(/\&/g, "%26");

            //コメントテキスト取得
            var commentText = $("textarea[name='questionnaire-comment']").val();

            //送信
            gtag('event', 'questionnaire', { 'breadcrumbs': breadcrumbText, 'choice': selectRadioText, 'comment': commentText, 'value': 1 });
        });

        //回答後に表示される項目内のリンククリック時のイベント
        $('#focusSearchKey a').on('click', function () {
            $('#searchForm .search-refine-box').click();
            $('#searchKey').focus();
        });

        //コメント入力テキストエリア変更時のイベント
        $('.questionnaire-form textarea').on('keyup', function () {
            var value = $("input[name='questionnaire-answer']:checked").val();
            if (!value) {
                var textData = String($("textarea[name='questionnaire-comment']").val());
                if (textData === "") {
                    $('.questionnaire-form button').prop('disabled', true);
                } else {
                    $('.questionnaire-form button').prop('disabled', false);
                }
            }
        });
    }
};

var linkModalFunc = {
    //モーダルのタブ幅
    "setModalTabWidth": function () {
        var tabs = $("#pageModal .modal > .header .tabs");
        var tab = tabs.children('.tab');
        var tabLen = tab.length;
        var tabsW = tabs.width();
        tab.width(function () {
            var w = Math.floor(tabsW / tabLen);
            return w;
        });
    }
    /*
     * モーダル機能
     */
    , "initialize": function () {
        //イベントセット
        (function () {
            // メインページ自身のcontents.jsを読み込む

            // 読み込み対象contents.jsファイル名
            var loadFileNames = ["contents_" + _uri.fileName + ".js", "contentsHtml_" + _uri.fileName + ".js"];
            

            // contents.jsを読み込むための<scrip>を追加する
            if (_uri.fileName != "index" && _uri.fileName != "search") {
                for (var i = 0; i < loadFileNames.length; i++){
                    var script = document.createElement('script');
                    script.type = 'text/javascript';
                    script.src = "./src/js/contents/" + loadFileNames[i];
                    document.body.appendChild(script);
                }
            }
        }());

        var tabCountMax = 14;

        // ブックマーク
        var bookmarkFunc = topicFunc.bookmarkFunc();

        //タブ追加
        var addTab = function (e) {
            var target = $(e.target).closest('a');
            var uri = target.attr('href');
            if (uri) {
                uri = uri.split('#');
                var addPageData = {
                    "html": uri[0].replace(/([^\/\\]+)\.html?.*$/i, "$1"),
                    "hash": uri[1]
                };
                modalOpen(addPageData);
            }
        };

        //モーダル閉じ
        var scrollTop;
        var modalClose = function () {
            $('#pageModal, .overlay.modal').removeClass('in');
            setTimeout(function () {
                $('#pageModal, .overlay.modal').remove();
                $('body').removeClass('openModal');
                $('#wrapper').removeAttr('style');
                $(window).scrollTop(scrollTop);

                // リンクモーダルを閉じる時、ブックマーク登録状況に応じてメインページの☆マーク表示を切り替える
                bookmarkFunc.initializeIcon(_uri.file);
            }, 300);
        };

        //スクロール位置セット
        var scrollPos = function (id, firstOpen) {
            var targetTabContents = $('#pageModal .modalContents .tabContents.active');
            if (targetTabContents.is('.thisPageContents')) {
                id += '_modal';
            }
            var ta = $(id);
            if (!ta.length) return;
            var spos = targetTabContents.scrollTop();
            if (firstOpen) {
                setTimeout(function () {
                    targetTabContents.scrollTop(spos + ta.position().top);
                }, 400);
            } else {
                targetTabContents.scrollTop(spos + ta.position().top);

            }
        };


        //モーダル表示
        var modalOpen = function (addPageData) {
            var firstOpen = false;
            var addPage = addPageData.html;
            var hash = addPageData.hash;

            // 非実機用HTMLの場合のみ、印刷ボタンを表示する
            var printButton = $('html').data("for-printer") ? '' : '<button class="nowprint" title="' + textData.print_j + '"></button>';

            //　以下のいずれかの条件に合致する場合、「☆」を非表示にする
            //　・file://かつFirefox
            //  ・リンクモーダルの表示元HTMLが最新情報冊（ファイル名がAI_で始まる）
            //    (最新情報冊と機種情報HTMLの相互リンクはない。最新情報冊にあるリンクは、最新情報冊内のリンク。リンク元のタブ、リンク先のタブ、両方とも☆非表示。)
            var bookmarkButton = '<a class="contents-button-bookmark_gray" id="modalarea_star" title="' + textData.addBookmark + '"></a>';
            if (!cmn.isWebBrowsing() && _ua._isFirefox || _uri.fileName.startsWith("AI_")) {
                bookmarkButton = '';
            }

            var headUti = '<div id="headUti">'
                + '<button class="newPage"><span>' + textData.open_new + '</span></button>'
                + printButton
                + bookmarkButton
                + '</div>';

            // %#symbol-0000#%を<span class="span-symbol">0000の実体文字</span>へ置換する
            var convertToSymbolFormat = function (title) {
                if (title.indexOf('%#symbol-')) {
                    title = title.replace(/%#symbol-([^#]+?)#%/g, function (all, group1) {
                        return '<span class="span-symbol">' + String.fromCharCode('0x' + group1) + '</span>';
                    });
                }
                return title;
            }
            // contentsHtml.js内の仮文字をHTML表示可能なエンティティへ置換する
            var convertToSpecialChar = function (contents) {
                contents = contents.replace(/%#AMPERSAND#%/g, "&amp;");
                contents = contents.replace(/%#REVERSE-SOLIDUS#%/g, "&#92;");
                contents = contents.replace(/%#APOSTROPHE#%/g, "&#39;");
                contents = contents.replace(/%#QUOTATION-MARK#%/g, "&quot;");
                contents = contents.replace(/%#LESS-THAN-SIGN#%/g, "&lt;");
                contents = contents.replace(/%#GREATER-THAN-SIGN#%/g, "&gt;");
                return contents;
            };
            // %#symbol-0000#%を削除する
            var deleteSymbol = function (title) {
                if (title.indexOf('%#symbol-')) {
                    title = title.replace(/%#symbol-([^#]+?)#%/g, "");
                }
                return title;
            };

            //モーダル初期作成===============================================================
            if (!$('body').children().is('#pageModal')) {
                // contents.jsのtitle内に%#symbol-0000#%がある場合
                // リンクモーダルのタブに表示するときはKM - Symbolフォントを適用する
                // リンクモーダルのタブのツールチップにはフォント指定できないためsymbolの文字を表示しない
                var title = cmn.contents[_uri.file].title;
                var template = '<div id="pageModal"><div class="modal">'
                    + '<span class="close"></span>'
                    + '<div class="header"><div class="tabs">'
                    + '<span class="tab" data-tab="' + _uri.fileName + '" title="' + deleteSymbol(title) + '"><span>' + convertToSymbolFormat(title) + '</span></span>'
                    + '</div></div>'
                    + '<div class="modalContents"></div>'
                    + '</div></div><div class="overlay modal"></div>';

                firstOpen = true;
                scrollTop = $(window).scrollTop();
                $('body').addClass('openModal').append(template);
                $('#wrapper').css('top', (-scrollTop) + 'px');
                setTimeout(function () {
                    $('#pageModal, .overlay.modal').addClass('in');
                }, 0);

                //Set thisPage
                var thisPage = $('<div>' + convertToSpecialChar(cmn.contentsHtml[_uri.file].contents) + '</div>');
                thisPage.find('.Subsection-menu a[href^="#"]').each(function (i, e) {
                    var h = $(e).attr('href');
                    // スタイルシートでの変換時、ページトップの目次リンクに空の要素（<a href="#"></a>）が出力されている
                    // その箇所を飛ばすためにif(h != "#")を追加している
                    if (h != "#") thisPage.find(h).attr('id', thisPage.find(h).attr('id') + '_modal');
                });

                $('#pageModal .modalContents').append('<div class="tabContents thisPageContents" data-tabContents="' + _uri.fileName + '">'
                    + headUti
                    + '<div class="page">' + thisPage.html() + '</div>'
                    + '</div>');

                // 作成中のリンクモーダルタブ内のvideo要素へ字幕情報を追加する
                mainContentsFunc.prepareVideoTrack(_uri.fileName);

                // 作成中のリンクモーダルタブ内のvideo要素へVimeoのデフォルト字幕言語を設定する
                mainContentsFunc.setVimeoTextTrackLanguage(_uri.fileName);

                //リンクモーダルへのアンケートフォーム作成（Web サーバーにある HTML ファイルを閲覧時のみ表示）
                if (cmn.isWebBrowsing()) {
                    if ($('script[src*="www.googletagmanager.com"]').length) {
                        createQuestionaryFormInLinkModal(_uri.file, true);
                    }
                }
            }

            //該当ページのタブが存在するので切り替え
            if ($('#pageModal .tabs .tab').is('[data-tab="' + addPage + '"]')) {
                $('#pageModal .active').removeClass('active');
                $('#pageModal').find('[data-tab="' + addPage + '"], [data-tabContents="' + addPage + '"]').addClass('active');
                if (hash) {
                    scrollPos('#' + hash, firstOpen);
                } else {
                    $('#pageModal .modalContents .tabContents.active').scrollTop(0);
                }
            }
            //タブ追加
            else {
                var tabLength = $('#pageModal .tabs .tab').length;
                if (tabLength >= tabCountMax) {
                    alert(textData.tabOverAlert.replace('#0#', tabCountMax));
                    return false;
                } else {
                    /**
                     * fileNameのcontents.jsを読み込む
                     * @param {*} fileName 読み込み対象contents.jsの名前 
                     * @param {*} callback fileNameをonload後に実行する関数
                     */
                    var loadContents = function (fileName, callback) {
                        var loadContentsHtml = function () {
                            // fileName(contents.js)を元に、contentsHtml.jsファイルを読み込む
                            var contentsHtmlJsName = "contentsHtml_" + fileName.slice("contents_".length);
                            if ($('script').is('[src$="' + contentsHtmlJsName + '"]')) {
                                callback();
                            } else {
                                var scriptHtmlJs = document.createElement('script');
                                scriptHtmlJs.type = 'text/javascript';
                                scriptHtmlJs.src = "./src/js/contents/" + contentsHtmlJsName;
                                document.body.appendChild(scriptHtmlJs);
                                scriptHtmlJs.onload = function () {
                                    callback();
                                }
                            }
                        };

                        // fileNameが読み込み未ならば<script>を追加して読み込む
                        if (!$('script').is('[src$="' + fileName + '"]')) {
                            var scriptContentsJs = document.createElement('script');
                            scriptContentsJs.type = 'text/javascript';
                            scriptContentsJs.src = "./src/js/contents/" + fileName;
                            document.body.appendChild(scriptContentsJs);
                            scriptContentsJs.onload = function () {
                                loadContentsHtml();
                            }
                        } else {
                            loadContentsHtml();
                        }
                    };

                    loadContents("contents_" + addPage + ".js", function () {
                        var addPageObj = cmn.contents[addPage + ".html"];
                        var addPageText = convertToSpecialChar(cmn.contentsHtml[addPage + ".html"].contents);
                        if (addPageText) {
                            $('#pageModal .active').removeClass('active');
                            var head = addPageObj.htmlExists === 'false' ? '' : headUti;

                            // contents.jsのtitle内に%#symbol-0000#%がある場合
                            // リンクモーダルのタブに表示するときはKM - Symbolフォントを適用する
                            // リンクモーダルのタブのツールチップにはフォント指定できないためsymbolの文字を表示しない
                            $('#pageModal .tabs').append('<span class="tab active" data-tab="' + addPage + '" title="'
                                + deleteSymbol(addPageObj.title) + '"><span>' + convertToSymbolFormat(addPageObj.title) + '</span><span class="tabclose"></span></span>');

                            setTimeout(function () {
                                $('#pageModal .modalContents').append('<div class="tabContents active" data-tabContents="' + addPage + '">'
                                    + head
                                    + '<div class="page">' + addPageText + '</div>'
                                    + '</div>');
                                if (hash) {
                                    scrollPos('#' + hash, firstOpen);
                                }
                                // 各タブ表示時、ブックマーク登録状況に応じて☆マーク表示を切り替える
                                bookmarkFunc.initializeIcon(addPage + ".html");

                                // 作成中のリンクモーダルタブ内のvideo要素へ字幕情報を追加する
                                mainContentsFunc.prepareVideoTrack(addPage);

                                // 作成中のリンクモーダルタブ内のvideo要素へVimeoのデフォルト字幕言語を設定する
                                mainContentsFunc.setVimeoTextTrackLanguage(addPage);

                                //リンクモーダルへのアンケートフォーム作成（Web サーバーにある HTML ファイルを閲覧時のみ表示）
                                if (cmn.isWebBrowsing()) {
                                    if (addPageObj.htmlExists === 'true') {
                                        if ($('script[src*="www.googletagmanager.com"]').length) {
                                            createQuestionaryFormInLinkModal(addPage, false);
                                        }
                                    }
                                }

                                //リンクモーダル内の1つ目のタブ（リンク元ページのタブは除く）を表示時に、リンク元ページの
                                // 動画の読み込みを開始
                                if (tabLength == 1) {
                                    loadWebmContents($('#pageModal .tabContents.thisPageContents video[src$=".webm"]'));
                                }

                                // 動画の読み込みを開始
                                loadWebmContents($('#pageModal .tabContents.active video[src$=".webm"]'));
                            }, 30);
                            if ($(window).width() > 768) linkModalFunc.setModalTabWidth();
                        }
                    });
                }
            }

        };

        function createQuestionaryFormInLinkModal(addPage, firstPage) {
            var template = '<div class="questionnaire-area"><div class="questionnaire-form">'
                + '<p>' + textData.questionnaire_text + '</p>'
                + '<form><div><label><input id="answer9" type="radio" name="questionnaire-answer" value="3" /><p>'
                + textData.questionnaire_answer1 + '</p></label></div>'
                + '<div><label><input id="answer8" type="radio" name="questionnaire-answer" value="2" /><p>'
                + textData.questionnaire_answer2 + '</p></label></div>'
                + '<div><label><input id="answer7" type="radio" name="questionnaire-answer" value="1" /><p>'
                + textData.questionnaire_answer3 + '</p></label></div>'
                + '<div><textarea name="questionnaire-comment" rows="3" placeholder="' + textData.questionnaire_comment + '"></textarea></div>'
                + '<div><button type="button" disabled>' + textData.questionnaire_submit + '</button></div>'
                + '</form></div>'
                + '<div class="questionnaire-result" hidden>'
                + '<p>' + textData.questionnaire_result + '</p>'
                + '</div></div>';

            if (firstPage) {
                $('#pageModal main').append(template);
            } else {
                $('#pageModal .active main').append(template);
            }
        }

        //イベントセット
        (function () {
            //CrossReferenceリンク（メインページ用）
            // 実機において$(document).on('click')だけではリンクモーダルを表示できなかったため追加
            $('a.CrossReference').click(function (e) {
                addTab(e);
                return false;
            });
            //CrossReferenceリンク（リンクモーダル用）
            $(document).on('click', '.CrossReference', function (e) {
                addTab(e);
                return false;
            });

            //目次タブのリンク
            $(document).on('click', '#pageModal .modalContents [data-tabcontents$="t"] a', function (e) {
                //タブ追加
                addTab(e);

                return false;
            });

            //モーダル閉じ
            $(document).on('click', '#pageModal, .overlay.modal', function (e) {
                if ($(e.target).is('.close, #pageModal, .overlay.modal')) {
                    modalClose();
                    return false;
                }
            });

            //タブ切り替え
            $(document).on('click', '#pageModal .tabs .tab', function (e) {
                $('#pageModal .active').removeClass('active');
                var active = $(e.target).closest('.tab').addClass('active').attr('data-tab');
                $('#pageModal .modalContents [data-tabContents="' + active + '"]').addClass('active');
                // 各タブ表示時、ブックマーク登録状況に応じて☆マーク表示を切り替える
                bookmarkFunc.initializeIcon($(e.target).closest('.tab').attr('data-tab') + '.html');
            });

            //タブ閉じ
            $(document).on('click', '#pageModal .tabs .tabclose', function (e) {
                var targetTab = $(e.target).closest('.tab');
                var delTab = targetTab.attr('data-tab');
                var active = targetTab.siblings('.active').attr('data-tab');
                if (targetTab.is('.active')) {
                    active = targetTab.prev('.tab').attr('data-tab');
                }
                $('#pageModal .active').removeClass('active');
                $('#pageModal').find('[data-tab="' + delTab + '"], [data-tabContents="' + delTab + '"]').remove();
                $('#pageModal').find('[data-tab="' + active + '"], [data-tabContents="' + active + '"]').addClass('active');
                if ($(window).width() > 768) linkModalFunc.setModalTabWidth();
                return false;
            });

            //印刷
            $(document).on('click', '#pageModal button.nowprint', function (e) {
                window.print();
            });

            //新規ウインドウで開く
            $(document).on('click', '#pageModal button.newPage', function (e) {
                var active_page = $('#pageModal .tab.active').attr('data-tab') + '.html';
                window.open(active_page, '_blank');
            });

            //ページナビ（ページトップのリンク群）
            $(document).on('click', '#pageModal .modalContents .Subsection-menu a[href^="#"]', function (e) {
                scrollPos($(e.target).attr('href'));
                return false;
            });

            // リンクモーダル領域のブックマーク用☆画像をクリックするたびに切り替える
            $(document).on('click', '#modalarea_star', function (e) {
                bookmarkFunc.switchRegister();
            });

            if ($(window).width() > 768) {
                $(window).on('resize', function () {
                    linkModalFunc.setModalTabWidth();
                });
            }

            //イベント設定（リンクモーダル用）
            //フォーム内変更時のイベント
            $(document).on('change', '#pageModal .active .questionnaire-form form', function () {
                var value = $("#pageModal .active  input[name='questionnaire-answer']:checked").val();
                if (value) {
                    $('#pageModal .active .questionnaire-form button').prop('disabled', false);
                }
            });

            //送信ボタンクリック時のイベント
            $(document).on('click', '#pageModal .active .questionnaire-form button', function () {
                $('#pageModal .active .questionnaire-form').hide();
                $('#pageModal .active .questionnaire-result').show();

                //アンケートフォーム選択ラジオボタン文字列取得
                var selectRadioText = $("#pageModal .tabContents.active input[name='questionnaire-answer']:checked").parent('label').text();
                if (!selectRadioText) {
                    selectRadioText = "(not set)";
                }

                //パンくずリスト取得
                var addPage = $("#pageModal .tabContents.active").attr('data-tabcontents');
                var addPageObj = cmn.contents[addPage + ".html"];
                var breadArray = addPageObj.topic_path;
                var breadcrumbText = breadArray.join(' > ');

                //エンティティを実体に変換
                breadcrumbText = breadcrumbText.replace(/&quot;/g, "\"");
                breadcrumbText = breadcrumbText.replace(/&#39;/g, "'");
                breadcrumbText = breadcrumbText.replace(/&amp;/g, "&");
                breadcrumbText = breadcrumbText.replace(/&lt;/g, "<");
                breadcrumbText = breadcrumbText.replace(/&gt;/g, ">");

                //Symbolを実体文字に変換
                breadcrumbText = convertSymbolFont(breadcrumbText);

                //#466 &文字は送信不可のためURLエンコード
                breadcrumbText = breadcrumbText.replace(/\&/g, "%26");

                //コメントテキスト取得
                var commentText = $("#pageModal .tabContents.active textarea[name='questionnaire-comment']").val();

                //送信
                gtag('event', 'questionnaire', { 'breadcrumbs': breadcrumbText, 'choice': selectRadioText, 'comment': commentText, 'value': 1 });
            });

            //コメント入力テキストエリア変更時のイベント
            $(document).on('keyup', '#pageModal .tabContents.active .questionnaire-form textarea', function () {
                var value = $("#pageModal .tabContents.active input[name='questionnaire-answer']:checked").val();
                if (!value) {
                    var textData = String($("#pageModal .tabContents.active textarea[name='questionnaire-comment']").val());
                    if (textData === "") {
                        $('#pageModal .tabContents.active .questionnaire-form button').prop('disabled', true);
                    } else {
                        $('#pageModal .tabContents.active .questionnaire-form button').prop('disabled', false);
                    }
                }
            });
        }());
    }
};

var convertSymbolFont = function (str) {
    if (str.indexOf('%#symbol-')) {
        str = str.replace(/%#symbol-([^#]+?)#%/g, function (all, group1) {
            return '<symbol>' + String.fromCharCode('0x' + group1) + '</symbol>';
        });
    }

    return str;
};

/**
 * webm動画を1つずつ順次読み込む
  */
var loadWebmContents = function (targetContents) {
    if (targetContents.length) {
        targetContents.map(function (index, elm) {
            if (index == targetContents.length - 1) return;
            $(elm).on('canplaythrough', function () {
                targetContents.eq(index + 1).trigger('load');
            });
        })
        targetContents.first().trigger('load');
    }
};

$(function () {
    //  メイン画面のイベントを設定
    mainContentsFunc.setMaincontentsEvent();

    // 検索結果からページへ遷移したときキーをハイライト
    mainContentsFunc.searchKeyHighlight();

    // メインページ内の全video要素へ字幕情報を追加する
    mainContentsFunc.prepareVideoTrack();

    // メインページ内の全video要素へVimeoのデフォルト字幕言語を設定する
    mainContentsFunc.setVimeoTextTrackLanguage();

    // ヘッダー・目次関連の表示・非表示設定
    // AI冊以外の場合のみ（追加情報用のAI冊は検索フォーム非表示のため）
    if (!_uri.file.startsWith("AI_")) {
        mainContentsFunc.setHeaderEvent();
    }

    // リンクモーダル
    linkModalFunc.initialize();
    
    //Web サーバーにある HTML ファイルを閲覧時のみ表示
    if (cmn.isWebBrowsing()) {
        if ($('script[src*="www.googletagmanager.com"]').length) {
            //アンケートフォーム追加
            mainContentsFunc.addQuestionaryForm();

            //アンケートイベント設定
            mainContentsFunc.addQuestionaryEvent();
        }
    }

    // 動画の読み込みを開始
    loadWebmContents($('#contents-box video[src$=".webm"]'));
})
