/*/////////////////////////////////////////////////////////////////////////////////////////////////
	User's Guide PP
		Topic JavaScript
 Modified : 2017-01-25
/////////////////////////////////////////////////////////////////////////////////////////////////*/




/* global contents, _get, thisId, thisManualPath, Modernizr, thisFile, textData, thisFileName, cmn, _uri, _ua */



var topicFunc = {
	
	/*
	 * 初期
	 */
	"init": function(){
		cmn.removeThead();
		cmn.addViewClass('pageNavi');
	}
	
	/*
	 * 左メニューツリー作成
	 */
	,"leftNaviCreative": function(target){

		var treeElm = $(target).children("ul");
		if($(target).is('ul')){
			treeElm = $(target);
		}
		treeElm.addClass('treeview creating');
		
		$('.treeview ul').closest("li").addClass('collapse').children('span').append('<span class="hitarea"/>');

		$('.treeview li > span').each(function(i,e){
			if($(e).children().is('a')){
				$(e).addClass('inlink');
			}else{
				$(e).addClass('parent');
			}
		});
		
		//ツリーのアクティブ項目をセット
		$("#naviTree ul li a[href$='#']").parent('span').addClass('activePage').parents("li.collapse").addClass("expand");
		
		treeElm.removeClass('creating');
		
		var addMenuID = function(t, parentIni){
			var ini = (parentIni == undefined) ? "" : parentIni + '-';
			t.find('>li').each(function(i,e){
				var id = ini + i;
				$(e).attr('data-menuid', id);
				if($(e).children().is('ul')){
					addMenuID($(e).children('ul'), id);
				}
			});
		};
		addMenuID($(target));
		
	}
	
	/*
	 * 
	 */
	,"leftNaviEvent": function(){
		//開閉
		$('.treeview').on("click", '.parent', function(e){
			var targetLI = $(e.currentTarget).closest('li.collapse');
			targetLI.children('ul').slideToggle("fast", function(){
				targetLI.toggleClass('expand');
				topicFunc.localMenuStracture.save();
			});
		});
		
		//全て開く
		$('#ExpandAll').on("click", function(e){
			$('.treeview .collapse > ul').slideDown("fast", function(){
				$(this).parent('.collapse').addClass('expand');
				topicFunc.localMenuStracture.save();
			});
		});
		
		//全て閉じる
		$('#CollapseAll').on("click", function(e){
			$('.treeview .collapse > ul').slideUp("fast", function(){
				$(this).parent('.expand').removeClass('expand');
				topicFunc.localMenuStracture.save();
			});
		});
		
		//スクロール
		$('#naviTree').on('scroll', function(e){
			topicFunc.localMenuStracture.save();
		});
	}
	
	/*
	 * メニュー開閉保存読み込み
	 */
	,"localMenuStracture": {
		//初回のみ
		"init": function(){
			topicFunc.localMenuStracture.set();
			
		}
		
		//開閉情報 保存
		,"save": function(){
			var val = {
				"menuProp": {
					"menuWidth": $('#localMenu').width()
				}
			};
			val.menuProp[_uri.id] = {
				"open": [],
				"scrl": $('#naviTree').scrollTop()
			};
			$('#naviTree li.expand[data-menuid]').each(function(i,e){
				val.menuProp[_uri.id].open.push($(e).attr('data-menuid'));
			});
			
			topicFunc.localMenuStracture.LoadSave("save", JSON.stringify(val));
			//console.log('localMenuStracture.save');
		}
		//開閉情報 読み込み＆セット
		,"set": function(){
			if($('body').is('#bodyTopic')){//console.log(topicFunc.localMenuStracture.LoadSave("get"));
				var getData = topicFunc.localMenuStracture.LoadSave("get");
				var menuProp = (getData)? JSON.parse(getData).menuProp : false;
				
				if(menuProp){
					var openMenuArr = [];
					var scrollPos = 0;
					
					if(menuProp[_uri.id]){
						openMenuArr = menuProp[_uri.id].open;
						scrollPos = menuProp[_uri.id].scrl;
					}
					
					//メニュー開閉状態セット
					for(var i in openMenuArr){
						var targetLI = $('#naviTree li[data-menuid="' + openMenuArr[i] + '"]');
						targetLI.addClass('expand');
					}

					//メニュー幅セット
					var menuWidth = menuProp.menuWidth;
					$('#localMenu, #menuWrapper').width(menuWidth);
					$('#container').css('marginLeft', menuWidth);
					$("#ajustMenuWidthArea").css('left', menuWidth);

					//メニュースクロール状態セット
					$('#naviTree').scrollTop(scrollPos);
				}
			}else{
				topicFunc.localMenuStracture.LoadSave("save", "{}");
			}
			//console.log(topicFunc.localMenuStracture.key);
		}
		//
		,"LoadSave": function(type, val){
			var key = topicFunc.localMenuStracture.key;
			if(!key) return false;
			if('save' == type){
				if(Modernizr.cookies){
					$.cookie(key, val);
				}else{
					sessionStorage.setItem(key, val);
				}
				return true;
			}
			if('get' == type){
				var r;
				if(Modernizr.cookies){
					r = $.cookie(key);
				}else{
					r = sessionStorage.getItem(key);
				}
				return r;
			}
		}
		,"key": (function(){
			try{
				var shaObj = new jsSHA("SHA-1", "TEXT");
				shaObj.update(_uri.manualPath + window.name);
				return shaObj.getHash("HEX");
			}catch(e){
				//e.message;
				return false;
			}
		}())
	}
	
	/*
	 * モーダル機能
	 */
	,"pageModal": function(){
		var tabCountMax = 15;
		var groundXRef;
		
		var template = '<div id="pageModal"><div class="modal">'
				+ '<span class="close">&times;</span>'
				+ '<div class="modalReturnToTop"><span><a title="' + textData.returnToTopTxt + '"></a></span></div>'
				//+ '<div class="wrapper">'
				+ '<div class="header"><div class="tabs">'
				+ '<span class="tab" data-tab="' + _uri.fileName + '" title="' + $('#container h1').text() + '"><span>' + $('#container h1').text() + '</span></span>'
				+ '</div></div>'
				+ '<div class="modalContents"></div>'
				+ '<div class="path">'
				+ '<div class="copy"><button class="clipboard" title="' + textData.copyClipboard + '"><span class="fa fa-commenting"/></button></div>'
				+ '<div class="crumbs"/></div>'
				//+ '</div>'
				+ '</div></div><div class="overlay modal"></div>';
		var headUti = '<div id="headUti">'
				+ '<button class="newPage"><span>' + textData.open_new + '</span></button>'
				+ '<button class="print"><span>' + textData.print_j + '</span></button>'
				+ '</div>';
		
		//タブ追加
		var addTab = function(e){
			var target = $(e.target).closest('a');
			var uri = target.attr('href');
			if(uri){
				uri = uri.split('#');
				var addPageData = {
					"html": uri[0].replace(/([^\/\\]+)\.html?.*$/i, "$1"),
					"hash": uri[1]
				};
				modalOpen(addPageData, e);
			}
		};
		
		//そのタブ上で遷移
		var tranOnTab = function(e){
			var movPage = $(e.target).attr('href');
			movPage = movPage.replace(/([^\/\\]+)\.html?$/i, "$1");
			var movPageText = contents[movPage + ".html"].contents;
			if(movPageText){
				var jampTabContent = $('#pageModal .modalContents .tabContents.active');
				var movObj = $('<div>' + movPageText + '</div>');
				var title = movObj.find('h1').text();
				$('#pageModal .tabs .active').attr({
					"data-tab": movPage,
					"title": title
				}).html('<span>' + title + '</span><span class="tabclose">&times;</span>');
				jampTabContent.attr('data-tabContents', movPage).scrollTop(0).prepend(headUti).find('.page').html(movObj.html());
			}
		};
		
		//パンくず構造生成
		var getPath = function(arr){
			var path = [];
			$.each(arr, function(i,v){
				path.push('<span>' + v + '</span>');
			});
			return path.join('');
		};

		//パンくずコピー
		var copyEvent = function(){
			var clipboard = new Clipboard('#pageModal .clipboard', {
				text: function() {
					var t = [];
					$('#pageModal .crumbs span').each(function(i,e){
						t.push($(e).text());
					});
					return t.join(' > ');
				}
			});
			clipboard.on('success', function(e){
				//console.log(e);
			});
			clipboard.on('error', function(e){
				//console.log(e);
			});
		};
		
		//モーダル閉じ
		var scrollTop;
		var modalClose = function(){
			$('#pageModal, .overlay.modal').removeClass('in');
			$(groundXRef.target).focus().blur();
			groundXRef = false;
			setTimeout(function(){
				$('#pageModal, .overlay.modal').remove();
				$('body').removeClass('openModal');
				$('#wrapper').removeAttr('style');
				$(window).scrollTop(scrollTop);
			},300);
		};
		
		//スクロール位置セット
		var scrollPos = function(id, firstOpen){
			var targetTabContents = $('#pageModal .modalContents .tabContents.active');
			if(targetTabContents.is('.thisPageContents')){
				id += '_modal';
			}
			var ta = $(id);
			if(!ta.length) return;
			var spos = targetTabContents.scrollTop();
			if(firstOpen){
				setTimeout(function(){
					targetTabContents.scrollTop(spos + ta.position().top);
				}, 400);
			}else{
				targetTabContents.scrollTop(spos + ta.position().top);
			}
		};
		
		//
		var contentsHeight = function(){
			if(_ua._isSafari){
				$('#pageModal .modalContents').height(function(){
					return $('#pageModal .modal').height() - ($('#pageModal .header').height() - $('#pageModal .path').height());
				});
			}
		};
		
		//
		var modalWidth = function(){
			if( _ua._IEVer == 10){
				$('#pageModal > .modal').width(function(){
					var dif = $('#pageModal > .modal').outerWidth(true) - $('#pageModal > .modal').width();
					var cwidth = $('#documentBody').outerWidth(true);
					return cwidth - dif;
				});
			}
		};
		
		//モーダル表示
		var modalOpen = function(addPageData, e){
			var firstOpen = false;
			var addPage = addPageData.html;
			var hash = addPageData.hash;
			
			
			//モーダル初期作成===============================================================
			if(!$('body').children().is('#pageModal')){
				groundXRef = e;
				firstOpen = true;
				scrollTop = $(window).scrollTop();
				$('body').addClass('openModal').append(template);
				$('#wrapper').css('top', (-scrollTop) + 'px');
				setTimeout(function(){
					$('#pageModal, .overlay.modal').addClass('in');
				},0);
				
				//Set thisPage
				var thisPage = $('<div>' + contents[_uri.file].contents + '</div>');
				thisPage.find('.pageNavi a[href^="#"]').each(function(i,e){
					var h = $(e).attr('href');
					//$(e).attr('href', h + '_modal');
					thisPage.find(h).attr('id', thisPage.find(h).attr('id') + '_modal');
				});
				
				$('#pageModal .modalContents').append('<div class="tabContents thisPageContents" data-tabContents="' + _uri.fileName + '">'
						+ headUti
						+ '<div class="page">' + thisPage.html() +'</div>'
						+ '</div>');
				$('#pageModal > .modal > .path .crumbs').html(getPath(contents[_uri.file].topic_path));
				
				//アクティブタブのパンくずをクリップボードへ
				copyEvent();
				contentsHeight();
				modalWidth();
				
				//IE10, IE9 ---------------------
				if(_ua._IEolder10){
					topicFunc.funcIE10Older.modalScroleEvent($('#pageModal .tabContents.thisPageContents'));
				}
				// ------------------------------
			}
			//===============================================================
			
			//該当ページのタブが存在するので切り替え
			if($('#pageModal .tabs .tab').is('[data-tab="' + addPage + '"]')){
				$('#pageModal .active').removeClass('active');
				$('#pageModal').find('[data-tab="' + addPage + '"], [data-tabContents="' + addPage + '"]').addClass('active');
				if(hash){
					scrollPos('#' + hash, firstOpen);
				}else{
					$('#pageModal .modalContents .tabContents.active').scrollTop(0);
				}
			}
			//タブ追加
			else{
				var tabLength = $('#pageModal .tabs .tab').length;
				if(tabLength >= tabCountMax){
					alert(textData.tabOverAlert.replace('#0#', tabCountMax));
					return false;
				}else{
					var addPageObj = contents[addPage + ".html"];
					var addPageText = addPageObj.contents;
					if(addPageText){
						$('#pageModal .active').removeClass('active');
						var head = (/t$/.test(addPage)) ? '' : headUti;
						$('#pageModal .tabs').append('<span class="tab active" data-tab="' + addPage + '" title="'
								+ addPageObj.title + '"><span>' + addPageObj.title + '</span><span class="tabclose">&times;</span></span>');
						$('#pageModal > .modal > .path .crumbs').html(getPath(addPageObj.topic_path));
						
						setTimeout(function(){
							$('#pageModal .modalContents').append('<div class="tabContents active" data-tabContents="'+ addPage + '">'
								+ head
								+ '<div class="page">' + addPageText + '</div>'
								+'</div>');
							cmn.addViewClass('pageNavi');
							if(hash){
								scrollPos('#' + hash, firstOpen);
							}
							
							//IE10, IE9 ---------------------
							if(_ua._IEolder10){
								topicFunc.funcIE10Older.modalScroleEvent($('#pageModal .tabContents[data-tabContents="'+ addPage + '"]'));
							}
							// ------------------------------
						}, 30);
						
						//IE9 ------------------------------
						if(_ua._IEolder9){
							topicFunc.funcIE9.setModalTabWidth();
							topicFunc.funcIE9.crombsItemWidth('#pageModal > .modal > .path .crumbs');
						}
						// ------------------------------
					}
				}
			}
			
		};
		
		
		
		//イベントセット
		(function(){
			//CrossReferenceリンク
			$(document).on('click', '.CrossReference', function(e){
				addTab(e);
				return false;
			});
			
			//目次タブのリンク
			$(document).on('click', '#pageModal .modalContents [data-tabcontents$="t"] a', function(e){
				//そのタブ上で遷移
				//tranOnTab(e);
				//タブ追加
				addTab(e);
				
				return false;
			});
		
			//モーダル閉じ
			$(document).on('click', '#pageModal, .overlay.modal', function(e){
				if($(e.target).is('.close, #pageModal, .overlay.modal')){
					modalClose();
					return false;
				}
			});
			
			//タブ切り替え
			$(document).on('click', '#pageModal .tabs .tab', function(e){
				$('#pageModal .active').removeClass('active');
				var active = $(e.target).closest('.tab').addClass('active').attr('data-tab');
				$('#pageModal .modalContents [data-tabContents="' + active + '"]').addClass('active');
				$('#pageModal > .modal > .path .crumbs').html(getPath(contents[active + '.html'].topic_path));
				
				//IE10, IE9 ---------------------
				if(_ua._IEolder10){
					topicFunc.funcIE10Older.setModalScroll();
				}
				// ------------------------------
				
				//IE9 ------------------------------
				if(_ua._IEolder9) topicFunc.funcIE9.crombsItemWidth('#pageModal > .modal > .path .crumbs');
				// ------------------------------
			});
			
			//タブ閉じ
			$(document).on('click', '#pageModal .tabs .tabclose', function(e){
				var targetTab = $(e.target).closest('.tab');
				var delTab = targetTab.attr('data-tab');
				var active = targetTab.siblings('.active').attr('data-tab');
				if(targetTab.is('.active')){
					active = targetTab.prev('.tab').attr('data-tab');
				}
				$('#pageModal .active').removeClass('active');
				$('#pageModal').find('[data-tab="' + delTab + '"], [data-tabContents="' + delTab + '"]').remove();
				$('#pageModal').find('[data-tab="' + active + '"], [data-tabContents="' + active + '"]').addClass('active');

				//IE9 ------------------------------
				if(_ua._IEolder9) topicFunc.funcIE9.setModalTabWidth();
				// ------------------------------

				return false;
			});
			
			//印刷
			$(document).on('click', '#pageModal button.print', function(e){
				print();
			});

			//新規ウインドウで開く
			$(document).on('click', '#pageModal button.newPage', function(e){
				var active_page = $('#pageModal .tab.active').attr('data-tab') + '.html';
				window.open(active_page);
			});

			//ページトップへ
			$(document).on('click', '#pageModal .modalReturnToTop', function(e){
				$('#pageModal .modalContents .tabContents.active').animate({ scrollTop: 0 }, 300, 'swing');
			});

			//ページナビ
			$(document).on('click', '#pageModal .modalContents .pageNavi a[href^="#"]', function(e){
				scrollPos($(e.target).attr('href'));
				return false;
			});
			
			//
			$(window).on('resize', function(){
				contentsHeight();
				modalWidth();
			});
			
			//IE9 ------------------------------
			if(_ua._IEolder9) $(window).on('resize', function(){
				topicFunc.funcIE9.setModalTabWidth();
				topicFunc.funcIE9.crombsItemWidth('#pageModal > .modal > .path .crumbs');
			});
			// ------------------------------
			
		}());
		
	}

	/*
	 * 選んで印刷ボタンイベント
	 */
	,"selectPrintBtnEvent": function(){
		$('.PrintBtn').on("click", ".selectPrint", function(e){
			w = window.open("selected_print.html?b=" + _uri.id, "selected_print",
				"width=650, height=600, resizable=yes, location=no, menubar=no, toolbar=no");
			w.focus();
		});
	}

	/*
	 * このページを印刷ボタンイベント
	 */
	,"thisPagePrintBtnEvent": function(){
		$('.PrintBtn').on("click", ".thisPagePrint", function(e){
			print();
		});
	}
	
	/*
	 * ローカルナビ スライド表示/非表示
	 */
	,"menuShowHide": function(){
		$('#menuWrapper').append('<span class="menuShowHideBtn" title="' + textData.menuShowHide + '"/>');
		var menubelt = 32;
		$(document).on('click', '.menuShowHideBtn, .localMenuHide #localMenu', function(e){
			var menuWidth = $('#localMenu').width();
			//開
			var menuWrapper_width = menuWidth,
				localMenu_marginLeft = 0,
				localMenu_opacity = 1,
				container_marginLeft = menuWidth
				;
			//閉
			if(!$('#contents').is('.localMenuHide')){
				menuWrapper_width = menubelt;
				localMenu_marginLeft = menubelt - menuWidth;
				localMenu_opacity = 0;
				container_marginLeft = menubelt;
			}
			
			$('#contents').toggleClass('localMenuHide');
			
			$('#menuWrapper').animate({
				"width": menuWrapper_width + "px"
			}, 300);
			
			$('#localMenu').animate({
				"marginLeft": localMenu_marginLeft +"px",
				"opacity": localMenu_opacity
			}, 300);
			
			$('#container').animate({
				"marginLeft": container_marginLeft +"px"
			}, 300);
			
			$(this).blur();
			return false;
		});
	}
	
	/*
	 * メニュー幅のドラッグ移動
	 */
	,"ajustMenuWidth": function(){
		$('#contents').append('<span id="ajustMenuWidthArea"/>');
		
		var docHalf;
		$("#ajustMenuWidthArea").draggable({
			"axis": 'x',
			"start": function(event, ui){
				docHalf = parseInt($('#documentBody').width()) / 2;
				if($('#localMenu').width() > docHalf){
					$('#localMenu, #menuWrapper').width(docHalf);
					$('#container').css('marginLeft', docHalf);
				}
			},
			"drag": function(event, ui){
				//console.log(ui);
				var left = ui.position.left;
				if(left >= 200 && left <= docHalf){
					$('#localMenu, #menuWrapper').width(left);
					$('#container').css('marginLeft', left);
				}
			},
			"stop": function(event, ui){
				$("#ajustMenuWidthArea").css('left', $('#localMenu').width());
				topicFunc.localMenuStracture.save();
			}
		});
		
		
	}
	
	/*
	 * 検索結果からページへ遷移したときキーをハイライト
	 */
	,"searchKeyHighlight": function(){
		if(_get['k'] && $('body').is('#bodyTopic')){
			
			var getKeywordArr = function(inputWord){
				var splitStrBase = '㌀|㌞|㍇|㍧|㍨|㍩|㍪|㍫|㍬|㍭|㍮|㍯|㍰';
				var sep = splitStrBase.split('|');
				var temp = inputWord.match(new RegExp('('+ splitStrBase + ')', "g"));
				if(temp){
					temp = new RegExp('(' + temp.join('|') + ')', "g");
					sep = splitStrBase.replace(/\|/, '').replace(temp, '').split('|');
				}
				var phraseArr = [];
				var temp = inputWord;

				temp = temp.replace(/"([^"]+)"/g, function(a,$1){
					phraseArr.push($1);
					return sep[0];
				});

				var arr = temp.split(/[\s　]+/);

				$.each(arr, function(i,val){
					if(val == void(0)) arr.splice(i,1);
					if(val == sep[0]) {
						arr[i] = phraseArr.shift();
					}
				});

				return arr;
			};
			
			var keyword = getKeywordArr(_get['k']);
			var UpLo = _get['ul'];
			var ZenHan = _get['zh'];
			for(var i in keyword){//console.log(keyword);
				if(keyword[i]){
					$('#container div.page').keyHighlight(keyword[i], { "UpLo": UpLo, "ZenHan": ZenHan });
				}
			}
		}
	}
	
	/*
	 * IE10, IE9関数
	 */
	,"funcIE10Older": {
		//モーダルスクロール量
		"modalScroleEvent": function(target){
			target.on('scroll', function(e){
				$(e.target).attr('data-scroll', e.target.scrollTop);
			});
		}
		,"setModalScroll": function(){
			var active = $('#pageModal .tabContents.active');
			var pos = active.attr('data-scroll') || 0;
			active.scrollTop(pos);
		}
	}
	
	/*
	 * IE9関数
	 */
	,"funcIE9": {
		//パンくず幅
		"crombsItemWidth": function(el){
			var crmbs = $(el);
			var crumbsW = crmbs.width();
			var pathLen = crmbs.children().length;
			var av = crumbsW / pathLen;
			var bigItem = [];
			var addAvW = 0;
			crmbs.children().each(function(i,e){
				var itemW = $(e).outerWidth(true);
				if(itemW > av){
					bigItem.push($(e));
				}else{
					addAvW += av - itemW;
				}
			});
			if(bigItem.length){
				var maxW = Math.floor(av + (addAvW / bigItem.length));
				$.each(bigItem, function(i, $e){
					$e.css('maxWidth', maxW);
				});
			}
		}
		//モーダルのタブ幅
		,"setModalTabWidth": function(){
			var tabs = $("#pageModal .modal > .header .tabs");
			var tab = tabs.children('.tab');
			var tabLen = tab.length;
			var tabsW =  tabs.width();
			tab.width(function(){
				var w = Math.floor(tabsW / tabLen);
				return w - 29;
			});
		}
	}
};





/**************************************************
 * jQuery ready
 */
$(function(){
	
	//初期
	topicFunc.init();
	
	//左メニューツリー作成
	topicFunc.leftNaviCreative("#naviTree > ul");
	
	//左メニューツリーのイベント
	topicFunc.leftNaviEvent();
	
	//検索結果からページへ遷移したときキーをハイライト
	topicFunc.searchKeyHighlight();
	
	//モーダル機能
	topicFunc.pageModal();
	
	//このページを印刷ボタンイベント
	topicFunc.thisPagePrintBtnEvent();
	
	//選んで印刷ボタンイベント
	topicFunc.selectPrintBtnEvent();
	
	//ローカルナビ スライド表示/非表示
	topicFunc.menuShowHide();
	
	//メニュー幅のドラッグ移動
	topicFunc.ajustMenuWidth();
	
	//ローカルメニュー開閉読み込み
	topicFunc.localMenuStracture.init();
	
	
	
	
	
	
	//IE9 ------------------------------
	if(_ua._IEolder9){
		topicFunc.funcIE9.crombsItemWidth('#breadcrumbs');
	}
	// ------------------------------
	
});
//end jQuery ready
