/*
 * for Konica Minoｌta Printer User's Guide CD
 *
 * Initializing process
 */

// ブラウザ言語の取得
var getBrowserLanguage = function()
{
	try {
		return (navigator.browserLanguage || navigator.language || navigator.userLanguage).substr(0,5);
	}
	catch(e) {
		return "error";
	}
}

// OWN版とOEM版の切替えと、言語選択のドロップダウンリスト設定
var __init = function()
{
	var ie6 = false;
	ie6 = getBoolIE6();

	// IE6の場合AdobeURLは表示しない
	if(ie6) {
		document.getElementById("doc11tipsIE6").style.display = "block";
		
		// 子要素を削除する
		var element = document.getElementById("adburl");
		while(element.firstChild){
			element.removeChild(element.firstChild);
		}
		
	} else {
		document.getElementById("doc11tips").style.display = "block";
		document.getElementById("adburl").style.display = "block";
	}
	
	var header_background = '#0a0a0a url("./contents/img/top/header_line.gif") no-repeat bottom';
	var corplogo_background = '#0a0a0a url("./contents/img/top/corporate_logo.gif") no-repeat';
	var title_background = '#0a0a0a';
	var title_color = '#fff';
	var toolnavi1_color = '#fff';
	var toolnavi2_color = '#fff';
	for (var key in __i18n_corporate) {
		if (__i18n_corporate[key] == "1") {
			switch (key) {
			case "generic":
				header_background = '#fff url("./contents/img/top/header_line_generic.gif") no-repeat bottom';
				corplogo_background = '#fff url("./contents/img/top/corporate_logo_generic.gif") no-repeat';
				title_background = '#fff';
				title_color = '#0a0a0a';
				toolnavi1_color = '#0a0a0a';
				toolnavi2_color = '#0a0a0a';
				break;
			case "own":
			default:
				break;
			}
			break;
		}
	}
	document.getElementById("header").style.background = header_background;
	document.getElementById("corplogo").style.background = corplogo_background;
	document.getElementById("title").style.background = title_background;
	document.getElementById("title").style.color = title_color;
	document.getElementById("doc1text").style.color = toolnavi1_color;
	document.getElementById("doc8text").style.color = toolnavi2_color;
	
	if(__i18n_onlyEnFlg == 0){
		var langs = new Array();
		var i = 0;
		for (var key in __i18n_langages) {
			if (key == "_last") break;
			var val = __i18n_langages[key];
			if (val.substr(0,1) == "1") {
				langs[i] = new Array();
				langs[i][0] = key;
				langs[i][1] = val.substr(1, val.length-1);
				i++;
			}
		}

		var objsl = document.getElementById("selectlang");
		objsl.length = langs.length;
		for (var j=0; j<langs.length; j++) {
			objsl.options[j].text = langs[j][0];
			objsl.options[j].value = langs[j][1];
		}

		var browserlang = getBrowserLanguage().toLowerCase();
		if ("zh-hk" == browserlang) {
			browserlang = "zh-tw"; // ブラウザ言語が香港(zh-hk)だった場合はUIを繁体字(zh-tw)とする
		}
		var uilang = "en";	// ドロップダウンにない言語（つまり未対応の言語）の場合はUIを英語とする
		for (var k=0; k<objsl.length; k++) {
			var sllang = objsl.options[k].value.toLowerCase();
			if (sllang == browserlang.substr(0, sllang.length)) {
				objsl.options[k].selected = true;
				uilang = sllang;
				break;
			}
		}
	} else {
		uilang = "en";
	}
	
	setuilanguage(uilang);
	
	document.getElementById("doc2file").focus();
}
