/*/////////////////////////////////////////////////////////////////////////////////////////////////
	User's Guide
		SelectPrint JavaScript
 Modified : 2017-03-16
/////////////////////////////////////////////////////////////////////////////////////////////////*/

/* global textData, _ua, contents, viewFunc */



var selectPrint = {
	
	"_init": function(){
		
		$("body").append('<div class="loading"><span class="loadingicon fa fa-spinner fa-spin fa-3x fa-fw"></span></div>');
		$('body').append('<div id="nowloadingMsg"><div class="msg">'
				+ textData.selectprintLoadingTxt + '</div><div class="btn"><button>OK</button></div></div>');//
		selectPrint._nowloadingPosition();//
		
		$('#printButton button').prop('disabled', true).wrapInner('<span/>');
		
		$("#selectTree :checkbox").prop('checked', false);
		$("#selectTree li > span").removeClass('check');
		$('#selectTree li:has(>ul)').each(function(i,e){
			$(e).children('span').addClass('childrenToggle').children('input').val('');
		});
		
		$("body").append('<div id="contents"><div id="container" class="container"></div></div>');
		
		
		//コンテンツ読み込み
		$('#print').addClass('show').append('<span id="loadingText">'+textData.selectprintLoading+'&nbsp;<span id="par"></span></span>');//
		setTimeout(selectPrint._load_contents, 1000/60);
		
		
	}
	
	
	/*
	 * ローディングメッセージの位置
	 */
	, "_nowloadingPosition": function(){
		
		$('#nowloadingMsg').css('top', ($(window).height()/2 - $('#nowloadingMsg').height()/2) +"px");
		$('#nowloadingMsg').css('left', ($(window).width()/2 - $('#nowloadingMsg').width()/2) +"px");
	}
	
	
	/*
	 * コンテンツ読み込み 
	 */
	,"_load_contents": function(){
//		var val,page;
//		$("#selectTree input:checkbox").each(function(i,e){
//			val = $(e).val();
//			if(/^id/.test(val)){
//				page = $('<div>' + contents[val].contents + '</div>').find('.page');
//				$('#container').append('<div id="sp' + val + '" class="pageBreak hide">'+ page[0].outerHTML +'</div>');
//			}
//		});
//		
//		viewFunc._removeThead();
//		
//		//イベントをセット
//		selectPrint._setEvent();
//		
//		$('body > .loading').remove();
//		
		//////////////
		var progressbarWidth0 = -200;
		var loadingTextWidth = $('#loadingText').width();
		var p = [];
		$("#selectTree input:checkbox").each(function(i,e){
			val = $(e).val();
			if(/^id/.test(val)){
				p.push(val);
			}
		});
		
		var pInit = p.length;
		
		var loding = function(){
			var psent = Math.floor( (pInit - p.length) / pInit *100 );
			var val = p.shift();
			
			var page = $('<div>' + contents[val].contents + '</div>').find('.page');
			$('#container').append('<div id="sp' + val + '" class="pageBreak hide">'+ page[0].outerHTML +'</div>');
			
			if(p.length){
				$('#par').text(psent + '%');
				$('#loadingText').css('backgroundPosition', Math.floor(progressbarWidth0 + (loadingTextWidth / 100 * psent)) + 'px 50%');
				setTimeout(loding, 50);
			}else{
				viewFunc._removeThead();
				$('body > .loading, #loadingText, #nowloadingMsg').remove();
				$('#print').removeClass('show');
			}
		};
		
		if(pInit){
			setTimeout(loding, 50);
		}else{
			alert(textData.selectPrintErrTxt);
		}
		
		//イベントをセット
		selectPrint._setEvent();
		////////////////
		
		
		
		
	}
	
	
	/*
	 * イベントをセット
	 */
	,"_setEvent": function(){
		
		var btnState = function(){
			var checkLen = $('#selectForm :checkbox[value^=id]:checked').length;
			if(checkLen == 0){
				$('#print, #unSele').prop('disabled', true);
				$('#selAll').prop('disabled', false);
			}else if(checkLen == $('#container > div').length){
				$('#print, #unSele').prop('disabled', false);
				$('#selAll').prop('disabled', true);
			}else{
				$('#print, #unSele, #selAll').prop('disabled', false);
			}
		};
		btnState();
		
		$('#selAll').on("click", function(e){
			$("#selectTree :checkbox").prop('checked',true);
			$("#selectTree li > span").addClass('check childcheck');
			
			//コンテンツの表示ステータス変更
			$('#container > div').removeClass('hide').addClass('pageBreak')
					.filter(':first').removeClass('pageBreak');
			
			btnState();
		});
		
		$('#unSele').on("click", function(e){
			$("#selectTree :checkbox").prop('checked', false);
			$("#selectTree li > span").removeClass('check childcheck');
			
			//コンテンツの表示ステータス変更
			$('#container > div').addClass('hide');
			
			btnState();
		});
		
		$(':checkbox').on("click", function(e){
			var thisCheckbox = $(e.target).closest(':checkbox');
			var thisLI = thisCheckbox.closest('li');
			
			if(thisCheckbox.prop('checked')){
				thisCheckbox.parent('span').addClass('check');
				thisLI.find(':checkbox').prop('checked', true).parent('span').addClass('check');
			}else{
				thisCheckbox.parent('span').removeClass('check childcheck');
				thisLI.find(':checkbox').prop('checked', false).parent('span').removeClass('check childcheck');
			}
			
			$('#container > div').addClass('pageBreak hide');
			$("#selectForm :checked").each(function(i,e){
				var page = $('#sp' + $(e).val());
				page.removeClass('hide');
			});
			$('#container > div:not(.hide):first').removeClass('pageBreak');
			
			thisCheckbox.closest("li").parents('li').each(function(i,el){
				var target = $(el).children(".childrenToggle");
				var checkboxLen = $(el).find('> ul :checkbox').length;
				var checkLen = $(el).find('> ul :checkbox:checked').length;
				if(checkboxLen == checkLen){
					target.addClass('check childcheck');
				}else if(checkLen){
					target.addClass('childcheck').removeClass('check');
				}else{
					target.removeClass('check childcheck');
				}
			});
			
			btnState();
		});
		
		$('#print').on("click", function(){
			print();
		});
		
		$('#nowloadingMsg .btn button').on("click", function(){
			$('#nowloadingMsg').remove();
		});
		
		$(window).resize(selectPrint._nowloadingPosition);
		
	}
};



$(function(){
	
	selectPrint._init();
	
});