/*/////////////////////////////////////////////////////////////////////////////////////////////////
	User's Guide
		Defalt JavaScript
 Modified : 2017-03-03
/////////////////////////////////////////////////////////////////////////////////////////////////*/


/* global textData, cmn, _ua, menu_html, contents, lang, viewFunc */


//ダイアログ起動時の背後コンテンツスクロール値格納用変数
var scrollV = 0,
	dialogCount = 0;

var pageFunc = {
	
	/*
	 * 文言挿入
	 */
	"_insertText": function () {
		$('[data-textname]').each(function(i,e){
			$(e).text(textData[$(e).attr('data-textname')]);
		});
		$('[data-value-textname]').each(function(i,e){
			$(e).val(textData[$(e).attr('data-value-textname')]);
		});
		$('[data-title-textname]').each(function(i,e){
			$(e).attr("title", textData[$(e).attr('data-title-textname')]);
		});
		$('[data-alt-textname]').each(function(i,e){
			$(e).attr("alt", textData[$(e).attr('data-alt-textname')]);
		});
	}
	
	
	/*
	 * transitionLinkのテキスト差し替え
	 */
	,"_transLinkInsertText": function(target){
		if(target.find('p').is('.transitionLink')){
			if(target.find('p.transitionLink').parent().find('.CrossReference').length > 1){
				if(textData.accordionListHere != $('a.transition_link').text()){
					target.find('p.transitionLink').prepend(textData.accordionListTxt);
					target.find('a.transition_link').text(textData.accordionListHere);
				}
			}
		}
	}
	
	/*
	 * 検索窓
	 */
	,"_searchForm": function () {
		if(lang != "ja"){
			$('input#zenHan').prop('disabled', true);
			$('.searchOption .option-zenHan').addClass('hide').remove();
		}
		$('#searchKey')//.attr("placeholder", textData.searchDefTxt)
				.after('<span id="searchBtn"></span>');
		//if(_ua._isIE9){
			if(!$('#searchKey').val()){
				$('#searchKey').val(textData.searchDefTxt);
			}
			$('#searchKey').focus(function(){
				if($(this).val() == textData.searchDefTxt){
					$(this).val('').addClass("keyIn");
				}else{
					$(this).addClass("keyIn");
				}
			}).blur(function(){
				$('#searchKey').val($(this).val().replace(/^\s+/, '').replace(/\s+$/,'').replace(/[　\s]+/g,' '));
				if(!$(this).val()){
					$('#searchKey').val(textData.searchDefTxt).removeClass("keyIn");
				}
			});
		//}

		var sSubmit = function(keyword, form){
			keyword = $.trim(keyword);
			if(keyword == textData.searchDefTxt || !keyword){
				return false;
			}else{
				var fil = [];
				if($('#filter_title').is(':checked')){
					fil.push('t=1');
				}
				var filters = [];
				$('#searchCt input:checked').each(function(){
					filters.push($(this).val());
				});
				if(filters.length){
					fil.push('f=' + filters.join(','));
				}
				if($('#charUpLo').is(':checked')){
					fil.push('ul=1');
				}
				if($('#zenHan').is(':checked')){
					fil.push('zh=1');
				}
				fil = (fil.length) ? "&" + fil.join('&'):'';
				window.location = cmn._searchAction(form.attr('action')) + "?k=" + encodeURIComponent(keyword) + fil;
				return false;
			}
		};
		$('#search #searchBtn').click(function(){ $('#search form').submit(); });
		$('#search form').submit(function(e){
			sSubmit($('#search #searchKey').val(), $('#search form'));
			return false;
		});
	}
	
	
	/*
	 * 検索結果からのハイライト
	 */
	,"_hiligthKeyFunc": function (targetEle) {
		if(/^(id\d\d-|sh\d_|opkey_\d)/.test(_ua._thisFile)){
			if(_ua._get['k']){
				var getKeywordArr = function(inputWord){
					var splitStrBase = '㌀|㌞|㍇|㍧|㍨|㍩|㍪|㍫|㍬|㍭|㍮|㍯|㍰';
					var sep = splitStrBase.split('|');
					var temp = inputWord.match(new RegExp('('+ splitStrBase + ')', "g"));
					if(temp){
						temp = new RegExp('(' + temp.join('|') + ')', "g");
						sep = splitStrBase.replace(/\|/, '').replace(temp, '').split('|');
					}
					var phraseArr = [];
					var temp = inputWord;

					temp = temp.replace(/"([^"]+)"/g, function(a,$1){
						phraseArr.push($1);
						return sep[0];
					});

					var arr = temp.split(/[\s　]+/);

					$.each(arr, function(i,val){
						if(val == void(0)) arr.splice(i,1);
						if(val == sep[0]) {
							arr[i] = phraseArr.shift();
						}
					});

					return arr;
				};

				var keyword = getKeywordArr(_ua._get['k']);
				var UpLo = _ua._get['ul'];
				var ZenHan = _ua._get['zh'];
				for(var i in keyword){
					if(keyword[i]){
						$(targetEle).keyHighlight(keyword[i], { "UpLo": UpLo, "ZenHan": ZenHan });
					}
				}
			}
		}
	}
	
	
	/*
	 * パンくず整形
	 */
	,"_crombsNavi": function () {
		$('#crombsNavi > span:not(.frist)').before('<span class="toPrint">&gt;</span>');
	}
	
	
	/*
	 * グローバルメニュー
	 */
	,"_globalMenu": function () {
		
		//メニューオープン状態判定用フラグ
		var isGNaviOpen = false;
		
		//HTMLセット
		var gmenu = $("<div>" + menu_html.menu_global + "</div>").find('#globalNavi').html();
		$('#navigation').html('<div id="globalNavi">' + gmenu + '</div>');
		
		//整形
		$('#globalNavi li:not(.navi0)').each(function(i,e){
			$(e).find('>h3 span').text($(e).children('.naviList').children('h4:eq(0)').text());
			$(e).children('.naviList:not(#gnavi3_list)').children('h4:eq(0)').remove();
		});
		
		//イベント
		$('#globalNavi li:not(.navi0) h3').on("click", function(e){
			gnaviPullDW(e.target);
		});
		$('#globalNavi li h3').on("mouseenter", function(e){
			if($(e.target).closest('li').is('.navi0')){
				$('#globalNavi li[class^="navi"]').removeClass('open');
			}else{
				if(isGNaviOpen) gnaviPullDW(e.target);
			}
		});
		
		//Fax, PC-Fax, Network のため
		if(/^id\d\d/.test(_ua._thisFile)){
			var tcl = 'navi' + ((_ua._thisFile.split("-",1).join('').replace('id',''))*1);
			var activeGNavi = (/^navi(6|7)$/.test(tcl)) ? $('#globalNavi li.navi3') : $('#globalNavi li.'+ tcl);
			activeGNavi.addClass('active');
		}
		
		//メニュー開閉
		function gnaviPullDW(a){
			var clickLI = $(a).closest('li');
			var siblingsLI = clickLI.siblings('li');
			if(clickLI.is('.open')){
				clickLI.removeClass('open');
				siblingsLI.removeClass('open');
				isGNaviOpen = false;
			}else{
				clickLI.addClass('open');
				siblingsLI.removeClass('open');
				isGNaviOpen = true;
			}
		}
		
		//メニュー閉じ （表示外をクリックしたとき）
		$(document).on('click', function(e) {
			var $clicked = $(e.target);
			if(!$clicked.parents().is("#navigation")){
				$('#globalNavi li[class^="navi"]').removeClass('open');
				isGNaviOpen = false;
			}
		});
		
	}
	
	
	/*
	 * ローカルメニュー
	 */
	,"_leftNavi": function () {
		if(/^id/i.test(_ua._thisFile)){
			
			var loadf = $("<div>" + menu_html['menu_'+_ua._thisId] + "</div>").find('#leftNavi').html();
			$("#leftNavi").html(loadf);
			
			$("#naviTree").before('<div id="naviUtility">'
					+ '<span id="treeControl">'
					+ '<button id="CollapseAll">'+ textData.lnaviCollapseAllTxt +'</button>'
					+ '<button id="ExpandAll">'+ textData.lnaviExpandAllTxt +'</button>'
					+ '</span>'
					+ '</div>');
			if(!/^id15/.test(_ua._thisFile)){
				$("#naviUtility").append('<span><button id="selectPrint">'+ textData.selectPrintTxt +'</button></span>');
			}
			$("#naviUtility button").button();
			
			$("#naviTree ul li a[href$='"+ _ua._thisFile +"']").addClass('selected').closest("li").addClass("selectedList");

			if(/^id14/.test(_ua._thisFile)){
				pageFunc._leftNaviFunc("#naviTree > ul", "full", false);
			}else{
				pageFunc._leftNaviFunc("#naviTree > ul", "full");
			}
			
			//イベント
			$('#selectPrint').on("click", function(){
				w = window.open("selected_print_"+ _ua._thisId +".html", "selected_print", "width=500,height=500,resizable=yes");
				w.focus();
			});
			$("#naviTree ul li a").on({
				"mouseenter":function(e){
					$(e.target).closest("li").addClass("hoverList");
				},
				"mouseleave": function(e){
					$(e.target).closest("li").removeClass("hoverList");
				}
			});
			
		}
	}
	
	
	/*
	 * ローカルメニューツリー作成
	 */
	,"_leftNaviFunc": function(target, level, collapsed){
		var treeLevel = level;
		var strlink = ', .opcl';//文字列も開閉動作させる
		if($(target).is('ul')){
			$(target).addClass('treeview');
		}else{
			$(target).children("ul").addClass('treeview');
		}
		if(collapsed == undefined) collapsed = true;
		var excol = (collapsed)?'expandable':'collapsable';

		if(/[0-9]+/.test(level+"")){
			var tlevel = '';
			for(i=0; i<treeLevel; i++){
				$('ul.treeview > li'+ tlevel).each(function(j,e){
					if($(e).children().is('ul')){
						$(e).children('span').addClass('opcl');
						$(e).addClass(excol).prepend('<div class="hitarea '+ excol +'-hitarea"/>');
					}
				});
				tlevel += '>ul>li';
			}
		}else{
			var cLI = $('.treeview ul').closest("li");
			cLI.addClass(excol).children('span').addClass('opcl');
			cLI.prepend('<div class="hitarea '+ excol +'-hitarea"/>');
		}

		var selmap = $('ul.treeview .selectedList').parents('li.expandable').map(function(){return this;}).get();
		for(i=0,len=selmap.length; i<len; i++){
			$(selmap[i]).removeClass('expandable').addClass('collapsable')
					.children('.hitarea').removeClass('expandable-hitarea').addClass('collapsable-hitarea');
		}
		
		//イベント
		$('.hitarea'+ strlink).on("click", function(e){
			var taLI = $(e.target).closest('li');
			if(taLI.children().is('.expandable-hitarea')){
				taLI.removeClass('expandable').addClass('collapsable')
						.children('div').removeClass('expandable-hitarea').addClass('collapsable-hitarea');
			}else{
				taLI.removeClass('collapsable').addClass('expandable')
						.children('div').removeClass('collapsable-hitarea').addClass('expandable-hitarea');
			}
		});
		$('#ExpandAll').on("click", function(e){
			$('.treeview').find('.expandable').removeClass('expandable').addClass('collapsable')
					.find('.hitarea').removeClass('expandable-hitarea').addClass('collapsable-hitarea');
		});
		$('#CollapseAll').on("click", function(e){
			$('.treeview').find('.collapsable').removeClass('collapsable').addClass('expandable')
					.find('.hitarea').removeClass('collapsable-hitarea').addClass('expandable-hitarea');
		});
	}
	
	
	/*
	 * アラート付き画面遷移
	 */
	,"_transLink": function () {
		$('.container').on('click', "a.transition_link", function(e){
			var _t = $(e.target).closest('.transition_link');
			var val = _t.attr('href').split('#');
			
			if(confirm(textData.confirmLinkTxt)){
				//OK押下時の処理
				setTimeout(function(){
					location.href = val[0];
				}, 0);
			}
			return false;
		});
	}
	
	
	/*
	 * ダイアログイベントセット
	 */
	,"_setDialogEvent": function () {
		
		$(document).on('click', "a.CrossReference, .dialog_link", function(e){
			var _t = $(e.target).closest('.CrossReference, .dialog_link');
			var val = _t.attr('href').split('#');
			val = {
				"page": val[0].replace(/\.html?$/, ''),
				"id": val[1]||"page",
				"title": _t.attr('data-link-title'),
				"ovlayLen": $('body > div.ui-widget-overlay').length,
				"inContents": false
			};
			pageFunc._dialog.countJudge(val);
			return false;
		});
		
		//ダイアログコンテンツが既に入っているもの
		$('#opkey .qitem .dc .heading_sub').on("click", function(e){
			var _t = '#contentsOf_' + $(e.target).closest('.dc').attr('id');
			$(_t).addClass('container');
			val = {
				"target": _t,
				"title": $(_t).find('> .heading').text(),
				"ovlayLen": $('body > div.ui-widget-overlay').length,
				"inContents": true//ダイアログコンテンツが既に入っているもの
			};
			pageFunc._dialog.countJudge(val);
			return false;
		});
	}
	
	
	/*
	 * ダイアログ処理
	 */
	,"_dialog": {
			"open": function(val){
				dialogCount++;
				var contentsTarget;

				if(val.inContents){
					contentsTarget = $(val.target);
				}else{
					var _id = val.page +'_'+ val.id +'-'+ dialogCount;
					$('body').append('<div class="dialogContents" id="dialog_'+ _id +'">'
							+ '<div class="container">'
							+ '<div id="'+ _id +'_load"></div>'
							+ '</div></div>');
					contentsTarget = $('#'+ _id +'_load');
					//if(contents[val.page]){
						var loadPage = $("<div>"+ contents[val.page].contents +"</div>");
						var loadElm = (val.id == 'page') ? '.page' : '#'+ val.id;
						var targetClass = loadPage.find(loadElm).attr('class');
						contentsTarget.html(loadPage.find(loadElm).html()).addClass(targetClass);
					//}else{
					//	contentsTarget.html('Not Found');
					//}
				}

				if(!contentsTarget.find('div.keyPath h5>span').is('.keyPathShow')){
					contentsTarget.find('div.keyPath h5').append('<span class="keyPathShow">&gt;&gt;'+textData.keyPathShow+'</span>');
				}
				
				viewFunc._removeThead();
				
				//transitionLinkのテキスト差し替え
				pageFunc._transLinkInsertText(contentsTarget);

				var dtitle = val.title;
				dtitle = dtitle.split("&apos;").join("&#039;");
				dtitle = dtitle.split("'").join("&#039;");
				dtitle = dtitle.split("&quot;").join("&#034;");
				dtitle = dtitle.split('"').join("&#034;");
				
				var notContentsHeight = 0;
				var dialogHeight = function(_this){
					var ui_dialog = $(_this).closest('.ui-dialog');
					notContentsHeight += ui_dialog.children('.ui-dialog-titlebar').outerHeight(true)
							+ ui_dialog.children('.thisPrint.Item').outerHeight(true)
							+ ui_dialog.children('.ui-dialog-buttonpane').outerHeight(true)
							+ ( ui_dialog.children('.ui-dialog-content').outerHeight(true)
								- ui_dialog.children('.ui-dialog-content').outerHeight()
							);
				};
				
				
				var dialogProperty = {
					"modal": true,
					"title": dtitle,
					"width": 710,
					"height": 550,
					"maxHeight": $(window).height() - 100,
					"maxWidth": 1000,
					"buttons": [{
							"text": textData.closeTxt,
							"click": function(){
								pageFunc._dialog.close(this, val.inContents);
							}
					}],
					"open": function(event, ui){
						$(this).before('<div class="thisPrint Item dialogPbtn"><button>' + textData.qaPrintTxt + '</button></div>');
						$(this).scrollTop(0);
						$('#documentBody').addClass('openDialogPrintHide');
						$('body > .ui-dialog:visible').addClass('openDialogPrintHide');
						$(this).parent().removeClass("openDialogPrintHide");
						$('body > .ui-widget-overlay:not(:last)').removeClass('overlayOn');
						$('body > .ui-widget-overlay:last').addClass('overlayOn');
						var di = val.ovlayLen;
						$(this).parent().css({
							"top": (($(this).parent().css('top').match(/[0-9]+/) * 1) + (5 * di)) + 'px',
							"left": (($(this).parent().css('left').match(/[0-9]+/) * 1) + (5 * di)) + 'px'
						});
						if(val.inContents) contentsTarget.find('> .heading').hide();
						
						dialogHeight(this);
						
					},
					"resize": function(event, ui){console.log(ui.size.height +"-"+ notContentsHeight);
						$(this).css({
							"height": ui.size.height - notContentsHeight
						});
					},
					"resizeStop": function(event, ui){console.log(ui);
						$(this).parent().css({
							'position': 'fixed',
							'top': ($(this).parent().css('top').match(/[0-9]+/)*1) - $(document).scrollTop() + 'px',
							'left': ($(this).parent().css('left').match(/[0-9]+/)*1) - $(document).scrollLeft() + 'px'
						});
					},
					"close": function(event, ui){
						pageFunc._dialog.close(this, val.inContents);
					}
				};

				if (_ua._isMobile) {
					//一個目のダイアログ起動時の背後コンテンツスクロール値を取得
					if ($('.ui-dialog').length < 1) {
						scrollV = $(window).scrollTop();
					}
					dialogProperty.width = '100%';
					if($(window).height() > $(window).width()){
						//縦表示の場合
						dialogProperty.height = $(window).height();
					}else{
						//横表示の場合
						dialogProperty.height = $(window).height()-15;
					}
					dialogProperty.position = [0, 0];
					dialogProperty.draggable  = false;
					dialogProperty.resizable = false;
					dialogProperty.open = function (event, ui) {
						$(this).parent().css({
							"top": 0,
							"left": 0
						});
						$('#documentBody').css({
							"top": "-"+ scrollV + "px",
							"position": "fixed",
							"visibility": "hidden"
						});
					};
				} else {
					/* ダイアログ表示時、後ろコンテンツのスクロール防止 */
					if ($('.ui-dialog').length < 1) {
						scrollV = $(window).scrollTop();
					}
					$('#documentBody').css({
						"top": "-"+ scrollV + "px",
						"position": "fixed",
						"left": "50%",
						"marginLeft": "-" + ($('#documentBody').width() / 2) +"px"
					});
				}

				if(val.inContents){
					contentsTarget.dialog(dialogProperty);
				}else{
					$('#dialog_'+ _id).dialog(dialogProperty);
				}
			}

			,"close": function(t, inContents){
				$(t).dialog("destroy");
				if(!inContents) $(t).remove();
				dialogCount--;
				if(!$('body > div').is('.ui-widget-overlay')){
					$("#documentBody").removeClass("openDialogPrintHide");
				}
				var zi = 1000;
				$('body > div.ui-dialog').each(function(i,e){
					zi = ($(e).css('z-index') <= zi) ? zi : $(e).css('z-index') ;
				});
				$('body > div.ui-dialog').each(function(i,e){
					if($(e).css('z-index') == zi){
						$(e).removeClass("openDialogPrintHide");
					}
				});
				$('body > .ui-widget-overlay:not(:last)').removeClass('overlayOn');
				$('body > .ui-widget-overlay:last').addClass('overlayOn');
				if (_ua._isMobile) {
					//タブレットのダイアログclose時の処理
					//ダイアログが0になったら背後コンテンツを元の状態に戻す
					if ($('.ui-dialog').length < 1) {
						$('#documentBody').css({
							"position": "static",
							"visibility": "visible"
						});
						$(window).scrollTop(scrollV);
					}
				} else {
					if ($('.ui-dialog').length < 1) {
						$('#documentBody').css({
							"position": "",
							"top": "",
							"left": "",
							"marginLeft": ""
						});
						$(window).scrollTop(scrollV);
					}
				}
			}
		
			,"countJudge": function(val){
				if(val.ovlayLen == 5){
					//5枚目以降ダイアログを表示する場合、コンファームウィンドウ表示、OK押下でさらにダイアログを表示
					if(confirm(textData.dialogConfirmTxt)){
						pageFunc._dialog.open(val);
					}
				}
				//ダイアログ10枚以上***************
				else if(val.ovlayLen > 9){
					alert(textData.dialogNotOpenTxt);
				}
				//ダイアログ4枚までと6～9枚***************
				else{
					pageFunc._dialog.open(val);
				}
			}
		
	}
	
	
	
	
	
	/*
	 * アコーディオン
	 */
	,"_accordion": function () {
		
		//目的から探すのみスクリプトでid付与(IDがない場合のみ)
		$('#opkey .qitem2').each(function(i,e){
			if(!$(e).attr('id')) $(e).attr('id', 'qitem'+ i);
		});

		var btnvalue = $('<div>'
				+ '<div class="thisPrint Item">'
				+ '<button class="disDetail" disabled="disabled"></button>'
				+ '<button class="QaPrint">' + textData.qaPrintTxt + '</button>'
				+ '</div>'
				+ '</div>');
		
		$('#opkey .qitem2 .answer').each(function(i,e){
			if($(e).find('.thisPrint.Item').length < 1){
				if($(e).find('.transitionLink').length){
					btnvalue.find('.QaPrint').addClass('disQaPrint').removeClass('QaPrint');
					
					//transitionLinkのテキスト差し替え
					pageFunc._transLinkInsertText($(e));
				}
				if($(e).children().is('.accordion_contents')){
					$(e).children('.accordion_contents').append(btnvalue.html());
				}else{
					$(e).append(btnvalue.html());
				}
			}
		});
		$('#faq .answer, #opkey .answer').after('<div class="af"></div>');
		$('#faq, #opkey').accordion({
			"header": 'h4',
			"heightStyle": "content",
			"active": false,
			"collapsible": true,
			"activate": function(event, ui){
				var _hash = $(ui.newHeader).parent().attr('id');
				if(_hash){
					location.href = '#'+_hash;
				}
			}
		});
		


		//検索結果からアコーディオンページに遷移した際アコーディオンを開いた状態で遷移
		setTimeout(function(){
			if(/#qitem/.test(_ua._thisHash)){
				$(_ua._thisHash + ">h4").click();
			}
		},0);
		
		
	}
	
	
	/*
	 * プリント
	 */
	,"_printfnc": function () {
		//viewFunc._removeThead();//IE8のTHEAD削除
		///setTimeout(function(){
			print();
		//},500);
	}
	
	
	/*
	 * 目的からさがす
	 */
	,"_sh3": function () {
		if(_ua._thisFile.match(/^sh3_/)){
			$("#naviTree").addClass('sh3').find("li > ul").prev('span').children('a').addClass('onlink');
			$("#naviTree ul li a[href$='"+_ua._thisFile+"']").addClass('selected').closest("li").addClass("selectedList");
			pageFunc._leftNaviFunc("#naviTree > ul", "full");
			if($('#container #opkey > h1').length > 1){
				$('#container').prepend('<h1>' + $("#crombsNavi span:last-child").text() + '</h1>');
				$('#container #opkey > h1').each(function(i){
					var j = (i)? '' : ' first';
					$(this).replaceWith('<h2 class="originH1'+j+'">'+ $(this).text() +'</h2>');
				});
			}
		}
	}
	
	
	/*
	 * コスト削減
	 */
	,"_sh4": function () {
		if(_ua._thisFile.match(/^sh4_/)){
			$("#naviTree ul li a[href$='"+_ua._thisFile+"']").addClass('selected').parent("span").addClass("selectedList");
			$('.dcbtn').append('<a class="QaPrint"></a>');
			$('#csCommonA .answer').after('<div class="af"></div>');
			$('#csCommonA').accordion({
				"header": 'h4',
				"heightStyle": "content",
				"active": false,
				"collapsible": true
			});
		}
	}
	
	
	/*
	 * セキュリティー向上
	 */
	,"_sh5": function () {
		if(/^sh5_/.test(_ua._thisFile)){
			$("#naviTree ul li a[href$='"+_ua._thisFile+"']").addClass('selected').closest("li").addClass("selectedList");
			$('.dcbtn').append('<a class="QaPrint"></a>');
			$('#csCommonA .answer').after('<div class="af"></div>');
			$('#csCommonA').accordion({
				"header": 'h4',
				"heightStyle": "content",
				"active": false,
				"collapsible": true
			});
		}
	}
	
	
	/*
	 * 設定キーの説明 キーパスの表示非表示
	 */
	,"_keyPathShowHide": function () {
		$('div.keyPath h5').append('<span class="keyPathShow">&gt;&gt;'+textData.keyPathShow+'</span>');
		$(document).on("click", "div.keyPath span.keyPathShow", function(e){
			$(e.target).closest('h5').next('.keyPathList').toggle();
		});
	}
	
	
	/*
	 * 機能 / 設定キーの説明
	 */
	,"_opkey": function () {
		if(/^opkey_/.test(_ua._thisFile)){
			
			//検索フォーム
			(function(){
				//$('#op_searchKey').attr("placeholder", textData.opSearchDefTxt);
				//if(_ua._isIE9){
					if(!$('#op_searchKey').val()){
						$('#op_searchKey').val(textData.opSearchDefTxt);
					}
					$('#op_searchKey').focus(function(){
						if($(this).val() == textData.opSearchDefTxt){
							$(this).val('').addClass("keyIn");
						}else{
							$(this).addClass("keyIn");
						}
					})
					.blur(function(){
						$('#op_searchKey').val($(this).val().replace(/^\s+/, '').replace(/\s+$/,'').replace(/[　\s]+/g,' '));
						if(!$(this).val()){
							$('#op_searchKey').val(textData.opSearchDefTxt).removeClass("keyIn");
						}
					});
				//}

				$('#op_searchBtn').on("click", function(){
					$('#opkeySearch form').submit();
				});
				$('#opkeySearch form').on("submit", function(){
					var val = $('#op_searchKey').val();
					if(val){
						window.location =  cmn._searchAction($('#opkeySearch form').attr('action')) + "?k=" + encodeURIComponent(val);
					}
					return false;
				});
			}());
			
			//ローカルナビ
			(function(){
				$('#leftNavi').html(menu_html.menu_opkey);

				$("#leftNavi ul.opkeyTreeview").addClass('treeview')
						.find("a[href$='"+ _ua._thisFile +"']").addClass('selected')
						.closest("li").addClass("selectedList");

				$('ul.treeview li').each(function(i,e){
					if($(e).children().is('ul')){
						$(e).children('span').addClass('opcl');
						$(e).addClass('expandable').prepend('<div class="hitarea expandable-hitarea"/>');
					}
				});
				var selmap = $('ul.treeview .selectedList').parents('li.expandable').map(function(){return this;}).get();
				for(i=0,len=selmap.length; i<len; i++){
					$(selmap[i]).removeClass('expandable').addClass('collapsable')
							.children('.hitarea').removeClass('expandable-hitarea').addClass('collapsable-hitarea');
				}
				$('.selectedList > .hitarea').removeClass('expandable-hitarea').addClass('collapsable-hitarea');
				$('.selectedList li.expandable > .hitarea').removeClass('expandable-hitarea').addClass('collapsable-hitarea');
				$('.selectedList').removeClass('expandable').addClass('collapsable')
						.find('li.expandable').removeClass('expandable').addClass('collapsable');

				$('.hitarea').on("click", function(e){
					var hit = $(e.target).closest(".hitarea");
					if(hit.is('.expandable-hitarea')){
						hit.removeClass('expandable-hitarea').addClass('collapsable-hitarea')
								.closest('li').removeClass('expandable').addClass('collapsable');
					}else{
						hit.removeClass('collapsable-hitarea').addClass('expandable-hitarea')
								.closest('li').removeClass('collapsable').addClass('expandable');
					}
				});
				
				$("#leftNavi ul.opkeyTreeview .opcl > a[href]").on({
					"mouseenter": function(e){
						$(e.target).closest('.opcl').addClass('hover');
					},
					"mouseleave": function(e){
						$(e.target).closest('.opcl').removeClass('hover');
					}
				});
				
			}());
		}
	}
	
	
	/*
	 * イラスト検索
	 */
	,"_illustSearch": function () {
		
		var isChengeItem = function(gp){
			$('#isItem > .pegeBreak').remove();
			$('#isItem > div').each(function(i,e){
				if($(e).is('.' + gp)){
					$(e).show();
				}else{
					$(e).hide();
				}
			});
			var fp, op;
			if(/^(ja|zh)/i.test(lang)){
				fp = 6;
				op = 8;
			}else{
				fp = 5;
				op = 7;
			}
			$('#isItem > div:visible').each(function(i,e){
				if( i == fp || ( i > fp && ( i - fp ) % op == 0 ) ){
					$(e).after("<div class='pegeBreak'>&nbsp;</div>");
				}
			});
		};
		
		if($('#contents #illustSearch').length){
			$('body').addClass('c1style');
			$('#searchType li .navi1').closest('li').addClass('active');
			
			isChengeItem('is1');
			
			$('#searchType > ul > li > span').on("click", function(e){
				var _t = $(e.target).closest('span');
				$('#searchType li').removeClass('active');
				_t.closest('li').addClass('active');
				_t.attr('class').match(/(^|\s+)(navi)(\d+)(\s+|$)/);
				isChengeItem('is' + RegExp.$3);
			});
			
			$('#isItem .item a.dialog_link').off().on('click', function(e){
				e.preventDefault();
			});
			
			$('#isItem .item').on("click", function(e){
				var _t = $(e.target).closest('.item').find('.dialog_link');
				var val = _t.attr('href').split('#');
				val = {
					"page": val[0].replace(/\.html?$/, ''),
					"id": val[1]||"page",
					"title": _t.attr('data-link-title'),
					"ovlayLen": $('body > div.ui-widget-overlay').length,
					"inContents": false
				};
				pageFunc._dialog.countJudge(val);
				return false;
			});
		}
	}
	
	
	/*
	 * 印刷ボタン
	 */
	,"_setPrintBtn": function () {
		if($('#container').find('#faq, #opkey').length){
			if(!/^sh3_/.test(_ua._thisFile)){
				$('#opkey .qitem > div.answer').each(function(i,e){
					if($(e).children('div').is('.dc')){
						$(e).find('> .dc > p > .heading_sub').text(textData.detailPrintTxt)
								.after('<span class="QaPrint"></span>');
					}else{
						$(e).append('<div class="thisPrint Item">'
								+ '<button class="disDetail" disabled="disabled"></button>'
								+ '<button>' + textData.qaPrintTxt + '</button></div>');
						if(!$(e).is(':has(div[class=keyPath])')){
							if($(e).is(':has(div[class!=firstp] > a.dialog_link)')){
								$(e).find("> .thisPrint > button:eq(1)").addClass('disQaPrint')
										.attr('disabled',"disabled");
							}
						}
					}
				});
			}
		}else{
			$('#container').prepend('<div id="thisPagePrint" class="thisPrint"><button>' + textData.pagePrintTxt + '</button></div>');
		}
		
		$('#illustSearch').prepend('<div id="thisPagePrint" class="thisPrint"><button>' + textData.pagePrintTxt + '</button></div>');
		
		$(document).on('click', ".thisPrint button:not(.disQaPrint),.dcbtn .QaPrint,.dc .QaPrint", function(){
			pageFunc._printfnc();
			return false;
		});
		
		
	}
	
	
	/*
	 * #documentBodyのmin-heightをウインドウ高にする
	 */
	,"_documentBodyHeight": function () {
		var documentBodyHeight = function(){
			$("#documentBody").css('min-height',  'auto');
			var margin = $("#documentBody").outerHeight(true) - $("#documentBody").height();
			$("#documentBody").css('min-height',  ($(window).height() - margin)  + 'px');
		};
		documentBodyHeight();
		$(window).on("resize", function(){
			documentBodyHeight();
		});
	}
	
	
	/*
	 * ページトップへ
	 */
	,"_returnToTop": function () {
		$('#documentBody').append('<div id="returnToTop"><span title="' + textData.returnToTopTxt + '"></span></div>');
		$('#returnToTop span').click(function(){
			$(document).scrollTop(0);
		});
	}
	
	
	/*
	 * 
	 */
	,"_bugsFixed": {
		"safari_printScroll": function(){
			if(_ua._isSafari){
				//印刷時のスクロール位置変化吸収
				var winScrl = 0,
					printEnd = false,
					printStart = false,
					afterSet = false;
				$(window).on("scroll", function(e){
					//console.log('scroll : '+ printEnd +' : '+ $('html').height());
					if(printStart){
						afterSet = true;
					}
					if(printEnd){
						$(window).scrollTop(winScrl);
						printEnd = false;
					}
				});
				var mousewheelevent = 'onwheel' in document ? 'wheel' : 'onmousewheel' in document ? 'mousewheel' : 'DOMMouseScroll';
				$(document).on(mousewheelevent + " mousedown keydown", function(e){
					printEnd = false;
				});
				
				if('matchMedia' in window){
					window.matchMedia('print').addListener(function(mql){
						if(mql.matches){
							//console.log('Start Print' +' : '+ $('html').height());
							winScrl = $(window).scrollTop();
							printStart = true;
							printEnd = false;
						}else{
							//console.log('End Print' +' : '+ $('html').height());
							printStart = false;
							printEnd = true;
							if(afterSet){
								$(window).scrollTop(winScrl);
								afterSet = false;
							}
							
						}
					});
				}
			}
		}
	}
	
	
};









$(function(){
	
	//見た目の調整
	viewFunc._removeThead();
	viewFunc._printClass();
	
	
	// 文言挿入
	pageFunc._insertText();
	
	//検索窓
	pageFunc._searchForm();
	
	//パンくず整形
	pageFunc._crombsNavi();
	
	//グローバルメニュー
	pageFunc._globalMenu();
	
	//ローカルメニュー
	pageFunc._leftNavi();
	
	//検索結果からページへ遷移したときキーをハイライト
	pageFunc._hiligthKeyFunc('#container div.page, #opkey, #opkeyContents, #csCommonA');
	
	//ダイアログのイベントをセット
	pageFunc._setDialogEvent();
	
	//アコーディオン
	pageFunc._accordion();
	
	//アラート付き画面遷移(「メインページに切替え」)
	pageFunc._transLink();
	
	//設定キーの説明 キーパスの表示非表示
	pageFunc._keyPathShowHide();
	
	//機能 / 設定キーの説明
	pageFunc._opkey();
	
	//目的からさがす
	pageFunc._sh3();
	
	//コスト削減
	pageFunc._sh4();
	
	//セキュリティー向上
	pageFunc._sh5();
	
	//イラスト検索
	pageFunc._illustSearch();
	
	//印刷ボタン
	pageFunc._setPrintBtn();
	
	//#documentBodyのmin-heightをウインドウ高にする
	//pageFunc._documentBodyHeight();
	
	//ページトップへ
	pageFunc._returnToTop();
	
	//
	pageFunc._bugsFixed.safari_printScroll();
	
});








