/*/////////////////////////////////////////////////////////////////////////////////////////////////
	User's Guide
	TOP Page Only
	Modified : 2017-03-03
/////////////////////////////////////////////////////////////////////////////////////////////////*/

/* global textData, cmn, lang, reqImage, menu_html, _ua */

var topFunc = {
	
	/*
	 * 文言挿入
	 */
	"_insertText": function () {
		$('#featuresMain h3').each(function(i,e){
			var id = $(e).attr('id');
			if(id){
				var idNum = id.replace(/^navi(\d+)$/, '$1');
				$(e).attr('title', textData["topNavi" + idNum + "AttrTitleTxt"]).children('a').text(textData["topNavi" + idNum + "Txt"]);
			}
		});
		$('[data-textname]').each(function(i,e){
			$(e).text(textData[$(e).attr('data-textname')]);
		});
		$('[data-value-textname]').each(function(i,e){
			$(e).val(textData[$(e).attr('data-value-textname')]);
		});
		$('[data-title-textname]').each(function(i,e){
			$(e).attr("title", textData[$(e).attr('data-title-textname')]);
		});
		$('[data-alt-textname]').each(function(i,e){
			$(e).attr("alt", textData[$(e).attr('data-alt-textname')]);
		});
	}
	
	
	/*
	 * コンテンツ領域高さ確保
	 */
	,"_winHeight": function () {
		var wh = function () {
			$('#contents').height('auto');
			var cp = $('#contents').outerHeight(true) - $('#contents').height();
			if($("#documentBody").height() <= $(window).height()){
				$('#contents').height($(window).height() - $('#header').outerHeight(true) - cp);
			}
		};
		wh();
		$(window).resize(wh);
	}
	
	
	/*
	 * ツールナビ
	 */
	,"_toolNavi": function () {
		$('#toolNavi > ul > li').each(function(i,e){
			var loadf = menu_html['top_menu_id' + cmn._initAlign($(e).children('h4').attr('id').slice(4), 2)];
			if(loadf){
				loadf = $(loadf);
				$(e).children('h4').after('<div class="naviList">' + loadf.find('#naviTree').html() + '</div>');
			}
			
		});
		
		$('#toolNavi > ul > li:last-child .naviList').addClass('last');

		$('#toolNavi > ul > li > h4').on("click", function(e){
			var target = $(e.target).closest('h4');
			if(target.is(':has(a[href])')){
				$("#toolNavi .naviList").removeClass("openList");
				location.href = target.find('a').attr('href');
			}else{
				$('#toolNavi > ul > li .naviList').each(function(i,e){
					if($(e).is(":not(.openList)") && $(e).prev('h4')[0].id == target[0].id){
						$(e).addClass("openList");
					}else{
						$(e).removeClass("openList");
					}
				});
			}
		});
		
		//メニュー閉じ （表示外をクリックしたとき）
		$(document).on('click', function(e){
			var $clicked = $(e.target);
			if(!$clicked.parents().is("#toolNavi")){
				$("#toolNavi .naviList").removeClass("openList");
			}
		});
	}
	
	
	/*
	 * 検索窓
	 */
	,"_searchForm": function () {
		if(lang != "ja"){
			$('input#zenHan').prop('disabled', true);
			$('.searchOption .option-zenHan').addClass('hide').remove();
		}
		$('#searchKey')//.attr("placeholder", textData.searchDefTxt)
				.after('<span id="searchBtn"></span>');
		
		//if(_ua._isIE9){
			if(!$('#searchKey').val()){
				$('#searchKey').val(textData.searchDefTxt);
			}
			$('#searchKey')
				.focus(function(){
					if($(this).val() == textData.searchDefTxt){
						$(this).val('').addClass("keyIn");
					}else{
						$(this).addClass("keyIn");
					}
				})
				.blur(function(){
					$('#searchKey').val($(this).val().replace(/^\s+/, '').replace(/\s+$/,'').replace(/[　\s]+/g,' '));
					if(!$(this).val()){
						$('#searchKey').val(textData.searchDefTxt).removeClass("keyIn");
					}
				}
			);
		//}

		$('#searchBtn').click(function(){ $('#search form').submit(); });
		$('#search form').submit(function(){

			//New Search-------
			var keyword = $.trim($('#searchKey').val());
			if(keyword == textData.searchDefTxt || !keyword){
				return false;
			}else{
				var fil = [];
				if($('#charUpLo').is(':checked')){
					fil.push('ul=1');
				}
				if($('#zenHan').is(':checked')){
					fil.push('zh=1');
				}
				fil = (fil.length) ? "&" + fil.join('&'):'';
				window.location = cmn._searchAction($('#search form').attr('action')) + "?k=" + encodeURIComponent(keyword) + fil;
				return false;
			}
			//----------

		});
	}
	
	
	/*
	 * 
	 */
	,"_featuresMain": function () {
		//ホバー
		$('#featuresNavi #featuresMain h3').hover(function(){
				$('#featuresNavi #featuresMain h3').removeClass('hover');
				$(this).addClass('hover'); 
			}, function(){
				$(this).removeClass('hover');
			}
		);
	}
	
	
	/*
	 * 多言語 ＆ モデル振り分け処理
	 */
	,"_modelLangLink": function () {
		
		var multiLangProcess = function (){
			if(init){
				var langPack, hitKey=[], indiLang=[], appImg=[];
				var loopCount = 200;
				var thisDir = document.location.pathname.replace(/file:\/\/+/i, "").replace(/\\/g, "/").split('/').slice(-2).join('').replace(/index\.html?.*$/, "");

				var re = new RegExp('(^|-)'+lang.substr(0,2)+'(-|$)','i');

				for(var key in init){
					if(re.test(key)){
						langPack = langPack||key;
					}
					for(var langObj in init[key]){
						appImg.push(init[key][langObj].dir);
					}
				}
				init = init[langPack];
				appImg = cmn._uniqueArray(appImg);
				for(var i in appImg){
					var src = '../' + appImg[i] + reqImage;
					var img = new Image();
					img.id = appImg[i];
					img.onload=function(){
						indiLang.push(this.id);
					};
					img.src = src;
				}

				var langlinkDisplay = function(){
					for(var key in init){
						var reg = new RegExp('(^| )'+key+'( |$)','i');
						if(init[key].dir == thisDir){
							hitKey.push(new Array(true, init[key].dir, init[key].txt));
						}else{
							if(reg.test(indiLang.join(' '))){
								hitKey.push(new Array(false, init[key].dir, init[key].txt));
							}
						}
					}
					hitKey = cmn._uniqueArray(hitKey);
					if(hitKey.length == 2){
						var langLink = [];
						for(var i in hitKey){
							if(hitKey[i][0]){
								langLink.push('<span class="active">'+ hitKey[i][2] +'</span>');
							}else{
								langLink.push('<span><a href="../'+hitKey[i][1]+'/index.html">'+hitKey[i][2]+'</a></span>');
							}
						}
						langLink = '<div id="lang">' + langLink.join(' | ') + '</div>';
					}else if(hitKey.length > 2){
						var langLink = '';
						for(var i in hitKey){
							var ck = (hitKey[i][0]) ? ' selected="selected"' : '' ;
							langLink += '<option value="'+hitKey[i][1]+'"'+ck+'>'+hitKey[i][2]+'</option>\n';
						}
						langLink = '<div id="lang"><select>'+ langLink +'</select></div>';
					}
					$('#header').prepend(langLink);

					$('#lang select').change(function(){
						location.href = '../'+ $("#lang select :selected").val() +'/index.html';
					});
				};

				var folderSearch = function(){
					if(indiLang[1]){
						langlinkDisplay();
					}else{
						if(loopCount>0){
							loopCount--;
							setTimeout(function(){ folderSearch(); }, 20);
						}
					}
				};
				folderSearch();

			}
		};

		var condiMultiLangProcess = function(){
			if(init){
				var active;
				var existenceObj = JSON.parse(JSON.stringify(init));
				var langDirLen = Object.keys(init).length;
				var pathname = document.location.pathname.replace(/\\/g, "/");
				var checkLen = 0;
				
				var langlinkDisplay = function(checkLen){
					if(checkLen == langDirLen){
						var langCount = Object.keys(existenceObj).length;
						var langLink = [];
						if(langCount == 2){
							for(var key in existenceObj){
								if(active == key){
									langLink.push('<span class="active">'+ existenceObj[key].txt +'</span>');
								}else{
									langLink.push('<span><a href="../../'+ existenceObj[key].dir +'/index.html">'+ existenceObj[key].txt +'</a></span>');
								}
							}
							langLink = '<div id="lang">' + langLink.join(' | ') + '</div>';
						}else if(langCount > 2){
							for(var key in existenceObj){
								var ck = (active == key) ? ' selected="selected"' : '' ;
								langLink.push('<option value="'+ existenceObj[key].dir +'"'+ ck +'>'+ existenceObj[key].txt +'</option>');
							}
							langLink = '<div id="lang"><select>'+ langLink.join('') +'</select></div>';
						}
						$('#header').prepend(langLink);

						$('#lang select').on("change", function(){
							location.href = '../../'+ $("#lang select :selected").val() +'/index.html';
						});
					}
				};
				
				for(var key in init){
					if(!active && new RegExp('/'+ init[key].dir +'/').test(pathname)){
						active = key;
					}
					
					var src = '../../' + init[key].dir + reqImage;
					var img = new Image();
					img.id = key;
					img.onload = function(){
						langlinkDisplay(++checkLen);
					};
					img.onerror = function(){
						delete existenceObj[this.id];
						langlinkDisplay(++checkLen);
					};
					img.src = src;
				}
				
			}
		};

		var modelSelectProcess = function (){
			$('#header').prepend('<div id="lang"><span><a href="../../index.html">'+ textData.modelSelect +'</span></div>');
		};

		var multiLangBtn = false;
		var condiMultiLangBtn = false;
		var modelSelectBtn = false;

		var judgCount = 3;
		var judg = function (){
			judgCount--;
			if(judgCount <= 0){

				if(modelSelectBtn){
					modelSelectProcess();
				}
				else if(condiMultiLangBtn){
					window.multiLangProcess = condiMultiLangProcess;
					var script = document.createElement('script');
					script.type = 'text/javascript';
					script.src = "../../common/_init.js";
					var head = document.getElementsByTagName('head')[0];
					head.appendChild(script);
				}
				else if(multiLangBtn){
					window.multiLangProcess = multiLangProcess;
					var script = document.createElement('script');
					script.type = 'text/javascript';
					script.src = "../_init.js";
					var head = document.getElementsByTagName('head')[0];
					head.appendChild(script);
				}
				$('#mlJudg').remove();
				$('#coMlJudg').remove();
				$('#modelSelectJudg').remove();
			}
		};

		$('body').append('<img id="mlJudg"><img id="coMlJudg"><img id="modelSelectJudg">');

		$('#mlJudg').on("load", function(){
			multiLangBtn = true;
			judg();
		}).on("error", function(){
			judg();
		}).attr('src','../_.gif');

		$('#coMlJudg').on("load", function(){
			condiMultiLangBtn = true;
			judg();
		}).on("error", function(){
			judg();
		}).attr('src','../../common/_.gif');

		$('#modelSelectJudg').on("load", function(){
			modelSelectBtn = true;
			judg();
		}).on("error", function(){
			judg();
		}).attr('src','../../shared/img/_.gif');

	}
	
	
	/*
	 * 
	 */
	,"_": function () {
		
	}
	
};









$(function(){
	
	//コンテンツ領域高さ確保
	topFunc._winHeight();
	
	//ツールナビ
	topFunc._toolNavi();
	
	//テキストを挿入
	topFunc._insertText();
	
	//検索窓
	topFunc._searchForm();
	
	//メインナビ
	topFunc._featuresMain();
	
	//多言語 ＆ モデル振り分け処理
	topFunc._modelLangLink();





	/* add by a.baba 140227 start タブレット縦横表示切り換え時トップページのheightをリサイズ ///////*/
	if(_ua._isMobile){
		$(window).on('resize scroll', function(){
			$("#documentBody").height($(window).height());
		});
	}
	/* add by a.baba 140227 end ////////////////////////////////////////////////////////////////////////////*/



});//($function()の終了





