/**********************************************
検索に関連したscript
**********************************************/
var searchModal;

$(function () {
    var minwidth = $('#searchKey').width();
    var maxwidth = "100%";

    if ($('#searchKey').val() != '') {
        $('#searchKey').width(maxwidth);
    }

    $("#searchForm").on("click", ".has-children", function () {
        $(this).next().slideToggle();
    });

    //検索BOXクリック時のトグルメニューの開閉イベント
    $("#searchForm").on("click", "a", function () {
        $(".search-box a").removeClass('selected');

        $(this).addClass('selected');

        /*クリックした時、openクラスがあればcloseクラスに変更
            closeクラスだった場合はopenクラスに変更*/
        if ($(this).hasClass('open')) {
            $(this).removeClass('open');
            $(this).addClass('close');
        } else if ($(this).hasClass('close')) {
            $(this).removeClass('close');
            $(this).addClass('open');
        }
    });

    //TextBox値入力時のイベント
    $("#searchKey").on("load input", function () {
        if ($("#searchKey").val() == '') {
            $("#searchKey").width(minwidth);
        } else {
            $("#searchKey").width(maxwidth);
        }
    });

    $(document).click(function (event) {
        // クリックした箇所が、検索ボックス内ではない　かつ　モーダルダイアログ内ではない場合、「絞り込み検索」を閉じる
        // （「絞り込み検索」から表示する「タイトルで絞る」のモーダルダイアログの外側をクリック時に、
        // 「絞り込み検索」を閉じてしまわないために、”モーダルダイアログ内ではない場合”という条件を追加している）
        if ($(event.target).closest("#searchForm").length <= 0 &&
            $(event.target).closest(".remodal-wrapper").length <= 0 &&
            $(event.target).closest("#focusSearchKey").length <= 0) {
            if ($(".search-refine-box").hasClass("open")) {
                $(".search-refine-box").removeClass('open');
                $(".search-refine-box").addClass('close');
                $(".search-refine-box").next().slideToggle();
            }
        }
    });

    //以下ダイアログ内の処理
    //初期設定
    funcSearchDlg._init();
});


/**********************************************
検索ダイアログ関連
**********************************************/
//チェックボックス項目クリック時の処理
$(".child-list > li").on("click", function (e) {
    if ($(this).children("input[type='checkbox']").is(':checked')) {
        $(this).children("input[type='checkbox']").prop('checked', false);
    } else {
        $(this).children("input[type='checkbox']").prop('checked', true);
    }

    toggleHighlightOnChecked("#" + $(this).parent().siblings("a").attr("id"));
});

//チェックボックスをクリックした時の処理
$(".child-list > li > input[type='checkbox']").on('click', function (e) {
    toggleHighlightOnChecked("#" + $(this).parent().parent().prev("a").attr("id"));
    e.stopPropagation();
});

//項目にチェックされているかどうかのクラスを付与
function toggleHighlightOnChecked(itemId) {
    if ($(itemId).next().find("input[type='checkbox']:checked").length > 0) {
        $(itemId).addClass("search-value-selected");
    } else {
        $(itemId).removeClass("search-value-selected");
    }
}

//「タイトルで絞る」のモーダルダイアログ内チェックボックスの処理

//モーダルを開いた時にモーダル自身を保持
$(document).on('opened', '.remodal', function () {
    searchModal = $(this);
});

$(document).on('opening', '.remodal', function () {
    var dataIdVal;

    dataIdVal = $(this).attr("data-remodal-id");
    if (dataIdVal === "title-modal") {
        $('#title_button').removeClass("search-check-selected");

        $('#searchCt label').each(function () {
            if ($(this).hasClass('search-check-selected')) {
                $(this).children('input').prop('checked', true);
                $(this).addClass('search-chk-color');
            } else {
                $(this).children('input').prop('checked', false);
                $(this).removeClass('search-chk-color');
            }
        });
    }
});

$(document).on('confirmation', '.remodal', function () {
    var dataIdVal;

    dataIdVal = searchModal.attr("data-remodal-id");
    if (dataIdVal === "title-modal") {
        $('#searchCt input').each(function () {
            if ($(this).prop('checked')) {
                $(this).parent().addClass("search-check-selected");
            } else {
                $(this).parent().removeClass("search-check-selected");
            }
        });
    }
});

//モーダル内「条件を追加」ボタンクリック時の処理
$(".search-remodal-select-wrapper > button").on("click", function (e) {
    var currentModal = $(this).parents(".remodal");

    if (searchModal.is(currentModal)) {
        if ($(searchModal).find(".remodal-check input[type='checkbox']:checked").length > 0) {
            $("#" + searchModal.attr("data-remodal-id") + "-menu").addClass("search-option-selected");
        } else {
            $("#" + searchModal.attr("data-remodal-id") + "-menu").removeClass("search-option-selected");
        }
    }
});

/**********************************************
検索ダイアログ内処理
**********************************************/

//検索ダイアログ用設定
var search_settings = {
    "filter_elm": "#searchCt",  //「タイトルで絞る」内に表示する項目の要素（PC表示用）
    "filter_elm2": "#searchCt2",    //「タイトルで絞る」内に表示する項目の要素（モバイル表示用）
};

//検索ダイアログ設定（システム用）
var search_conf = {
    "books": books, //ブックの変数
    "keywordData": keyword_data //関連ワードの変数
};

var funcSearchDlg = {
    //初期設定
    "_init": function () {
        $.extend(search_conf, search_settings, {
            "$filter": $(search_settings.filter_elm),
            "$filter2": $(search_settings.filter_elm2),
            "sData": getParamData
        });

        search_conf.sData.p = search_conf.sData.p || 1;
        search_conf.sData.pc = search_conf.sData.pc || 1;

        //絞り込みリスト作成
        funcSearchDlg._setFilterHtml();

        //イベントセット
        funcSearchDlg._setEvent();

        //モバイル版絞り込み検索
        if (search_conf.sData.m) {
            $("#search-mobile-body").slideToggle();
            if ($("#search-menu-mobile-anchor").children("i").hasClass("fa-chevron-down")) {
                $("#search-menu-mobile-anchor").children("i")
                    .removeClass("fa-chevron-down")
                    .addClass("fa-chevron-up");
            }

            if (search_conf.sData.k) {
                $("#searchKey2").val(search_conf.sData.k);
            }

            return;
        }
    },
    //GETデータ取得
    "_getGetData": function () {
        var get = {};
        var data = window.location.search.replace(/^\?/, '').split('&');

        for (var i in data) {
            temp = decodeURIComponent(data[i]).split('=');

            ak = temp[0];
            temp.shift();
            get[ak] = temp.join('=');
        }

        return get;
    },
    //絞り込み項目をセット
    "_setFilterHtml": function () {
        //絞り込み項目生成
        ///////////////////////////////////////////////////////////////////////////////////////
        var title = search_conf.books[0].group;
        var groupFilter = [];
        var chapFilter = [];

        $.each(search_conf.books, function (i, v) {
            //グループが変わったら書き出し、リセット
            if (title != v.group) {
                var titlehtml = '';

                titlehtml = '<p class="search-remodal-title';

                if (title != "") {
                    titlehtml += " guideTitle";
                }

                titlehtml += '">' + title + '</p>';

                groupFilter.unshift('<div class="search-col1">');
                groupFilter.push('</div>');

                chapFilter.push(titlehtml + '<div class="search-remodal-item-wrapper');
                if (title != "") {
                    chapFilter.push(' guideStyle');
                }

                chapFilter.push('">' + groupFilter.join('') + "</div>");
                title = v.group;
                groupFilter.length = 0;
            }

            var commaPoint = v.book_key.indexOf(',');

            if (commaPoint > 0) {
                var array = v.book_key;
                var str = array.split(',');
                var nameVal = str[0];

                groupFilter.push('<div class="search-remodal-item1"><label>'
                    + '<input type="checkbox" name="' + nameVal + '" value="' + v.book_key + '">'
                    + '<p>' + v.bookname + '</p></label>' + '</div>');
            } else {
                groupFilter.push('<div class="search-remodal-item1"><label>'
                    + '<input type="checkbox" name="' + v.book_key + '" value="' + v.book_key + '">'
                    + '<p>' + v.bookname + '</p></label>' + '</div>');
            }
        });

        var titlehtml = '';
        titlehtml = '<p class="search-remodal-title';

        if (title != "") {
            titlehtml += " guideTitle";
        }

        titlehtml += '">' + title + '</p>';
        groupFilter.unshift('<div class="search-col1">');
        groupFilter.push('</div>');
        chapFilter.push(titlehtml + '<div class="search-remodal-item-wrapper');

        if (title != "") {
            chapFilter.push(' guideStyle');
        }

        chapFilter.push('">' + groupFilter.join('') + "</div>");

        search_conf.$filter.html(chapFilter.join(''));
        search_conf.$filter2.html(chapFilter.join(''));

        //絞り込みのチェック付加
        ///////////////////////////////////////////////////////////////////////////////////////
        if (search_conf.sData.f) {
            $.each(search_conf.sData.f.split(','), function (i, v) {
                $('input[name=' + v + ']').prop('checked', true);
                $('#searchCt2 input:checked').each(function () {
                    $(this).parent().addClass("search-value-selected");
                    $(this).addClass("initial");
                });
                $('#searchCt input:checked').each(function () {
                    $(this).parent().addClass("search-check-selected");
                    $(this).addClass("initial");
                });
                $('#title-modal-menu').addClass("search-value-selected");
                $('#title-checklist-toggler').addClass("search-value-selected");
                $('#all-clear-button').addClass("search-value-selected");
                $('#searchSubmit').addClass("search-value-selected");
            });
        }

        //チェックボックスの設定
        ///////////////////////////////////////////////////////////////////////////////////////
        if (search_conf.sData.w) {
            $.each(search_conf.sData.w.split(','), function (i, v) {
                //チェックボックスのチェック
                $('input[name=' + v + ']').prop('checked', true);
            });
        }

        if (search_conf.sData.k) {
            //検索オプションが有効である場合はボタンの色を変更。
            $('#all-clear-button').addClass("search-value-selected");
            $('#searchSubmit').addClass("search-value-selected");
            $('.search-button').addClass("search-value-selected");
            $('#all-clear-button2').addClass("search-value-selected");
        }
    },
    //イベントをセット
    "_setEvent": function () {

        //クリアボタンクリック時のイベント（PC表示時）
        ///////////////////////////////////////////////////////////////////////////////////////
        $('#all-clear-button').on('click', function (e) {
            //チェックボックスのチェック解除
            $('#searchCt').find(':checkbox').prop('checked', false);
            //search-value-selectedクラス削除
            $('#title-modal-menu').removeClass("search-value-selected");
            $('#all-clear-button').removeClass("search-value-selected");
            $('#searchSubmit').removeClass("search-value-selected");
            $('.search-check-selected').removeClass("search-check-selected");
            $('#title-modal-menu').removeClass("search-option-selected");
            $('label').removeClass("search-chk-color");
            $('label').removeClass("search-value-selected");
            $("#searchCt input").removeClass("initial");
            $('.search-value-selected').removeClass("search-value-selected");
            //テキストボックスを空に
            $('#searchKey').val('');
            //クリアボタン無効化
            $('#all-clear-button').prop("disabled", true);
            $('#all-clear-button').prop("disabled", false);

            //モバイル側反映
            //search-value-selectedクラス削除
            $('.search-value-selected').removeClass("search-value-selected");
            $('a').removeClass("search-chk-color");
            $("#searchCt2 input").removeClass("initial");
            //テキストボックスを空に
            $('#searchKey2').val('');
            //クリアボタン無効化
            $('#all-clear-button2').prop("disabled", true);
            $('#all-clear-button2').prop("disabled", false);
        });

        //クリアボタンクリック時のイベント（モバイル表示時）
        ///////////////////////////////////////////////////////////////////////////////////////
        $('#all-clear-button2').on('click', function (e) {
            //チェックボックスのチェック解除
            $('#searchCt2').find(':checkbox').prop('checked', false);
            //search-value-selectedクラス削除
            $('#title-checklist-toggler').removeClass("search-value-selected");
            $('#all-clear-button').removeClass("search-value-selected");
            $('#searchSubmit').removeClass("search-value-selected");
            $('.search-value-selected').removeClass("search-value-selected");
            $('a').removeClass("search-chk-color");
            $("#searchCt2 input").removeClass("initial");
            //テキストボックスを空に
            $('#searchKey2').val('');
            //クリアボタン無効化
            $('#all-clear-button2').prop("disabled", true);
            $('#all-clear-button2').prop("disabled", false);

            //PC側反映
            //search-value-selectedクラス削除
            $('.search-value-selected').removeClass("search-value-selected");
            $('.search-check-selected').removeClass("search-check-selected");
            $('.search-option-selected').removeClass("search-option-selected");
            $('label').removeClass("search-chk-color");
            $("#searchCt input").removeClass("initial");
            //テキストボックスを空に
            $('#searchKey').val('');
            //クリアボタン無効化
            $('#all-clear-button').prop("disabled", true);
            $('#all-clear-button').prop("disabled", false);
        });

        //テキストボックスに値が入力、削除されたとき(PC表示時）
        ///////////////////////////////////////////////////////////////////////////////////////
        $('#searchKey').keyup(function (e) {
            var textbox_text = $('#searchKey').val();
            var check_count_refineByTitle = $('#searchCt :checked').length;

            if (textbox_text == "" && check_count_refineByTitle == 0) {
                $('#all-clear-button').removeClass("search-value-selected");
                $('#searchSubmit').removeClass("search-value-selected");

                //モバイル連動
                $('.search-button').removeClass("search-value-selected");
                $('#all-clear-button2').removeClass("search-value-selected");
                $('#searchKey2').val(textbox_text);
            }
            else if (textbox_text == "" && check_count_refineByTitle) {
                $('#all-clear-button').addClass("search-value-selected");
                $('#searchSubmit').removeClass("search-value-selected");

                //モバイル連動
                $('.search-button').removeClass("search-value-selected");
                $('#all-clear-button2').addClass("search-value-selected");
                $('#searchKey2').val(textbox_text);
            } else {
                $('#all-clear-button').addClass("search-value-selected");
                $('#searchSubmit').addClass("search-value-selected");

                //モバイル連動
                $('.search-button').addClass("search-value-selected");
                $('#all-clear-button2').addClass("search-value-selected");
                $('#searchKey2').val(textbox_text);
            }
        });

        //テキストボックスに値が入力、削除されたとき(モバイル表示時）
        ///////////////////////////////////////////////////////////////////////////////////////
        $('#searchKey2').keyup(function (e) {
            var textbox_text = $('#searchKey2').val();
            var check_count_refineByTitle = $('#searchCt2 :checked').length;

            if (textbox_text == "" && check_count_refineByTitle == 0) {
                $('.search-button').removeClass("search-value-selected");
                $('#all-clear-button2').removeClass("search-value-selected");

                //PC連動
                $('#all-clear-button').removeClass("search-value-selected");
                $('#searchSubmit').removeClass("search-value-selected");
                $('#searchKey').val(textbox_text);
            }
            else if (textbox_text == "" && check_count_refineByTitle) {
                $('.search-button').removeClass("search-value-selected");
                $('#all-clear-button2').addClass("search-value-selected");

                //PC連動
                $('#all-clear-button').addClass("search-value-selected");
                $('#searchSubmit').removeClass("search-value-selected");
                $('#searchKey').val(textbox_text);
            } else {
                $('.search-button').addClass("search-value-selected");
                $('#all-clear-button2').addClass("search-value-selected");

                //PC連動
                $('#all-clear-button').addClass("search-value-selected");
                $('#searchSubmit').addClass("search-value-selected");
                $('#searchKey').val(textbox_text);
            }
        });

        //タイトルチェックボックスの処理(PC表示時）
        ///////////////////////////////////////////////////////////////////////////////////////
        $('#searchCt').on('change', ':checkbox, :radio', function () {
            var check_count = $('#searchCt :checked').length;
            var initial_count = $("#searchCt .initial").length;

            if (check_count == 0 && initial_count == 0) {
                $("#title_button").removeClass("search-check-selected");
            } else {
                //初期チェックの数、現在チェックされている数、initalクラスが付与されておりチェックがされている数が全て同じ
                //である場合は初期状態と判断し、条件を追加ボタンの色替えを無効化する。
                var checked_initial_count = $("#searchCt input.initial:checked").length;
                if (checked_initial_count == check_count && check_count == initial_count) {
                    $("#title_button").removeClass("search-check-selected");
                } else {
                    $("#title_button").addClass("search-check-selected");
                }
            }

            if ($(this).prop('checked')) {
                $(this).parent().addClass("search-chk-color");
            } else {
                $(this).parent().removeClass("search-chk-color");
            }
        });

        //タイトルチェックボックスの処理(モバイル表示時）
        ///////////////////////////////////////////////////////////////////////////////////////
        $('#searchCt2').on('change', ':checkbox, :radio', function () {
            var check_count = $('#searchCt2 :checked').length;
            var initial_count = $("#searchCt2 .initial").length;

            if (check_count == 0 && initial_count == 0) {
                $("#confirm-title").removeClass("search-value-selected");
            } else {
                var checked_initial_count = $("#searchCt2 input.initial:checked").length;

                if (checked_initial_count == check_count && check_count == initial_count) {
                    $("#confirm-title").removeClass("search-value-selected");
                } else {
                    $("#confirm-title").addClass("search-value-selected");
                }
            }

            if ($(this).prop('checked')) {
                $(this).parent().addClass("search-chk-color");
            } else {
                $(this).parent().removeClass("search-chk-color");
            }
        });

        //タイトルダイアログボタンが押されたとき
        ///////////////////////////////////////////////////////////////////////////////////////
        $('#title_button').on('click', function (e) {
            var textbox_text = $('#searchKey').val();
            var check_count = $('#searchCt :checked').length;

            //PC表示タイトルで絞り込むのチェックボックスに付与されているinitialクラスを削除
            $("#searchCt .initial").removeClass("initial");

            //モバイル側初期化
            //モバイル表示タイトルで絞り込むのチェックボックスに付与されているクラスを削除
            $("#searchCt2 .initial").removeClass("initial");
            $(".full-width .search-value-selected").removeClass("search-value-selected");
            $(".full-width .search-chk-color").removeClass("search-chk-color");

            //チェックが付いているinputにinitialクラスを付与
            $("#searchCt input:checked").each(function () {
                $(this).addClass("initial");

                //モバイル側にも反映
                var valueAttrVal = $(this).attr("value");
                //inputにinitialクラスを付与
                $('#searchCt2 input[value="' + valueAttrVal + '"]').addClass("initial");
                //inputの親のlabel要素にsearch-value-selectedとsearch-chk-colorクラスを付与
                $('#searchCt2 input[value="' + valueAttrVal + '"]').parent().addClass("search-value-selected");
                $('#searchCt2 input[value="' + valueAttrVal + '"]').parent().addClass("search-chk-color");
            });

            if (textbox_text == "" && check_count == 0) {
                $('#title-modal-menu').removeClass("search-value-selected");
                $('#all-clear-button').removeClass("search-value-selected");
                $('#searchSubmit').removeClass("search-value-selected");

                //モバイル連動
                $('.search-button').removeClass("search-value-selected");
                $('#all-clear-button2').removeClass("search-value-selected");
                $(".full-width #title-checklist-toggler").removeClass("search-value-selected");
            }
            else if (textbox_text == "" && check_count) {
                $('#title-modal-menu').addClass("search-value-selected");
                $('#all-clear-button').addClass("search-value-selected");
                $('#searchSubmit').removeClass("search-value-selected");

                //モバイル連動
                $('.search-button').removeClass("search-value-selected");
                $('#all-clear-button2').addClass("search-value-selected");
                $(".full-width #title-checklist-toggler").addClass("search-value-selected");
            } else {
                $('#all-clear-button').addClass("search-value-selected");
                $('#searchSubmit').addClass("search-value-selected");

                //モバイル連動
                $('.search-button').addClass("search-value-selected");
                $('#all-clear-button2').addClass("search-value-selected");
                if (check_count) {
                    $('#title-modal-menu').addClass("search-value-selected");
                    $(".full-width #title-checklist-toggler").addClass("search-value-selected");
                } else {
                    $('#title-modal-menu').removeClass("search-value-selected");
                    $(".full-width #title-checklist-toggler").removeClass("search-value-selected");
                }
            }
        });
    }
};

var getParamData = funcSearchDlg._getGetData();
