/* global decodeURIComponent */

/**************************************************
 * URLからの情報取得
 * 　戻り：　_uri
 */
var _uri = (function () {
    var uri = {
        "location": window.location.href
        , "fullPath": ((window.location.origin || '') + window.location.pathname).replace(/\\/g, "/")
    };
    uri.path = uri.fullPath.split('/').slice(0, -1).join('/');
    uri.file = uri.fullPath.split('/').slice(-1).join('') || "index.html";
    uri.hash = window.location.hash;
    uri.manualPath = uri.path.replace(/\/?contents\/?$/i, '');
    uri.fileName = uri.file.replace(/\.html?$/, '');
    uri.id = uri.file.split("_", 1).join('');
    return uri;
}());

/**************************************************
 * ユーザーエージェントから情報取得
 * 　戻り：　_ua
 */
var _ua = (function () {
    var na = navigator, ua = na.userAgent;
    var __ua = {
        "_protocol": document.location.protocol
        , "_isWin": /win/i.test(na.platform)
        , "_isMac": /mac/i.test(na.platform)
        , "_isWebKit": /WebKit/i.test(ua)
        , "_isEdge": /Edg\//i.test(ua)
        , "_browser": false
    };
    __ua._isChrome = !__ua._isEdge && /chrome/i.test(ua);
    __ua._isGecko = !__ua._isWebKit && /Gecko/.test(ua);
    __ua._isFirefox = __ua._isGecko && /Firefox/.test(ua);
    __ua._isSafari = __ua._isWebKit && !__ua._isChrome && __ua._isMac;

    if (__ua._isEdge) {
        __ua._browser = 'edge';
    } else if (__ua._isSafari) {
        __ua._browser = 'safari';
    } else if (__ua._isFirefox) {
        __ua._browser = 'firefox';
    } else if (__ua._isChrome) {
        __ua._browser = 'chrome';
    }

    if (__ua._isSafari) {
        __ua._SafariFullVer = ua.replace(/^.+Version\/([0-9.]+).*$/i, '$1');
        __ua._SafariVer = __ua._SafariFullVer.split('.')[0];
    }

    return __ua;
}());


/* *************************************************
 * URLからGET情報取得
 */
var _get = (function () {
    var getdata = window.location.search.replace(/^\?/, '').split('&');
    var get = [];
    for (var i = 0, len = getdata.length; i < len; i++) {
        var temp = decodeURIComponent(getdata[i]).split('=');
        var ak = temp[0];
        temp.shift();
        get[ak] = temp.join('=');
    }
    return get;
}());


/**************************************************
 * 共有関数
 */
var cmn = {

    //検索フォーム
    "searchForm": function () {
        //PC表示
        $('#search form').on("submit", function () {
            submit('pc');
            return false;
        });

        //モバイル表示
        $('#search-mobile-body form').on("submit", function () {
            submit('mobile');
            return false;
        });

        var submit = function (windowSize) {
            var keywordSelector = (windowSize == 'pc') ? '#searchKey' : '#searchKey2';
            var refineByTitleSelector = (windowSize == 'pc') ? '#searchCt input:checked' : '#searchCt2 input:checked';

            var keyword = $.trim($(keywordSelector).val());

            if (!keyword) {
                alert(textData.noSearchItem);
                return false;
            } else {
                var fil = [];

                var filters = [];
                $(refineByTitleSelector).each(function () {
                    filters.push($(this).val());
                });
                if (filters.length) {
                    fil.push('f=' + filters.join(','));
                }

                fil = (fil.length) ? "&" + fil.join('&') : '';

                window.location.href = $('#search form').attr('action') + "?k=" + encodeURIComponent(keyword) + fil;
            }
        }
    },
    //Web サーバーにある HTML ファイルを閲覧時かの判定
    "isWebBrowsing": function () {
        if (location.protocol === "http:" || location.protocol === "https:") {
            return true;
        } else {
            return false;
        }
    },
    "contentsHtml": {},
    "contents": {}
};

/**************************************************
 * jQuery ready
 */
$(function () {

    //検索フォーム
    cmn.searchForm();

});
//end jQuery ready
