/*/////////////////////////////////////////////////////////////////////////////////////////////////
	User's Guide
	Load JavaScript
	Modified : 2017-03-03
/////////////////////////////////////////////////////////////////////////////////////////////////*/

/* global opera, decodeURIComponent, settings */


var _ua = (function(){
	var __na = navigator,
		__ua = __na.userAgent,
		conf = {},
		htmlClass = [];
	
	if(settings.lang) htmlClass.push('lang-' + settings.lang);
	
	conf._isWin = /win/i.test(__na.platform);
	if(conf._isWin){
		htmlClass.push('Win');
		conf._isWin10 = /Win(dows )?NT 10\./i.test(__ua);
		conf._isWin8_1 = /Win(dows )?NT 6\.3/i.test(__ua);
		conf._isWin8 = /Win(dows )?NT 6\.(2|3)/i.test(__ua);
		conf._isWin7 = /Win(dows )?NT 6\.1/i.test(__ua);
	}
	
	conf._isMac = /mac/i.test(__na.platform);
	if(conf._isMac){
		htmlClass.push('Mac');
		if((osver = __ua.match(/Mac OS X [0-9._]+/i))){
			osver = (osver+'').replace(/Mac OS X ([0-9._]+)/i, '$1');
			osver = (/\./.test(osver)) ? osver.split('.') : osver.split('_');
			conf['_isMacOSX' + osver[0]] = true;
			osver2 = (!osver[1]) ? osver[0]+'_0' : osver[0]+'_'+osver[1] ;
			conf['_isMacOSX' + osver2] = true;
			osverFull = osver.join('_');
			conf['_isMacOSX' + osverFull] = true;
		}
	}
	conf._isX11 = /X11/i.test(__ua);

	conf._isWebKit = /WebKit/i.test(__ua);
	conf._isChrome = /chrome/i.test(__ua);
	conf._isSafari = conf._isWebKit && !conf._isChrome;
	conf._isOpera = window.opera && opera.buildNumber;
	conf._isEdge = /Edge\//i.test(__ua);
	conf._isIE = !conf._isWebKit && !conf._isOpera && ( /MSIE/i.test(__ua) || /Trident/i.test(__ua) )/* && (/Explorer/gi).test(_na.appName)*/;
	conf._isGecko = !conf._isWebKit && /Gecko/.test(__ua);
	conf._isFirefox = conf._isGecko && /Firefox/.test(__ua);
	conf._isKMBuiltIn = /KMBuiltInBrowser/i.test(__ua);

	conf._isiPhone = /iPhone/i.test(__ua);
	conf._isiPod = /iPod/i.test(__ua);
	conf._isiPad = /iPad/i.test(__ua);
	conf._isAndroid = /Android/i.test(__ua);
	conf._isMobile = conf._isiPhone || conf._isiPod || conf._isiPad || conf._isAndroid;
	//ua._isMobile = true;

	if(conf._isSafari){
		htmlClass.push('Safari');
		if((bver = __ua.match(/Version\/[0-9.]+ /i))){
			bver = (bver+'').replace(/Version\/([0-9.]+?) /i, '$1').split('.');
			conf['_isSafari' + bver[0]] = true;
			bver2 = (!bver[1]) ? bver[0]+'_0' : bver[0]+'_'+bver[1] ;
			conf['_isSafari' + bver2] = true;
			bverFull = bver.join('_');
			conf['_isSafari' + bverFull] = true;
		}
		conf._isSafari5low = conf._isSafari3 || conf._isSafari4 || conf._isSafari5;
		conf._isSafari6hi = !conf._isSafari5low;

		htmlClass.push('Safari-' + bver[0]);
		
	}

	if(conf._isIE){
		htmlClass.push('IE');
		if((bver = __ua.match(/((MSIE |rv:)[0-9]+)/i))){
			bver = (bver[0]+'').replace(/(MSIE |rv:)([0-9]+)/i, '$2');
			if(bver == '5') bver = '6';
			conf['_isIE' + bver] = true;
		}
		if(bver >= 9) conf._isIE9hi = true;
		if(bver >= 10) conf._isIE10hi = true;
		if(bver >= 11) conf._isIE11hi = true;
		htmlClass.push('IE-' + bver);
	}

	if(conf._isEdge){
		htmlClass.push('Edge');
		if((bver = __ua.match(/Edge\/[0-9.]+/i))){
			bver = (bver+'').replace(/Edge\/([0-9.]+)/i, '$1').split('.');
			conf['_isEdge' + bver[0]] = true;
			bver2 = (!bver[1]) ? bver[0]+'_0' : bver[0]+'_'+bver[1] ;
			conf['_isEdge' + bver2] = true;
			bverFull = bver.join('_');
			conf['_isEdge' + bverFull] = true;
			htmlClass.push('Edge-' + bver[0]);
		}
	}

	if(conf._isFirefox){
		htmlClass.push('Firefox');
		if((bver = __ua.match(/Firefox\/[0-9.]+/i))){
			bver = (bver+'').replace(/Firefox\/([0-9.]+)/i, '$1').split('.');
			conf['_isFirefox' + bver[0]] = true;
			bver2 = (!bver[1]) ? bver[0]+'_0' : bver[0]+'_'+bver[1] ;
			conf['_isFirefox' + bver2] = true;
			bverFull = bver.join('_');
			conf['_isFirefox' + bverFull] = true;
		}
		htmlClass.push('Firefox-' + bver[0]);
	}

	if(conf._isChrome && !conf._isEdge){
		htmlClass.push('Chrome');
		if((bver = __ua.match(/Chrome\/[0-9.]+/i))){
			bver = (bver+'').replace(/Chrome\/([0-9.]+)/i, '$1').split('.');
			conf['_isChrome' + bver[0]] = true;
			bver2 = (!bver[1]) ? bver[0]+'_0' : bver[0]+'_'+bver[1] ;
			conf['_isChrome' + bver2] = true;
			bverFull = bver.join('_');
			conf['_isChrome' + bverFull] = true;
			htmlClass.push('Chrome-' + bver[0]);
		}
	}
	
	conf._isWebAccess = /https?:/.test(document.location.protocol);
	conf._NotHTTP = !conf._isWebAccess;
	
	conf._thisFile = document.location.pathname.replace(/file:\/\/+/i, "").replace(/\\/g, "/").split('/').slice(-1).join('');
	conf._thisId = conf._thisFile.split("-",1).join('');
	conf._thisHash = location.hash;
	conf._isTop = conf._thisFile == 'index.html' || conf._thisFile == '';
	
	conf._getdata = location.search.replace(/^\?/,'').split('&');
	conf._get = [];
	for(var i=0,len=conf._getdata.length; i<len; i++){
		temp = decodeURIComponent(conf._getdata[i]).split('=');
		ak = temp[0];
		temp.shift();
		conf._get[ak] = temp.join('=');
	}
	
	
	
	var addHtmlClass = function(cls){
		cls = cls || [];
		var html = document.getElementsByTagName('html')[0];
		var nowClass = (html.getAttribute("class")) ? [nowClass.push(html.getAttribute("class"))] : [];
		nowClass = nowClass.concat(cls);
		if(nowClass.length) html.setAttribute("class", nowClass.join(' '));
	};
	addHtmlClass(htmlClass);
	
	return conf;
}());


//console.log(_ua);

var sharedPath = (_ua._isTop) ? 'contents/shared' : 'shared' ;
var lang = settings.lang;


var loadFile = [
	'<script src="' + sharedPath + '/js/lib/jquery-3.1.1.min.js" type="text/javascript"></script>'
	,'<script src="' + sharedPath + '/js/lib/jquery-ui-1.12.1.min.js" type="text/javascript"></script>'
	,'<script src="' + sharedPath + '/js/lib/jquery.keyHighlight.min.js" type="text/javascript"></script>'
	,'<script src="' + sharedPath + '/sysout/textData.js" type="text/javascript"></script>'
	,'<script src="' + sharedPath + '/sysout/menu.js" type="text/javascript"></script>'
	,'<script src="' + sharedPath + '/sysout/contents.js" type="text/javascript"></script>'
	,'<script src="' + sharedPath + '/js/common.js" type="text/javascript"></script>'
];

if(_ua._isMobile){
	loadFile.push(
		'<meta name="viewport" content="width=device-width">'
		,'<link href="' + sharedPath + '/css/mobile.css" rel="stylesheet" type="text/css" media="screen,print" />'
		,'<script src="' + sharedPath + '/js/mobile.js" type="text/javascript"></script>'
		,'<link href="' + sharedPath + '/css/responsive.css" rel="stylesheet" type="text/css" media="screen,print" />'
	);
}






document.write(loadFile.join(''));




