var topicFunc = {
	/**
	 * スクロール関連イベントをセットする
	 */
	"setScrollEvent": function () {
		//下へスクロールするボタンの初期表示（縦スクロールバーがある場合に表示する）
		if ($(document).innerHeight() !== $(window).innerHeight()) {
			$('#scrollToBottom').fadeIn();
		}

		//画面リサイズ時に縦スクロールバーが出たら表示する
		//setTimeoutを使い画面リサイズが確定したときに処理を実行する
		//cf. https://kadoppe.com/archives/2012/02/jquery-window-resize-event.html
		var timer = false;
		$(window).resize(function () {
			if (timer !== false) {
				clearTimeout(timer);
			}
			timer = setTimeout(function () {
				if ($(document).innerHeight() !== $(window).innerHeight()) {
					$('#scrollToBottom').fadeIn();
				} else {
					$('#scrollToBottom').fadeOut();
				}
			}, 200);
		});

		$(window).scroll(function () {
			//画面を80pxスクロールした場合
			if ($(window).scrollTop() > 80) {
				$('#scrollToTop').fadeIn();
			} else {
				$('#scrollToTop').fadeOut();
			}
			//下へスクロールするボタンのフェードインアウト
			var pageBottom = $(document).innerHeight() - $(window).innerHeight();
			// ブラウザによって高さやスクロール位置の取得結果に誤差があり、
			// 一番下までスクロール済と判断できない場合を回避するため
			// 一番下までスクロール済であると判断する閾値pageBottomを"3"下げておく
			if (pageBottom - 3 <= $(window).scrollTop()) {
				//ウィンドウの一番下までスクロールした時にフェードアウト
				$('#scrollToBottom').fadeOut();
			} else {
				$('#scrollToBottom').fadeIn();
			}
		});

		$('#scrollToTop').on('click', function () {
			$('html,body').animate({ scrollTop: 0 }, 500);
			return false;
		});

		$('#scrollToBottom').on('click', function () {
			var pageBottom = $(document).innerHeight() - $(window).innerHeight();
			$('html,body').animate({ scrollTop: pageBottom }, 500);
			return false;
		});
	},
	
	/**
	 * ブックマーク用のメソッド群
	 */
	"bookmarkFunc": function () {
		// ブックマーク一覧ダイアログに表示する各ブックマークの本文の最大文字数
		var bookmarkTextMaxLength = 100;

		// cookie有効期間 5年
		var cookieExpires = 365 * 5;

		// ブラウザに保存されているブックマーク情報の区切り文字
		var bookmarkSeparator = ",";

		// ブラウザの内部データへ保存するKey情報（meta要素(name=keywords)のcontent値）から
		// 機種情報を取得する
		var modelInfo = $('meta[name=keywords]').attr('content');
		// Cookie / localStrageへ保存時のKey固定文字列（モデル名以外の部分）
		var bookmarkKeySuffix = "3DECB3AFC3628B7EEEBA716FFCA5F3123D532716";
		// Cookie / localStrageへ保存時のKey
		var bookmarkKey = (modelInfo == "" || modelInfo == undefined) ? "" : modelInfo + "_" + bookmarkKeySuffix;

		// ブラウザに保存可能な件数
		var limitBookmarkCount = 100;

		// ブラウザに保存可能な容量(「各ブラウザ内の最小値5117byte（IEとEdge）」から、「キー」と、「キーと値の区切り＝が使用する2バイト」を除く)
		var limitBookmarkSize = 5117 - (encodeURI(bookmarkKey).length + 2);

		// ブックマークの保存先としてCookie/webStorageのどちらを使用するか
		// IE・Edge：Cookie
		// その他ブラウザ：webStorage
		var isWebstorage = (function () {
			if (_ua._isIE || _ua._isEdge) {
				return false;
			} else {
				return true;
			}
		})();


		// webStorageを使用可能か(無効化されていないか)
		var isWebstorageEnable = (function () {
			if (!isWebstorage) return false;

			try {
				return ('localStorage' in window) && (window.localStorage !== undefined) && (window.localStorage !== null);
			} catch (e) {
				return false;
			}
		})();

		// Cookieを使用可能か（無効化されていないか）
		var isCookieEnable = (function () {
			if (isWebstorage) return false;

			// IE, Edgeの場合、
			// Cookie無効に設定していてもnavigator.cookieEnabledがtrueになるため、
			// 実際に登録してみてできるかどうか確認する
			var checkKey = Math.random();
			while (getCookie(checkKey)) {
				// checkKeyが既にCookieに登録済の場合、checkKeyを再生成する
				checkKey = Math.random();
			}
			// チェック値をCookieへ登録する
			setCookie(checkKey, true);
			// チェック値が登録されているか確認する
			var val = getCookie(checkKey);
			if (!val) {
				return false;
			} else {
				// チェック値が登録されていれば、削除してチェック終了
				deleteCookie(checkKey);
				return true;
			}

			function setCookie(cookieName, value) {
				$.cookie(cookieName, value);
			}
			function getCookie(cookieName) {
				var c = $.cookie();
				var str = '';
				for (key in c) {
					if (key == cookieName) {
						str = c[key];
					}
				}
				return str;
			}
			function deleteCookie(cookieName) {
				$.removeCookie(cookieName);
			}
		})();

		return {
			/**
			 * ブックマークの登録・未登録を切り替える
			 */
			switchRegister: function () {
				if (bookmarkKey === "") return;

				// ユーザ環境（Cookie/WebStorageの有効・無効）の確認
				if ((isWebstorage && !isWebstorageEnable) || (!isWebstorage && !isCookieEnable)) {
					// アラート表示してブックマーク登録を終了する
					alert(textData.disabledCookie);
					return;
				}
				// ブックマーク登録するファイル名
				// リンクモーダルダイアログのタブがアクティブな場合は、リンクモーダルダイアログで表示中ページ
				// その他の場合は、メインページ
				var targetFileName = $('.tab.active').length > 0 ? $('.tab.active').attr('data-tab') + ".html" : _uri.file;

				// ブックマーク登録済の場合、ブックマークを削除する
				if (isRegistered(targetFileName)) {
					// 画像とtitle属性を切り替える
					switchIcon(false);
					//ブックマークを削除する
					deleteBookmark(targetFileName);
				}
				// ブックマーク未登録の場合、ブックマークを登録する
				else {
					//ブックマークを追加する
					if (addBookmark(targetFileName)) {
						// 画像とtitle属性を切り替える
						switchIcon(true);
					};
				}
			},

			/**
			 * ブックマーク一覧ダイアログを表示する
			 */
			showlist: function () {
				// ダイアログのブックマーク表示領域をクリアする
				$('.bookmark-list-wrapper').empty();
				// 登録済ブックマークを取得する
				var bookmarks = getBookmarks();
				// 件数を表示する
				var bookmarkCount = getBookmarkCount();
				var unitString = bookmarkCount == 1 ? textData.item : textData.items;
				$('#bookmarkCount').text(bookmarkCount + " " + unitString);
				// ブックマークされているページへのパス
				var contentsPath = (_uri.file === "index.html") ? "./contents/" : "./";

				// bookmarkTextMaxLengthまでの文字列を取得する（%#symbol-0000#%を1文字とカウントする）
				var getLimitedText = function (allText) {
					// 全文字数が文字数制限の範囲無いならばそのまま返す
					if (allText.length < bookmarkTextMaxLength) return allText;

					// %#symbol-0000#%を含まない場合、文字数制限までの文字を返す
					if (allText.indexOf('%#symbol-') == -1) {
						return (allText.length > bookmarkTextMaxLength) ? (allText.substring(0, bookmarkTextMaxLength) + "...") : allText;
					}

					// %#symbol-0000#%を含まない文字列だけの配列を取得する
					var textsWithoutSymbol = allText.split(/%#symbol-[^#]+?#%/);
					// %#symbol-0000#%だけを配列に取得する
					var symbols = allText.match(/%#symbol-[^#]+?#%/g);

					var limitedText = "";	// 文字数制限になるまでの文字列とSymbolを集めた実文字列
					var tmpLimitedText = "";	// Symbolのテキストを1文字とカウントするための仮文字列
					var tmpSymbolChar = "S";	// Symbolのテキストを1文字とカウントするための仮文字列
					for (var idx = 0; idx < textsWithoutSymbol.length; idx++) {
						// 次の文字列を追加しても文字数制限を超えなければ追加する
						if (tmpLimitedText.length + textsWithoutSymbol[idx].length <= bookmarkTextMaxLength) {
							tmpLimitedText += textsWithoutSymbol[idx];
							limitedText += textsWithoutSymbol[idx];

							if (idx >= symbols.length) break;
							// 次のSymbolを追加しても文字数制限を超えなければ追加する
							if (tmpLimitedText.length + tmpSymbolChar.length <= bookmarkTextMaxLength) {
								tmpLimitedText += tmpSymbolChar;
								limitedText += symbols[idx];
							} else {
								// これ以上追加しない
								break;	
							}
						} else {
							// 文字数制限を超えない範囲まで追加する
							var usableLength = bookmarkTextMaxLength - tmpLimitedText.length;
							tmpLimitedText += textsWithoutSymbol[idx].substring(0, usableLength);
							limitedText += textsWithoutSymbol[idx].substring(0, usableLength);
							// これ以上追加しない
							break;
						}
					}
					limitedText += "...";
					return limitedText;
				};

				// %#symbol-0000#%をCSSが適用される要素へ置換する
				var convertToSymbolFormat = function (str) {
					if (str.indexOf('%#symbol-')) {
						str = str.replace(/%#symbol-([^#]+?)#%/g, function (all, group1) {
							return '<span class="span-symbol">' + String.fromCharCode('0x' + group1) + '</span>';
						});
					}					
					return str;
				};

				// ブックマーク分、HTMLへブックマークを出力する
				bookmarks.forEach(function (bookmark) {
					if (!cmn.contents[bookmark]) return;

					// タイトルの%#symbol-0000#%をCSSが適用される要素へ置換する
					var repTitle = convertToSymbolFormat(cmn.contents[bookmark].title);
					
					// 本文を指定文字数まで取得する
					var text = getLimitedText(cmn.contents[bookmark].text);
					// 本文の%#symbol-0000#%をCSSが適用される要素へ置換する
					text = convertToSymbolFormat(text);

					// パンくずを表示形式へ整形する
					var topicPathSeparator = " > ";
					var topicPath = cmn.contents[bookmark].topic_path.join(topicPathSeparator);
					// パンくずの%#symbol-0000#%をCSSが適用される要素へ置換する
					topicPath = convertToSymbolFormat(topicPath);
					
					// ブックマークを出力する
					var template = '<div class="bookmark-list">'
						+ '<div class="bookmark-list-title">'
						+ '<label>'
						+ '<input type="checkbox" name="bookmarkTitle" id="' + bookmark + '"/>'
						+ '<a href="' + contentsPath + bookmark + '">' + repTitle + '</a>'
						+ '</label>'
						+ '</div>'
						+ '<div class="bookmark-list-text">'
						+ '<p>' + text + '</p>'
						+ '</div>'
						+ '<div class="bookmark-list-topicpath">'
						+ '<p>' + topicPath + '</p>'
						+ '</div>'
						+ '</div>';
					$(".bookmark-list-wrapper").append(template)
				});
			},

			/**
			 * ページ表示時にブックマークの登録状況に応じて☆アイコン表示を切り替える
			 */
			initializeIcon: function (targetFileName) {
				if (isRegistered(targetFileName)) {
					// ブックマーク登録済アイコンを表示する
					switchIcon(true);
				} else {
					// ブックマーク未登録アイコンを表示する
					switchIcon(false);
				}
			},

			/**
			 * ブックマーク一覧ダイアログのチェックボックスがONのブックマークを全て削除する
			 */
			deleteSelectedBookmarks: function () {
				$("[name=bookmarkTitle]").each(function () {
					// チェックボックスONの場合、ブックマークを削除する
					if ($(this).prop('checked')) {
						// Cookie/WebStorage有効の場合のみ、削除する
						if ((isWebstorage && isWebstorageEnable) || (!isWebstorage && isCookieEnable)) deleteBookmark($(this).attr('id'));
					}
				});
				// ブックマーク一覧ダイアログのリストを更新する
				this.showlist();
				// 表示中のページのブックマークアイコンを更新する
				this.initializeIcon(_uri.file);
			},

			/**
			 * ブックマーク一覧ダイアログのチェックボックスを全て選択・全て解除する
			 * select: true 全選択　false 全解除
			 */
			selectAll: function (select) {
				$("[name=bookmarkTitle]").prop('checked', select);
			},

			/**
			 * ブックマークに必要なcontents.jsを読み込む
			 */
			loadContents: function () {
				// ブラウザに登録済の有効なブックマークを取得する
				var bookmarks = getValidBookmarks();

				// ブックマークに必要なcontents.jsを読み込む
				bookmarks.forEach(function (bookmark) {
					var contentsJsName = (bookmark.lastIndexOf(".") != -1) ? ("contents_" + bookmark.substring(0, bookmark.lastIndexOf(".")) + ".js") : "";
					if (!$('script').is('[src$="' + contentsJsName + '"]')) {
						var script = document.createElement('script');
						script.type = 'text/javascript';
						script.src = (_uri.file === "index.html") ? ("./contents/src/js/contents/" + contentsJsName) : ("./src/js/contents/" + contentsJsName);
						document.body.appendChild(script);
					}					
				});
			}
		};

		/**
		 * ブラウザに登録済のブックマーク情報のうち、実ページが存在するブックマークだけを取得する
		 */
		function getValidBookmarks() {
			var allBookmarks = getBookmarks();
			var validBookmarks = [];
			allBookmarks.forEach(function (bookmark) {
                if (htmlFileNames.indexOf(bookmark) >= 0) {
                    validBookmarks.push(bookmark);
                }
			});
			return validBookmarks;
        }

		/**
		 * 登録済ブックマークの内、HTMLファイルが実在する数を取得する
		 * （HTMLコンテンツの改版等の理由により、ブックマークした後にHTMLファイルが無くなる可能性があるため
		 * HTMLファイルが実在する数をユーザへ見せる）
		 * HTMLファイルの有無はsearch_index.jsを参照して判断する
		 */
		function getBookmarkCount() {
			var bookmarks = getBookmarks()
			var bookmarkCount = 0;
			bookmarks.forEach(function (bookmark) {
                if (htmlFileNames.indexOf(bookmark) >= 0) {
                    bookmarkCount++;
                }

			});
			return bookmarkCount;
		}

		/**
		 * ブックマークアイコンの表示を切り替える
		 * isRegistered: true ブックマーク登録済アイコンへ切り替える　false ブックマーク未登録アイコンへ切り替える
		 */
		function switchIcon(isRegistered) {
			// リンクモーダルダイアログのタブがアクティブな場合は、リンクモーダルダイアログ内のアクティブなタブのブックマークアイコンを対象とする
			// その他の場合は、メインページのブックマークアイコンを対象とする
			var iconElement = $('.tab.active').length > 0 ? $('.tabContents.active #modalarea_star') : $('#mainarea_star');
			if (isRegistered) {
				iconElement.removeClass('contents-button-bookmark_gray');
				iconElement.addClass('contents-button-bookmark_yellow');
				iconElement.attr('title', textData.deleteBookmark);
			} else {
				iconElement.removeClass('contents-button-bookmark_yellow');
				iconElement.addClass('contents-button-bookmark_gray');
				iconElement.attr('title', textData.addBookmark);
			}
		}

		/**
		 * ブックマークへ登録済か確認する
		 */
		function isRegistered(targetFileName) {
			// Cookie/WebStorage無効の場合はfalse終了
			if ((isWebstorage && !isWebstorageEnable) || (!isWebstorage && !isCookieEnable)) return false;

			var bookmark = getBookmark();
			// ブックマーク登録済
			if (bookmark !== null && bookmark.indexOf(targetFileName) !== -1) {
				return true;
			} else {
				return false;
			}
		}

		/**
		 * ブックマークを削除する
		 * filename: ブラウザ内部データとして保存しているブックマーク情報から削除するHTMLファイル名
		 */
		function deleteBookmark(filename) {
			// Cookie/WebStorage無効の場合は削除せず終了
			if ((isWebstorage && !isWebstorageEnable) || (!isWebstorage && !isCookieEnable)) return false;

			var bookmark = getBookmark();
			if (bookmark !== null) {
				var index = bookmark.indexOf(filename);
				if (index === 0 && bookmark.length === filename.length) {
					//keyに削除対象ファイル名だけが登録されている場合、keyを削除する
					if (isWebstorage) {
						localStorage.removeItem(bookmarkKey);
					} else {
						$.removeCookie(bookmarkKey, { path: '/' });
					}
				} else if (index === bookmark.length - filename.length) {
					//最後の要素として削除対象ファイル名が登録されている場合、
					//bookmark内の最終ファイル名を削除する
					bookmark = bookmark.replace(bookmarkSeparator + filename, "");
					if (isWebstorage) {
						localStorage.setItem(bookmarkKey, bookmark);
					} else {
						$.cookie(bookmarkKey, bookmark, { expires: cookieExpires, path: '/' });
					}
				} else {
					//途中のファイル名を削除する
					bookmark = bookmark.replace(filename + bookmarkSeparator, "");
					if (isWebstorage) {
						localStorage.setItem(bookmarkKey, bookmark);
					} else {
						$.cookie(bookmarkKey, bookmark, { expires: cookieExpires, path: '/' });
					}
				}
			}
		}

		/**
		 * ブックマークを追加する
		 * filename: ブラウザ内部データへブックマーク情報として追加するHTMLファイル名
		 */
		function addBookmark(filename) {
			// Cookie/WebStorage無効の場合は追加せず終了
			if ((isWebstorage && !isWebstorageEnable) || (!isWebstorage && !isCookieEnable)) return false;

			var bookmark = getBookmark();
			
			// bookmarkに追加登録できるかチェックする
			// チェック1：limitBookmarkCount 件まで保存可能
			if (getBookmarks().length >= limitBookmarkCount) {
				alert(textData.bookmarkOverAlert);
				return false;
			}
			// チェック2：保存済データサイズが limitBookmarkSize 未満ならば保存可能
			if (bookmark != null && bookmark.length > limitBookmarkSize) {
				alert(textData.bookmarkOverAlert);
				return false;
			}

			if (bookmark === null) {
				//1件目登録
				if (isWebstorage) {
					localStorage.setItem(bookmarkKey, filename);
				} else {
					$.cookie(bookmarkKey, filename, { expires: cookieExpires, path: '/' });
				}
			} else {
				//追加登録
				//同名ファイルが登録済の場合何もしない
				if (bookmark.indexOf(filename) === -1) {
					if (isWebstorage) {
						localStorage.setItem(bookmarkKey, bookmark + bookmarkSeparator + filename);
					} else {
						$.cookie(bookmarkKey, bookmark + bookmarkSeparator + filename, { expires: cookieExpires, path: '/' });
					}
				}
			}
			return true;
		}

		/**
		 * ブラウザの内部データへ登録済のブックマーク情報をそのまま文字列として取得する
		 * 未登録またはCookie/WebStorage無効の場合はnullを返却する
		 * 例：ControlPanel112233_01_01_01.html,Other123456_01_01.html
		 */
		function getBookmark() {
			// Cookie/WebStorage無効の場合は取得せず終了
			if ((isWebstorage && !isWebstorageEnable) || (!isWebstorage && !isCookieEnable)) return null;

			// localStorageを使用する場合
			if (isWebstorage) {
				return (bookmarkKey === "") ? null : localStorage.getItem(bookmarkKey);
			}
			// cookieを使用する場合
			else {
				if (bookmarkKey === "") return null;

				var bookmark = $.cookie(bookmarkKey);
				console.log("bookmark");
				console.log(bookmark);
				if (bookmark != null) {
					console.log("bookmark.length");
					console.log(bookmark.length);
				}
				return (bookmark === undefined) ? null : bookmark;
			}
		}

		/**
		 * ブラウザの内部データに登録済のブックマーク情報を配列として取得する
		 */
		function getBookmarks() {
			var bookmark = getBookmark();
			if (bookmark !== null) {
				return bookmark.split(bookmarkSeparator);
			} else {
				return [];
			}
		}
	},

	/**
	 * ブックマーク関連のイベントをセットする
	 * @param {} bookmarkFunc 
	 */
	"setBookmarkEvent": function (bookmarkFunc) {
		// 各ページの☆ブックマークをクリック時、リストモーダルダイアログを表示する
		$(".showlistmodal").on("click", function () {
			bookmarkFunc.showlist();
		});

		// メイン領域のブックマーク用☆画像をクリックするたびに切り替える
		$('#mainarea_star').on("click", function () {
			bookmarkFunc.switchRegister();
		});

		// ブックマーク一覧ダイアログの「すべてを選択」ボタン押下
		$('.btn-select-all').on("click", function () {
			bookmarkFunc.selectAll(true);
		});

		// ブックマーク一覧ダイアログの「選択を解除」ボタン押下
		$('.btn-delete-on-select').on("click", function () {
			bookmarkFunc.selectAll(false);
		});

		// ブックマーク一覧ダイアログの「選択項目を削除」ボタン押下
		$('.btn-delete-on-selected-list').on("click", function () {
			bookmarkFunc.deleteSelectedBookmarks();
		});
	},

	/**
	 * メイン・検索画面のハンバーガーメニュー関連の処理
	 */
	"setTopMemuEvent": function () {
		toggleMenu();

		//title付与（初期）
		addTipForToggleMenu();

		//ハンバーガーメニュー
		$('#toggleMenu').on('click', function () {
			$('#top-menu').toggleClass('active');
			$('#toggleMenu').toggleClass('active');

			//title付与
			addTipForToggleMenu();
		});
		//ブック切り替えメニュー以外の領域領域をタップしたらハンバーガーメニューを閉じる
		$(document).click(function (event) {
			// クリック箇所がブック切り替えメニューとハンバーガーメニュー以外ならば閉じる
			if ($(event.target).closest("#top-menu").length <= 0 && $(event.target).closest("#toggleMenu").length <= 0) {
				$('#top-menu').removeClass('active');
				$('#toggleMenu').removeClass('active');
			}
		});
		$('#top-menu').on('click', 'a', function () {
			if ($(this).hasClass('open')) {
				$(this).removeClass('open').addClass('close');
			} else if ($(this).hasClass('close')) {
				$(this).removeClass('close').addClass('open');
			}
		});
		$(window).on('resize', function () {
			toggleMenu();
		});

		function toggleMenu() {
			$("#top-menu").off("click", ".has-children");
			$("#top-menu ul > li").off("mouseenter");
			$("#top-menu ul > li").off("mouseleave");
			// slideToggle()の実行により、ulのdisplayが切り替わる（block/none）ため、
			// 処理実行前に、noneの状態にする（第2階層メニューを非表示にする）
			$("#top-menu ul > li > div").css("display", "none");
			$("#top-menu .has-children").removeClass('open').addClass('close');

			// モバイル表示
			if (window.matchMedia('(max-width:768px)').matches) {
				$("#top-menu").on("click", ".has-children", function () {
					$(this).next().slideToggle(0.01);
				});
			} else {
				// PC表示
				$("#top-menu ul > li").on("mouseenter", function () {
					$(this).find('div').show();
				});
				$("#top-menu ul > li").on("mouseleave", function () {
					$(this).find('div').hide();
				});
			}
		}

		function addTipForToggleMenu() {
			//titleの付与
			if($("#toggleMenu").hasClass('active')) {
					$("#toggleMenu").attr('title', textData.bookMenuCloseTip);
			} else {
					$("#toggleMenu").attr('title', textData.bookMenuOpenTip);
			}
		}

	},

	/**
	 * サイドメニュー（目次）関連の処理
	 */
	"setSideMenuEvent": function () {
		var url = window.location;
		var path = url.href.split('/');
		var file_name = path.pop();

		//モバイル表示の場合、目次を非表示にする
		if (window.matchMedia('(max-width: 768px)').matches) {
			toggleToc();
		}

		//titleの付与
		addTipForTocBtn();

		if (file_name.indexOf("search.html") == -1) {
			//記録してある開閉状態を反映する
			setLeftMenu();
			//自身の親がcloseだった場合はopenにする
			openAncestorMenu();
		}
		//目次の子要素の表示/非表示の切り替え
		$("#tocBody").on("click", ".has-children", function () {
			$(this).next().slideToggle(0.01);
		});
		//目次をクリックされたとき
		$('#tocBody').on('click', 'a', function () {

			//子を持つ要素は元の選択状態を保持
			if($(this).hasClass('has-children')) {

			} else {
				//一度全ての選択状況を解除
				$("#tocBody a").removeClass('selected');
				//自身を選択中に
				$(this).addClass('selected');
			}

			/*クリックした時、openクラスがあればcloseクラスに変更
				closeクラスだった場合はopenクラスに変更*/
			if ($(this).hasClass('open')) {
				$(this).removeClass('open');
				$(this).addClass('close');
			} else if ($(this).hasClass('close')) {
				$(this).removeClass('close');
				$(this).addClass('open');
			}
		});

		//目次表示/非表示の切り替えボタン押下
		$('#toggleToc').on('click', function () {
			toggleToc();
			addTipForTocBtn();
		});
		$('#tocBody').on('click', function () {
			if (!$('#tocBody').hasClass('active')) {
				toggleToc();
				addTipForTocBtn();
			}
		});

		//メイン内でリンクがクリックされたとき
		$('#contents-box').on('click', 'a', function () {
			//$('a[menuid=' + filenameId + ']').next().slideToggle();

			//検索結果画面は除外
			if ($(this).attr('href')) {
				//遷移先のページのURLからファイル名を取得する
				if ($(this).attr('href').indexOf('#')) {
					var filename = $(this).attr('href').replace(/#.*$/, "");
					var filenameId = filename.replace('.html', '');
				} else {
					var filenameId = $(this).attr('href').replace('.html', '');
				}
			}
		});

		//本文領域をタップしたらメニューを閉じる
		$('main').on('click', function () {
			// モバイル表示
			if (window.matchMedia('(max-width:768px)').matches) {
				if ($('#tocBody').hasClass('active')) {
					toggleToc();
					addTipForTocBtn();
				}
			}
		});
		//目次上部の「すべて開く」が押されたらすべて開く
		$('#tocOpen').on('click', function () {
			if ($("#tocBody a").hasClass('close')) {
				$("#tocBody a").removeClass('close');
				$("#tocBody a").addClass('open');
				$("#tocBody .has-children").next().slideDown();
			}
		});

		//目次上部の「すべて閉じる」が押されたらすべて閉じる
		$('#tocClose').on('click', function () {
			if ($("#tocBody a").hasClass('open')) {
				$("#tocBody a").removeClass('open');
				$("#tocBody a").addClass('close');
				$("#tocBody .has-children").next().slideUp();
			}
		});

		// 目次表示/非表示切り替え
		function toggleToc() {
			$('#tocHead').toggleClass('active');
			$('#tocBody').toggleClass('active');
			$('#toggleToc').toggleClass('active');
			$('.content').toggleClass('active');
			$('.toc-body-wrapper').toggleClass('active');
			$('.toc-book-title').toggleClass('active');
			$('.title_border').toggleClass('active');
		}

		function addTipForTocBtn() {
			//titleの付与
			if($("#toggleToc").hasClass('active')) {
					$("#toggleToc").attr('title', textData.closeTocTip);
			} else {
					$("#toggleToc").attr('title', textData.openTocTip);
			}
		}

		//飛び先のページの項目を選択状態にし、スクロール位置を設定
		function setLeftMenu() {

			var scrollPosition
			var filename = getFileName().replace('.html', '');
			var pos = filename.indexOf("?");
			if(pos > 0)
			{
				filename = filename.substring(0, pos);
			}

			$("#tocBody a[menuid = " + filename + "]").addClass('selected');

			setTimeout(function () {
				//スクロール位置を設定
				setChoicePosition();
			}, 0);
		}

		//自身の親がcloseだった場合はopenにする
		function openAncestorMenu() {

			//自身のファイル名を取得（110446_01_02_01.htmlなど）
			if (getFileName()) {
				var filenameId = getFileName().replace('.html', '');
				var pos = filenameId.indexOf("?");
				if(pos > 0)
				{
					filenameId = filenameId.substring(0, pos);
				}

				//メイン画面内のパンくずリストや相互参照でページが開かれた場合は上階層のメニューが表示されていないことがあるので
				//自身を表示したときに上階層が開かれていなかったら開く
				if ($('a[menuid=' + filenameId + ']').parent('li').parent('ul').prev('a').hasClass('close')) {
					$('a[menuid=' + filenameId + ']').parent('li').parent('ul').prev('a').removeClass('close');
					$('a[menuid=' + filenameId + ']').parent('li').parent('ul').prev('a').addClass('open');
					$.when(
						$('a[menuid=' + filenameId + ']').parent('li').parent('ul').prev('a').addClass('has-children-noanimation'),
						$('a[menuid=' + filenameId + ']').parent('li').parent('ul').prev('a').next().show()
					).done(function () {
						$('a[menuid=' + filenameId + ']').parent('li').parent('ul').prev('a').removeClass('has-children-noanimation');
					});
				}
				if ($('a[menuid=' + filenameId + ']').parent('li').parent('ul').parent('li').parent('ul').prev('a').hasClass('close')) {
					$('a[menuid=' + filenameId + ']').parent('li').parent('ul').parent('li').parent('ul').prev('a').addClass('open')
					$('a[menuid=' + filenameId + ']').parent('li').parent('ul').parent('li').parent('ul').prev('a').addClass('open');
					$.when(
						$('a[menuid=' + filenameId + ']').parent('li').parent('ul').parent('li').parent('ul').prev('a').addClass('has-children-noanimation'),
						$('a[menuid=' + filenameId + ']').parent('li').parent('ul').parent('li').parent('ul').prev('a').next().show()
					).done(function () {
						$('a[menuid=' + filenameId + ']').parent('li').parent('ul').parent('li').parent('ul').prev('a').removeClass('has-children-noanimation');
					});
				}
			}
		}

		//URLを取得し、ハッシュタグを削除してファイル名のみを返す
		function getFileName() {
			var currentUrl = window.location.href.split('/').pop();
			return currentUrl.replace(/#.*$/, "");
		}

		function setChoicePosition() {
			var tocCurHeight = $('#tocBody').outerHeight();		//サイドタブ領域の高さ
			var elemTop = $('.selected').parent('li').position();	//選択されているリスト領域のtop位置
			var elemHeight = $('.selected').parent('li').outerHeight(); //選択されているリスト領域の高さ
			var tocBodyTitleHeight = $('.toc-book-title').outerHeight();
			var tocTitleborder = $('.title_border').outerHeight();
			var elemPosition, display;

			elemPosition = parseInt(elemTop.top) + parseInt(elemHeight);

			//スクロール位置調整
			display = parseInt(elemPosition) - (parseInt(tocCurHeight) + parseInt(tocBodyTitleHeight) + parseInt(tocTitleborder));

			if(display > 0) {
				display = parseInt(display) + (parseInt(tocCurHeight) /2);
			}

			$('#tocBody').scrollTop(display);
		}
	},

	/**
	 * 機種画像を囲むブロック要素の高さを指定する
	 * PC表示：28vh
	 * モバイル表示：機種画像サイズ
	 */
	"setModelPhotoHeight": function () {
		//機種画像が無い場合には処理不要（教材の場合）
		if ($('.contents-area-background-image > img').length == 0) return;

		setModelPhotoHeight();

		$(window).on('resize', function () {
			setModelPhotoHeight();
		});

		function setModelPhotoHeight() {
			var w = window.innerWidth ? window.innerWidth : $(window).width();

			if (w < 769) {
				var modelPhotoImgHeight = $('.contents-area-background-image > img.mobile')[0].naturalHeight;
				$('.contents-area-background-image').css('height', modelPhotoImgHeight + 'px');
			} else {
				$('.contents-area-background-image').css('height', '28vh');
			}
		}
	},

	/* 目次部の高さを設定する */
	"setTocContentsHeight": function () {

		setTocContentsHeight();

		//リサイズ時に目次領域の高さ変更
		$(window).on('resize', function () {
			setTocContentsHeight();
		});

		function setTocContentsHeight() {
			var w = window.innerWidth ? window.innerWidth : $(window).width();
			var titleHeight = $('.toc-book-title').innerHeight();
			var headHeight = $('.main').innerHeight();
			var opencloseHeight = $('.toc-head').innerHeight();
			var borderHeight = $('.title_border').outerHeight();
			var contentsHeight = titleHeight + borderHeight + headHeight + opencloseHeight;
                        var vhVal=0;

			var ua = navigator.userAgent;

			if(ua.indexOf("Android") > 0) {
				var androidVersion = parseFloat(ua.slice(ua.indexOf("Android")+8));

				if(ua.indexOf('Mobile') > 0) {
					vhVal = window.innerHeight;
				} else {
					vhVal = window.innerHeight + (headHeight*2) + 25;
				}

			} else {
				vhVal = window.innerHeight;
			}

			if(w < 769) {
				var searchDispVal = $('.search-area').css('display');
				var searchAreaHeight = $('.search-area').innerHeight();

				if(searchDispVal !== "none") {
					contentsHeight = contentsHeight - searchAreaHeight;
				}

			        $('.toc-body').css('height', 'calc(' + vhVal + 'px - ' + contentsHeight +'px)');
			} else {
        			$('.toc-body').css('height', 'calc(' + vhVal + 'px - ' + contentsHeight +'px + 5px)');
			}
		}
	},
	/* file://かつFirefoxの場合、「☆ブックマーク」を非表示にする */
	"hideBookmarkListIcon": function () {
		var videoType = $("body").attr("data-VideoType");

		if (videoType==="mp4") {
			if (location.protocol == 'file:' && window.navigator.userAgent.toLowerCase().indexOf('firefox') !== -1) {
				$('main .showlisttext').parent('.showlistmodal').parent().css('display', 'none');
				$('.mobile-link .showlisttext-mobile').parent('.showlistmodal').parent().css('display', 'none');
			}
		}
	}
};
document.addEventListener("DOMContentLoaded", function () {
	// メイン・検索画面の場合
	if (_uri.file !== "index.html") {
		// サイドメニュー関連の処理
		topicFunc.setSideMenuEvent();
	}	

	if (_uri.file == "index.html") {
		//トップ画面のブックマーク非表示化
		topicFunc.hideBookmarkListIcon();
	}
});
$(function () {
	// スクロール関連イベントをセットする
	topicFunc.setScrollEvent();

	// ブックマーク関連
	var bookmarkFunc = topicFunc.bookmarkFunc();
	// 各ページ表示時、ブックマーク登録状況に応じて☆マーク表示を切り替える
	bookmarkFunc.initializeIcon(_uri.file);
	// ブックマークに必要なcontents.jsを読み込む
	bookmarkFunc.loadContents();
	// ブックマーク用のイベントをセットする
	topicFunc.setBookmarkEvent(bookmarkFunc);
	
	// メイン・検索画面の場合
	if (_uri.file !== "index.html") {
		// ハンバーガーメニュー関連の処理
		topicFunc.setTopMemuEvent();
	}

	// トップ画面の場合、機種画像の高さを指定する処理を設定する
	if (_uri.file == "index.html") {
		topicFunc.setModelPhotoHeight();
	}

	//目次部の高さを指定する処理を指定する。
	if (_uri.file !== "index.html" && _uri.file !== "search.html") {
		topicFunc.setTocContentsHeight();
	}

});
