/**********************************************
検索結果画面に関連したscript
**********************************************/

var checklistId;
var checklistTogglerId;

var delayOnResize = (function () {
		var timer = 0;
		return function (callback, ms) {
				clearTimeout(timer);
				timer = setTimeout(callback, ms);
		}
})();


resizeOnWindowWidth = function () {
		var w = window.innerWidth ? window.innerWidth: $(window).width();

		if(w < 769) {
				//モバイル表示
				$('#search-sidebar').hide(function () {
						$('ul.links li:not(:last)').hide();
						$('#search-mobile-menu').css("display", "inline-block");
						$('#search-result-content').removeClass('active');
						$('#tocBody').removeClass('active');
				});

				$('#search-mobile-menu').show();
		} else if(w >= 769) {
				//PC表示
				$('#search-mobile-menu').hide(function() {
						$('ul.links li').show();
						$('#search-mobile-menu').css("display", "none");
						$('#search-result-content').addClass('active');
						$('#tocBody').addClass('active');
				});

				$('#search-sidebar').show();
		}
}


//画面更新時に検索オプション部をPC用、Mobile用に切替
$(window).on('load', resizeOnWindowWidth());


//リサイズ時に検索オプション部をPC用、Mobile用に切替
$(window).on('resize', function() {
		delayOnResize(function() {
			resizeOnWindowWidth();
			}, 100);
});


/**********************************************
モバイルで検索に関連したscript
**********************************************/

//「絞り込み検索」箇所クリック時の処理
$("#contents-box").on("click", "#search-mobile-title", function (e) {
		$("#search-mobile-body").slideToggle();

		if ($(".search-menu-m-title").hasClass('open')) {
			$(".search-menu-m-title").removeClass('open').addClass('close');
		} else if ($(".search-menu-m-title").hasClass('close')) {
			$(".search-menu-m-title").removeClass('close').addClass('open');
		}

		e.preventDefault();
});


//「カテゴリーを絞る」、「場所で絞る」箇所をクリックした場合の処理
$("#contents-box").on("click", "#search-menu-mobile-contents > li > span", function(e) {
		if($(this).parent('li').hasClass("search-category-filter-m")) {
			$('#confirm-category').removeClass("search-value-selected");

			$('#categoryCt2 label').each(function() {
					if($(this).hasClass('search-value-selected')) {
						$(this).children('input').prop('checked', true);
						$(this).addClass('search-chk-color');
					} else {
						$(this).children('input').prop('checked', false);
						$(this).removeClass('search-chk-color');
					}
			});
		} else if($(this).parent('li').hasClass("search-place-filter-m")) {
			$('#confirm-local').removeClass("search-value-selected");

			$('#localCt2 label').each(function() {
					if($(this).hasClass('search-value-selected')) {
						$(this).children('input').prop('checked', true);
						$(this).addClass('search-chk-color');
					} else {
						$(this).children('input').prop('checked', false);
						$(this).removeClass('search-chk-color');
					}
			});
		} else if($(this).parent('li').hasClass("search-option-filter-m")) {
			$('#confirm-option').removeClass("search-value-selected");

			$('#optionCt2 label').each(function() {
					if($(this).hasClass('search-value-selected')) {
						$(this).children('input').prop('checked', true);
						$(this).addClass('search-chk-color');
					} else {
						$(this).children('input').prop('checked', false);
						$(this).removeClass('search-chk-color');
					}
			});
		} else if($(this).parent('li').hasClass("search-title-filter-m")) {
			$('#confirm-title').removeClass("search-value-selected");

			$('#searchCt2 label').each(function() {
					if($(this).hasClass('search-value-selected')) {
						$(this).children('input').prop('checked', true);
						$(this).addClass('search-chk-color');
					} else {
						$(this).children('input').prop('checked', false);
						$(this).removeClass('search-chk-color');
					}
			});
		}

		if($(this).children('a').hasClass('has-children-m-option')){
			checklistTogglerId = "#"+$(this).children('a.has-children-m-option').attr("id");
			checklistId = getChecklistIdByTogglerId($(this).children('a.has-children-m-option').attr("id"));
		} else {
			checklistTogglerId = "#"+$(this).children('a.has-children-m').attr("id");
			checklistId = getChecklistIdByTogglerId($(this).children('a.has-children-m').attr("id"));
		}

		$('#title-body-wrapper').animate({width:'toggle'}, 100);

		$(checklistId).animate({width:'toggle'}, 100);
});


//子項目遷移後に親選択に戻る際の処理
$("#contents-box").on("click", "#search-return-btn", function(e) {
		$('#title-body-wrapper').animate({width:'toggle'}, 100);
		$(checklistId).animate({width:'toggle'}, 100);
});


//「オプションで絞る」遷移先画面の「XXXオプション」クリック時の開閉処理
$("#contents-box").on("click", ".has-children-m-choices", function(e) {
		var tapElem = $(this);

		//クリックされたもの以外が開いている場合は閉じる
		$(".has-children-m-choices").not(this)
				.removeClass('selected')
				.removeClass('open')
				.addClass('close')
				.next().slideUp();

		//クリックされた項目の開閉状態を変更
		if($(this).hasClass('open')){
				$(this).removeClass('open')
							.removeClass('selected')
							.addClass('close');
		} else if($(this).hasClass('close')) {
				$(this).removeClass('close')
							.addClass('selected')
							.addClass('open');
		}

		$(this).next().slideToggle("normal", function(){
			//開閉状態変更により、タップした位置が画面外にスクロールしてしまった
			//場合にトップ位置を変更する。
			var tapContents;

			tapContents = tapElem.offset();
			if(tapContents.top > 0) {
				var currentTopPos;

				currentTopPos = $(window).scrollTop();
				if(((parseInt(tapContents.top)) - parseInt(currentTopPos)) < 0)
				{
					var fullwidthOffset;

					fullwidthOffset = $('.full-width').offset();

					tapContentHeight = tapElem.parent('li').height();
					//full-widthクラスが適用されているdivのoffset値から
					//Header高さ+αを引いた値を現在の位置に設定する
					$(window).scrollTop(fullwidthOffset.top - 40);
				}
			}
		});
});


//ID値を取得
function getChecklistIdByTogglerId(togglerID) {
		return "#" + togglerID.substr(0, togglerID.search("-toggler"));
}

//「条件を追加」ボタンクリック時の処理
$("#contents-box").on("click", ".confirm-choice-btn", function() {

		//チェックがついているチェックボックスにsearch-value-selectedクラスを付与
		var tarIdVal;

		tarIdVal = $(this).attr("id");
		if(tarIdVal === "confirm-category") {
			$('#categoryCt2 input').each(function() {
					if($(this).prop('checked')) {
							$(this).parent().addClass("search-value-selected");
					} else {
							$(this).parent().removeClass("search-value-selected");
					}
			});
		}
		else if(tarIdVal === "confirm-local") {
			$('#localCt2 input').each(function() {
					if($(this).prop('checked')) {
							$(this).parent().addClass("search-value-selected");
					} else {
							$(this).parent().removeClass("search-value-selected");
					}
			});
		}
		else if(tarIdVal === "confirm-option") {
			$('#optionCt2 input').each(function() {
					if($(this).prop('checked')) {
							$(this).parent().addClass("search-value-selected");
					} else {
							$(this).parent().removeClass("search-value-selected");
					}
			});
		}
		else if(tarIdVal === "confirm-title") {
			$('#searchCt2 input').each(function() {
					if($(this).prop('checked')) {
							$(this).parent().addClass("search-value-selected");
					} else {
							$(this).parent().removeClass("search-value-selected");
					}
			});
		}

		if($(checklistId).find("input[type=checkbox]:checked").length > 0) {
				$(checklistTogglerId).addClass("search-value-selected");
				$(checklistId).hide('slide', { direction: 'right' }, 300);
				$('#title-body-wrapper').show('slide', { direction: 'left' }, 300, function () {
					$('.search-result-list-wrapper').show();
				});
		} else {
				$(checklistTogglerId).removeClass("search-value-selected");
				$(checklistId).hide('slide', { direction: 'right' }, 300);
				$('#title-body-wrapper').show('slide', { direction: 'left' }, 300, function () {
					$('.search-result-list-wrapper').show();
				});
		}

		//「条件を追加」ボタン押下後、いずれかの項目にチェックが付いている場合は、すべてクリア、
		//検索ボタンの色を変更。
		//タイトルで絞る内の項目のみで合った場合はすべてクリアのみ色を変更。
		var chk_count_category = $('#categoryCt2 :checked').length;
		var chk_count_local = $('#localCt2 :checked').length;
		var chk_count_option = $('#optionCt2 :checked').length;
		var chk_count_title = $('#searchCt2 :checked').length;
		var textbox_text = $('#searchKey2').val();

		if(textbox_text == "" && chk_count_category == 0 && chk_count_local == 0 && chk_count_option == 0 && chk_count_title == 0) {
				$("#all-clear-button2").removeClass("search-value-selected");
				$(".search-button").removeClass("search-value-selected");
		}
		else if(textbox_text == "" && chk_count_category == 0 && chk_count_local == 0 && chk_count_option == 0 && chk_count_title) {
				$("#all-clear-button2").addClass("search-value-selected");
				$(".search-button").removeClass("search-value-selected");
		} else {
				$("#all-clear-button2").addClass("search-value-selected");
				$(".search-button").addClass("search-value-selected");
		}

		//「条件を追加」ボタン押下後、「絞り込み検索」の位置へスクロールする
		scrollTo(0, $('#search-mobile-title').offset().top - $('.list-area').height() - 10);
});


//チェックボックス項目クリック時の処理
$("#contents-box").delegate(".search-menu-m-choices-inner li.choice", "click", function() {
		if ($(this).children("input[type='checkbox']").is(':checked')) {
				$(this).children("input[type='checkbox']").prop('checked', false);
		} else {
				$(this).children("input[type='checkbox']").prop('checked', true);
		}

		if($(this).parent().find("input[type='checkbox']:checked").length > 0) {
				$(this).parent().siblings("a").addClass("search-value-selected");
		} else {
				$(this).parent().siblings("a").removeClass("search-value-selected");
		}
});


//チェックボックス自体をクリックした時の処理
$("#contents-box").delegate(".search-menu-m-choices-inner li.choice > input[type='checkbox']", "click", function (e) {
		toggleHighlightOnChecked("#" + $(this).parent().parent().prev("a").attr("id"));
		e.stopPropagation();
});


/**********************************************
検索処理関連
**********************************************/
$(function () {

		//初期設定
		func._init();

		if(conf.sData.k) {
				//検索実行
				func._search();

				//関連キーワード配列作成（あいまい）
				func._createReleateArr();

				//検索結果を表示
				func._view();
		}
});

//search_ini.jsを読み込むかどうか
var loadIniFile = false;

//検索結果の保存用オブジェクト
var results = {};

//設定
var setting = {
		"itemByPage": 10,															//1ページあたりの結果数
		"clampFrontPoint": 30, 												//ヒットキーワードの前何文字表示
		"clampDescLength": 150, 											//1項目の説明全体の表示文字数（PC表示用）
		"clampDescLengthForMobile": 100, 							//1項目の説明全体の表示文字数（モバイル表示用）
		"searchType": 'and', 														//検索タイプ
		"charUpLo": false, 														//大文字小文字の区別（true:区別する、false:区別しない）
		"charUpLo_elm": "#charUpLo", 									//大文字小文字の区別のチェックボックス要素（id値を指定）
		"zenHan": false, 															//全角半角の区別（true:区別する、false：区別しない）
		"zenHan_elm": "#zenHan", 											//全角半角の区別のチェックボックス要素（id値を指定）
		"count_elm": "#searchResult > .sCount", 			//カウント表示要素
		"results_elm": "#searchResult > .results", 		//結果表示要素
		"navi_elm": "#searchResult > .navi", 					//ページネーション表示要素
		"ufPattern": /%#symbol-([^#]+?)#%/, 					//ユーザーフォントパターン
		"highlightClass": "", 												//ハイライトタグにつけるクラス
		"score": {
				"title": 10000, 													//タイトルにヒット
				"title_indexPoint": -1, 									//タイトルの何文字目かで減点する。1文字あたりの減点
				"text": 1000, 														//説明にヒット
				"text_indexPoint": -1, 										//説明の何文字目かで減点する。１文字あたりの減点
				"dePointMax": -1000, 											//減点の最大値
				"add_point": 1000, 												//カテゴリー加算点数
				"add_pointCT": ["FAQ"]										//加算カテゴリー（ブック識別子）
		}
};

//設定（システム用）
var conf = {
		"splitStrBase": '㌀|㌞|㍇|㍧|㍨|㍩|㍪|㍫|㍬|㍭|㍮|㍯|㍰', 																//区切りに使う文字候補
		"localword": localword, 																																	//テキストボックスで入力された文字列
		"optionword": optionword, 																																//オプションで選択された項目の文字列
		"keywordData": keyword_data,																															//関連ワードの変数
		"index": search_index, 																																		//インデックスの変数
		"runStart": new Date().getTime(), 																												//検索動作開始を記録
		"thisFullPath": (window.location.origin + window.location.pathname).replace(/\\/g, "/"), 	//URIパス
		"isWebStorage": false, 																																		//WebStorageが使用可能かを判定
		"debug": {
				"runtime": false, 																																		//経過時間表示（true:表示、false:非表示）
				"scoreDisplay": false																																	//スコアの表示（true:表示、false:非表示）
		}
};

//WebStorageが使用可能かを判定
try {
		conf.isWebStorage = ('sessionStorage' in window) && (window.sessionStorage !== undefined) && (window.sessionStorage !== null);
} catch(e) {
		conf.isWebStorage = false;
}

//関数群
var func = {
		//初期設定
		"_init": function() {
				$.extend(conf, setting, {
						"$count": $(setting.count_elm), 
						"$results": $(setting.results_elm), 
						"$navi": $(setting.navi_elm), 
						"$charUpLo": $(setting.charUpLo_elm), 
						"$zenHan": $(setting.zenHan_elm), 
						"sData": getData
				});

				conf.sData.p = conf.sData.p || 1;
				conf.sData.pc = conf.sData.pc || 1;
				conf.andSearch = (conf.searchType == "and")? true : false;

				//イベントセット
				func._setEvent();

				if(conf.sData.k) {
						var wordhash = {}; //ハッシュ

						//場所で絞るにチェックが入っている場合
						$.each(conf.localword, function(i,v) {
								wordhash[v.word_id] = v.word;
						});

						//オプションで絞るにチェックが入っている場合
						$.each(conf.optionword, function(i,v) {
								wordhash[v.word_id] = v.word;
						});

						//カテゴリで絞るにチェックが入っている場合
						$('#categoryCt input:checked').each(function() {
								wordhash[$( this ).attr("name")] = $( this ).val();
						});

						var addwords = '';
						var words = [];

						if(conf.sData.w) {
								$.each(conf.sData.w.split(','), function(i,v) {
										words.push(wordhash[v]);
								});
						}

						if(words.length) {
								addwords =' "' + words.join('" "') + '"';
						}

						results.inputWord = conf.sData.k + addwords; // + ' "クリック タッチパネル"';
						results.keywords = func._getKeywordArr(results.inputWord);
						results.keywordsLength = results.keywords.length;
						results.filters = (conf.sData.f) ? conf.sData.f.split(',') : [];
						results.filtersTitle = (/^1$/i.test(conf.sData.t)) ? true : false;
						results.filtersCharUpLo = conf.charUpLo;
						results.filtersZenHan = conf.zenHan;
						results.viewPage = conf.sData.p;
						results.viewPageCheck = conf.sData.pc;
						results.resultsIndex = {};

						if(!conf.sData.o) {
								$("#searchKey").val(conf.sData.k);
								$("#searchKey2").val(conf.sData.k);
						}

						results.visitedCheck = {};

						if(conf.isWebStorage) {
								func._visited('research');
						}
				} else {
						conf.$results.html('<div class="item"><h3>' + textData.searchNotFound + '</h3></div>');
				}
		}, 
		//GETデータ取得
		"_getGetData": function() {
				var get = {};
				var data = window.location.search.replace(/^\?/,'').split('&');

				for(var i in data) {
						temp = decodeURIComponent(data[i]).split('=');

						ak = temp[0];
						temp.shift();
						get[ak] = temp.join('=');
				}

				return get;
		}, 
		//イベントをセット
		"_setEvent": function() {

				//ページネーション
				//実際にページに飛ばす処理
				///////////////////////////////////////////////////////////////////////////////////////
				conf.$navi.on('click', 'span:not(.selected)', function(e) {
						if(results.visitedCheck.filter) {
								conf.sData.pc = $(this).attr('page');
						} else {
								conf.sData.p = $(this).attr('page');
						}

						func._jampPage();
				});

				//既読/未読チェックのコントロールイベント
				///////////////////////////////////////////////////////////////////////////////////////
				$('#searchResult').on('click', '.visitedCtrl button', function(e) {
						var clickBtn = $(e.target);

						if(clickBtn.is('.viewCheck')) {
								func._visited('view');
						} else if(clickBtn.is('.reset')) {
								func._visited('reset');
						}
				});
		}, 
		//配列の重複削除
		"_uniqueArray": function(array) {

			var storage = {};
				var uniqueArray = [];
				var i,value;

				for(i=0; i<array.length; i++) {
						value = array[i];

						if(!(value in storage)) {
								storage[value] = true;
								uniqueArray.push(value);
						}
				}

				return uniqueArray;
		}, 
		//ピリオドの付与
		"_addComma": function(num) {

				var parts = num.toString().split('.');

				parts[0] = parts[0].replace(/(\d)(?=(\d\d\d)+(?!\d))/g, '$1,');

				return parts.join('.');
		}, 
		//セパレータ文字取得
		"_sepStr": function(text) {

				var temp = text.match(new RegExp('('+ conf.splitStrBase + ')', "g"));

				if(temp) {
						temp = new RegExp('(' + temp.join('|') + ')', "g");
						return conf.splitStrBase.replace(/\|/, '').replace(temp, '').split('|');
				} else {
						return conf.splitStrBase.split('|');
				}
		}, 
		//入力キーワードを配列に分離
		"_getKeywordArr": function(inputWord) {

				var sep = func._sepStr(inputWord);
				var arr = [];
				var phraseArr = [];
				var temp = inputWord;

				temp = temp.replace(/"([^"]+)"/g, function(a,$1) {
						phraseArr.push($1);
						return sep[0];
				});

				arr = temp.split(/[\s　]+/);

				$.each(arr, function(i,val) {
						if(val == void(0)) arr.splice(i,1);
						if(val == sep[0]) arr[i] = phraseArr.shift();
				});

				return arr;
		}, 
		//正規表現エスケープ処理
		"_escapeRegex": function(s) {

				return s.replace(/[\[\]{}()*+?\\^$|#;\.]/g, "\\$&");
		}, 
		//カタカナ表現生成　ガ=> (ガ|ｶﾞ)
		"_katakanaRegExp": function(str) {

				var zenHanReg = [
						"(ガ|ｶﾞ)","(ギ|ｷﾞ)","(グ|ｸﾞ)","(ゲ|ｹﾞ)","(ゴ|ｺﾞ)","(ザ|ｻﾞ)","(ジ|ｼﾞ)","(ズ|ｽﾞ)","(ゼ|ｾﾞ)","(ゾ|ｿﾞ)",
						"(ダ|ﾀﾞ)","(ヂ|ﾁﾞ)","(ヅ|ﾂﾞ)","(デ|ﾃﾞ)","(ド|ﾄﾞ)","(バ|ﾊﾞ)","(パ|ﾊﾟ)","(ビ|ﾋﾞ)","(ピ|ﾋﾟ)","(ブ|ﾌﾞ)",
						"(プ|ﾌﾟ)","(ベ|ﾍﾞ)","(ペ|ﾍﾟ)","(ボ|ﾎﾞ)","(ポ|ﾎﾟ)","(ヴ|ｳﾞ)","(ァ|ｧ)","(ア|ｱ)","(ィ|ｨ)","(イ|ｲ)","(ゥ|ｩ)",
						"(ウ|ｳ)","(ェ|ｪ)","(エ|ｴ)","(ォ|ｫ)","(オ|ｵ)","(カ|ｶ)","(キ|ｷ)","(ク|ｸ)","(ケ|ｹ)","(コ|ｺ)","(サ|ｻ)",
						"(シ|ｼ)","(ス|ｽ)","(セ|ｾ)","(ソ|ｿ)","(タ|ﾀ)","(チ|ﾁ)","(ッ|ｯ)","(ツ|ﾂ)","(テ|ﾃ)","(ト|ﾄ)","(ナ|ﾅ)",
						"(ニ|ﾆ)","(ヌ|ﾇ)","(ネ|ﾈ)","(ノ|ﾉ)","(ハ|ﾊ)","(ヒ|ﾋ)","(フ|ﾌ)","(ヘ|ﾍ)","(ホ|ﾎ)","(マ|ﾏ)","(ミ|ﾐ)",
						"(ム|ﾑ)","(メ|ﾒ)","(モ|ﾓ)","(ャ|ｬ)","(ヤ|ﾔ)","(ュ|ｭ)","(ユ|ﾕ)","(ョ|ｮ)","(ヨ|ﾖ)","(ラ|ﾗ)","(リ|ﾘ)",
						"(ル|ﾙ)","(レ|ﾚ)","(ロ|ﾛ)","(ワ|ﾜ)","(ヲ|ｦ)","(ン|ﾝ)","(。|｡)","(「|｢)","(」|｣)","(、|､)","(・|･)",
						"(ー|ｰ)","(゛|ﾞ)","(゜|ﾟ)"
				];

				for(var i in zenHanReg) {
						var re = new RegExp(zenHanReg[i], "g");

						str = str.replace(re, re.source);
				}

				return str;
		}, 
		//全角半角正規表現生成　＆　エスケープ　a => (a|ａ)、ＡＢ => (Ａ|A)(Ｂ|B)、［ => (［|\[)
		"_zenHanRegExp": function(str) {

				var re = /[\!-\~！-～￥　 ]/;

				if(re.test(str)) {
						str = str.split('');

						for(var i in str) {
								str[i] = str[i].replace(re, function(s) {
										if(/[！-～]/.test(s)) {
												return '(' + s + '|' + func._escapeRegex(String.fromCharCode(s.charCodeAt(0) - 0xFEE0)) + ')';
										} else if(/[￥]/.test(s)) {
												return '(' + s + '|' + func._escapeRegex(String.fromCharCode(0x005C)) + ')';
										} else if(/[\\]/.test(s)) {
												return '(' + func._escapeRegex(s) + '|' + String.fromCharCode(0xFFE5) + ')';
										} else if(/[　 ]/.test(s)) {
												return '(' + String.fromCharCode(0x0020) + '|' + String.fromCharCode(0x3000) + ')';
										} else {
												return '(' + func._escapeRegex(s) + '|' + String.fromCharCode(s.charCodeAt(0) + 0xFEE0) + ')';
										}
								});
						}

						str = str.join('');
				} else {
						str = func._escapeRegex(str);
				}

				str = func._katakanaRegExp(str);

				return str;
		}, 
		//ユーザーフォント削除
		"_ufrm": function(d) {

				var re = new RegExp(conf.ufPattern.source, "g");
				return d.replace(re, '');
		}, 
		//検索実行
		"_search": function() {

				var result = {};

				//検索用正規表現作成
				func._createfindreg();

				//対象インデックス作成
				var searchIndex = {};

				$.each(conf.index, function(key, indexItem){
						//スコア０点付加
						indexItem._score = indexItem._score || 0;

						//スコア詳細配列
						indexItem._scoreDetail = [];

						//全対象
						if(results.filters.length == 0){
								var temp = {};

								temp[key] = indexItem;
								$.extend(searchIndex, temp);
						} else if($.inArray(indexItem.book_key, results.filters) != -1){
								var temp = {};

								temp[key] = indexItem;
								$.extend(searchIndex, temp);
						}
				});

				//スコア値
				var calcScore = function(hitType, loopIni, hitIndex, dScore, hit){
						var demeritPoints = hitPoint = point = 0;

						if(hit){
								var demeritPoints = Math.max(hitIndex * conf.score[hitType + "_indexPoint"], conf.score.dePointMax);
								var hitPoint = conf.score[hitType] * (results.keywordsLength - loopIni);

								point = hitPoint + demeritPoints;
						}

						dScore["_"+ hitType + "_1_HitPoint"] = hitPoint;
						dScore["_"+ hitType + "_2_DePoint"] = demeritPoints;
						dScore["_"+ hitType + "_3_Formula"] = hitPoint +' - '+ Math.abs(demeritPoints) +' = '+ point;

						point = Math.max(point, 0);

						dScore["_"+ hitType + "_4_Point"] = point;

						return point;
				};

				//検索
				$.each(results.regsFind, function(findregIni, findReg){//キーワードループ
						//and検索の第２検索語以降
						if(conf.andSearch && findregIni > 0){
								searchIndex = result;
								result = {};
						}
						//and検索の第１検索語、もしくはor検索
						else{
								result = results.resultsIndex;
						}

						$.each(searchIndex, function(key, indexItem){//対象インデックスループ
								var hit = false, score = 0;

								//スコア詳細オブジェクト設定
								var dScore = indexItem._scoreDetail[findregIni] = {};

								//タイトルサーチ
								var titleMatch = func._ufrm(indexItem.title).match(findReg);

								if(titleMatch){
										hit = true;
										score += calcScore("title", findregIni, titleMatch.index, dScore, true);
								} else {
										calcScore("title", findregIni, 0, dScore, false);
								}

								//「タイトルのみ」のチェックがない場合は本文をサーチ
								if(!results.filtersTitle){
										var textMatch = func._ufrm(indexItem.text).match(findReg);

										if(textMatch){
												hit = true;
												score += calcScore("text", findregIni, textMatch.index, dScore, true);
										} else {
												calcScore("text", findregIni, 0, dScore, false);
										}
								}

								//ヒット
								if(hit){
										//カテゴリー加算
										var addPoint = 0;

										//以下if文と下のindexItem._score+=score箇所をコメントアウトするとスコア性無効化（全て0点扱いとなる）
										if($.inArray(indexItem.book_key, conf.score.add_pointCT) > -1){
											addPoint = conf.score.add_point;
											score += addPoint;
										}

										dScore['_add_Point'] = addPoint;

										//スコア加算
										indexItem._score += score;
										dScore['Word'] = results.keywords[findregIni];
										dScore['Word_Total'] = score;

										//結果オブジェクトへマージ
										var temp = {};
										temp[key] = indexItem;
										$.extend(result, temp);
								}
						});

						results.resultsIndex = result;
				});

				results.resultsLength = Object.keys(results.resultsIndex).length;
		}, 
		//検索用正規表現作成
		"_createfindreg": function() {

				var regsFind = [];
				var keys = results.keywords;// + ",アクション";
				var reFlag = (conf.charUpLo) ? "":'i';

				for(var i in keys) {
						try{
								var temp = '';

								if(conf.zenHan) {
										temp = func._escapeRegex(keys[i]);
								} else {
										temp = func._zenHanRegExp(keys[i]);
								}

								regsFind.push(new RegExp(temp, reFlag));
						} catch(e){}
				}

				//検索の正規表現配列をセット
				results.regsFind = regsFind;
		}, 
		//関連キーワード作成
		"_createReleateArr": function() {

				var releatekey = [];
				var inputWord = $.trim(results.inputWord.replace(/[\s　]+/g," "));

				$.each(conf.keywordData, function(key,val) {
						var re = new RegExp('(^| |")' + val.reg + '( |"|$)', "i");

						if(re.test(inputWord)) {
								releatekey = releatekey.concat(val.values);
						}
				});

				results.releatekeywords = func._uniqueArray(releatekey);
		}, 
		//ページネーション作成
		"_pagination": function() {

				var resultIni = results.resultsLength;
				var p = results.viewPage;

				if(resultIni > 0) {
						if(results.visitedCheck.filter) {
								resultIni = results.visitedCheck.check.length;
								p = results.viewPageCheck;
						}

						var ct = Math.ceil(resultIni / conf.itemByPage);
						var buf = [];
						var prevnum = parseInt(p) - 1;
						var nextnum = parseInt(p) + 1;
						var maxnum = 5;
						var dispNum = 0;
						var num=0;
						var curnum;

						if($(window).width() < 768) {
								if(p != 1) {
										if(p != ct) {
												buf.push('<div><span class="prevnextmark" page="' + prevnum + '">' + '\<' + '</span>');
												buf.push('<span class="prevnextmark" page="' + nextnum + '">' + '\>' + '</span></div>');
										} else {
												buf.push('<div><span class="prevnextmark" page="' + prevnum + '">' + '\<' + '</span></div>');
										}
								} else {
										if(p != ct) {
												buf.push('<div><span class="prevnextmark" page="' + nextnum + '">' + '\>' + '</span></div>');
										}
								}

								if((parseInt(p) - 5) < 0) {
										dispNum = 1;

										if(p == 1) curnum = 1;
										else curnum = parseInt(p)+1;

								} else if(parseInt(p) == parseInt(ct)) {
										dispNum = parseInt(p) - 4;
										curnum = 5;
								} else {
										dispNum = parseInt(p) - 2;
										curnum = 4;

										if((parseInt(ct) - dispNum) < 4) {
												dispNum = parseInt(p) - 3;
												curnum = 5;
										}
								}

								for(var i=dispNum; i<=ct; i++) {
										buf.push('<span page="' + i + '">' + i + '</span>');
										num++;
										if(num==5) break;
								}
						} else {
								//最初のページでなければ前ページ用のアイコンを出力
								if(p != 1) {
										buf.push('<span page="' + prevnum + '">' + '\<' + '</span>');
								}

								//中身を表示する
								if((parseInt(p) - 5) < 0) {
										dispNum = 1;
										if(p == 1) curnum = 0;
										else curnum = parseInt(p);
								} else if(parseInt(p) == parseInt(ct)) {
										dispNum = parseInt(p) - 4;
										curnum = 5;
								} else {
										dispNum = parseInt(p) - 2;
										curnum = 3;

										if((parseInt(ct) - dispNum) < 4) {
												dispNum = parseInt(p) - 3;
												curnum = 4;
										}
								}

								for(var i=dispNum; i<=ct; i++) {
										buf.push('<span page="' + i + '">' + i + '</span>');
										num++;
										if(num==5) break;
								}

								//最後のページでなければ前ページ用のアイコンを出力
								if(p != ct) {
										buf.push('<span page="' + nextnum + '">' + '\>' + '</span>');
								}
						}

						conf.$navi.html(buf.join(""))
								.find("span").removeClass("selected").eq(curnum).addClass("selected");
				}
		}, 
		//結果項目の説明トリミング
		"_clamping": function(item) {

				var ufRe = new RegExp(conf.ufPattern.source, "g");
				var userFont = [];
				var clamp = {"front": 0, "rear": -1};
				var hitPoint = 0;
				item.clamp = {"front": false, "rear": false};

				//ユーザーフォントをセパレーター文字に置き換えておく。文字数計算のため１文字に置き換えておく。
				if(conf.ufPattern.test(item.text)){
						var sepStr = func._sepStr(item.text);
						item.text = item.text.replace(ufRe, function(s){
								userFont.push(s);
								return sepStr[0];
						});
				}

				var isMatch = null;

				$.each(results.regsFind, function(i,reg){
						isMatch = item.text.match(reg);
						if(isMatch){
								hitPoint = Math.max(clamp.front, isMatch.index);
								return false;
						}
				});

				//ブラウザ幅を取得
				var w = window.innerWidth ? window.innerWidth: $(window).width();

        clamp.front = Math.max(hitPoint - conf.clampFrontPoint, 0);
	  		clamp.front = Math.min(clamp.front, Math.max(item.text.length - conf.clampDescLength, 0));

				if(w < 769){
						clamp.rear = clamp.front + conf.clampDescLengthForMobile;
				} else {
						clamp.rear = clamp.front + conf.clampDescLength;
				}

				item.clamp.front = clamp.front > 0;
				item.clamp.rear = clamp.rear < item.text.length;

				var clampStrings = {
						"before": item.text.substring(0, clamp.front), 
						"clamp": item.text.substring(clamp.front, clamp.rear), 
						"after": item.text.substring(clamp.rear)
				};

				if(userFont.length){
						var re = new RegExp(sepStr[0], "g");
						var ufNum = [];

						$.each(clampStrings, function(key, str){
								ufNum.push((str.match(re)||[]).length);
						});

						for(var i=ufNum[0],len=ufNum[0]+ufNum[1]; i<len; i++){
								clampStrings.clamp = clampStrings.clamp.replace(sepStr[0], userFont[i]);
						}
				}

				item.text = clampStrings.clamp;

				return item;
		}, 
		//結果項目のキーワードハイライト
		"_highlight": function(str) {

				var ufRe = new RegExp(conf.ufPattern.source, "g");
				var userFont = [];
				var markClass = '';

				//ユーザーフォントをセパレーター文字に置き換えておく。文字数計算のため１文字に置き換えておく。
				if(conf.ufPattern.test(str)){
						var sepStr = func._sepStr(str);
						str = str.replace(ufRe, function(s){
								userFont.push(s);
								return sepStr[0];
						});
				}

				var re = [];

				$.each(results.regsFind, function(i,reg){
						re.push(reg.source);
				});

				re = new RegExp("(" + re.join('|') + ")", (results.filtersCharUpLo)?"g":'ig');
				if(conf.highlightClass) markClass = 'class="' + conf.highlightClass + '"';
				str = str.replace(re, '<mark' + markClass + '>$1</mark>');

				if(userFont.length){
						$.each(userFont, function(i, val){
								str = str.replace(sepStr[0], val);
						});
				}

				return str;
		}, 
		//ソート
		"_sortResults": function() {

				var arr = [];
				var i = 0;

				$.each(results.resultsIndex, function(key, val){
						val._file = key;
						val.i = i;
						arr.push(val);
						i++;
				});

				arr.sort(function(a,b){
						if(a._score > b._score){
								return -1;
						} else if(a._score < b._score){
								return 1;
						}	else {
								return a.i < b.i ? -1:1;
						}
				});

				$.each(arr, function(i, obj){
					delete obj.i;
				});

				results.sortResultsArr = arr;
		}, 
		//検索結果を表示
		"_view": function() {

				var vCheck = results.visitedCheck;
				var html = ['<div class="item"><h3>', textData.searchNotFound, '</h3></div>'];

				if(results.resultsLength){
						html = [];
						func._sortResults();
						results.viewItems = [];

						if(conf.isWebStorage){
								var viewText = textData.viewSelected;

								if(vCheck.filter){
										viewText = textData.viewAll;
								}

								$('#searchResult .visitedCtrl').remove();

								var visitedCtrl = '';
								//	var visitedCtrl = '<div class="visitedCtrl">'
								//			+ '<button class="viewCheck" disabled="disabled">'+ viewText +'</button>'
								//			+ '<button class="reset" disabled="disabled">'+ textData.resetCheck +'</button>'
								//			+ '</div>';

								conf.$results.before(visitedCtrl).closest('#searchResult').addClass('visitedFunc');
								func._visitedCtrlBtn();
						}

						var loopFunc = function(target){
								var item = $.extend({}, target);
								var checkbox = '';

								//if(conf.isWebStorage){
										//checkbox = '<input type="checkbox" class="visitCheckbox" value="' + item._file.replace(/^(.+\.html)\?(.*)$/, '$1') + '">';
								//}

								item = func._clamping(item);
								item.title = func._highlight(item.title);
								item.text = func._highlight(item.text);

								var reFont = new RegExp(conf.ufPattern.source, "g");

								item.title = item.title.replace(reFont, '<span class="kmsymbol" data-charcode="$1"></span>');
								item.text = item.text.replace(reFont, '<span class="kmsymbol" data-charcode="$1"></span>');

								item.topic_path = item.topic_path.map(function (value) {
									if (value.indexOf('%#symbol-')) {
										value = value.replace(reFont, function (all, group1) {
											return '<span class="span-symbol">' + String.fromCharCode('0x' + group1) + '</span>';
										});
									}
									return value;
								});

								var path = "<span class='breadCrumb'>" + item.topic_path.join("</span><span class='breadCrumb'>") + "</span>";
								var fil = [];

								if(results.filtersCharUpLo) fil.push('ul=1');
								if(results.filtersZenHan) fil.push('zh=1');

								fil = (fil.length) ? "&" + fil.join('&'):'';
								item._file = item._file.replace(/\.html/, '$&' + "?k=" + encodeURIComponent(results.inputWord) + fil);

								results.viewItems.push(item);

								var clampClass = function(){
										var re = '', clamp = [];

										if(item.clamp.front) clamp.push('clamp-front');
										if(item.clamp.rear) clamp.push('clamp-rear');
										if(clamp.length) re = ' class="' + clamp.join(' ') + '"';

										return re;
								};

								var scoreHtml = function(){
										var re = '', html = [];

										//debug用（スコア表示）
										if(conf.debug.scoreDisplay){
												html.push('<div class="score">');
												html.push('<div class="score-keywords">');

												$.each(item._scoreDetail, function(i,val){
														html.push(
																'<div>', 
																'<table>', 
																'<caption>Word ', (i + 1),': <span>', val.Word,'</span></caption>', 
																'<tr><th>Title Point</th><td>', val._title_3_Formula,'</td></tr>', 
																'<tr><th>Text Point</th><td>', val._text_3_Formula,'</td></tr>', 
																'<tr><th>Add Point</th><td>', val._add_Point,'</td></tr>', 
																'<tr class="total"><th>Keyword Point</th><td>', func._addComma(val.Word_Total),'</td></tr>', 
																'</table>', 
																'</div>'
														);
												});

												html.push('</div>');
												html.push('<div class="score-total">Score: <span>', func._addComma(item._score), '</span></div>');
												html.push('</div>');
												re = html.join('');
										}

										return re;
								};

								html.push(
										'<div class="item">', 
										'<div class="result">', 
										'<h3>' +  checkbox + '<a class="searchResultBookTitle" href="', item._file ,'">', item.title ,'</a></h3>', 
										'<div', clampClass() ,'>', item.text ,'</div>', 
										'<div class="path">', path ,'</div>', 
										'</div>', 
										scoreHtml(), 
										'</div>'
								);
						};

						if(vCheck.filter){
								//選択した項目のみ表示の処理
								var resultIni = results.sortResultsArr.length;
								var checkIni = vCheck.check.length;

								results.checkResultsArr = [];
								for(i = 0; i < resultIni; i++){
										for(var j = 0; j < checkIni; j++){
												if(new RegExp('^' + vCheck.check[j]).test(results.sortResultsArr[i]._file)){
														results.checkResultsArr.push(results.sortResultsArr[i]);
														break;
												}
										}
								}

								var maxPage = Math.ceil(results.checkResultsArr.length / conf.itemByPage);
								var getPage = results.viewPageCheck;
								var loopStart = Math.max((Math.min(getPage, maxPage) - 1), 0) * conf.itemByPage;
								var loopStop = loopStart + conf.itemByPage;

								for(var i = loopStart; i < loopStop && results.checkResultsArr[i]; i++){
										loopFunc(results.checkResultsArr[i]);
								}
						} else {
								//通常表示の処理
								var loopStart = (results.viewPage - 1) * conf.itemByPage;
								var loopStop = loopStart + conf.itemByPage;

								for(var i = loopStart; i < loopStop && results.sortResultsArr[i]; i++){
										loopFunc(results.sortResultsArr[i]);
								}
						}
				}

				var isScoreView = function(){
						if(conf.debug.scoreDisplay){
								conf.$results.addClass('inScore');

								if(conf.debug.scoreDisplay !== true){
										conf.$results.addClass('hide');
								}
						}
				};

				isScoreView();

				conf.$results.html( html.join("") );

				$.each(results.visitedCheck.check, function(i,v){
						$('#searchResult .results input[value="' + v + '"]').prop('checked', true);
				});

				//関連ワード（未使用）
				if(results.releatekeywords.length){
						conf.$results.find('.relatedWords').remove();

						var upper = [];
						var lower = [];

						$.each(results.releatekeywords, function(i,val){
								var keyUrl = function(key){
										if(/[\s　]+/.test(key)){
												return encodeURIComponent('"' + key + '"');
										} else {
												return encodeURIComponent(key);
										}
								};
								var relatedUrl = location.href.replace(/(k\=)([^&]+)(\&|$)/, '$1' + keyUrl(val) + '$3').replace(/(\&pc?=[0-9]+)/g, '');
								var relatedItem = '<span class="relatedKey"><a href="' + relatedUrl + '">' + val + '</a></span>';

								if(i < 3){
										upper.push(relatedItem);
								} else {
										lower.push(relatedItem);
								}
						});

						conf.$count.after('<div class="relatedWords upper"><h4>'+ textData.searchRelatedHeader +'</h4>'+ upper.join('') + '</div>');

						if(lower.length){
								conf.$navi.after('<div class="relatedWords lower"><h4>'+ textData.searchRelatedHeader +'</h4>' + lower.join('')+'</div>');
						}
				}

				func._pagination();

				conf.runFinish =  new Date().getTime();
				results.runTimes = (conf.runFinish - conf.runStart) / 1000;

				//カウント表示
				var countsArr = [
						results.resultsLength,
						Math.min(loopStart + 1, results.resultsLength),
						Math.min(loopStart + conf.itemByPage, results.resultsLength)
				];

				if(vCheck.filter){
						countsArr = [
								vCheck.check.length,
								Math.min(loopStart + 1, vCheck.check.length),
								Math.min(loopStart + conf.itemByPage, vCheck.check.length)
						];
				}

				var Count = results.resultsLength == 1 ? textData.searchCountSingle : textData.searchCounts;

				Count = Count.replace(/#(\d+)#/g, function(hitAll,$1,index,strAll){
						var r = '0';

						if(countsArr[$1]){
								r = countsArr[$1];
						}

						return r;
				});

				var timeArr = [
						results.runTimes
				];
				var Time =  textData.searchTimes;

				Time = Time.replace(/#(\d+)#/g, function(hitAll,$1,index,strAll){
						var r = '0';

						if(timeArr[$1]){
								r = timeArr[$1];
						}

						return r;
				});

				var srCount = [ Count ];

				if(conf.debug.runtime) srCount.push(Time);
				srCount = srCount.join(' ');

				conf.$count.html(function(){
						var num = results.resultsLength;
						var re = srCount;

						if(num < 1){
								re = '';
						}

						return re;
				});
		}, 
		//既読/未読の判別機能(未使用）
		"_visited": function(cmd, id, behavior) {

				//var getStorage = function(){
				//		var st = sessionStorage.getItem(conf.shaKey);
				//		return (st)? JSON.parse(st).visitedCheck : false;
				//};

				//var setStorage = function(){
				//		val = JSON.stringify({"visitedCheck": results.visitedCheck});
				//		sessionStorage.setItem(conf.shaKey, val);
				//};

				//var vCheck = results.visitedCheck;
				//if("view" == cmd){
						//選択した項目のみ表示切り替え
				//		if(vCheck.filter){
				//				vCheck.filter = false;
				//		} else {
				//				vCheck.filter = true;
				//		}

				//		setStorage();
				//		conf.sData.pc = 1;
				//		conf.sData.p = 1;
				//		func._jampPage();
				//} else if("reset" == cmd){
						//すべての選択を解除
				//		$('#searchResult .visitCheckbox').prop("checked", false);
				//		vCheck.check = [];

					//	if(vCheck.filter){
								//vCheck.filter = false;
				//				setStorage();
								//delete conf.sData.pc;
								//conf.sData.p = 1;
								//func._jampPage();
				//		} else {
								//vCheck.filter = false;
				//				setStorage();
				//		}
				//} else if("checkbox" == cmd){
						//チェックボックスをクリック
				//		if(behavior){
								//追加
				//				vCheck.check.push(id);
				//		} else {
								//削除
				//				var targetIndex = vCheck.check.indexOf(id);

					//			if(targetIndex > -1){
					//					vCheck.check.splice(targetIndex, 1);
					//			}
					//	}

				//		vCheck.check = func._uniqueArray(vCheck.check);
				//		func._visitedCtrlBtn();
				//		setStorage();
				//} else if("research" == cmd){
						//再検索チェック
				//		var st = getStorage();

				//		if(results.inputWord != st.keyword){
								//検索/再検索
				//				vCheck.keyword = results.inputWord;
				//				vCheck.check = [];
				//				vCheck.filter = false;
				//		} else {
								//ページ遷移
				//				vCheck.keyword = st.keyword;
				//				vCheck.check = st.check;
				//				vCheck.filter = st.filter || false;
				//		}

					//	func._visitedCtrlBtn();

					//	var re = new RegExp('^(' + results.filters.join('|') + ')');
					//	var temp = [];

					//	$.each(vCheck.check, function(i,v){
					//			if(re.test(v)){
					//					temp.push(v);
					//			}
					//	});

					//	if(!vCheck.check.length) vCheck.filter = false;
					//	setStorage();
					//	vCheck.check = temp;
				//}
		}, 
		//
		"_visitedCtrlBtn": function() {
				//if(results.visitedCheck.check.length){
				//		$('#searchResult .visitedCtrl button').filter('.viewCheck, .reset').prop('disabled', false);
				//} else {
				//		$('#searchResult .visitedCtrl button').filter('.viewCheck, .reset').prop('disabled', true);
				//}
		}, 
		//ページ遷移
		"_jampPage": function(p) {

				var fil = [];

				$.each(conf.sData, function(key,val){
						fil.push(key + '=' + encodeURIComponent(val));
				});

				window.location.href = $('#search form').attr('action') + "?" + fil.join('&');
		}

};

var getData = func._getGetData();

