/**********************************************
検索に関連したscript
**********************************************/
var searchModal;

$(function () {
		var minwidth = $('#searchKey').width();
		var maxwidth = "100%";

		if($('#searchKey').val() != '') {
				$('#searchKey').width(maxwidth);
		}

		$("#searchForm").on("click", ".has-children", function() {
				$(this).next().slideToggle();
		});

		//検索BOXクリック時のトグルメニューの開閉イベント
		$("#searchForm").on("click", "a", function() {
				$(".search-box a").removeClass('selected');

				$(this).addClass('selected');

				/*クリックした時、openクラスがあればcloseクラスに変更
					closeクラスだった場合はopenクラスに変更*/
				if($(this).hasClass('open')) {
						$(this).removeClass('open');
						$(this).addClass('close');
				} else if($(this).hasClass('close')) {
						$(this).removeClass('close');
						$(this).addClass('open');
				}
		});

		//TextBox値入力時のイベント
		$("#searchKey").on("load input", function() {
				if($("#searchKey").val() == '') {
						$("#searchKey").width(minwidth);
				} else {
						$("#searchKey").width(maxwidth);
				}
		});

	$(document).click(function (event) {
		// クリックした箇所が、検索ボックス内ではない　かつ　モーダルダイアログ内ではない場合、「絞り込み検索」を閉じる
		// （「絞り込み検索」から表示する「オプションで絞る」「タイトルで絞る」のモーダルダイアログの外側をクリック時に、
		// 「絞り込み検索」を閉じてしまわないために、”モーダルダイアログ内ではない場合”という条件を追加している）
		if ($(event.target).closest("#searchForm").length <= 0 && 
				$(event.target).closest(".remodal-wrapper").length <= 0 && 
				$(event.target).closest("#focusSearchKey").length <= 0) {
			if ($(".search-refine-box").hasClass("open")) {
				$(".search-refine-box").removeClass('open');
				$(".search-refine-box").addClass('close');
				$(".search-refine-box").next().slideToggle();
			}
		}
	});

		//以下ダイアログ内の処理
		//初期設定
		funcSearchDlg._init();
});


/**********************************************
検索ダイアログ関連
**********************************************/
//チェックボックス項目クリック時の処理
$(".child-list > li").on("click", function (e) {
		if($(this).children("input[type='checkbox']").is(':checked')) {
				$(this).children("input[type='checkbox']").prop('checked', false);
		} else {
				$(this).children("input[type='checkbox']").prop('checked', true);
		}

		toggleHighlightOnChecked("#" + $(this).parent().siblings("a").attr("id"));
});


//チェックボックスをクリックした時の処理
$(".child-list > li > input[type='checkbox']").on('click', function(e) {
		toggleHighlightOnChecked("#" + $(this).parent().parent().prev("a").attr("id"));
		e.stopPropagation();
});


//項目にチェックされているかどうかのクラスを付与
function toggleHighlightOnChecked(itemId) {
		if ($(itemId).next().find("input[type='checkbox']:checked").length > 0) {
				$(itemId).addClass("search-value-selected");
		} else {
				$(itemId).removeClass("search-value-selected");
		}
}


//「オプションで絞る」、「タイトルで絞る」のモーダルダイアログ内チェックボックスの処理

//モーダルを開いた時にモーダル自身を保持
$(document).on('opened', '.remodal', function() {
		searchModal = $(this);
});

$(document).on('opening', '.remodal', function() {
		var dataIdVal;

		dataIdVal = $(this).attr("data-remodal-id");
		if(dataIdVal === "option-modal") {
				$('#option_button').removeClass("search-check-selected");

				$('#optionCt label'). each(function() {
						if($(this).hasClass('search-check-selected')) {
							$(this).children('input').prop('checked', true);
							$(this).addClass('search-chk-color');
						} else {
							$(this).children('input').prop('checked', false);
							$(this).removeClass('search-chk-color');
						}
				});
    }
		else if(dataIdVal === "title-modal") {
				$('#title_button').removeClass("search-check-selected");

				$('#searchCt label'). each(function() {
					if($(this).hasClass('search-check-selected')) {
						$(this).children('input').prop('checked', true);
						$(this).addClass('search-chk-color');
					} else {
						$(this).children('input').prop('checked', false);
						$(this).removeClass('search-chk-color');
					}
			});
		}
});


$(document).on('confirmation', '.remodal', function() {
		var dataIdVal;

		dataIdVal = searchModal.attr("data-remodal-id");
		if(dataIdVal === "option-modal") {
				$('#optionCt input').each(function() {
						if($(this).prop('checked')) {
								$(this).parent().addClass("search-check-selected");
						} else {
								$(this).parent().removeClass("search-check-selected");
						}
				});
		}
		else if(dataIdVal === "title-modal") {
				$('#searchCt input').each(function() {
						if($(this).prop('checked')) {
								$(this).parent().addClass("search-check-selected");
						} else {
								$(this).parent().removeClass("search-check-selected");
						}
				});
		}
});


//モーダル内「条件を追加」ボタンクリック時の処理
$(".search-remodal-select-wrapper > button").on("click", function(e) {
		var currentModal = $(this).parents(".remodal");

		if (searchModal.is(currentModal)) {
				if ($(searchModal).find(".remodal-check input[type='checkbox']:checked").length > 0) {
						$("#"+searchModal.attr("data-remodal-id")+"-menu").addClass("search-option-selected");
				} else {
						$("#"+searchModal.attr("data-remodal-id")+"-menu").removeClass("search-option-selected");
				}
		}
});


/**********************************************
検索ダイアログ内処理
**********************************************/

//検索ダイアログ用設定
var search_settings = {
		"filterTitle_elm": "#filter_title", 					//絞り込み「タイトルのみ」の要素
		"filter_elm": "#searchCt", 										//「タイトルで絞る」内に表示する項目の要素（PC表示用）
		"filter_elm2": "#searchCt2", 									//「タイトルで絞る」内に表示する項目の要素（モバイル表示用）
		"local_elm": "#localCt", 											//「場所で絞る」内に表示する項目の要素（PC表示用）
		"local_elm2": "#localCt2", 										//「場所で絞る」内に表示する項目の要素（モバイル表示用）
		"option_elm": "#optionCt", 										//「オプションで絞る」内に表示する項目の要素（PC表示用）
		"option_elm2": "#optionCt2", 									//「オプションで絞る」内に表示する項目の要素（モバイル表示用）
		"searchFilterItem_elm": "#searchFilterItem" 	//「タイトルのみ」と絞り込みブックの表示要素
};


//検索ダイアログ設定（システム用）
var search_conf = {
		"books": books, 																																					//ブックの変数
		"localword": localword, 																																	//テキストボックスで入力された文字列
		"optionword": optionword, 																																//オプションで選択された項目の文字列
		"keywordData": keyword_data 																															//関連ワードの変数
};


var funcSearchDlg = {
		//初期設定
		"_init": function() {

				$.extend(search_conf, search_settings, {
						"$searchFilterItem": $(search_settings.searchFilterItem_elm), 
						"$filterTitle": $(search_settings.filterTitle_elm), 
						"$filter": $(search_settings.filter_elm), 
						"$filter2": $(search_settings.filter_elm2), 
						"$local": $(search_settings.local_elm), 
						"$local2": $(search_settings.local_elm2), 
						"$option": $(search_settings.option_elm), 
						"$option2": $(search_settings.option_elm2), 
						"sData": getParamData
				});

				search_conf.sData.p = search_conf.sData.p || 1;
				search_conf.sData.pc = search_conf.sData.pc || 1;

				//絞り込みリスト作成
				funcSearchDlg._setFilterHtml();

				//イベントセット
				funcSearchDlg._setEvent();

				//モバイル版絞り込み検索
				if(search_conf.sData.m) {
						$("#search-mobile-body").slideToggle();
						if($("#search-menu-mobile-anchor").children("i").hasClass("fa-chevron-down")) {
								$("#search-menu-mobile-anchor").children("i")
										.removeClass("fa-chevron-down")
										.addClass("fa-chevron-up");
						}

						if(search_conf.sData.k){
								$("#searchKey2").val(search_conf.sData.k);
						}

						return;
				}
		},
		//GETデータ取得
		"_getGetData": function() {
				var get = {};
				var data = window.location.search.replace(/^\?/,'').split('&');

				for(var i in data) {
						temp = decodeURIComponent(data[i]).split('=');

						ak = temp[0];
						temp.shift();
						get[ak] = temp.join('=');
				}

				return get;
		}, 
		//絞り込み項目をセット
		"_setFilterHtml": function() {
				//絞り込み項目生成
				///////////////////////////////////////////////////////////////////////////////////////
				var title = search_conf.books[0].group;
				var groupFilter = [];
				var chapFilter = [];

				$.each(search_conf.books, function(i,v) {
						//グループが変わったら書き出し、リセット
						if(title != v.group) {
								var titlehtml = '';

								titlehtml = '<p class="search-remodal-title';

								if(title!="") {
										titlehtml += " guideTitle";
								}

								titlehtml += '">' + title + '</p>';

								groupFilter.unshift('<div class="search-col1">');
								groupFilter.push('</div>');

								chapFilter.push(titlehtml + '<div class="search-remodal-item-wrapper');
								if(title!="") {
										chapFilter.push(' guideStyle');
								}

								chapFilter.push('">' + groupFilter.join('') + "</div>");
								title = v.group;
								groupFilter.length = 0;
						}

						var commaPoint = v.book_key.indexOf(',');

						if(commaPoint > 0) {
								var array = v.book_key;
								var str = array.split(',');
								var nameVal = str[0];

								groupFilter.push('<div class="search-remodal-item1"><label>'
										+ '<input type="checkbox" name="' + nameVal + '" value="' + v.book_key + '">'
										+ '' + '<p>' + v.bookname + '</p></label>' + '</span>'
										+ '</div>');
						} else {
								groupFilter.push('<div class="search-remodal-item1"><label>'
										+ '<input type="checkbox" name="' + v.book_key + '" value="' + v.book_key + '">'
										+ '' + '<p>' + v.bookname + '</p></label>' + '</span>'
										+ '</div>');
						}
				});

				var titlehtml = '';
				titlehtml = '<p class="search-remodal-title';

				if(title!="") {
						titlehtml += " guideTitle";
				}

				titlehtml += '">' + title + '</p>';
				groupFilter.unshift('<div class="search-col1">');
				groupFilter.push('</div>');
				chapFilter.push(titlehtml + '<div class="search-remodal-item-wrapper');

				if(title!="") {
						chapFilter.push(' guideStyle');
				}

				chapFilter.push('">' + groupFilter.join('') + "</div>");

				search_conf.$filter.html(chapFilter.join(''));

				//タイトルで絞る項目生成（モバイル表示）
				///////////////////////////////////////////////////////////////////////////////////////
				var title = search_conf.books[0].group;
				var groupFilter2 = [];
				var chapFilter2 = [];

				$.each(search_conf.books, function(i,v){
						//グループが変わったら書き出し、リセット
						if(title != v.group){
								var titlehtml = '';

								titlehtml = '<p class="search-remodal-title';
								if(title!="") {
										titlehtml += " guideTitle";
								}

								titlehtml += '">' + title + '</p>';

								groupFilter2.unshift('<div class="search-col1">');
								groupFilter2.push('</div>');
								chapFilter2.push(titlehtml + '<div class="search-remodal-item-wrapper');

								if(title!="") {
										chapFilter2.push(' guideStyle');
								}

								chapFilter2.push('">' + groupFilter2.join('') + "</div>");
								title = v.group;
								groupFilter2.length = 0;
						}

						var commaPoint = v.book_key.indexOf(',');

						if(commaPoint > 0) {
							var array = v.book_key;
							var str = array.split(',');
							var nameVal = str[0];

							groupFilter2.push('<div class="search-remodal-item1"><label>'
							+ '<input type="checkbox" name="' + nameVal + '" value="' + v.book_key + '">'
							+ '' + '<p>' + v.bookname + '</p></label>' + '</span>'
							+ '</div>');
						} else {
							groupFilter2.push('<div class="search-remodal-item1"><label>'
							+ '<input type="checkbox" name="' + v.book_key + '" value="' + v.book_key + '">'
							+ '' + '<p>' + v.bookname + '</p></label>' + '</span>'
							+ '</div>');
						}
				});

				var titlehtml = '';

				titlehtml = '<p class="search-remodal-title';
				if(title!="") {
						titlehtml += " guideTitle";
				}

				titlehtml += '">' + title + '</p>';
				groupFilter2.unshift('<div class="search-col1">');
				groupFilter2.push('</div>');
				chapFilter2.push(titlehtml + '<div class="search-remodal-item-wrapper');
				if(title!="") {
						chapFilter2.push(' guideStyle');
				}

				chapFilter2.push('">' + groupFilter2.join('') + "</div>");
				search_conf.$filter2.html(chapFilter2.join(''));

				//場所で絞る項目生成
				///////////////////////////////////////////////////////////////////////////////////////
				var localFilter = [];
				var localFilter2 = [];

				$.each(search_conf.localword, function(i,v) {
						localFilter.push('<li><label>'
								+ '<input type="checkbox" name="' + v.word_id + '" value="' + v.word + '">'
								+ '<p>' + v.word + '</p>'
								+ '</label></li>');

						localFilter2.push('<li class="choice"><label>'
								+ '<input type="checkbox" name="' + v.word_id + '" value="' + v.word + '">'
								+ '<p>' + v.word + '</p>'
								+ '</label></li>');
				});

				search_conf.$local.html('<ul>' + localFilter.join('') + '</ul>');
				search_conf.$local2.html(localFilter2.join(''));

				//オプションで絞る項目生成(PC表示）
				///////////////////////////////////////////////////////////////////////////////////////
				var title = search_conf.optionword[0].group;
				var groupFilter = [];
				var optionFilter = [];

				$.each(search_conf.optionword, function(i,v) {
						//グループが変わったら書き出し、リセット
						if (title != v.group) {
								var titlehtml = '';
								titlehtml = '<p class="search-remodal-title">' + title + '</p>';

								//5以上の場合は分割
								if(groupFilter.length >= 5) {
										groupFilter.splice(Math.ceil(groupFilter.length / 2), 0, '</div><div class="search-col2">');
								}

								groupFilter.unshift('<div class="search-col1">');
								groupFilter.push('</div>');

								optionFilter.push(titlehtml + '<div class="search-remodal-item-wrapper">' + groupFilter.join('') + "</div>");
								title = v.group;
								groupFilter.length = 0;
						}

						groupFilter.push('<div class="search-remodal-item1"><label>'
								+ '<input type="checkbox" name="' + v.word_id + '" value="' + v.word + '">'
								+ '' + '<p>' + v.word + '</p></label>' + '</span>'
								+ '</div>');
				});

				var titlehtml = '';
				titlehtml = '<p class="search-remodal-title">' + title + '</p>';

				//5以上の場合は分割
				if (groupFilter.length >= 5) {
						groupFilter.splice(Math.ceil(groupFilter.length / 2), 0, '</div><div class="search-col2">');
				}
				groupFilter.unshift('<div class="search-col1">');
				groupFilter.push('</div>');
				optionFilter.push(titlehtml + '<div class="search-remodal-item-wrapper">' + groupFilter.join('') + "</div>");
				search_conf.$option.html(optionFilter.join(''));

				//オプションで絞る項目生成(モバイル表示）
				///////////////////////////////////////////////////////////////////////////////////////
				var title = search_conf.optionword[0].group;
				var groupFilter2 = [];
				var optionFilter2 = [];

				$.each(search_conf.optionword, function(i,v){
						//グループが変わったら書き出し、リセット
						if(title != v.group){
								var titlehtml = '';

								titlehtml = '<a class="has-children-m-choices close" id="option-choice-group-2">' + title + '</a>';
								optionFilter2.push('<li class="choice-wrapper">' + titlehtml + '<ul class="choice-child-list">' + groupFilter2.join('') + "</ul></li>");
								optionFilter2.push('<li><hr style="margin-top: 13.7px;margin-bottom: 13.7px;margin-left: 12.6px;margin-right: 12.6px;"></li>');
								title = v.group;
								groupFilter2.length = 0;
						}

						groupFilter2.push('<li class="choice"><label>'
							+ '<input type="checkbox" name="' + v.word_id + '" value="' + v.word + '">'
							+ '<p>' + v.word + '</p>'
							+ '</label></li>');
				});

				var titlehtml = '';

				titlehtml = '<a class="has-children-m-choices close" id="option-choice-group-2">' + title + '</a>';
				optionFilter2.push('<li class="choice-wrapper">' + titlehtml + '<ul class="choice-child-list">' + groupFilter2.join('') + "</ul></li>");
				search_conf.$option2.html(optionFilter2.join(''));

				//タイトルのみのチェック付加
				///////////////////////////////////////////////////////////////////////////////////////
				if(search_conf.sData.t && /^(1|true)$/i.test(search_conf.sData.t.toString())) {
						search_conf.$filterTitle.prop('checked', true);
				}

				//絞り込みのチェック付加
				///////////////////////////////////////////////////////////////////////////////////////
				if(search_conf.sData.f) {
						$.each(search_conf.sData.f.split(','), function(i,v) {
								$('input[name=' + v + ']').prop('checked', true);
								$('#searchCt2 input:checked').each(function() {
									$(this).parent().addClass("search-value-selected");
								});
								$('#searchCt input:checked').each(function() {
									$(this).parent().addClass("search-check-selected");
								});
								$('#title-modal-menu').addClass("search-value-selected");
								$('#title-checklist-toggler').addClass("search-value-selected");
								$('#all-clear-button').addClass("search-value-selected");
								$('#searchSubmit').addClass("search-value-selected");
						});
				}

				//チェックボックスの設定
				///////////////////////////////////////////////////////////////////////////////////////
				if(search_conf.sData.w) {
						$.each(search_conf.sData.w.split(','), function(i,v) {
								//チェックボックスのチェック
								$('input[name=' + v + ']').prop('checked', true);

								//グループタイトルのボールド
								if($('#categoryCt2').find('input[name=' + v + ']').length != 0) {
										$('#category-checklist-toggler').addClass("search-value-selected");
										$('#confirm-category').addClass("search-value-selected");
										$(this).addClass("search-check-selected");
								} else if($('#localCt2').find('input[name=' + v + ']').length != 0) {
										$('#place-checklist-toggler').addClass("search-value-selected");
										$('#confirm-local').addClass("search-value-selected");
										$(this).addClass("search-check-selected");
								} else if($('#optionCt2').find('input[name=' + v + ']').length != 0) {
										$('#option-checklist-toggler').addClass("search-value-selected");
										$('#confirm-option').addClass("search-value-selected");
										$(this).addClass("search-check-selected");
								}

								$('#categoryCt2 input:checked').each(function() {
										$(this).parent().addClass("search-value-selected");
								});

								$('#localCt2 input:checked').each(function() {
										$(this).parent().addClass("search-value-selected");
								});

								$('#optionCt2 input:checked').each(function() {
										$(this).parent().addClass("search-value-selected");
										$(this).closest('.choice-wrapper').children('a').addClass('search-value-selected');
								});

								if($('#categoryCt').find('input[name=' + v + ']').length != 0) {
										$('#category-checkmenu').addClass("search-value-selected");
								} else if($('#localCt').find('input[name=' + v + ']').length != 0) {
										$('#place-checkmenu').addClass("search-value-selected");
								} else if($('#optionCt').find('input[name=' + v + ']').length != 0) {
										$('#option-modal-menu').addClass("search-value-selected");
								}

								$('#categoryCt input:checked').each(function() {
										$(this).parent().addClass("search-value-selected");
								});

								$('#localCt input:checked').each(function() {
										$(this).parent().addClass("search-value-selected");
								});

								$('#optionCt input:checked').each(function() {
										$(this).parent().addClass("search-check-selected");
								});
						});
				}

				var check_count = $('#optionCt :checked').length;
				var check_count2 = $('#localCt :checked').length;
				var check_count3 = $('#categoryCt :checked').length;
				var check_count4 = $('#optionCt2 :checked').length;
				var check_count5 = $('#localCt2 :checked').length;
				var check_count6 = $('#categoryCt2 :checked').length;

				if(search_conf.sData.k || check_count != 0 || check_count2 != 0 || check_count3 != 0 || check_count4 != 0 || check_count5 != 0 || check_count6 != 0) {
						//いずれかの検索オプションが有効である場合はボタンの色を変更。
						$('#all-clear-button').addClass("search-value-selected");
						$('#searchSubmit').addClass("search-value-selected");
						$('.search-button').addClass("search-value-selected");
						$('#all-clear-button2').addClass("search-value-selected");
				}

				//大文字小文字のチェック付加(未使用)
				///////////////////////////////////////////////////////////////////////////////////////
				//if(search_conf.sData.ul && /(1|true)/i.test(search_conf.sData.ul.toString())) {
				//		search_conf.charUpLo =  true;
				//		search_conf.$charUpLo.prop('checked', true);
				//}

				//全角半角のチェック付加（未使用）
				///////////////////////////////////////////////////////////////////////////////////////
				//if(search_conf.sData.zh && /(1|true)/i.test(search_conf.sData.zh.toString())) {
				//		search_conf.zenHan = true;
				//		search_conf.$zenHan.prop('checked', true);
				//}
		},
		//イベントをセット
		"_setEvent": function() {

				//クリアボタンクリック時のイベント（PC表示時）
				///////////////////////////////////////////////////////////////////////////////////////
				$('#all-clear-button').on('click', function(e) {
						//チェックボックスのチェック解除
						$('#categoryCt').find(':checkbox').prop('checked', false);
						$('#localCt').find(':checkbox').prop('checked', false);
						$('#optionCt').find(':checkbox').prop('checked', false);
						$('#searchCt').find(':checkbox').prop('checked', false);
						//search-value-selectedクラス削除
						$('#category-checkmenu').removeClass("search-value-selected");
						$('#place-checkmenu').removeClass("search-value-selected");
						$('#option-modal-menu').removeClass("search-value-selected");
						$('#title-modal-menu').removeClass("search-value-selected");
						$('#all-clear-button').removeClass("search-value-selected");
						$('#searchSubmit').removeClass("search-value-selected");
						$('.search-check-selected').removeClass("search-check-selected");
						$('#title-modal-menu').removeClass("search-option-selected");
						$('#option-modal-menu').removeClass("search-option-selected");
						$('label').removeClass("search-chk-color");
						$('label').removeClass("search-value-selected");
						//テキストボックスを空に
						$('#searchKey').val('');
						//クリアボタン無効化
						$('#all-clear-button').prop("disabled", true);
						$('#all-clear-button').prop("disabled", false);
				});

				//クリアボタンクリック時のイベント（モバイル表示時）
				///////////////////////////////////////////////////////////////////////////////////////
				$('#all-clear-button2').on('click', function(e) {
						//チェックボックスのチェック解除
						$('#categoryCt2').find(':checkbox').prop('checked', false);
						$('#localCt2').find(':checkbox').prop('checked', false);
						$('#optionCt2').find(':checkbox').prop('checked', false);
						$('#searchCt2').find(':checkbox').prop('checked', false);
						//search-value-selectedクラス削除
						$('#category-checklist-toggler').removeClass("search-value-selected");
						$('#place-checklist-toggler').removeClass("search-value-selected");
						$('#option-checklist-toggler').removeClass("search-value-selected");
						$('#title-checklist-toggler').removeClass("search-value-selected");
						$('#all-clear-button').removeClass("search-value-selected");
						$('#searchSubmit').removeClass("search-value-selected");
						$('.search-value-selected').removeClass("search-value-selected");
						$('a').removeClass("search-chk-color");
						//テキストボックスを空に
						$('#searchKey2').val('');
						//クリアボタン無効化
						$('#all-clear-button2').prop("disabled", true);
						$('#all-clear-button2').prop("disabled", false);
				});

				//カテゴリチェックボックスの処理(PC表示時）
				///////////////////////////////////////////////////////////////////////////////////////
				$('#categoryCt').on('change', ':checkbox, :radio', function() {
						var check_count = $('#categoryCt :checked').length;
						var check_count2 = $('#localCt :checked').length;
						var check_count3 = $('#optionCt :checked').length;
						var textbox_text = $('#searchKey').val();

						if(textbox_text == "" && check_count == 0 && check_count2 == 0 && check_count3 == 0) {
								$('#category-checkmenu').removeClass("search-value-selected");
								$('#all-clear-button').removeClass("search-value-selected");
								$('#searchSubmit').removeClass("search-value-selected");
						} else if(check_count == 0) {
								$('#category-checkmenu').removeClass("search-value-selected");
						} else {
								$('#category-checkmenu').addClass("search-value-selected");
								$('#all-clear-button').addClass("search-value-selected");
								$('#searchSubmit').addClass("search-value-selected");
						}

						if($(this).prop('checked')) {
								$(this).parent().addClass("search-value-selected");
						} else {
								$(this).parent().removeClass("search-value-selected");
						}
				});

				//カテゴリチェックボックスの処理(モバイル表示時）
				///////////////////////////////////////////////////////////////////////////////////////
				$('#categoryCt2').on('change', ':checkbox, :radio', function() {
						$('#confirm-category').addClass("search-value-selected");

						if($(this).prop('checked')) {
								$(this).parent().addClass("search-chk-color");
						} else {
								$(this).parent().removeClass("search-chk-color");
						}
				});

				//場所カテゴリチェックボックスの処理(PC表示時）
				///////////////////////////////////////////////////////////////////////////////////////
				$('#localCt').on('change', ':checkbox, :radio', function() {
						var check_count = $('#localCt :checked').length;
						var check_count2 = $('#categoryCt :checked').length;
						var check_count3 = $('#optionCt :checked').length;
						var textbox_text = $('#searchKey').val();

						if(textbox_text == "" && check_count == 0 && check_count2 == 0 && check_count3 == 0) {
								$('#place-checkmenu').removeClass("search-value-selected");
								$('#all-clear-button').removeClass("search-value-selected");
								$('#searchSubmit').removeClass("search-value-selected");
						} else if(check_count == 0) {
								$('#place-checkmenu').removeClass("search-value-selected");
						} else {
								$('#place-checkmenu').addClass("search-value-selected");
								$('#all-clear-button').addClass("search-value-selected");
								$('#searchSubmit').addClass("search-value-selected");
						}

						if($(this).prop('checked')) {
								$(this).parent().addClass("search-value-selected");
						} else {
								$(this).parent().removeClass("search-value-selected");
						}
				});

				//場所カテゴリチェックボックスの処理(モバイル表示時）
				///////////////////////////////////////////////////////////////////////////////////////
				$('#localCt2').on('change', ':checkbox, :radio', function() {
						$('#confirm-local').addClass("search-value-selected");

						if($(this).prop('checked')) {
								$(this).parent().addClass("search-chk-color");
						} else {
								$(this).parent().removeClass("search-chk-color");
						}
				});

				//オプションカテゴリチェックボックスの処理(PC表示時）
				///////////////////////////////////////////////////////////////////////////////////////
				$('#optionCt').on('change', ':checkbox, :radio', function() {
						$('#option_button').addClass("search-check-selected");

						if($(this).prop('checked')) {
								$(this).parent().addClass("search-chk-color");
						} else {
								$(this).parent().removeClass("search-chk-color");
						}
				});

				//オプションカテゴリチェックボックスの処理(モバイル表示時）
				///////////////////////////////////////////////////////////////////////////////////////
				$('#optionCt2').on('change', ':checkbox, :radio', function() {
						$('#confirm-option').addClass("search-value-selected");

						if($(this).prop('checked')) {
								$(this).parent().addClass("search-chk-color");
						} else {
								$(this).parent().removeClass("search-chk-color");
						}
				});

				//オプションダイアログボタンが押されたとき
				///////////////////////////////////////////////////////////////////////////////////////
				$('#option_button').on('click', function(e) {
						var textbox_text = $('#searchKey').val();
						var check_count = $('#optionCt :checked').length;
						var check_count2 = $('#localCt :checked').length;
						var check_count3 = $('#categoryCt :checked').length;
						var check_count4 = $('#searchCt :checked').length;

						if(textbox_text == "" && check_count == 0 && check_count2 == 0 && check_count3 == 0 && check_count4 == 0) {
								$('#all-clear-button').removeClass("search-value-selected");
								$('#searchSubmit').removeClass("search-value-selected");
						} 
						else if(textbox_text == "" && check_count == 0 && check_count2 == 0 && check_count3 == 0 && check_count4) {
								$('#all-clear-button').addClass("search-value-selected");
								$('#searchSubmit').removeClass("search-value-selected");
						} else {
								$('#option-modal-menu').addClass("search-value-selected");
								$('#all-clear-button').addClass("search-value-selected");
								$('#searchSubmit').addClass("search-value-selected");
						}

						if(check_count == 0) {
							$('#option-modal-menu').removeClass("search-value-selected");
						}
				});

				//テキストボックスに値が入力、削除されたとき(PC表示時）
				///////////////////////////////////////////////////////////////////////////////////////
				$('#searchKey').keyup(function(e) {
						var textbox_text = $('#searchKey').val();
						var check_count = $('#optionCt :checked').length;
						var check_count2 = $('#localCt :checked').length;
						var check_count3 = $('#categoryCt :checked').length;
						var check_count4 = $('#searchCt :checked').length;

						if(textbox_text == "" && check_count == 0 && check_count2 == 0 && check_count3 == 0 && check_count4 == 0) {
								$('#all-clear-button').removeClass("search-value-selected");
								$('#searchSubmit').removeClass("search-value-selected");
						}
						else if(textbox_text == "" && check_count == 0 && check_count2 == 0 && check_count3 == 0 && check_count4) {
								$('#all-clear-button').addClass("search-value-selected");
								$('#searchSubmit').removeClass("search-value-selected");
						} else {
								$('#all-clear-button').addClass("search-value-selected");
								$('#searchSubmit').addClass("search-value-selected");
						}
				});

				//テキストボックスに値が入力、削除されたとき(モバイル表示時）
				///////////////////////////////////////////////////////////////////////////////////////
				$('#searchKey2').keyup(function(e) {
						var textbox_text = $('#searchKey2').val();
						var check_count = $('#optionCt2 :checked').length;
						var check_count2 = $('#localCt2 :checked').length;
						var check_count3 = $('#categoryCt2 :checked').length;
						var check_count4 = $('#searchCt2 :checked').length;

						if(textbox_text == "" && check_count == 0 && check_count2 == 0 && check_count3 == 0 && check_count4 == 0) {
								$('.search-button').removeClass("search-value-selected");
								$('#all-clear-button2').removeClass("search-value-selected");
						}
						else if(textbox_text == "" && check_count == 0 && check_count2 == 0 && check_count3 == 0 && check_count4) {
								$('.search-button').removeClass("search-value-selected");
								$('#all-clear-button2').addClass("search-value-selected");
						} else {
								$('.search-button').addClass("search-value-selected");
								$('#all-clear-button2').addClass("search-value-selected");
						}
				});

				//タイトルチェックボックスの処理(PC表示時）
				///////////////////////////////////////////////////////////////////////////////////////
				$('#searchCt').on('change', ':checkbox, :radio', function() {
						var check_count = $('#searchCt :checked').length;

						$('#title_button').addClass("search-check-selected");

						if($(this).prop('checked')) {
								$(this).parent().addClass("search-chk-color");
						} else {
								$(this).parent().removeClass("search-chk-color");
						}
				});

				//タイトルチェックボックスの処理(モバイル表示時）
				///////////////////////////////////////////////////////////////////////////////////////
				$('#searchCt2').on('change', ':checkbox, :radio', function() {
						var check_count = $('#searchCt2 :checked').length;

						$('#confirm-title').addClass("search-value-selected");

						if($(this).prop('checked')) {
								$(this).parent().addClass("search-chk-color");
						} else {
								$(this).parent().removeClass("search-chk-color");
						}
				});

				//タイトルダイアログボタンが押されたとき
				///////////////////////////////////////////////////////////////////////////////////////
				$('#title_button').on('click', function(e) {
						var textbox_text = $('#searchKey').val();
						var check_count = $('#searchCt :checked').length;
						var check_count2 = $('#optionCt :checked').length;
						var check_count3 = $('#localCt :checked').length;
						var check_count4 = $('#categoryCt :checked').length;

						if(textbox_text == "" && check_count == 0 && check_count2 == 0 && check_count3 == 0 && check_count4 == 0) {
								$('#title-modal-menu').removeClass("search-value-selected");
								$('#all-clear-button').removeClass("search-value-selected");
								$('#searchSubmit').removeClass("search-value-selected");
						}
						else if(textbox_text == "" && check_count && check_count2 == 0 && check_count3 == 0 && check_count4 == 0) {
								$('#title-modal-menu').addClass("search-value-selected");
								$('#all-clear-button').addClass("search-value-selected");
								$('#searchSubmit').removeClass("search-value-selected");
						} else {
								$('#title-modal-menu').addClass("search-value-selected");
								$('#all-clear-button').addClass("search-value-selected");
								$('#searchSubmit').addClass("search-value-selected");
						}

						if(check_count == 0) {
							$('#title-modal-menu').removeClass("search-value-selected");
						}
				});

				//絞り込み全解除(未使用？）
				///////////////////////////////////////////////////////////////////////////////////////
				$('#contents').on('click', '.allDeselect', function(e) {
						search_conf.$searchFilterItem.find(':checkbox').prop('checked', false);
						$('#search form').submit();
				});

				//検索オプション、絞り込みの状態が変わったときにsubmit(未使用）
				///////////////////////////////////////////////////////////////////////////////////////
				//$('#search .searchOption' +','+ search_conf.searchFilterItem_elm).on('change', ':checkbox, :radio', function() {
				//		$('#search form').submit();
				//}

				//結果ページ内のチェックボックスが変更された時（未使用）
				///////////////////////////////////////////////////////////////////////////////////////
				//$('#searchResult').on('change', '.results input[type="checkbox"]', function(e) {
				//		func._visited('checkbox', e.target.value, e.target.checked);
				//});
		}
};

var getParamData = funcSearchDlg._getGetData();
