/*/////////////////////////////////////////////////////////////////////////////////////////////////
	User's Guide PP
		common JavaScript
 Modified : 2016-12-27
/////////////////////////////////////////////////////////////////////////////////////////////////*/


/* global decodeURIComponent */

/**************************************************
 * URLからの情報取得
 * 　戻り：　_uri
 */
var _uri = (function () {
	var uri = {
		"location": window.location.href
		, "fullPath": ((window.location.origin || '') + window.location.pathname).replace(/\\/g, "/")
	};
	uri.path = uri.fullPath.split('/').slice(0, -1).join('/');
	uri.file = uri.fullPath.split('/').slice(-1).join('') || "index.html";
	uri.hash = window.location.hash;
	uri.manualPath = uri.path.replace(/\/?contents\/?$/i, '');
	uri.fileName = uri.file.replace(/\.html?$/, '');
	uri.id = uri.file.split("_", 1).join('');
	return uri;
}());

/**************************************************
 * ユーザーエージェントから情報取得
 * 　戻り：　_ua
 */
var _ua = (function(){
	var na = navigator, ua = na.userAgent;
	var __ua = {
		"_protocol": document.location.protocol
		,"_isWin": /win/i.test(na.platform)
		,"_isMac": /mac/i.test(na.platform)
		,"_isWebKit": /WebKit/i.test(ua)
		,"_isOpera": window.opera && window.opera.buildNumber
		,"_isEdge": /Edge\//i.test(ua)
		,"_browser": false
	};
	__ua._isKMBuiltIn = /KMBuiltInBrowser/i.test(ua) && __ua._protocol === "http:";	// 実機組み込みブラウザの場合にuserAgent値が何になるか不明のため"KMBuiltInBrowser"として仮実装。実機にて確認後、要修正。
	// __ua._isKMBuiltIn = /chrome/i.test(ua) && __ua._protocol === "file:";　// 実機の代わりに、Chrome・Edgeにおいて印刷ボタンが非表示になることの確認テスト用。実機OKになれば削除すること。
	__ua._isChrome = !__ua._isEdge && /chrome/i.test(ua);
	__ua._isIE = !__ua._isWebKit && !__ua._isOpera && ( /MSIE/i.test(ua) || /Trident/i.test(ua) );
	__ua._isGecko = !__ua._isWebKit && /Gecko/.test(ua);
	__ua._isFirefox = __ua._isGecko && /Firefox/.test(ua);
	__ua._isSafari = __ua._isWebKit && !__ua._isChrome && __ua._isMac;
	
	if(__ua._isEdge){
		__ua._browser = 'edge';
	}else if(__ua._isIE){
		__ua._browser = 'ie';
	}else if(__ua._isSafari){
		__ua._browser = 'safari';
	}else if(__ua._isFirefox){
		__ua._browser = 'firefox';
	}else if(__ua._isChrome){
		__ua._browser = 'chrome';
	}
	
	if(__ua._isIE){
		var bver = ua.replace(/^.+(MSIE |rv:)([0-9]+).+$/i, '$2');
		__ua._IEVer = Number(bver);
		__ua._IEVer11 = bver == 11;
	}
	if(__ua._isSafari){
		__ua._SafariFullVer = ua.replace(/^.+Version\/([0-9.]+).*$/i, '$1');
		__ua._SafariVer = __ua._SafariFullVer.split('.')[0];
	}
	
	return __ua;
}());


/* *************************************************
 * URLからGET情報取得
 */
var _get = (function(){
	var getdata = window.location.search.replace(/^\?/,'').split('&');
	var get = [];
	for(var i=0,len=getdata.length; i<len; i++){
		var temp = decodeURIComponent(getdata[i]).split('=');
		var ak = temp[0];
		temp.shift();
		get[ak] = temp.join('=');
	}
	return get;
}());


/**************************************************
 * 共有関数
 */
var cmn = {
	
	//検索フォーム
	"searchForm": function(){
		//PC表示
		$('#search form').on("submit", function(){

			var keyword = $.trim($('#searchKey').val());
			var searchCont = $('#searchCt input:checked').length;
			var categoryCont = $('#categoryCt input:checked').length;
			var localCont = $('#localCt input:checked').length;
			var optionCont = $('#optionCt input:checked').length;
			var opFlg=false;

			if((!keyword && !searchCont && !categoryCont && !localCont && !optionCont) || 
				 (!keyword && !categoryCont && !localCont && !optionCont && searchCont)){
				alert(textData.noSearchItem);
				return false;
			}else{

				var fil = [];
				var add = [];
				var opOnly="";
				
				if($('#filter_title').is(':checked')){
					fil.push('t=1');
				}
				var filters = [];
				$('#searchCt input:checked').each(function(){
					filters.push($(this).val());
				});
				if(filters.length){
					fil.push('f=' + filters.join(','));
				}
				if($('#charUpLo').is(':checked')){
					fil.push('ul=1');
				}
				if($('#zenHan').is(':checked')){
					fil.push('zh=1');
				}
				
				
				var words = [];
				//カテゴリーで絞る
				$('#categoryCt input:checked').each(function(){
					words.push($( this ).attr("name"));//word追加
				} );	
				
				//場所で絞る
				$('#localCt input:checked').each(function(){
					words.push($( this ).attr("name"));//word追加
				} );
				
				//オプションで絞る
				$('#optionCt input:checked').each(function(){
					words.push($( this ).attr("name"));//word追加
				} );
				if(words.length){
					fil.push('w=' + words.join(','));
				}				
				
				fil = (fil.length) ? "&" + fil.join('&'):'';
				add = (add.length) ? " " + add.join(' '):'';

        if(!keyword)
        {
					$('#categoryCt input:checked').each(function(){
						keyword += '"';
						keyword += $(this).next('p').text();
						keyword += '" ';
						opFlg = true;
					})
        }

				if(!keyword)
				{
					$('#localCt input:checked').each(function(){
						keyword += '"';
						keyword += $(this).next('p').text();
            keyword += '" ';
						opFlg = true;
					})
				}

				if(!keyword)
				{
					$('#optionCt input:checked').each(function(){
						keyword += '"';
						keyword += $(this).parent('label').text();
						keyword += '" ';
						opFlg = true;
					})
				}

				if(opFlg)
				{
					opOnly = "&o=1";
				}

				window.location.href = $('#search form').attr('action') + "?k=" + encodeURIComponent(keyword) + add + fil + opOnly;

				return false;
			}
		});

		//モバイル表示
		$('#search-mobile-body form').on("submit", function(){
			
			var keyword = $.trim($('#searchKey2').val());
			var searchCont = $('#searchCt2 input:checked').length;
			var categoryCont = $('#categoryCt2 input:checked').length;
			var localCont = $('#localCt2 input:checked').length;
			var optionCont = $('#optionCt2 input:checked').length;
			var opFlg = false;

			if((!keyword && !searchCont && !categoryCont && !localCont && !optionCont) || 
				 (!keyword && !categoryCont && !localCont && !optionCont && searchCont)){
				alert(textData.noSearchItem);			
				return false;
			}else{
				
				var fil = [];
				var add = [];
				var opOnly="";
				
				if($('#filter_title').is(':checked')){
					fil.push('t=1');
				}
				var filters = [];
				$('#searchCt2 input:checked').each(function(){
					filters.push($(this).val());
				});
				if(filters.length){
					fil.push('f=' + filters.join(','));
				}
				if($('#charUpLo').is(':checked')){
					fil.push('ul=1');
				}
				if($('#zenHan').is(':checked')){
					fil.push('zh=1');
				}
				
				var words = [];
				//カテゴリーで絞る
				$('#categoryCt2 input:checked').each(function(){
					words.push($( this ).attr("name"));//word追加
				} );	
				
				//場所で絞る
				$('#localCt2 input:checked').each(function(){
					words.push($( this ).attr("name"));//word追加
				} );
				
				//オプションで絞る
				$('#optionCt2 input:checked').each(function(){
					words.push($( this ).attr("name"));//word追加
				} );
				if(words.length){
					fil.push('w=' + words.join(','));
				}
				
				fil = (fil.length) ? "&" + fil.join('&'):'';
				add = (add.length) ? " " + add.join(' '):'';

        if(!keyword)
        {
					$('#categoryCt2 input:checked').each(function(){
						keyword += '"';
						keyword += $(this).next('p').text();
						keyword += '" ';
						opFlg = true;
					})
        }

				if(!keyword)
				{
					$('#localCt2 input:checked').each(function(){
						keyword += '"';
						keyword += $(this).next('p').text();
						keyword += '" ';
						opFlg = true;
					})
				}

				if(!keyword)
				{
					$('#optionCt2 input:checked').each(function(){
						keyword += '"';
						keyword += $(this).parent('label').text();
						keyword += '" ';
						opFlg = true;
					})
				}

				//キーワードが存在しない場合は、オプションのいずれかをキーワードに設定する
				if(opFlg)
				{
					opOnly = "&o=1";
				}

				window.location.href = $('#search form').attr('action') + "?k=" + encodeURIComponent(keyword) + add + fil + opOnly;
				return false;
			}
		});
		
		
		//絞り込みモバイル版
		$('#search-link-box-mobile').on("click", function(e){
			var keyword = $.trim($('#searchKey').val());
			if(!keyword){
				window.location.href = $('#search form').attr('action') + "?" + 'm=true';
				return false;
			}else{
				window.location = $('#search form').attr('action') + "?k=" + encodeURIComponent(keyword) + '&m=true';
				return false;
			}
		});

	}, 
	"contents": {}
};

/**************************************************
 * jQuery ready
 */
$(function(){

	//検索フォーム
	cmn.searchForm();

});
//end jQuery ready
